SET LONG 20000;
SELECT XMLELEMENT("rf;Umsatz",
        XMLELEMENT("rf;Tarif",
         XMLFOREST(T_Name AS "rf;Name",
                   T_Typ AS "rf;Typ",
                  '200' || EXTRACT(YEAR FROM A_Beginn) AS "rf;Jahr"),
         XMLELEMENT("rf;Gueltigkeit", XMLATTRIBUTES('Datum' AS "rf;Typ"),
          XMLFOREST(TO_CHAR(T_GueVon, 'YY-MM-DD') AS "rf;GueVon",
                    TO_CHAR(T_GueBis, 'YY-MM-DD') AS "rf;GueBis"))),
        XMLELEMENT("da;Summe",
         XMLFOREST(ROUND(SUM(A_Preis)/100,2) AS "da;Einzeln",
                   SUM(ROUND(SUM(A_Preis)/100,2))
                    OVER (PARTITION BY T_Name) AS "da;TarifGesamt",
                   SUM(ROUND(SUM(A_Preis)/100,2))
                    OVER ()            AS "da;Gesamt",
                   ROUND((RATIO_TO_REPORT(SUM(A_Preis))
                    OVER ())*100,2)                  AS "da;Prozent"))) AS Text        
  FROM anruf INNER JOIN tarif
  ON anruf.A_TNr = tarif.T_Nr
GROUP BY T_Name, T_Nr, EXTRACT(YEAR FROM A_Beginn), T_Typ, T_GueVon, T_GueBis
ORDER BY EXTRACT(YEAR FROM A_Beginn), T_Name, T_Nr; 