SET LONG 20000;
SELECT XMLELEMENT("Tarif", XMLATTRIBUTES(A_TNr AS "Nr", T_Typ AS "Typ"),
        XMLFOREST(T_Name AS "Name",        
                  T_Preis AS "Preis"),
        XMLELEMENT("GueDatum", XMLATTRIBUTES('Gueltigkeit' AS "Typ"),
         XMLFOREST(TO_CHAR(T_GueVon, 'YY-MM-DD') AS "Von",
                   TO_CHAR(T_GueBis, 'YY-MM-DD') AS "Bis")),
        XMLELEMENT("GueUhrzeit", XMLATTRIBUTES('Gueltigkeit' AS "Typ"),
         XMLFOREST(T_Ende AS "Von",
                   T_Beginn AS "Bis")),
        XMLELEMENT("Umsatz",
         XMLELEMENT("Anrufe", COUNT(A_Nr)),
         XMLELEMENT("Kunden",
           (SELECT COUNT(DISTINCT A_Von)
              FROM anruf c
             WHERE a.A_TNr = c.A_TNr)),         
             XMLELEMENT("Summe",
          XMLFOREST(         
                   ROUND(SUM(A_Preis)/100,2) AS "Gesamt",
       ROUND(ROUND(SUM(A_Preis)/100,2) /
       (SELECT COUNT(DISTINCT A_Von)
          FROM anruf c
         WHERE a.A_TNr = c.A_TNr),2) AS "ProKopf")))) as text
  FROM anruf a INNER JOIN tarif b
    ON a.A_TNr = b.T_Nr
  GROUP BY A_TNr, T_Name, T_Preis, T_GueVon, T_GueBis, T_Beginn, T_Ende, T_Typ
  ORDER BY T_Name;