/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.IndirectlyCollapseFilter;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.ICollapseUpdater;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class CollapseUpdater
implements ICollapseUpdater {
    public static ICollapseUpdater getICollapseUpdater(DDiagram diagram) {
        CollapseUpdater collapseUpdater = null;
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            Option optionalCollapseUpdater = diagramTypeDescriptor.getDiagramDescriptionProvider().getCollapseUpdater(diagram);
            if (!optionalCollapseUpdater.some()) continue;
            collapseUpdater = (ICollapseUpdater)optionalCollapseUpdater.get();
        }
        if (collapseUpdater == null) {
            collapseUpdater = new CollapseUpdater();
        }
        return collapseUpdater;
    }

    public void synchronizeCollapseFiltersAndGMFBounds(DDiagramElement element, boolean add, Class<? extends CollapseFilter> kindOfFilter) {
        EObjectQuery eObjectQuery = new EObjectQuery((EObject)element);
        Iterable nodes = Iterables.filter((Iterable)eObjectQuery.getInverseReferences(NotationPackage.eINSTANCE.getView_Element()), Node.class);
        if (nodes.iterator().hasNext()) {
            Node node = (Node)nodes.iterator().next();
            this.synchronizeCollapseFiltersAndGMFBounds(element, (Option<Node>)Options.newSome((Object)node), add, kindOfFilter);
        } else {
            this.synchronizeCollapseFiltersAndGMFBounds(element, (Option<Node>)Options.newNone(), add, kindOfFilter);
        }
    }

    protected void synchronizeCollapseFiltersAndGMFBounds(DDiagramElement element, Option<Node> optionalNode, boolean add, Class<? extends CollapseFilter> kindOfFilter) {
        if (add) {
            this.addNewGraphicalFilter(element, optionalNode, kindOfFilter);
        } else {
            this.removeGraphicalFilter(element, optionalNode, kindOfFilter);
        }
    }

    protected void addNewGraphicalFilter(DDiagramElement element, Option<Node> optionalNode, Class<? extends CollapseFilter> kindOfFilter) {
        DDiagramElementQuery query = new DDiagramElementQuery(element);
        boolean isAlreayCollapsed = query.isIndirectlyCollapsed();
        if (kindOfFilter.equals(CollapseFilter.class)) {
            if (!query.isCollapsed()) {
                CollapseFilter collapseApplication = DiagramFactory.eINSTANCE.createCollapseFilter();
                element.getGraphicalFilters().add((Object)collapseApplication);
            }
            this.addIndirectlyCollapseFilterToChildren(element);
        } else if (kindOfFilter.equals(IndirectlyCollapseFilter.class) && !query.isOnlyIndirectlyCollapsed()) {
            IndirectlyCollapseFilter indirectlyCollapseFilter = DiagramFactory.eINSTANCE.createIndirectlyCollapseFilter();
            element.getGraphicalFilters().add((Object)indirectlyCollapseFilter);
        }
        this.storeInFilterAndCollapseBounds(element, optionalNode, isAlreayCollapsed);
    }

    public void storeInFilterAndCollapseBounds(DDiagramElement element, Option<Node> optionalNode, boolean isAlreayCollapsed) {
        if (optionalNode.some()) {
            this.saveBoundsInFilter((Node)optionalNode.get(), element);
            NodeQuery nodeQuery = new NodeQuery((Node)optionalNode.get());
            boolean isBorderedNode = nodeQuery.isBorderedNode();
            if (!isAlreayCollapsed && isBorderedNode) {
                this.collapseBounds((Node)optionalNode.get(), element);
            }
        }
    }

    protected void removeGraphicalFilter(DDiagramElement element, Option<Node> optionalNode, Class<? extends CollapseFilter> kindOfFilter) {
        NodeQuery nodeQuery;
        Option<Bounds> optionalExpandedBounds = optionalNode.some() ? this.getExpandedBounds((Node)optionalNode.get(), element) : Options.newNone();
        if (kindOfFilter.equals(CollapseFilter.class)) {
            for (CollapseFilter collapseApplication : Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)element.getGraphicalFilters(), CollapseFilter.class), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(IndirectlyCollapseFilter.class))))) {
                element.getGraphicalFilters().remove((Object)collapseApplication);
            }
            this.removeFromChildrenIndirectlyCollapsedFilter(element);
        } else if (kindOfFilter.equals(IndirectlyCollapseFilter.class)) {
            for (CollapseFilter collapseApplication : Lists.newArrayList((Iterable)Iterables.filter((Iterable)element.getGraphicalFilters(), IndirectlyCollapseFilter.class))) {
                element.getGraphicalFilters().remove((Object)collapseApplication);
            }
        }
        if (optionalNode.some() && !(nodeQuery = new NodeQuery((Node)optionalNode.get())).isCollapsed() && nodeQuery.isBorderedNode() && optionalExpandedBounds.some()) {
            ((Node)optionalNode.get()).setLayoutConstraint((LayoutConstraint)optionalExpandedBounds.get());
        }
    }

    public void collapseBounds(Node node, DDiagramElement element) {
        Option<Bounds> option = new NodeQuery(node).getCollapsedBounds();
        if (option.some()) {
            node.setLayoutConstraint((LayoutConstraint)option.get());
        }
    }

    public Option<Bounds> getExpandedBounds(Node node, DDiagramElement element) {
        return new NodeQuery(node).getExtendedBounds();
    }

    protected void saveBoundsInFilter(Node node, DDiagramElement diagramElement) {
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            Bounds bounds = (Bounds)layoutConstraint;
            int referenceWidth = bounds.getWidth();
            int referenceHeight = bounds.getHeight();
            for (CollapseFilter filter : Iterables.filter((Iterable)diagramElement.getGraphicalFilters(), CollapseFilter.class)) {
                if (filter.eIsSet((EStructuralFeature)DiagramPackage.eINSTANCE.getCollapseFilter_Width()) && filter.eIsSet((EStructuralFeature)DiagramPackage.eINSTANCE.getCollapseFilter_Height())) {
                    referenceWidth = filter.getWidth();
                    referenceHeight = filter.getHeight();
                    continue;
                }
                filter.setWidth(referenceWidth);
                filter.setHeight(referenceHeight);
            }
        }
    }

    private List<DDiagramElement> getAllChildren(DDiagramElement element) {
        ArrayList allChildren = Lists.newArrayList();
        if (element instanceof AbstractDNode) {
            AbstractDNode abstractDNode = (AbstractDNode)element;
            allChildren.addAll(abstractDNode.getOwnedBorderedNodes());
            if (abstractDNode instanceof DNodeContainer) {
                DNodeContainer dDiagramElementContainer = (DNodeContainer)abstractDNode;
                allChildren.addAll(dDiagramElementContainer.getOwnedDiagramElements());
            } else if (abstractDNode instanceof DNodeList) {
                DNodeList dNodeList = (DNodeList)abstractDNode;
                allChildren.addAll(dNodeList.getOwnedElements());
            }
        }
        return allChildren;
    }

    protected void addIndirectlyCollapseFilterToChildren(DDiagramElement element) {
        List<DDiagramElement> children = this.getAllChildren(element);
        for (DDiagramElement child : children) {
            this.synchronizeCollapseFiltersAndGMFBounds(child, true, IndirectlyCollapseFilter.class);
        }
    }

    protected void removeFromChildrenIndirectlyCollapsedFilter(DDiagramElement element) {
        List<DDiagramElement> children = this.getAllChildren(element);
        for (DDiagramElement child : children) {
            this.synchronizeCollapseFiltersAndGMFBounds(child, false, IndirectlyCollapseFilter.class);
        }
    }
}

