/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.browser;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.ui.PlatformUI;

public class DiagramEditorBrowser {
    private final DiagramDocumentEditor editor;

    public DiagramEditorBrowser(DiagramDocumentEditor editor) {
        this.editor = editor;
    }

    public Iterator<IGraphicalEditPart> findEditPart(Predicate<IGraphicalEditPart> match) {
        return this.filterMatchingEditParts(match, this.allEditParts());
    }

    private Iterator<IGraphicalEditPart> filterMatchingEditParts(final Predicate<IGraphicalEditPart> predicate, Iterator<IGraphicalEditPart> parts) {
        UnmodifiableIterator mines = Iterators.filter(parts, (Predicate)new Predicate<IGraphicalEditPart>(){

            public boolean apply(IGraphicalEditPart input) {
                return predicate.apply((Object)input);
            }
        });
        return mines;
    }

    public Iterator<IGraphicalEditPart> allEditParts() {
        AbstractTreeIterator<IGraphicalEditPart> it = new AbstractTreeIterator<IGraphicalEditPart>((IGraphicalEditPart)this.editor.getDiagramEditPart()){

            protected Iterator<? extends IGraphicalEditPart> getChildren(Object object) {
                if (object instanceof IGraphicalEditPart) {
                    return ((IGraphicalEditPart)object).getChildren().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        return it;
    }

    public void arrangeAll() throws InterruptedException {
        this.synchronizationWithUIThread();
        ArrangeRequest request = new ArrangeRequest("arrangeAllAction");
        request.setPartsToArrange((List)Lists.newArrayList((Object[])new DiagramEditPart[]{this.editor.getDiagramEditPart()}));
        this.editor.getDiagramEditPart().refresh();
        this.editor.getDiagramEditPart().performRequest((Request)request);
        this.editor.getEditingDomain().getCommandStack().flush();
        this.editor.getDiagramEditPart().getRoot().getViewer().flush();
        this.synchronizationWithUIThread();
        Thread.sleep(30000L);
        this.synchronizationWithUIThread();
    }

    private void synchronizationWithUIThread() {
        while (PlatformUI.getWorkbench().getDisplay().readAndDispatch()) {
        }
    }
}

