/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.util.Proxy;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.AbstractDiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DefaultDirectEditOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramBorderNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.EditStatusUpdater;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.edit.internal.validators.ResizeValidator;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SpecificBorderItemSelectionEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewLocationHint;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.diagram.ui.tools.api.permission.EditPartAuthorityListener;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.SiriusDragEditPartsTrackerEx;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractDiagramBorderNodeEditPart
extends BorderedBorderItemEditPart
implements IDiagramBorderNodeEditPart {
    protected EditPartAuthorityListener authListener = new EditPartAuthorityListener(this);
    private NotificationListener adapterDiagramElement;
    private NotificationPreCommitListener adapterSemanticElements;
    private NotificationListener editModeListener = new EditStatusUpdater(this);

    public AbstractDiagramBorderNodeEditPart(View view) {
        super(view);
    }

    protected void registerModel() {
        super.registerModel();
        DiagramElementEditPartOperation.registerModel(this);
    }

    protected void unregisterModel() {
        super.unregisterModel();
        DiagramElementEditPartOperation.unregisterModel(this);
    }

    protected void handleNotificationEvent(Notification notification) {
        EObject element;
        IStyleEditPart styleEditPart = this.getStyleEditPart();
        if (styleEditPart != null && (element = ((IGraphicalEditPart)styleEditPart).resolveSemanticElement()) != null && element.eResource() != null) {
            styleEditPart.refresh();
        }
        if ((element = this.resolveSemanticElement()) != null && element.eResource() != null && this.getParent() != null) {
            this.refresh();
        }
        super.handleNotificationEvent(notification);
        AbstractDiagramNodeEditPartOperation.handleNotificationEvent(this, notification);
        DiagramBorderNodeEditPartOperation.handleNotificationEvent(this, notification);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        AbstractDiagramNodeEditPartOperation.createDefaultEditPolicies(this);
    }

    @Override
    public NotificationListener getEAdapterDiagramElement() {
        if (this.adapterDiagramElement == null) {
            this.adapterDiagramElement = DiagramElementEditPartOperation.createEApdaterDiagramElement(this);
        }
        return this.adapterDiagramElement;
    }

    @Override
    public NotificationPreCommitListener getEAdapterSemanticElements() {
        if (this.adapterSemanticElements == null) {
            this.adapterSemanticElements = DiagramElementEditPartOperation.createEAdpaterSemanticElements(this);
        }
        return this.adapterSemanticElements;
    }

    @Override
    public NotificationListener getEditModeListener() {
        return this.editModeListener;
    }

    @Override
    public IStyleEditPart getStyleEditPart() {
        return DiagramElementEditPartOperation.getStyleEditPart(this);
    }

    @Override
    public List<EObject> resolveAllSemanticElements() {
        return DiagramElementEditPartOperation.resolveAllSemanticElements(this);
    }

    @Override
    public DDiagramElement resolveDiagramElement() {
        return DiagramElementEditPartOperation.resolveDiagramElement(this);
    }

    @Override
    public EObject resolveTargetSemanticElement() {
        return DiagramElementEditPartOperation.resolveTargetSemanticElement(this);
    }

    @Override
    public EditPartAuthorityListener getEditPartAuthorityListener() {
        return this.authListener;
    }

    public void activate() {
        if (!this.isActive()) {
            IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
            auth.addAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
            super.activate();
            DiagramElementEditPartOperation.activate(this);
        }
        this.getEditPartAuthorityListener().refreshEditMode();
    }

    public void enableEditMode() {
        if (!this.getEditPartAuthorityListener().isLocked()) {
            super.enableEditMode();
        }
    }

    public void deactivate() {
        DiagramElementEditPartOperation.deactivate(this);
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
        auth.removeAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
        if (this.isActive()) {
            super.deactivate();
        }
    }

    public void refresh() {
        EObject element = this.resolveSemanticElement();
        if (element != null && element.eResource() != null && this.getMetamodelType().isInstance(element)) {
            super.refresh();
            List children = this.getChildren();
            int i = 0;
            while (i < children.size()) {
                EditPart editPart = (EditPart)children.get(i);
                editPart.refresh();
                ++i;
            }
        }
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.refreshVisuals();
    }

    protected List<?> getModelChildren() {
        DNode node;
        ArrayList modelChildren = new ArrayList(super.getModelChildren());
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        DDiagramElement diagramElement = this.resolveDiagramElement();
        if (diagramElement instanceof DNode && (((NodeStyle)(node = (DNode)diagramElement).getStyle()).getLabelPosition() == LabelPosition.NODE_LITERAL || StringUtil.isEmpty((String)node.getName()))) {
            DiagramNodeEditPartOperation.removeLabel(this, modelChildren);
        }
        return modelChildren;
    }

    protected List<?> getModelSourceConnections() {
        ArrayList modelChildren = Lists.newArrayList((Iterable)Iterables.filter((Iterable)super.getModelSourceConnections(), View.class));
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        return modelChildren;
    }

    protected List<View> getModelTargetConnections() {
        ArrayList modelChildren = Lists.newArrayList((Iterable)Iterables.filter((Iterable)super.getModelTargetConnections(), View.class));
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        return modelChildren;
    }

    @Override
    public IBorderItemLocator createBorderItemLocator(IFigure figure, DDiagramElement vpElementBorderItem) {
        return AbstractDiagramNodeEditPartOperation.createBorderItemLocator(this, figure, vpElementBorderItem);
    }

    protected Command getPortCreationCommand(Command originalCommand, CreateViewRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Create View");
        compositeCommand.compose((IUndoableOperation)new CommandProxy(originalCommand));
        LayoutUtils.prepareFigureForDummyAdds(this.getBorderedFigure().getBorderItemContainer());
        for (CreateViewRequest.ViewDescriptor viewDescriptor : Iterables.filter((Iterable)request.getViewDescriptors(), CreateViewRequest.ViewDescriptor.class)) {
            EObject containerSemanticElement;
            Object createdElement;
            IAdaptable adapt = viewDescriptor.getElementAdapter();
            if (!(adapt instanceof Proxy) || !((createdElement = ((Proxy)adapt).getRealObject()) instanceof DNode) || !((DNode)(containerSemanticElement = this.resolveSemanticElement())).getActualMapping().getAllBorderedNodeMappings().contains((Object)((DNode)createdElement).getActualMapping())) continue;
            Rectangle bounds = PortLayoutHelper.getBounds(this, (DNode)createdElement, viewDescriptor, (DDiagramElement)containerSemanticElement);
            viewDescriptor.setPersisted(true);
            compositeCommand.compose((IUndoableOperation)new SetBoundsCommand(this.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, bounds));
            compositeCommand.compose((IUndoableOperation)SiriusLayoutDataManager.INSTANCE.getAddAdapterMakerCommand(this.getEditingDomain(), (IAdaptable)viewDescriptor));
        }
        LayoutUtils.releaseDummys(this.getBorderedFigure().getBorderItemContainer());
        return new ICommandProxy(compositeCommand.reduce());
    }

    public Command getResizeBorderItemCommand(ChangeBoundsRequest request) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        EObject element = this.resolveSemanticElement();
        boolean valid = true;
        ResizeValidator resizeValidator = new ResizeValidator(request);
        valid = resizeValidator.validate();
        if (valid && this.getMetamodelType().isInstance(element)) {
            for (Object next : request.getEditParts()) {
                if (!(next instanceof IGraphicalEditPart)) break;
                IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)next;
                Command result = DiagramBorderNodeEditPartOperation.getResizeBorderItemCommand(graphicalEditPart, request);
                if (result == null) continue;
                cmd = result;
                break;
            }
        }
        return cmd;
    }

    @Override
    public Image getLabelIcon() {
        return DiagramElementEditPartOperation.getLabelIcon(this);
    }

    @Override
    public void refreshFigure() {
        DiagramBorderNodeEditPartOperation.refreshFigure(this);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        DiagramBorderNodeEditPartOperation.refreshVisuals(this);
    }

    protected void refreshFont() {
        super.refreshFont();
        DiagramBorderNodeEditPartOperation.refreshFont(this);
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        SpecificBorderItemSelectionEditPolicy result = new SpecificBorderItemSelectionEditPolicy();
        DDiagramElement dde = this.resolveDiagramElement();
        if (dde instanceof DNode) {
            DNode node = (DNode)dde;
            DiagramBorderNodeEditPartOperation.updateResizeKind((ResizableEditPolicy)result, node);
        }
        return result;
    }

    @Override
    public void setTooltipText(String text) {
        AbstractDiagramNodeEditPartOperation.setTooltipText(this, text);
    }

    public Command getCommand(Request request) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        RequestQuery requestQuery = new RequestQuery(request);
        if (!(requestQuery.isNoteCreationRequest() || requestQuery.isTextCreationRequest() || requestQuery.isNoteDropRequest() || requestQuery.isTextDropRequest())) {
            Command cmd = super.getCommand(request);
            result = CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, cmd);
        }
        return result;
    }

    @Override
    public ZoomManager getZoomManager() {
        return AbstractDiagramNodeEditPartOperation.getZoomManager(this);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("sourceConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("sourceConnectionAnchorLocation");
                return this.getNodeFigure().getSourceConnectionAnchorAt(realLocation);
            }
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("targetConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("targetConnectionAnchorLocation");
                return this.getNodeFigure().getTargetConnectionAnchorAt(realLocation);
            }
        }
        return super.getTargetConnectionAnchor(request);
    }

    public DragTracker getDragTracker(Request request) {
        SiriusDragEditPartsTrackerEx result = request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3 ? null : new SiriusDragEditPartsTrackerEx((EditPart)this);
        return result;
    }

    protected void performDirectEditRequest(Request request) {
        if (this.getChildren().isEmpty() || !(this.getChildren().get(0) instanceof IDiagramNameEditPart) || this.getNodeLabel() == null) {
            DefaultDirectEditOperation.performDirectEditRequest(this, request, this.getNodeLabel());
        } else {
            super.performDirectEditRequest(request);
        }
    }
}

