/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.RegionContainerUpdateLayoutOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class RegionContainerResizableEditPolicy
extends AirResizableEditPolicy {
    protected static final String REGION_AUTO_SIZE_PROPAGATOR = "region_auto-size_propagator";

    @Override
    protected Command getAutoSizeCommand(Request request) {
        Command autoSizeCommand = super.getAutoSizeCommand(request);
        if (this.concernRegionContainer()) {
            IDiagramElementEditPart host = (IDiagramElementEditPart)this.getHost();
            TransactionalEditingDomain domain = host.getEditingDomain();
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(domain, "Region Container Auto Size Command");
            ctc.add((IUndoableOperation)new CommandProxy(autoSizeCommand));
            autoSizeCommand = new ICommandProxy((ICommand)ctc);
            Request req = new Request();
            req.setType(request.getType());
            req.getExtendedData().put(REGION_AUTO_SIZE_PROPAGATOR, this.getHost());
            Object object = request.getExtendedData().get(REGION_AUTO_SIZE_PROPAGATOR);
            for (EditPart editPart : this.getRegionParts()) {
                if (object == editPart) continue;
                ctc.add((IUndoableOperation)new CommandProxy(editPart.getCommand(req)));
            }
            ctc.add((IUndoableOperation)CommandFactory.createICommand(domain, new RegionContainerUpdateLayoutOperation((Node)host.getModel())));
        }
        return autoSizeCommand;
    }

    @Override
    protected Command getResizeCommand(ChangeBoundsRequest request) {
        Command resizeCommand = super.getResizeCommand(request);
        if (this.concernRegionContainer()) {
            resizeCommand = this.getRegionContainerResizeCommand(request, resizeCommand);
        }
        return resizeCommand;
    }

    private Command getRegionContainerResizeCommand(ChangeBoundsRequest request, Command command) {
        if (request.getEditParts().size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Command regionsResizeCommand = command;
        Collection<ChangeBoundsRequest> siblingRequests = this.getConstrainedRegionRequests(request);
        if (!siblingRequests.isEmpty()) {
            String name = "Region Container Resize Composite Command";
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(((IDiagramElementEditPart)this.getHost()).getEditingDomain(), name);
            ctc.add((IUndoableOperation)new CommandProxy(command));
            regionsResizeCommand = new ICommandProxy((ICommand)ctc);
            for (ChangeBoundsRequest siblingRequest : siblingRequests) {
                if (siblingRequest.getEditParts() == null) continue;
                for (EditPart constrainedPart : Iterables.filter((Iterable)siblingRequest.getEditParts(), EditPart.class)) {
                    Command constrainedCommand = constrainedPart.getCommand((Request)siblingRequest);
                    if (constrainedCommand == null) {
                        constrainedCommand = UnexecutableCommand.INSTANCE;
                    }
                    ctc.add((IUndoableOperation)new CommandProxy(constrainedCommand));
                }
            }
        } else if (!request.isConstrainedMove() && !request.isConstrainedResize()) {
            regionsResizeCommand = UnexecutableCommand.INSTANCE;
        }
        return regionsResizeCommand;
    }

    private Collection<ChangeBoundsRequest> getConstrainedRegionRequests(ChangeBoundsRequest request) {
        ChangeBoundsRequest req;
        Option<AbstractDiagramElementContainerEditPart> lastRegionPart;
        ArrayList constrainedRequests = Lists.newArrayList();
        RequestQuery query = new RequestQuery((Request)request);
        Dimension sizeDelta = request.getSizeDelta().getCopy();
        Point moveDelta = request.getMoveDelta().getCopy();
        List<AbstractDiagramElementContainerEditPart> regionToResize = this.getRegionParts();
        int stackDirection = this.getStackDirection();
        if (query.isResizeFromTop() && stackDirection == 5 || query.isResizeFromLeft() && stackDirection == 24) {
            ChangeBoundsRequest req2;
            Option<AbstractDiagramElementContainerEditPart> firstRegionPart = this.getFirstRegionPart();
            if (firstRegionPart.some() && !request.isConstrainedResize()) {
                req2 = this.initConstrainedRequest(request);
                req2.setEditParts((EditPart)firstRegionPart.get());
                req2.setSizeDelta(sizeDelta.getCopy());
                constrainedRequests.add(req2);
                regionToResize.remove(firstRegionPart.get());
            }
            if (!regionToResize.isEmpty() && !request.isConstrainedResize()) {
                req2 = this.initConstrainedRequest(request);
                req2.setEditParts((List)Lists.newArrayList(regionToResize));
                if (stackDirection == 5) {
                    req2.setSizeDelta(new Dimension(sizeDelta.width, 0));
                    req2.setMoveDelta(new Point(0, -moveDelta.y));
                } else if (stackDirection == 24) {
                    req2.setSizeDelta(new Dimension(0, sizeDelta.height));
                    req2.setMoveDelta(new Point(-moveDelta.x, 0));
                }
                constrainedRequests.add(req2);
                regionToResize.clear();
            }
        } else if ((query.isResizeFromBottom() && stackDirection == 5 || query.isResizeFromRight() && stackDirection == 24) && (lastRegionPart = this.getLastRegionPart()).some() && !request.isConstrainedResize()) {
            ChangeBoundsRequest req3 = this.initConstrainedRequest(request);
            req3.setEditParts((EditPart)lastRegionPart.get());
            req3.setSizeDelta(sizeDelta.getCopy());
            constrainedRequests.add(req3);
            regionToResize.remove(lastRegionPart.get());
        }
        if (stackDirection == 5 && (query.isResizeFromLeft() || query.isResizeFromRight())) {
            if (!regionToResize.isEmpty() && !request.isConstrainedResize()) {
                req = this.initConstrainedRequest(request);
                req.setEditParts((List)Lists.newArrayList(regionToResize));
                req.setSizeDelta(new Dimension(sizeDelta.width, 0));
                constrainedRequests.add(req);
            }
        } else if (stackDirection == 24 && (query.isResizeFromTop() || query.isResizeFromBottom()) && !regionToResize.isEmpty() && !request.isConstrainedResize()) {
            req = this.initConstrainedRequest(request);
            req.setEditParts((List)Lists.newArrayList(regionToResize));
            req.setSizeDelta(new Dimension(0, sizeDelta.height));
            constrainedRequests.add(req);
        }
        return constrainedRequests;
    }

    private ChangeBoundsRequest initConstrainedRequest(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest();
        req.setConstrainedResize(true);
        req.setConstrainedMove(true);
        req.setType(request.getType());
        req.setResizeDirection(request.getResizeDirection());
        return req;
    }

    private boolean concernRegionContainer() {
        boolean regionImpacted = false;
        EditPart hostPart = this.getHost();
        if (hostPart instanceof AbstractDiagramElementContainerEditPart) {
            IDiagramElementEditPart ideep = (IDiagramElementEditPart)hostPart;
            DDiagramElement dde = ideep.resolveDiagramElement();
            regionImpacted = dde instanceof DNodeContainer && new DNodeContainerExperimentalQuery((DNodeContainer)dde).isRegionContainer();
        }
        return regionImpacted;
    }

    private int getStackDirection() {
        IDiagramElementEditPart ideep;
        DDiagramElement dde;
        int direction = 0;
        EditPart hostPart = this.getHost();
        if (hostPart instanceof AbstractDiagramElementContainerEditPart && (dde = (ideep = (IDiagramElementEditPart)hostPart).resolveDiagramElement()) instanceof DNodeContainer) {
            DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery((DNodeContainer)dde);
            if (query.isVerticalStackContainer()) {
                direction = 5;
            } else if (query.isHorizontaltackContainer()) {
                direction = 24;
            }
        }
        return direction;
    }

    private List<AbstractDiagramElementContainerEditPart> getRegionParts() {
        AbstractDNodeContainerCompartmentEditPart comp = (AbstractDNodeContainerCompartmentEditPart)Iterables.getFirst((Iterable)Iterables.filter((Iterable)this.getHost().getChildren(), AbstractDNodeContainerCompartmentEditPart.class), null);
        if (comp != null) {
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)comp.getChildren(), AbstractDiagramElementContainerEditPart.class));
        }
        return Collections.emptyList();
    }

    private Option<AbstractDiagramElementContainerEditPart> getFirstRegionPart() {
        List<AbstractDiagramElementContainerEditPart> regionParts = this.getRegionParts();
        return Options.newSome((Object)((AbstractDiagramElementContainerEditPart)Iterables.getFirst(regionParts, null)));
    }

    private Option<AbstractDiagramElementContainerEditPart> getLastRegionPart() {
        List<AbstractDiagramElementContainerEditPart> regionParts = this.getRegionParts();
        return Options.newSome((Object)((AbstractDiagramElementContainerEditPart)Iterables.getLast(regionParts, null)));
    }
}

