/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SetConnectionBendpointsAccordingToDraw2DCommand
extends SetConnectionBendpointsCommand {
    private boolean sourceMove;
    private PrecisionPoint moveDelta;

    public SetConnectionBendpointsAccordingToDraw2DCommand(TransactionalEditingDomain editingDomain) {
        super(editingDomain);
    }

    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.getEdgeAdaptor() instanceof ConnectionEditPart) {
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getEdgeAdaptor();
            GraphicalHelper.applyInverseZoomOnPoint((IGraphicalEditPart)connectionEditPart, (Point)this.moveDelta);
            Connection connection = connectionEditPart.getConnectionFigure();
            Point tempSourceRefPoint = connection.getSourceAnchor().getReferencePoint();
            connection.translateToRelative((Translatable)tempSourceRefPoint);
            Point tempTargetRefPoint = connection.getTargetAnchor().getReferencePoint();
            connection.translateToRelative((Translatable)tempTargetRefPoint);
            PointList connectionPointList = connection.getPoints().getCopy();
            if (this.sourceMove) {
                boolean changeXDelta;
                tempSourceRefPoint.performTranslate(this.moveDelta.x, this.moveDelta.y);
                IFigure sourceAnchorOnwer = connection.getSourceAnchor().getOwner();
                Rectangle rBox = sourceAnchorOnwer instanceof Connection ? ((Connection)sourceAnchorOnwer).getPoints().getBounds() : sourceAnchorOnwer.getBounds();
                PrecisionRectangle boxBeforeMove = new PrecisionRectangle(rBox);
                sourceAnchorOnwer.translateToAbsolute((Translatable)boxBeforeMove);
                PrecisionRectangle boxAfterMove = new PrecisionRectangle(boxBeforeMove.getCopy());
                boxAfterMove.translate((Point)this.moveDelta);
                boolean bl = changeXDelta = boxBeforeMove.x != boxAfterMove.x;
                if (connectionPointList.getPoint((int)1).y < boxAfterMove.getCenter().y) {
                    if (connectionPointList.getPoint((int)1).y < boxBeforeMove.getCenter().y) {
                        connectionPointList.setPoint(connectionPointList.getFirstPoint().translate((Point)this.moveDelta), 0);
                        if (changeXDelta) {
                            connectionPointList.setPoint(connectionPointList.getPoint(1).translate(this.moveDelta.x, 0), 1);
                        }
                    } else {
                        connectionPointList.setPoint(connectionPointList.getFirstPoint().translate(this.moveDelta.x, this.moveDelta.y - boxBeforeMove.height), 0);
                        if (changeXDelta) {
                            connectionPointList.setPoint(connectionPointList.getPoint(1).translate(this.moveDelta.x, 0), 1);
                        }
                    }
                } else if (connectionPointList.getPoint((int)1).y < boxBeforeMove.getCenter().y) {
                    connectionPointList.setPoint(connectionPointList.getFirstPoint().translate(this.moveDelta.x, this.moveDelta.y + boxBeforeMove.height), 0);
                    if (changeXDelta) {
                        connectionPointList.setPoint(connectionPointList.getPoint(1).translate(this.moveDelta.x, 0), 1);
                    }
                } else {
                    connectionPointList.setPoint(connectionPointList.getFirstPoint().translate(this.moveDelta.x, this.moveDelta.y), 0);
                    if (changeXDelta) {
                        connectionPointList.setPoint(connectionPointList.getPoint(1).translate(this.moveDelta.x, 0), 1);
                    }
                }
            } else {
                boolean changeXDelta;
                tempTargetRefPoint.performTranslate(this.moveDelta.x, this.moveDelta.y);
                IFigure targetAnchorOnwer = connection.getTargetAnchor().getOwner();
                Rectangle rBox = targetAnchorOnwer instanceof Connection ? ((Connection)targetAnchorOnwer).getPoints().getBounds() : targetAnchorOnwer.getBounds();
                PrecisionRectangle boxBeforeMove = new PrecisionRectangle(rBox.getCopy());
                targetAnchorOnwer.translateToAbsolute((Translatable)boxBeforeMove.getCopy());
                PrecisionRectangle boxAfterMove = new PrecisionRectangle(boxBeforeMove.getCopy());
                boxAfterMove.translate((Point)this.moveDelta);
                boolean bl = changeXDelta = boxBeforeMove.x != boxAfterMove.x;
                if (connectionPointList.getPoint((int)1).y < boxAfterMove.getCenter().y) {
                    if (connectionPointList.getPoint((int)1).y < boxBeforeMove.getCenter().y) {
                        connectionPointList.setPoint(connectionPointList.getLastPoint().translate((Point)this.moveDelta), 3);
                        if (changeXDelta) {
                            connectionPointList.setPoint(connectionPointList.getPoint(2).translate(this.moveDelta.x, 0), 2);
                        }
                    } else {
                        connectionPointList.setPoint(connectionPointList.getLastPoint().translate(this.moveDelta.x, this.moveDelta.y - boxBeforeMove.height), 3);
                        if (changeXDelta) {
                            connectionPointList.setPoint(connectionPointList.getPoint(2).translate(this.moveDelta.x, 0), 2);
                        }
                    }
                } else if (connectionPointList.getPoint((int)1).y < boxBeforeMove.getCenter().y) {
                    connectionPointList.setPoint(connectionPointList.getLastPoint().translate(this.moveDelta.x, this.moveDelta.y + boxBeforeMove.height), 3);
                    if (changeXDelta) {
                        connectionPointList.setPoint(connectionPointList.getPoint(2).translate(this.moveDelta.x, 0), 2);
                    }
                } else {
                    connectionPointList.setPoint(connectionPointList.getLastPoint().translate(this.moveDelta.x, this.moveDelta.y), 3);
                    if (changeXDelta) {
                        connectionPointList.setPoint(connectionPointList.getPoint(2).translate(this.moveDelta.x, 0), 2);
                    }
                }
            }
            this.setNewPointList(connectionPointList, tempSourceRefPoint, tempTargetRefPoint);
            return super.doExecute(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public void setSourceMove(boolean sourceMove) {
        this.sourceMove = sourceMove;
    }

    public void setMoveDelta(PrecisionPoint moveDelta) {
        this.moveDelta = moveDelta;
    }
}

