/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class RegionContainerUpdateLayoutOperation
extends AbstractModelChangeOperation<Void> {
    private final Node regionContainer;

    public RegionContainerUpdateLayoutOperation(Node regionContainer) {
        super("Layout Regions Operations");
        this.regionContainer = this.extractRealRegionContainer(regionContainer);
    }

    private Node extractRealRegionContainer(Node node) {
        int visualID;
        if (node != null && node.eContainer() instanceof Node && (7001 == (visualID = SiriusVisualIDRegistry.getVisualID((View)node)) || 7002 == visualID)) {
            return (Node)node.eContainer();
        }
        return node;
    }

    private List<Node> getRegionsToLayout() {
        ArrayList regionsToLayout = Lists.newArrayList();
        if (this.regionContainer != null) {
            Node labelNode = SiriusGMFHelper.getLabelNode((View)this.regionContainer);
            ArrayList nodes = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.regionContainer.getChildren(), Node.class));
            if (labelNode != null && nodes.size() == 2) {
                nodes.remove(labelNode);
                Node compartment = (Node)nodes.iterator().next();
                Iterables.addAll((Collection)regionsToLayout, (Iterable)Iterables.filter((Iterable)compartment.getChildren(), Node.class));
            }
        }
        return regionsToLayout;
    }

    @Override
    public Void execute() {
        List<Node> regionsToLayout = this.getRegionsToLayout();
        if (!regionsToLayout.isEmpty()) {
            RegionContainerUpdateLayoutOperation.sortRegions((View)this.regionContainer, regionsToLayout);
            EObject element = this.regionContainer.getElement();
            if (element instanceof DNodeContainer) {
                DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery((DNodeContainer)element);
                if (query.isVerticalStackContainer()) {
                    this.updateRegionsLayoutContraints(regionsToLayout, true);
                } else if (query.isHorizontaltackContainer()) {
                    this.updateRegionsLayoutContraints(regionsToLayout, false);
                }
            }
        }
        return null;
    }

    private void updateRegionsLayoutContraints(List<Node> regionsToLayout, boolean vertical) {
        HashMap regionBounds = Maps.newHashMap();
        int commonWidth = -1;
        int commonHeight = -1;
        for (Node node : regionsToLayout) {
            Rectangle bounds = GMFHelper.getBounds(node, true, true);
            commonWidth = Math.max(commonWidth, bounds.width);
            commonHeight = Math.max(commonHeight, bounds.height);
            regionBounds.put(node, bounds);
        }
        int y = this.getMinY();
        int x = 0;
        for (Node node : regionsToLayout) {
            Rectangle bounds = (Rectangle)regionBounds.get(node);
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Location) {
                Location loc = (Location)layoutConstraint;
                loc.setX(x);
                loc.setY(y);
            }
            if (vertical) {
                y += bounds.height;
            } else {
                x += bounds.width;
            }
            if (!(layoutConstraint instanceof Size)) continue;
            Size size = (Size)layoutConstraint;
            if (size.getWidth() != -1 && vertical) {
                size.setWidth(commonWidth);
            }
            if (size.getHeight() == -1 || vertical) continue;
            size.setHeight(commonHeight);
        }
        LayoutConstraint layoutConstraint = this.regionContainer.getLayoutConstraint();
        if (layoutConstraint instanceof Size) {
            Size size = (Size)layoutConstraint;
            if (vertical) {
                size.setHeight(-1);
            } else {
                size.setWidth(-1);
            }
        }
    }

    private int getMinY() {
        int y = 0;
        Node labelNode = SiriusGMFHelper.getLabelNode((View)this.regionContainer);
        if (labelNode != null) {
            y = GMFHelper.getBounds(labelNode, true).bottom();
        }
        return y;
    }

    public static void sortRegions(View containerNode, List<? extends View> modelChildren) {
        Collections.sort(modelChildren, new IndexComparator(containerNode));
        Collections.sort(modelChildren, new MappingComparator(containerNode));
    }

    private static class IndexComparator
    implements Comparator<View> {
        private final View container;

        public IndexComparator(View container) {
            this.container = container;
        }

        @Override
        public int compare(View o1, View o2) {
            EObject semantic = ViewUtil.resolveSemanticElement((View)this.container);
            if (semantic instanceof DNodeContainer) {
                EObject sem1 = ViewUtil.resolveSemanticElement((View)o1);
                EObject sem2 = ViewUtil.resolveSemanticElement((View)o2);
                if (sem1 instanceof DDiagramElementContainer && sem2 instanceof DDiagramElementContainer) {
                    DNodeContainer dNodeContainer = (DNodeContainer)semantic;
                    return dNodeContainer.getContainers().indexOf((Object)sem1) - dNodeContainer.getContainers().indexOf((Object)sem2);
                }
            }
            return 0;
        }
    }

    private static class MappingComparator
    implements Comparator<View> {
        private final View containerView;

        public MappingComparator(View container) {
            this.containerView = container;
        }

        @Override
        public int compare(View view0, View view1) {
            EObject eObj;
            EObject element0 = view0.getElement();
            EObject element1 = view1.getElement();
            if (element0 instanceof DMappingBased && element1 instanceof DMappingBased && (eObj = this.containerView.getElement()) instanceof DNodeContainer) {
                DNodeContainer container = (DNodeContainer)eObj;
                EList allMappings = container.getActualMapping().getAllContainerMappings();
                RepresentationElementMapping origin0 = ((DMappingBased)element0).getMapping();
                RepresentationElementMapping origin1 = ((DMappingBased)element1).getMapping();
                return allMappings.indexOf(origin0) - allMappings.indexOf(origin1);
            }
            return 0;
        }
    }
}

