/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.preferences;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.gmf.runtime.common.ui.preferences.CheckBoxFieldEditor;
import org.eclipse.gmf.runtime.common.ui.preferences.ComboFieldEditor;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.preferences.ConnectionsPreferencePage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class DiagramConnectionsPreferencePage
extends ConnectionsPreferencePage {
    private static final String LINE_STYLE_LABEL = DiagramUIMessages.ConnectionsPreferencePage_lineStyle_label;
    private static final String ENABLE_OVERRIDE_LABEL = "Enable user specifc default values. These setting apply to all diagrams (does not affect existing elements).";
    protected ComboFieldEditor lineStyleFieldEditor = null;
    protected CheckBoxFieldEditor enableOverrideFieldEditor = null;
    protected Composite fieldsParent = null;

    public static void initDefaults(IPreferenceStore preferenceStore) {
        ConnectionsPreferencePage.initDefaults((IPreferenceStore)preferenceStore);
    }

    public DiagramConnectionsPreferencePage() {
        this.setPreferenceStore(DiagramUIPlugin.getPlugin().getPreferenceStore());
    }

    protected void addFieldEditors(Composite composite) {
        this.fieldsParent = composite;
        this.enableOverrideFieldEditor = new CheckBoxFieldEditor("Viewpoint.Connectors.enableOverride", ENABLE_OVERRIDE_LABEL, this.fieldsParent);
        this.addField((FieldEditor)this.enableOverrideFieldEditor);
        this.lineStyleFieldEditor = new ComboFieldEditor("Viewpoint.Connectors.lineStyle", LINE_STYLE_LABEL, this.fieldsParent, 1, true, 0, 0, true);
        this.lineStyleFieldEditor.autoStorage = true;
        this.addField((FieldEditor)this.lineStyleFieldEditor);
        Combo lineStyleCombo = this.lineStyleFieldEditor.getComboControl();
        lineStyleCombo.add(DiagramUIMessages.ConnectionsPreferencePage_ConnectionView_Manual_text);
        lineStyleCombo.add(DiagramUIMessages.ConnectionsPreferencePage_ConnectionView_Rectilinear_text);
        lineStyleCombo.add(Routing.TREE_LITERAL.getLiteral());
        lineStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String comboValue = ((Combo)evt.getSource()).getText();
                if (DiagramUIMessages.ConnectionsPreferencePage_ConnectionView_Manual_text.equals(comboValue)) {
                    comboValue = Routing.MANUAL_LITERAL.getLiteral();
                }
                DiagramConnectionsPreferencePage.this.getPreferenceStore().setValue("Connectors.lineStyle", Routing.get((String)comboValue).getValue());
            }
        });
    }

    protected void initialize() {
        super.initialize();
        ScopedPreferenceStore diagramCorePreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.sirius.diagram");
        this.enableOverrideFieldEditor.setPreferenceStore((IPreferenceStore)diagramCorePreferenceStore);
        this.enableOverrideFieldEditor.load();
        this.lineStyleFieldEditor.setPreferenceStore((IPreferenceStore)diagramCorePreferenceStore);
        this.lineStyleFieldEditor.load();
        this.enableLineStyleField(diagramCorePreferenceStore.getBoolean("Viewpoint.Connectors.enableOverride"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.enableOverrideFieldEditor.equals(event.getSource()) && event.getProperty().equals("field_editor_value")) {
            boolean enabled = (Boolean)event.getNewValue();
            this.enableLineStyleField(enabled);
            if (enabled) {
                this.getPreferenceStore().setValue("Connectors.lineStyle", this.lineStyleFieldEditor.getStringValue());
            } else {
                this.getPreferenceStore().setValue("Connectors.lineStyle", 0);
            }
        }
    }

    protected void enableLineStyleField(boolean enable) {
        this.lineStyleFieldEditor.setEnabled(enable, this.fieldsParent);
        this.lineStyleFieldEditor.getComboControl().setEnabled(enable);
    }
}

