/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.RefreshEdgeLayoutNotificationFilter;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class EdgeLayoutUpdaterModelChangeTrigger
implements ModelChangeTrigger {
    public static final int PRIORITY = 5;
    private TransactionalEditingDomain transactionalEditingDomain;
    private SessionEventBroker eventBroker;

    public EdgeLayoutUpdaterModelChangeTrigger(Session session, DDiagram dDiagram) {
        this.transactionalEditingDomain = session.getTransactionalEditingDomain();
        this.eventBroker = session.getEventBroker();
        this.eventBroker.addLocalTrigger((NotificationFilter)new RefreshEdgeLayoutNotificationFilter(dDiagram), (ModelChangeTrigger)this);
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        CompoundCommand command = new CompoundCommand();
        ArrayList<Edge> edgesWithCreatedCommand = new ArrayList<Edge>();
        for (Notification notification : notifications) {
            EObject container;
            if (!RefreshEdgeLayoutNotificationFilter.isNotificationForRefreshEdgeLayout(notification)) continue;
            Object notifier = notification.getNotifier();
            Edge gmfEdge = null;
            if (notifier instanceof DEdge) {
                gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)((DEdge)notifier));
            } else if (notifier instanceof EdgeStyle) {
                container = ((EdgeStyle)notifier).eContainer();
                if (container instanceof DEdge) {
                    gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)((DEdge)container));
                }
            } else if (notifier instanceof RoutingStyle && (container = ((RoutingStyle)notifier).eContainer()) instanceof Edge) {
                gmfEdge = (Edge)container;
            }
            if (gmfEdge == null || edgesWithCreatedCommand.contains(gmfEdge)) continue;
            CenterEdgeEndModelChangeOperation operation = RefreshEdgeLayoutNotificationFilter.otherNotificationsAreIndirectlyConcerned(notification, notifications) ? new CenterEdgeEndModelChangeOperation(gmfEdge) : new CenterEdgeEndModelChangeOperation(gmfEdge, false);
            command.append((Command)CommandFactory.createRecordingCommand(this.transactionalEditingDomain, operation));
            edgesWithCreatedCommand.add(gmfEdge);
        }
        return Options.newSome((Object)command);
    }

    public int priority() {
        return 5;
    }

    public void dispose() {
        this.eventBroker.removeLocalTrigger((ModelChangeTrigger)this);
        this.eventBroker = null;
        this.transactionalEditingDomain = null;
    }
}

