/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.action;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;

public class LaunchBehaviorContributionItem
extends ContributionItem {
    public static final String CONCERN_CONTRIBUTION_ID = "ConcernContributionBehavior";
    private final IPartService service;
    private IPartListener partListener;
    private EditPart viewPointEditPart;
    private Button button;
    private ToolItem toolitem;

    public LaunchBehaviorContributionItem(IPartService partService) {
        super(CONCERN_CONTRIBUTION_ID);
        this.service = partService;
        Assert.isNotNull((Object)partService);
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                EditPart editPArt = (EditPart)part.getAdapter(EditPart.class);
                if (editPArt instanceof RenderedDiagramRootEditPart) {
                    RenderedDiagramRootEditPart root = (RenderedDiagramRootEditPart)editPArt;
                    for (Object child : root.getChildren()) {
                        if (!(child instanceof DDiagramEditPart)) continue;
                        LaunchBehaviorContributionItem.this.viewPointEditPart = (EditPart)((GraphicalEditPart)child);
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
            }

            public void partDeactivated(IWorkbenchPart p) {
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        partService.addPartListener(this.partListener);
    }

    protected Control createControl(Composite parent) {
        this.button = new Button(parent, 8);
        this.button.setText("Launch Behavior");
        this.button.setSize(30, 20);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Request request = new Request((Object)"launchRuleTools");
                LaunchBehaviorContributionItem.this.viewPointEditPart.performRequest(request);
            }
        });
        Image image = DiagramUIPlugin.getPlugin().getImage(DiagramUIPlugin.Implementation.findImageDescriptor("images/Go.gif"));
        this.button.setImage(image);
        this.button.setSize(image.getBounds().width + this.button.getBorderWidth(), image.getBounds().height + this.button.getBorderWidth());
        return this.button;
    }

    public void dispose() {
        if (this.partListener == null) {
            return;
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.dispose();
        }
        if (this.service != null) {
            this.service.removePartListener(this.partListener);
        }
        this.button = null;
        this.partListener = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
        Assert.isTrue((boolean)false, (String)"Can't add a control to a menu");
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }
}

