/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.permission;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.DiagramSemanticElementLockedNotificationFigure;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.PlatformUI;

public class EditPartAuthorityListener
implements IAuthorityListener {
    private IGraphicalEditPart part;

    public EditPartAuthorityListener(IGraphicalEditPart part) {
        this.part = part;
    }

    public void notifyIsLocked(EObject instance) {
        if (this.shouldRefresh(instance)) {
            this.refreshEditMode();
        }
    }

    public void notifyIsReleased(EObject instance) {
        if (this.shouldRefresh(instance)) {
            this.refreshEditMode();
        }
    }

    public void notifyIsLocked(Collection<EObject> instances) {
        for (EObject eObject : instances) {
            if (!this.shouldRefresh(eObject)) continue;
            this.refreshEditMode();
            return;
        }
    }

    public void notifyIsReleased(Collection<EObject> instances) {
        for (EObject eObject : instances) {
            if (!this.shouldRefresh(eObject)) continue;
            this.refreshEditMode();
            return;
        }
    }

    private boolean shouldRefresh(EObject instance) {
        boolean isConcerningDiagramEditPart;
        boolean shouldRefresh = instance != null && this.part.isActive() && this.part.resolveSemanticElement() instanceof DSemanticDecorator;
        boolean isConcerningEditPart = shouldRefresh && instance.equals(((DSemanticDecorator)this.part.resolveSemanticElement()).getTarget());
        boolean bl = isConcerningDiagramEditPart = shouldRefresh && this.part.resolveSemanticElement() instanceof DDiagramElement && ((DDiagramElement)this.part.resolveSemanticElement()).getTarget() != null && instance.equals(((DDiagramElement)this.part.resolveSemanticElement()).getParentDiagram());
        return shouldRefresh && (isConcerningEditPart || isConcerningDiagramEditPart);
    }

    public void refreshEditMode() {
        Option<DDiagramEditor> diagramEditorIfAny = this.getDDiagramEditor();
        if (diagramEditorIfAny.some()) {
            final DDiagramEditor diagramEditor = (DDiagramEditor)diagramEditorIfAny.get();
            final EObject semanticElement = this.part.resolveSemanticElement();
            IPermissionAuthority auth = diagramEditor.getPermissionAuthority();
            final boolean enableEditMode = auth.canEditInstance(semanticElement);
            boolean refreshShouldBePerformedSynchronously = DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiPreferencesKeys.PREF_REFRESH_DECORATORS_SYNCHRONOUSLY.name());
            if (refreshShouldBePerformedSynchronously) {
                this.doRefreshEditMode(enableEditMode, diagramEditor, semanticElement);
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EditPartAuthorityListener.this.doRefreshEditMode(enableEditMode, diagramEditor, semanticElement);
                    }
                });
            }
        }
    }

    protected void doRefreshEditMode(boolean enableEditMode, DDiagramEditor diagramEditor, EObject semanticElement) {
        if (!enableEditMode || !this.isTargetValid(semanticElement)) {
            this.part.disableEditMode();
        } else {
            this.part.enableEditMode();
        }
        DecorationEditPolicy decorationEditPolicy = (DecorationEditPolicy)this.part.getEditPolicy((Object)"DecorationPolicy");
        if (decorationEditPolicy != null && this.part.getParent() != null && this.part.getRoot() != null) {
            decorationEditPolicy.refresh();
        }
        this.doRefreshRootSemanticElementEditMode(diagramEditor, semanticElement);
    }

    private void doRefreshRootSemanticElementEditMode(DDiagramEditor diagramEditor, EObject semanticElement) {
        DDiagramEditPart ddep;
        RootEditPart rootEditPart;
        if (this.part instanceof DDiagramEditPart && semanticElement instanceof DSemanticDecorator && (rootEditPart = (ddep = (DDiagramEditPart)this.part).getRoot()) instanceof DiagramRootEditPart) {
            LockStatus lockStatus = diagramEditor.getPermissionAuthority().getLockStatus(((DSemanticDecorator)semanticElement).getTarget());
            switch (lockStatus) {
                case LOCKED_BY_ME: {
                    DiagramSemanticElementLockedNotificationFigure.createNotification((DiagramRootEditPart)rootEditPart, LockStatus.LOCKED_BY_ME);
                    break;
                }
                case LOCKED_BY_OTHER: {
                    DiagramSemanticElementLockedNotificationFigure.createNotification((DiagramRootEditPart)rootEditPart, LockStatus.LOCKED_BY_OTHER);
                    break;
                }
                default: {
                    DiagramSemanticElementLockedNotificationFigure.removeNotification((DiagramRootEditPart)rootEditPart);
                }
            }
        }
    }

    private boolean isTargetValid(EObject semanticElement) {
        boolean result = true;
        if (semanticElement instanceof DDiagramElement) {
            EObject target = ((DDiagramElement)semanticElement).getTarget();
            result = target != null && target.eResource() != null;
        }
        return result;
    }

    public boolean isLocked() {
        DDiagramEditor diagramEditor;
        if (this.part.getParent() != null && this.part.getRoot() != null && (diagramEditor = (DDiagramEditor)this.part.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID")) != null) {
            IPermissionAuthority auth = diagramEditor.getPermissionAuthority();
            return !auth.canEditInstance(this.part.resolveSemanticElement());
        }
        return false;
    }

    private Option<DDiagramEditor> getDDiagramEditor() {
        Option diagramEditor = Options.newNone();
        try {
            diagramEditor = Options.newSome((Object)((DDiagramEditor)this.part.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID")));
        }
        catch (NullPointerException nullPointerException) {}
        return diagramEditor;
    }
}

