/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.repair;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.repair.IRepairParticipant;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.migration.resource.session.commands.MigrationCommandExecutor;
import org.eclipse.sirius.business.internal.repair.commands.RemoveDiagramElementsCommand;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.FilterVariableValue;
import org.eclipse.sirius.diagram.business.api.helper.concern.ConcernService;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.business.internal.repair.resource.DiagramKey;
import org.eclipse.sirius.diagram.business.internal.repair.resource.RepairRepresentationRefresher;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostEdgeData;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementFactory;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostNodeData;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.concern.ConcernDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.tool.BehaviorTool;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.GMFDiagramUpdater;
import org.eclipse.sirius.diagram.ui.tools.api.migration.DiagramCrossReferencer;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.DiagramElementStateFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.IDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.Identifier;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.commands.RemoveInvalidViewsCommand;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;

public class DiagramRepairParticipant
implements IRepairParticipant {
    private final Map<Identifier, IDiagramElementState<DDiagramElement>> elementStatesMap = Maps.newHashMap();
    private DiagramElementStateFactory diagramElementStateFactory;
    private List<GMFDiagramUpdater> gmfDiagramUpdaters = new ArrayList<GMFDiagramUpdater>();
    private TransactionalEditingDomain editingDomain;
    private ListMultimap<DiagramKey, LostNodeData> lostNodesByDelete;
    private ListMultimap<DiagramKey, LostEdgeData> lostEdgesByDelete;

    public void repairStarted() {
        this.diagramElementStateFactory = DiagramElementStateFactory.newInstance();
        this.lostNodesByDelete = ArrayListMultimap.create();
        this.lostEdgesByDelete = ArrayListMultimap.create();
    }

    public void repairCompeleted() {
        Collection<IDiagramElementState<DDiagramElement>> values = this.elementStatesMap.values();
        for (IDiagramElementState<DDiagramElement> diagramElementState : values) {
            diagramElementState.dispose();
        }
        this.diagramElementStateFactory.dispose();
        this.lostEdgesByDelete.clear();
        this.lostNodesByDelete.clear();
        this.elementStatesMap.clear();
    }

    public void restoreModelElementState(DView view, IProgressMonitor monitor) {
        monitor.subTask("Restoring model state");
        Resource viewResource = view.eResource();
        DiagramCrossReferencer crossReferencer = new DiagramCrossReferencer(viewResource);
        UnmodifiableIterator analysisIterator = Iterators.filter((Iterator)view.eAllContents(), DDiagramElement.class);
        LinkedHashMap<Object, DDiagramElement> states = new LinkedHashMap<Object, DDiagramElement>();
        while (analysisIterator.hasNext()) {
            DDiagramElement dDiagramElement = (DDiagramElement)analysisIterator.next();
            IDiagramElementState<DDiagramElement> state = this.getElementState(dDiagramElement);
            if (state != null) {
                states.put(state, dDiagramElement);
            }
            monitor.worked(1);
        }
        for (Map.Entry entry : states.entrySet()) {
            IDiagramElementState state = (IDiagramElementState)entry.getKey();
            DDiagramElement dDiagramElement = (DDiagramElement)entry.getValue();
            state.restoreElementState(dDiagramElement);
        }
        this.setDefaultConcern(view);
        if (crossReferencer != null) {
            crossReferencer.clear();
            crossReferencer.clean();
        }
        if (this.editingDomain != null) {
            this.refreshVisibility(view);
        }
        ArrayList arrayList = Lists.newArrayList();
        Iterators.addAll((Collection)arrayList, (Iterator)Iterators.filter((Iterator)viewResource.getAllContents(), Diagram.class));
        for (Diagram currentDiagram : arrayList) {
            if (ViewUtil.resolveSemanticElement((View)currentDiagram) == null) continue;
            CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(currentDiagram);
            canonicalSynchronizer.storeViewsToArrange(false);
            canonicalSynchronizer.synchronize();
        }
    }

    private void refreshVisibility(DView view) {
        for (final DRepresentation representation : view.getAllRepresentations()) {
            if (!(representation instanceof DDiagram)) continue;
            IdentityCommand refreshAllElementsVisibilityCommand = new IdentityCommand(){

                public void execute() {
                    DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility((DDiagram)representation);
                }
            };
            new MigrationCommandExecutor().execute(this.editingDomain, (Command)refreshAllElementsVisibilityCommand);
        }
    }

    public void postRefreshOperations(TransactionalEditingDomain domain, Resource resource) {
        this.editingDomain = domain;
        RemoveInvalidViewsCommand removeInvalidViewsCommand = new RemoveInvalidViewsCommand(resource);
        new MigrationCommandExecutor().execute(domain, (Command)removeInvalidViewsCommand);
    }

    public void saveModelElementState(DView view, IProgressMonitor monitor) {
        monitor.subTask("Saving model state");
        DiagramCrossReferencer crossReferencer = new DiagramCrossReferencer(view.eResource());
        UnmodifiableIterator analysisIterator = Iterators.filter((Iterator)view.eAllContents(), DDiagramElement.class);
        ArrayList elementsToRemove = Lists.newArrayList();
        while (analysisIterator.hasNext()) {
            DDiagramElement diagramElement = (DDiagramElement)analysisIterator.next();
            if (this.diagramElementStateFactory.isValid(diagramElement)) {
                Identifier identifier = Identifier.createIdentifier(diagramElement);
                if (this.elementStatesMap.containsKey(identifier)) {
                    elementsToRemove.add(diagramElement);
                } else {
                    IDiagramElementState<? extends DDiagramElement> elementState = this.diagramElementStateFactory.buildDiagramElementState(identifier, diagramElement, crossReferencer);
                    this.elementStatesMap.put(elementState.getIdentifier(), elementState);
                }
            } else {
                elementsToRemove.add(diagramElement);
            }
            monitor.worked(1);
        }
        for (EObject eObject : elementsToRemove) {
            EcoreUtil.remove((EObject)eObject);
        }
        if (crossReferencer != null) {
            crossReferencer.clear();
            crossReferencer.clean();
        }
    }

    private void setDefaultConcern(DView view) {
        for (DRepresentation representation : view.getAllRepresentations()) {
            Resource currentConcernResource;
            DDiagram diagram;
            DiagramDescription description;
            if (!(representation instanceof DDiagram) || (description = (diagram = (DDiagram)representation).getDescription()) == null || description.getDefaultConcern() == null || diagram.getCurrentConcern() == null || !diagram.getCurrentConcern().equals(description.getDefaultConcern()) || (currentConcernResource = diagram.getCurrentConcern().eResource()) != null && currentConcernResource.isLoaded()) continue;
            ConcernService.setCurrentConcern((DDiagram)diagram, (ConcernDescription)description.getDefaultConcern());
        }
    }

    private IDiagramElementState<DDiagramElement> getElementState(DDiagramElement element) {
        IDiagramElementState<DDiagramElement> result = null;
        if (this.diagramElementStateFactory.isValid(element)) {
            Identifier identifier = Identifier.createIdentifier(element);
            result = this.elementStatesMap.get(identifier);
        }
        return result;
    }

    public void startRepairOnView(Session session, DView view) {
        for (DRepresentation representation : view.getAllRepresentations()) {
            if (!(representation instanceof DDiagram)) continue;
            GMFDiagramUpdater updater = new GMFDiagramUpdater(session, (DDiagram)representation);
            this.gmfDiagramUpdaters.add(updater);
        }
    }

    public void endRepairOnView() {
        for (GMFDiagramUpdater gmfDiagramUpdater : this.gmfDiagramUpdaters) {
            gmfDiagramUpdater.dispose();
        }
        this.gmfDiagramUpdaters.clear();
    }

    public void removeElements(DView view, TransactionalEditingDomain domain, IProgressMonitor monitor) {
        List<EObject> toBeRemoved = this.computeElementsToDeleteOrDeletedElements(view);
        this.removeDiagramElements(monitor, domain, toBeRemoved);
    }

    private List<EObject> computeElementsToDeleteOrDeletedElements(DView view) {
        ArrayList toBeRemoved = Lists.newArrayList();
        this.lostNodesByDelete.clear();
        this.lostEdgesByDelete.clear();
        UnmodifiableIterator viewIterator = Iterators.filter((Iterator)view.eAllContents(), DDiagramElement.class);
        while (viewIterator.hasNext()) {
            DDiagramElement diagElement = (DDiagramElement)viewIterator.next();
            if (new DiagramElementMappingQuery(diagElement.getDiagramElementMapping()).isSynchronizedAndCreateElement(diagElement)) {
                toBeRemoved.add(diagElement);
                continue;
            }
            if (!LostElementFactory.isCompleteDiagramElement((DDiagramElement)diagElement)) continue;
            DiagramKey diagramKey = DiagramKey.createDiagramKey((DDiagram)diagElement.getParentDiagram());
            if (diagElement instanceof AbstractDNode) {
                this.createLostNodeData(diagramKey, diagElement);
                continue;
            }
            if (!(diagElement instanceof DEdge)) continue;
            this.createLostEdgeData(diagramKey, diagElement);
        }
        return toBeRemoved;
    }

    private void createLostEdgeData(DiagramKey diagramKey, DDiagramElement diagElement) {
        LostEdgeData data = LostElementFactory.createLostEdgeData((DDiagramElement)diagElement);
        this.lostEdgesByDelete.put((Object)diagramKey, (Object)data);
    }

    private void createLostNodeData(DiagramKey diagramKey, DDiagramElement diagElement) {
        LostNodeData data = LostElementFactory.createLostNodeData((DDiagramElement)diagElement);
        this.lostNodesByDelete.put((Object)diagramKey, (Object)data);
    }

    private void removeDiagramElements(IProgressMonitor monitor, TransactionalEditingDomain transactionalEditingDomain, List<EObject> toBeRemoved) {
        monitor.beginTask("remove Diagram Elements", 1);
        RemoveDiagramElementsCommand removeDiagramElementsCommand = new RemoveDiagramElementsCommand((IProgressMonitor)new NullProgressMonitor(), toBeRemoved);
        new MigrationCommandExecutor().execute(transactionalEditingDomain, (Command)removeDiagramElementsCommand);
        monitor.done();
    }

    public List<DRepresentation> cleanRepresentations(EList<DRepresentation> representations) {
        LinkedList<DRepresentation> representationsToRemove = new LinkedList<DRepresentation>();
        for (DRepresentation representation : representations) {
            if (representation instanceof DDiagram) {
                DDiagram next = (DDiagram)representation;
                this.cleanReferences(next);
                if (representation instanceof DSemanticDiagram && ((DSemanticDiagram)representation).getDescription() == null) {
                    representationsToRemove.add(representation);
                }
            }
            if (!(representation instanceof DSemanticDecorator) || ((DSemanticDecorator)representation).getTarget() != null && ((DSemanticDecorator)representation).getTarget().eResource() != null) continue;
            representationsToRemove.add(representation);
        }
        return representationsToRemove;
    }

    private void cleanReferences(DDiagram diagram) {
        if (diagram.getFilterVariableHistory() != null && diagram.getFilterVariableHistory().getOwnedValues() != null) {
            Iterator filterVariablesIterator = diagram.getFilterVariableHistory().getOwnedValues().iterator();
            while (filterVariablesIterator.hasNext()) {
                FilterVariableValue filterVariable = (FilterVariableValue)filterVariablesIterator.next();
                if (!filterVariable.eIsProxy() && filterVariable.eResource() != null) continue;
                filterVariablesIterator.remove();
            }
        }
        if (diagram.getActivateBehaviors() != null) {
            Iterator activatedBehaviorsIterator = diagram.getActivateBehaviors().iterator();
            while (activatedBehaviorsIterator.hasNext()) {
                BehaviorTool activatedBehaviors = (BehaviorTool)activatedBehaviorsIterator.next();
                if (!activatedBehaviors.eIsProxy() && activatedBehaviors.eResource() != null) continue;
                activatedBehaviorsIterator.remove();
            }
        }
        if (diagram.getActivatedFilters() != null) {
            Iterator activatedFiltersIterator = diagram.getActivatedFilters().iterator();
            while (activatedFiltersIterator.hasNext()) {
                FilterDescription filterDescription = (FilterDescription)activatedFiltersIterator.next();
                if (!filterDescription.eIsProxy() && filterDescription.eResource() != null) continue;
                activatedFiltersIterator.remove();
            }
        }
        if (diagram.getActivatedRules() != null) {
            Iterator activatedRulesIterator = diagram.getActivatedRules().iterator();
            while (activatedRulesIterator.hasNext()) {
                ValidationRule activatedRule = (ValidationRule)activatedRulesIterator.next();
                if (!activatedRule.eIsProxy() && activatedRule.eResource() != null) continue;
                activatedRulesIterator.remove();
            }
        }
    }

    public void refreshRepresentations(DAnalysis dAnalysis, DView view) {
        RepairRepresentationRefresher refresher = new RepairRepresentationRefresher(this.lostNodesByDelete, this.lostEdgesByDelete);
        refresher.refreshRepresentations(dAnalysis, view);
    }
}

