/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.copier;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.identifier.RepresentationElementIdentifier;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.internal.dialect.identifier.DiagramIdentifier;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;

public class GMFDiagramCopier
extends EcoreUtil.Copier {
    private static final long serialVersionUID = 1L;
    private static final int MAGIC_INDEX = 1234;
    private Map<EObject, RepresentationElementIdentifier> originalIdentifiers;
    private Map<EObject, RepresentationElementIdentifier> copyIdentifiers;

    public GMFDiagramCopier(DDiagram originalRepresentation, DDiagram copyRepresentation) {
        this.createIdentifiers(originalRepresentation, copyRepresentation);
    }

    private void createIdentifiers(DDiagram originalRepresentation, DDiagram copyRepresentation) {
        this.originalIdentifiers = new HashMap<EObject, RepresentationElementIdentifier>();
        DiagramIdentifier originalDi = (DiagramIdentifier)DialectManager.INSTANCE.createIdentifier((EObject)originalRepresentation, this.originalIdentifiers);
        originalDi.setIndex(1234);
        this.createIdentifiers((DRepresentation)originalRepresentation, this.originalIdentifiers);
        this.copyIdentifiers = new HashMap<EObject, RepresentationElementIdentifier>();
        DiagramIdentifier copyDi = (DiagramIdentifier)DialectManager.INSTANCE.createIdentifier((EObject)copyRepresentation, this.copyIdentifiers);
        copyDi.setIndex(1234);
        this.createIdentifiers((DRepresentation)copyRepresentation, this.copyIdentifiers);
        for (DRepresentationElement element : copyRepresentation.getRepresentationElements()) {
            DialectManager.INSTANCE.createIdentifier((EObject)element, this.copyIdentifiers);
        }
    }

    private void createIdentifiers(DRepresentation representation, Map<EObject, RepresentationElementIdentifier> identifiers) {
        for (DRepresentationElement element : representation.getRepresentationElements()) {
            NodeStyle style;
            DialectManager.INSTANCE.createIdentifier((EObject)element, identifiers);
            if (!(element instanceof DNode) || (style = ((DNode)element).getOwnedStyle()) == null) continue;
            DialectManager.INSTANCE.createIdentifier((EObject)style, identifiers);
        }
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject instanceof View && eReference == NotationPackage.eINSTANCE.getView_Element()) {
            View copyView = (View)copyEObject;
            EObject originalElement = (EObject)eObject.eGet((EStructuralFeature)eReference);
            if (originalElement != null) {
                RepresentationElementIdentifier originalIdentifier = this.originalIdentifiers.get(originalElement);
                for (Map.Entry<EObject, RepresentationElementIdentifier> entry : this.copyIdentifiers.entrySet()) {
                    RepresentationElementIdentifier copyIdentifier = entry.getValue();
                    if (!originalIdentifier.equals(copyIdentifier)) continue;
                    View originalView = (View)eObject;
                    if (originalView.isSetElement()) {
                        copyView.setElement(entry.getKey());
                    }
                    return;
                }
            }
        }
        super.copyReference(eReference, eObject, copyEObject);
    }
}

