/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorsAndFontsPropertySection;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.DiagramColorsAndFontsPropertySection;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.diagram.ViewPropertiesSynchronizer;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ColorPalettePopup;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.UserFixedColor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;

public class DiagramColorAndFontPropertySection
extends DiagramColorsAndFontsPropertySection {
    protected RGB changeColor(SelectionEvent event, Button button, final String propertyId, String commandName, ImageDescriptor imageDescriptor) {
        RGB colorToReturn = null;
        if (!(Properties.ID_FILLCOLOR.equals(propertyId) || Properties.ID_LINECOLOR.equals(propertyId) || Properties.ID_FONTCOLOR.equals(propertyId))) {
            colorToReturn = super.changeColor(event, button, propertyId, commandName, imageDescriptor);
        } else {
            ColorPalettePopup popup = new ColorPalettePopup(button.getParent().getShell(), 25);
            Rectangle r = button.getBounds();
            Point location = button.getParent().toDisplay(r.x, r.y);
            popup.open(new Point(location.x, location.y + r.height));
            if (popup.getSelectedColor() == null && !popup.useDefaultColor()) {
                return null;
            }
            RGB selectedColor = popup.getSelectedColor();
            final EStructuralFeature feature = (EStructuralFeature)PackageUtil.getElement((String)propertyId);
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            Iterator it = this.getInputIterator();
            colorToReturn = selectedColor;
            RGB color = selectedColor;
            while (it.hasNext()) {
                Object preferredValue;
                final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
                color = selectedColor;
                if (popup.useDefaultColor() && (preferredValue = ep.getPreferredValue(feature)) instanceof Integer) {
                    color = FigureUtilities.integerToRGB((Integer)((Integer)preferredValue));
                }
                if (colorToReturn == null) {
                    colorToReturn = color;
                }
                if (color == null) continue;
                final RGB finalColor = color;
                commands.add(this.createCommand(commandName, ((View)ep.getModel()).eResource(), new Runnable(){

                    @Override
                    public void run() {
                        ENamedElement element = PackageUtil.getElement((String)propertyId);
                        if (element instanceof EStructuralFeature) {
                            ep.setStructuralFeatureValue(feature, (Object)FigureUtilities.RGBToInteger((RGB)finalColor));
                        }
                        View view = (View)ep.getModel();
                        UserFixedColor newColor = DescriptionFactory.eINSTANCE.createUserFixedColor();
                        newColor.setName("<anonymous>");
                        newColor.setBlue(finalColor.blue);
                        newColor.setGreen(finalColor.green);
                        newColor.setRed(finalColor.red);
                        IInterpreter interpreter = new EObjectQuery((EObject)view).getSession().getInterpreter();
                        new ViewPropertiesSynchronizer().synchronizeDDiagramElementStyleColorProperties(view, (FixedColor)newColor, propertyId, interpreter);
                    }
                }));
            }
            if (!commands.isEmpty()) {
                this.executeAsCompositeCommand(commandName, commands);
                Image overlyedImage = new ColorsAndFontsPropertySection.ColorOverlayImageDescriptor(imageDescriptor.getImageData(), color).createImage();
                this.disposeImage(button.getImage());
                button.setImage(overlyedImage);
            }
        }
        return colorToReturn;
    }
}

