/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.concern.provider.ConcernItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.provider.FilterItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.style.provider.StyleItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.tool.provider.ToolItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.provider.DiagramItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.ActivateFiltersCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.DeactivateFiltersCommand;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.audit.provider.AuditItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.validation.provider.ValidationItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FiltersPropertySection
extends AbstractPropertySection {
    protected TransactionalEditingDomain domain;
    protected Table choiceTable;
    protected Table featureTable;
    AdapterFactoryLabelProvider myAdapterFactoryLabelProvider;
    private ComposedAdapterFactory adapterFactory;
    private DDiagram diagram;
    private TableViewer availableElementsTableViewer;
    private TableViewer selectedElementsTableViewer;
    private Button addButton;
    private Button removeButton;
    private final IDoubleClickListener availableElementsTableDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            if (FiltersPropertySection.this.addButton.isEnabled()) {
                FiltersPropertySection.this.addButton.notifyListeners(13, null);
            }
        }
    };
    private final IDoubleClickListener selectedElementsTableDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            if (FiltersPropertySection.this.removeButton.isEnabled()) {
                FiltersPropertySection.this.removeButton.notifyListeners(13, null);
            }
        }
    };
    private EditPart editPart;
    private final Adapter viewpointListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            FiltersPropertySection.this.viewpointChanged();
        }
    };

    protected void newElementsSelected(Collection<?> newElements) {
        this.domain.getCommandStack().execute((Command)new ActivateFiltersCommand(this.domain, this.getDiagram(), Lists.newArrayList((Iterable)Iterables.filter(newElements, FilterDescription.class))));
    }

    protected void oldElementsRemoved(Collection<?> oldElements) {
        this.domain.getCommandStack().execute((Command)new DeactivateFiltersCommand(this.domain, this.getDiagram(), Lists.newArrayList((Iterable)Iterables.filter(oldElements, FilterDescription.class))));
    }

    public void aboutToBeShown() {
        this.availableElementsTableViewer.addDoubleClickListener(this.availableElementsTableDoubleClickListener);
        this.selectedElementsTableViewer.addDoubleClickListener(this.selectedElementsTableDoubleClickListener);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArrayList newElements = new ArrayList();
                IStructuredSelection selection = (IStructuredSelection)FiltersPropertySection.this.availableElementsTableViewer.getSelection();
                for (Object value : selection) {
                    newElements.add(value);
                }
                FiltersPropertySection.this.newElementsSelected(newElements);
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArrayList oldElements = new ArrayList();
                IStructuredSelection selection = (IStructuredSelection)FiltersPropertySection.this.selectedElementsTableViewer.getSelection();
                Object firstValue = null;
                for (Object value : selection) {
                    if (firstValue == null) {
                        firstValue = value;
                    }
                    FiltersPropertySection.this.selectedElementsTableViewer.remove(value);
                    oldElements.add(value);
                }
                FiltersPropertySection.this.oldElementsRemoved(oldElements);
            }
        });
    }

    private void addSemanticListener(DDiagram viewPoint) {
        viewPoint.eAdapters().add((Object)this.viewpointListener);
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList<ComposeableAdapterFactory> factories = new ArrayList<ComposeableAdapterFactory>();
        factories.add((ComposeableAdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        Composite choiceComposite = this.createChoiceComposite(composite);
        this.choiceTable = this.getWidgetFactory().createTable(choiceComposite, 2050);
        this.choiceTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.availableElementsTableViewer = new TableViewer(this.choiceTable);
        Composite controlButtons = this.getWidgetFactory().createComposite(composite, 0);
        controlButtons.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout controlsButtonGridLayout = new GridLayout();
        controlButtons.setLayout((Layout)controlsButtonGridLayout);
        new Label(controlButtons, 0);
        this.addButton = this.getWidgetFactory().createButton(controlButtons, "Add >", 8);
        this.addButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeButton = this.getWidgetFactory().createButton(controlButtons, "< Remove", 8);
        this.removeButton.setLayoutData((Object)new GridData(4, 4, false, false));
        Label spaceLabel = new Label(controlButtons, 0);
        GridData spaceLabelGridData = new GridData();
        spaceLabelGridData.verticalSpan = 2;
        spaceLabel.setLayoutData((Object)spaceLabelGridData);
        Composite featureComposite = this.createFeatureComposite(composite);
        this.featureTable = this.getWidgetFactory().createTable(featureComposite, 2050);
        this.featureTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selectedElementsTableViewer = new TableViewer(this.featureTable);
    }

    private IPermissionAuthority getPermissionAuthority() {
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)this.diagram);
        return accessor.getPermissionAuthority();
    }

    protected Composite createFeatureComposite(Composite composite) {
        Composite featureComposite = this.getWidgetFactory().createComposite(composite, 0);
        featureComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        featureComposite.setLayout((Layout)new GridLayout());
        Label featureLabel = this.getWidgetFactory().createLabel(featureComposite, "Applied filters", 0);
        featureLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        return featureComposite;
    }

    protected Composite createChoiceComposite(Composite composite) {
        Composite choiceComposite = this.getWidgetFactory().createComposite(composite, 0);
        choiceComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        choiceComposite.setLayout((Layout)new GridLayout());
        Label choiceLabel = this.getWidgetFactory().createLabel(choiceComposite, "Available filters", 0);
        choiceLabel.setLayoutData((Object)new GridData(768));
        return choiceComposite;
    }

    protected void fillItemProviderFactories(List<ComposeableAdapterFactory> factories) {
        factories.add((ComposeableAdapterFactory)new ViewpointItemProviderAdapterFactory());
        factories.add(new DiagramItemProviderAdapterFactory());
        factories.add((ComposeableAdapterFactory)new org.eclipse.sirius.viewpoint.description.provider.DescriptionItemProviderAdapterFactory());
        factories.add(new DescriptionItemProviderAdapterFactory());
        factories.add((ComposeableAdapterFactory)new org.eclipse.sirius.viewpoint.description.style.provider.StyleItemProviderAdapterFactory());
        factories.add(new StyleItemProviderAdapterFactory());
        factories.add((ComposeableAdapterFactory)new org.eclipse.sirius.viewpoint.description.tool.provider.ToolItemProviderAdapterFactory());
        factories.add(new ToolItemProviderAdapterFactory());
        factories.add((ComposeableAdapterFactory)new AuditItemProviderAdapterFactory());
        factories.add(new ConcernItemProviderAdapterFactory());
        factories.add(new FilterItemProviderAdapterFactory());
        factories.add((ComposeableAdapterFactory)new ValidationItemProviderAdapterFactory());
        factories.add((ComposeableAdapterFactory)new EcoreItemProviderAdapterFactory());
        factories.add((ComposeableAdapterFactory)new ResourceItemProviderAdapterFactory());
        factories.add((ComposeableAdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    protected Collection<?> getAppliedElements() {
        HashSet result = new HashSet();
        if (this.diagram != null) {
            result.addAll(this.diagram.getActivatedFilters());
        }
        return result;
    }

    protected Collection<?> getAvailableElements() {
        HashSet result = new HashSet();
        if (this.diagram != null && this.diagram.getDescription() != null) {
            DiagramDescription desc = this.diagram.getDescription();
            result.addAll(desc.getFilters());
        }
        result.removeAll(this.getAppliedElements());
        return result;
    }

    protected DDiagram getDiagram() {
        return this.diagram;
    }

    protected EditPart getEditPart() {
        return this.editPart;
    }

    private ItemProvider getItemProvider(Collection<?> choices) {
        return new ItemProvider(this.getItemProvidersAdapterFactory(), choices);
    }

    private AdapterFactory getItemProvidersAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = this.createAdapterFactory();
        }
        return this.adapterFactory;
    }

    private AdapterFactoryLabelProvider getLabelProvider() {
        if (this.myAdapterFactoryLabelProvider == null) {
            this.myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(this.getItemProvidersAdapterFactory());
        }
        return this.myAdapterFactoryLabelProvider;
    }

    public void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!FiltersPropertySection.this.availableElementsTableViewer.getTable().isDisposed()) {
                    FiltersPropertySection.this.availableElementsTableViewer.setLabelProvider((IBaseLabelProvider)FiltersPropertySection.this.getLabelProvider());
                    FiltersPropertySection.this.selectedElementsTableViewer.setLabelProvider((IBaseLabelProvider)FiltersPropertySection.this.getLabelProvider());
                    FiltersPropertySection.this.availableElementsTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(FiltersPropertySection.this.getItemProvidersAdapterFactory()));
                    FiltersPropertySection.this.selectedElementsTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(FiltersPropertySection.this.getItemProvidersAdapterFactory()));
                    FiltersPropertySection.this.availableElementsTableViewer.setInput((Object)FiltersPropertySection.this.getItemProvider(FiltersPropertySection.this.getAvailableElements()));
                    FiltersPropertySection.this.selectedElementsTableViewer.setInput((Object)FiltersPropertySection.this.getItemProvider(FiltersPropertySection.this.getAppliedElements()));
                }
            }
        });
    }

    private void removeSemanticListener(DDiagram dia) {
        dia.eAdapters().remove((Object)this.viewpointListener);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object input;
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection && (input = ((IStructuredSelection)selection).getFirstElement()) instanceof DDiagramEditPart) {
            EObject vp = ((DDiagramEditPart)input).resolveSemanticElement();
            this.editPart = ((DDiagramEditPart)input).getRoot();
            if (vp instanceof DDiagram) {
                this.setSirius((DDiagram)vp);
                this.domain = ((DDiagramEditPart)input).getEditingDomain();
            }
        }
        this.refresh();
    }

    private void setSirius(DDiagram newDia) {
        if (!this.getPermissionAuthority().canEditInstance((EObject)newDia)) {
            this.featureTable.setEnabled(false);
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.choiceTable.setEnabled(false);
        }
        if (this.diagram == newDia) {
            return;
        }
        if (this.diagram != null) {
            this.removeSemanticListener(this.diagram);
        }
        this.diagram = newDia;
        this.refresh();
        if (this.diagram != null) {
            this.addSemanticListener(this.diagram);
        }
    }

    private void viewpointChanged() {
        this.refresh();
    }

    public void dispose() {
        super.dispose();
        if (this.getDiagram() != null) {
            this.removeSemanticListener(this.getDiagram());
        }
    }
}

