/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.tools.internal.properties.CompositeEObjectPropertySource;
import org.eclipse.sirius.diagram.ui.tools.internal.properties.SemanticPropertySection;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.views.properties.IPropertySource;

public class StylePropertySection
extends SemanticPropertySection {
    private Map<DStylizable, View> map = new HashMap<DStylizable, View>();

    @Override
    public IPropertySource getPropertySource(Object object) {
        Object propSrc = null;
        if (object instanceof IPropertySource) {
            propSrc = (IPropertySource)object;
        } else if (!(object instanceof EObject) || this.getPermissionAuthority((EObject)object).canEditInstance((EObject)object)) {
            if (object instanceof DStylizable && ((DStylizable)object).getStyle() instanceof EdgeStyle && ((EdgeStyle)((DStylizable)object).getStyle()).getStrokeColor() != null) {
                StylePropertySource targetPropertySource;
                IItemPropertySource ips;
                DStylizable stylizable = (DStylizable)object;
                View view = this.map.get(stylizable);
                EdgeStyle edgeStyle = (EdgeStyle)stylizable.getStyle();
                RGBValues rgb = edgeStyle.getStrokeColor();
                CompositeEObjectPropertySource propertySource = new CompositeEObjectPropertySource();
                AdapterFactory af = this.getAdapterFactory(edgeStyle);
                if (af != null && (ips = (IItemPropertySource)af.adapt((Notifier)edgeStyle, IItemPropertySource.class)) != null) {
                    targetPropertySource = new StylePropertySource(edgeStyle, view, ips);
                    propertySource.addPropertySource((EObject)edgeStyle, (IPropertySource)targetPropertySource);
                }
                if ((af = this.getAdapterFactory(rgb)) != null && (ips = (IItemPropertySource)af.adapt((Notifier)rgb, IItemPropertySource.class)) != null) {
                    targetPropertySource = new StylePropertySource(rgb, view, ips);
                    propertySource.addPropertySource((EObject)rgb, (IPropertySource)targetPropertySource);
                }
                propSrc = propertySource;
            } else {
                propSrc = this.getPropertySourceForOtherStyles(object);
            }
        }
        return propSrc;
    }

    private IPropertySource getPropertySourceForOtherStyles(Object object) {
        Object propSrc = null;
        if (object instanceof DStylizable) {
            IItemPropertySource ips;
            AdapterFactory af;
            DStylizable stylizable = (DStylizable)object;
            View view = this.map.get(stylizable);
            Style style = stylizable.getStyle();
            if (style != null && (af = this.getAdapterFactory(style)) != null && (ips = (IItemPropertySource)af.adapt((Notifier)style, IItemPropertySource.class)) != null) {
                StylePropertySource targetPropertySource = new StylePropertySource(style, view, ips);
                propSrc = targetPropertySource;
            }
        }
        if (propSrc == null) {
            IItemPropertySource ips;
            AdapterFactory af = this.getAdapterFactory(object);
            if (af != null && (ips = (IItemPropertySource)af.adapt(object, IItemPropertySource.class)) != null) {
                propSrc = new StylePropertySource(object, ips);
            }
            if (propSrc == null && object instanceof IAdaptable) {
                propSrc = (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
            }
        }
        return propSrc;
    }

    private IPermissionAuthority getPermissionAuthority(EObject instance) {
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(instance);
        return accessor.getPermissionAuthority();
    }

    @Override
    protected Object transformSelection(Object selection) {
        EObject target;
        Object object = selection;
        View view = null;
        if (object instanceof EditPart) {
            object = ((EditPart)object).getModel();
        } else if (object instanceof IAdaptable) {
            object = ((IAdaptable)object).getAdapter(View.class);
        }
        if (object instanceof View) {
            view = (View)object;
            object = view.getElement();
        }
        if (view != null && object instanceof DStylizable) {
            this.map.put((DStylizable)object, view);
        }
        if (object instanceof DSemanticDecorator && ((target = ((DSemanticDecorator)object).getTarget()) == null || target.eResource() == null)) {
            object = null;
        }
        return object;
    }

    private static class StylePropertySource
    extends PropertySource {
        private View view;

        public StylePropertySource(Object object, IItemPropertySource itemPropertySource) {
            super(object, itemPropertySource);
            this.view = null;
        }

        public StylePropertySource(Object object, View view, IItemPropertySource itemPropertySource) {
            super(object, itemPropertySource);
            this.view = view;
        }

        public void setPropertyValue(Object propertyId, Object value) {
            if (this.object instanceof Style && propertyId instanceof String) {
                Style style = (Style)this.object;
                String featureName = (String)propertyId;
                EStructuralFeature feature = style.eClass().getEStructuralFeature(featureName);
                if (feature != null && !style.getCustomFeatures().contains((Object)feature.getName())) {
                    style.getCustomFeatures().add((Object)feature.getName());
                }
            } else if (this.object instanceof EObject && ((EObject)this.object).eContainer() instanceof Style && propertyId instanceof String) {
                EObject containedValue = (EObject)this.object;
                Style style = (Style)containedValue.eContainer();
                EStructuralFeature feature = containedValue.eContainingFeature();
                if (feature != null && !style.getCustomFeatures().contains((Object)feature.getName())) {
                    style.getCustomFeatures().add((Object)feature.getName());
                }
            }
            super.setPropertyValue(propertyId, value);
            if (this.object instanceof LabelStyle) {
                this.updateNotationView(propertyId, value);
            } else if (this.object instanceof EdgeStyle) {
                this.updateNotationView(propertyId, value);
            } else if (this.object instanceof RGBValues) {
                this.updateNotationView(propertyId, value);
            }
        }

        private void updateNotationView(Object propertyId, Object value) {
            if (this.view != null && this.view.getStyles() != null) {
                for (Object notationStyle : this.view.getStyles()) {
                    if (notationStyle instanceof FontStyle) {
                        FontStyle fontStyle = (FontStyle)notationStyle;
                        if (value instanceof FontFormat && propertyId.equals(ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName())) {
                            if (FontFormat.BOLD_LITERAL == value) {
                                fontStyle.setBold(true);
                                fontStyle.setItalic(false);
                                continue;
                            }
                            if (FontFormat.ITALIC_LITERAL == value) {
                                fontStyle.setBold(false);
                                fontStyle.setItalic(true);
                                continue;
                            }
                            if (FontFormat.BOLD_ITALIC_LITERAL == value) {
                                fontStyle.setBold(true);
                                fontStyle.setItalic(true);
                                continue;
                            }
                            if (FontFormat.NORMAL_LITERAL != value) continue;
                            fontStyle.setBold(false);
                            fontStyle.setItalic(false);
                            continue;
                        }
                        if (!(value instanceof Integer) || !propertyId.equals(ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_SIZE.getName())) continue;
                        fontStyle.setFontHeight(((Integer)value).intValue());
                        continue;
                    }
                    if (!(notationStyle instanceof ConnectorStyle)) continue;
                    ConnectorStyle connectorStyle = (ConnectorStyle)notationStyle;
                    if (!(value instanceof EdgeRouting) || !propertyId.equals(DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.getName())) continue;
                    if (EdgeRouting.MANHATTAN_LITERAL == value) {
                        connectorStyle.setRouting(Routing.RECTILINEAR_LITERAL);
                        continue;
                    }
                    if (EdgeRouting.STRAIGHT_LITERAL == value) {
                        connectorStyle.setRouting(Routing.MANUAL_LITERAL);
                        continue;
                    }
                    if (EdgeRouting.TREE_LITERAL != value) continue;
                    connectorStyle.setRouting(Routing.TREE_LITERAL);
                }
            }
        }
    }
}

