/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;

public class EditPartQuery {
    private final IGraphicalEditPart part;

    public EditPartQuery(IGraphicalEditPart part) {
        this.part = (IGraphicalEditPart)Preconditions.checkNotNull((Object)part);
    }

    public <T> T getFirstAncestorOfType(Class<T> type) {
        if (this.part == null) {
            return null;
        }
        EditPart current = this.part.getParent();
        while (current != null && !type.isInstance(current)) {
            current = current.getParent();
        }
        return type.cast(current);
    }

    public <T> List<T> getAllAncestorsOfType(Class<T> type) {
        if (this.part == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        EditPart current = this.part.getParent();
        while (current != null) {
            if (type.isInstance(current)) {
                result.add(type.cast(current));
            }
            current = current.getParent();
        }
        return result;
    }

    public List<Node> getBorderedNodes(int expectedSide) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (IBorderItemEditPart borderItemEditPart : this.getBorderNodeEditParts(expectedSide)) {
            result.add((Node)borderItemEditPart.getModel());
        }
        return result;
    }

    public List<IBorderItemEditPart> getBorderNodeEditParts(final int expectedSide) {
        if (this.part instanceof IBorderedShapeEditPart) {
            Iterable bordersItemPart = Iterables.filter((Iterable)this.part.getChildren(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(IBorderItemEditPart.class), (Predicate)new Predicate<IBorderItemEditPart>(){

                public boolean apply(IBorderItemEditPart input) {
                    int currentSide = input.getBorderItemLocator().getCurrentSideOfParent();
                    return expectedSide == currentSide;
                }
            }));
            return Lists.newArrayList((Iterable)bordersItemPart);
        }
        return new ArrayList<IBorderItemEditPart>();
    }

    public Map<Node, Integer> getBorderedNodesToMoveWithDelta(int expectedSide, int parentResizeSize) {
        Map<Node, Integer> result = new HashMap<Node, Integer>();
        if (this.part instanceof IBorderedShapeEditPart) {
            IFigure parentFigure = ((IBorderedShapeEditPart)this.part).getMainFigure();
            Rectangle parentBounds = parentFigure.getBounds();
            if (parentFigure instanceof NodeFigure) {
                parentBounds = ((NodeFigure)parentFigure).getHandleBounds().getCopy();
            }
            List<Node> expectedSideNodes = this.getBorderedNodes(expectedSide);
            if (parentResizeSize < 0) {
                if (expectedSide == 16 || expectedSide == 8) {
                    result = this.getBorderedNodesToMoveVerticallyWithDelta(expectedSideNodes, parentBounds, parentResizeSize);
                } else if (expectedSide == 1 || expectedSide == 4) {
                    result = this.getBorderedNodesToMoveHorizontallyWithDelta(expectedSideNodes, parentBounds, parentResizeSize);
                }
            }
        }
        return result;
    }

    private Map<Node, Integer> getBorderedNodesToMoveVerticallyWithDelta(List<Node> nodes, Rectangle parentBounds, int parentResizeSize) {
        HashMap<Node, Integer> result = new HashMap<Node, Integer>();
        for (Node node : nodes) {
            Bounds borderedNodeBounds;
            int distanceFromBottom;
            if (!(node.getLayoutConstraint() instanceof Bounds) || (distanceFromBottom = parentBounds.height - IBorderItemOffsets.DEFAULT_OFFSET.height - ((borderedNodeBounds = (Bounds)node.getLayoutConstraint()).getY() + borderedNodeBounds.getHeight())) >= -parentResizeSize) continue;
            result.put(node, distanceFromBottom + parentResizeSize);
        }
        return result;
    }

    private Map<Node, Integer> getBorderedNodesToMoveHorizontallyWithDelta(List<Node> nodes, Rectangle parentBounds, int parentResizeSize) {
        HashMap<Node, Integer> result = new HashMap<Node, Integer>();
        for (Node node : nodes) {
            Bounds borderedNodeBounds;
            int distanceFromRight;
            if (!(node.getLayoutConstraint() instanceof Bounds) || (distanceFromRight = parentBounds.width - IBorderItemOffsets.DEFAULT_OFFSET.height - ((borderedNodeBounds = (Bounds)node.getLayoutConstraint()).getX() + borderedNodeBounds.getWidth())) >= -parentResizeSize) continue;
            result.put(node, distanceFromRight + parentResizeSize);
        }
        return result;
    }
}

