/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.listeners;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableEditorUtil;
import org.eclipse.sirius.table.ui.tools.internal.editor.utils.TreeColumnWidthQuery;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;

public class DTableViewerListener
implements ITreeViewerListener,
ControlListener {
    private DTableViewerManager dTableViewerManager;
    private DTable dTable;
    private ModelAccessor modelAccessor;
    private TransactionalEditingDomain domain;

    public DTableViewerListener(DTableViewerManager dTableViewerManager, ModelAccessor modelAccessor, TransactionalEditingDomain domain) {
        this.dTableViewerManager = dTableViewerManager;
        this.dTable = (DTable)this.dTableViewerManager.getEditor().getRepresentation();
        this.modelAccessor = modelAccessor;
        this.domain = domain;
    }

    public void treeExpanded(TreeExpansionEvent event) {
        DLine dLine;
        if (event.getElement() instanceof DLine && (dLine = (DLine)event.getElement()).isCollapsed()) {
            CommandStack commandStack = this.domain.getCommandStack();
            CompoundCommand cmd = new CompoundCommand("Expand " + dLine.getName() + " line");
            Command expandDLineCmd = SetCommand.create((EditingDomain)this.domain, (Object)dLine, (Object)TablePackage.Literals.DLINE__COLLAPSED, (Object)false);
            cmd.append(expandDLineCmd);
            commandStack.execute((Command)cmd);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        DLine dLine;
        if (event.getElement() instanceof DLine && !(dLine = (DLine)event.getElement()).isCollapsed()) {
            CommandStack commandStack = this.domain.getCommandStack();
            CompoundCommand cmd = new CompoundCommand("Collapse " + dLine.getName() + " line");
            Command collapseDLineCmd = SetCommand.create((EditingDomain)this.domain, (Object)dLine, (Object)TablePackage.Literals.DLINE__COLLAPSED, (Object)true);
            cmd.append(collapseDLineCmd);
            commandStack.execute((Command)cmd);
        }
    }

    public void controlMoved(ControlEvent event) {
    }

    public void controlResized(ControlEvent event) {
        if (event.widget instanceof TreeColumn && this.dTableViewerManager.getEditor().isPropertiesUpdateEnabled()) {
            String featureName;
            DColumn objectToModify;
            TreeColumn treeColumn = (TreeColumn)event.widget;
            boolean mustUpdateModel = false;
            TreeColumnWidthQuery treeColumnWidthQuery = new TreeColumnWidthQuery(treeColumn);
            Display.getDefault().syncExec((Runnable)((Object)treeColumnWidthQuery));
            int widgetWidth = (Integer)treeColumnWidthQuery.getResult();
            DColumn dColumn = (DColumn)treeColumn.getData("org.eclipse.sirius.table.ui.dTableColumn");
            if (dColumn != null) {
                boolean bl = mustUpdateModel = dColumn.isVisible() && dColumn.getWidth() != widgetWidth;
                if (DTableViewerManager.IS_GTK_OS && DTableEditorUtil.isLastColumn(treeColumn)) {
                    mustUpdateModel = false;
                }
                objectToModify = dColumn;
                featureName = TablePackage.eINSTANCE.getDColumn_Width().getName();
            } else {
                mustUpdateModel = this.dTable.getHeaderColumnWidth() != widgetWidth;
                objectToModify = this.dTable;
                featureName = TablePackage.eINSTANCE.getDTable_HeaderColumnWidth().getName();
            }
            if (mustUpdateModel && this.modelAccessor.getPermissionAuthority().canEditFeature((EObject)objectToModify, featureName) && ((TransactionalEditingDomainImpl)this.domain).getActiveTransaction() == null) {
                if (widgetWidth == 0) {
                    widgetWidth = 1;
                }
                Command updateWidthCmd = null;
                if (objectToModify instanceof DColumn && widgetWidth != dColumn.getWidth()) {
                    updateWidthCmd = SetCommand.create((EditingDomain)this.domain, (Object)dColumn, (Object)TablePackage.Literals.DCOLUMN__WIDTH, (Object)widgetWidth);
                } else if (this.dTable.getHeaderColumnWidth() != widgetWidth) {
                    updateWidthCmd = SetCommand.create((EditingDomain)this.domain, (Object)this.dTable, (Object)TablePackage.Literals.DTABLE__HEADER_COLUMN_WIDTH, (Object)widgetWidth);
                }
                this.domain.getCommandStack().execute(updateWidthCmd);
            }
        }
    }
}

