/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.properties.service;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.eclipse.uml2.uml.edit.providers.UMLReflectiveItemProviderAdapterFactory;
import org.eclipse.uml2.uml.edit.providers.UMLResourceItemProviderAdapterFactory;
import org.obeonetwork.dsl.uml2.design.api.utils.PropertiesViewUtils;
import org.obeonetwork.dsl.uml2.properties.uml.components.StereotypeApplicationsPropertiesEditionComponent;

public class TableLabelService {
    private static final String EMPTY = "";
    private EObject source = null;

    public TableLabelService() {
    }

    public TableLabelService(EObject source) {
        this.source = source;
    }

    public String caseStereotype(Object object) {
        if (object instanceof Stereotype) {
            return ((Stereotype)object).getName();
        }
        throw new IllegalArgumentException();
    }

    public String caseEStructuralFeature(Object object) {
        if (object instanceof EStructuralFeature) {
            return ((EStructuralFeature)object).getName();
        }
        throw new IllegalArgumentException();
    }

    public String caseStereotypeApplicationPropertyValue(StereotypeApplicationsPropertiesEditionComponent.StereotypeApplication.StereotypeApplicationProperty property, AdapterFactoryLabelProvider factory) {
        IItemLabelProvider itemProvider;
        Object value = property.getValue();
        AdapterFactory adapterFactory = factory.getAdapterFactory();
        if (adapterFactory instanceof ComposedAdapterFactory) {
            ((ComposedAdapterFactory)adapterFactory).addAdapterFactory((AdapterFactory)new UMLResourceItemProviderAdapterFactory());
            ((ComposedAdapterFactory)adapterFactory).addAdapterFactory((AdapterFactory)new UMLItemProviderAdapterFactory());
            ((ComposedAdapterFactory)adapterFactory).addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
            ((ComposedAdapterFactory)adapterFactory).addAdapterFactory((AdapterFactory)new UMLReflectiveItemProviderAdapterFactory());
        }
        if ((itemProvider = (IItemLabelProvider)adapterFactory.adapt(property.getValue(), IItemLabelProvider.class)) != null) {
            return itemProvider.getText(value);
        }
        AdapterFactoryItemDelegator provider = new AdapterFactoryItemDelegator(adapterFactory);
        return provider.getText(value);
    }

    public String caseProfile(Object object) {
        if (object instanceof Stereotype) {
            return ((Stereotype)object).getProfile().getName();
        }
        if (object instanceof Profile) {
            return ((Profile)object).getName();
        }
        throw new IllegalArgumentException();
    }

    public String caseRequired(Object object) {
        if (object instanceof Stereotype && this.source != null && this.source instanceof Element) {
            return String.valueOf(((Element)this.source).isStereotypeRequired((Stereotype)object));
        }
        throw new IllegalArgumentException();
    }

    public String caseIsStatic(Object object) {
        if (object instanceof Feature) {
            return String.valueOf(((Feature)object).isStatic());
        }
        throw new IllegalArgumentException();
    }

    public String caseParameters(Object object) {
        if (object instanceof Operation) {
            EList parameters = ((Operation)object).getOwnedParameters();
            StringBuffer ownedParameter = new StringBuffer();
            int i = 0;
            while (i < parameters.size()) {
                Parameter parameter = (Parameter)parameters.get(i);
                if (!ParameterDirectionKind.RETURN_LITERAL.equals((Object)parameter.getDirection())) {
                    ownedParameter.append(parameter.getName());
                    ownedParameter.append(":");
                    if (parameter.getType() != null) {
                        ownedParameter.append(parameter.getType().getName());
                    }
                    if (i == 0 && parameters.size() > 1 || i < parameters.size() - 1) {
                        ownedParameter.append(" ");
                    }
                }
                ++i;
            }
            return ownedParameter.toString();
        }
        throw new IllegalArgumentException();
    }

    public String caseIsAbstract(Object object) {
        if (object instanceof Classifier) {
            return String.valueOf(((Classifier)object).isAbstract());
        }
        if (object instanceof BehavioralFeature) {
            return String.valueOf(((BehavioralFeature)object).isAbstract());
        }
        throw new IllegalArgumentException();
    }

    public String caseVisibility(Object object) {
        if (object instanceof NamedElement) {
            return ((NamedElement)object).getVisibility().getName();
        }
        throw new IllegalArgumentException();
    }

    public String caseDirection(Object object) {
        if (object instanceof Parameter) {
            return ((Parameter)object).getDirection().getName();
        }
        throw new IllegalArgumentException();
    }

    public String caseDefaultValue(Object object) {
        if (object instanceof Property) {
            if (((Property)object).getDefaultValue() != null) {
                return ((Property)object).getDefault();
            }
            return EMPTY;
        }
        throw new IllegalArgumentException();
    }

    public String caseName(Object object) {
        if (object instanceof Element) {
            String label = PropertiesViewUtils.computeUmlLabel((Element)((Element)object));
            if (label != null && label.length() > 0 && !"null".equals(label)) {
                return label;
            }
            return EMPTY;
        }
        throw new IllegalArgumentException();
    }

    public String caseType(Object object) {
        if (object instanceof Operation) {
            Type type = ((Operation)object).getType();
            if (type != null) {
                return type.getName();
            }
            return "void";
        }
        if (object instanceof TypedElement) {
            Type type = ((TypedElement)object).getType();
            if (type != null) {
                return type.getName();
            }
            return EMPTY;
        }
        if (object instanceof Relationship) {
            return ((Relationship)object).eClass().getName();
        }
        throw new IllegalArgumentException();
    }

    public String caseMultiplicity(Object object) {
        if (object instanceof MultiplicityElement) {
            int lower = ((MultiplicityElement)object).getLower();
            StringBuffer label = new StringBuffer(String.valueOf(lower) + "..");
            int upper = ((MultiplicityElement)object).getUpper();
            if (upper < 0) {
                label.append("*");
            } else {
                label.append(upper);
            }
            return label.toString();
        }
        throw new IllegalArgumentException();
    }

    public String caseOtherRelatedElements(Object object) {
        if (object instanceof Relationship) {
            EList elements = ((Relationship)object).getRelatedElements();
            ArrayList elementsWithoutSource = new ArrayList();
            elementsWithoutSource.addAll(elements);
            elementsWithoutSource.remove(this.source);
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < elementsWithoutSource.size()) {
                Element element = (Element)elementsWithoutSource.get(i);
                result.append(PropertiesViewUtils.computeUmlLabel((Element)element));
                if (i < elementsWithoutSource.size() - 1) {
                    result.append(",");
                }
                ++i;
            }
            return result.toString();
        }
        throw new IllegalArgumentException();
    }

    public String caseRole(Object object) {
        if (object instanceof ConnectorEnd) {
            ConnectorEnd connectorEnd = (ConnectorEnd)object;
            ConnectableElement connectableElement = connectorEnd.getRole();
            if (connectableElement != null) {
                return connectableElement.getName();
            }
            return EMPTY;
        }
        throw new IllegalArgumentException();
    }

    public String caseProperty(Object object) {
        if (object instanceof Property) {
            Property property = (Property)object;
            return property.getName();
        }
        throw new IllegalArgumentException();
    }

    public boolean caseNavigability(Object object) {
        if (object instanceof Property) {
            Property property = (Property)object;
            return property.isNavigable();
        }
        throw new IllegalArgumentException();
    }

    public boolean caseOwned(Object object) {
        if (object instanceof Property) {
            Property property = (Property)object;
            return property.getOwner() instanceof Association;
        }
        throw new IllegalArgumentException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableColumnName {
        NAME("Name"),
        TYPE("Type"),
        DEFAULT_VALUE("Default value"),
        VISIBILITY("Visibility"),
        IS_STATIC("Static"),
        MULTIPLICITY("Multiplicity"),
        IS_ABSTRACT("Abstract"),
        PARAMETERS("Parameters"),
        DIRECTION("Direction"),
        STEREOTYPE("Stereotype"),
        PROFILE("Profile"),
        REQUIRED("Required"),
        OTHER_RELATED_ELEMENTS("Other Related Element(s)"),
        ROLE("Role"),
        PROPERTY("Property"),
        NAVIGABILITY("Navigable"),
        OWNED("Owned"),
        ESTRUCTURAL_FEATURE("Feature"),
        VALUE("Value");

        private String label;

        private TableColumnName(String label) {
            this.label = label;
        }

        public String label() {
            return this.label;
        }
    }
}

