/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.experimental.sync;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.SiriusDiagramHelper;
import org.eclipse.sirius.diagram.business.api.helper.concern.ConcernService;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.helper.layers.LayerService;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.api.refresh.RefreshExtensionService;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.AbstractDNodeCandidate;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DEdgeSynchronizerHelper;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DNodeSynchronizerHelper;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.IsMappingOfCurrentDiagramDescription;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.MappingsUpdater;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.VisualIDMap;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramComponentizationHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.EdgeMappingHelper;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.business.internal.sync.visitor.DiagramElementsHierarchyVisitor;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.base.cache.KeyCache;
import org.eclipse.sirius.ext.base.collect.GSetIntersection;
import org.eclipse.sirius.ext.base.collect.MultipleCollection;
import org.eclipse.sirius.ext.base.collect.SetIntersection;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.DecorationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.SemanticBasedDecoration;

public class DDiagramSynchronizer {
    private static final EObject FAKE_MAPPING = EcoreFactory.eINSTANCE.createEObject();
    private static Map<String, String> visualIDMap = Collections.unmodifiableMap(new VisualIDMap());
    private DSemanticDiagram diagram;
    private final IInterpreter interpreter;
    private final DiagramDescription description;
    private final ModelAccessor accessor;
    private DDiagramElementSynchronizer sync;
    private final Collection<EObjectCouple> ignoredDuringRefreshProcess = new ArrayList<EObjectCouple>();
    private Session session;
    private DEdgeSynchronizerHelper edgeHelper;
    private DNodeSynchronizerHelper nodHelper;
    private DiagramMappingsManager diagramMappingsManager;
    private SetMultimap<EObjectCouple, DDiagramElement> previousCandidatesCache;
    private MappingsUpdater mappingsUpdater;
    private HashSet<DDiagramElement> edgesDones;
    private boolean forceRetrieve;

    public DDiagramSynchronizer(IInterpreter interpreter, DiagramDescription description, ModelAccessor accessor) {
        this.interpreter = interpreter;
        this.description = description;
        this.accessor = accessor;
    }

    public DSemanticDiagram getDiagram() {
        return this.diagram;
    }

    public DDiagramElementSynchronizer getElementSynchronizer() {
        return this.sync;
    }

    public void setDiagram(DSemanticDiagram diagram) {
        this.diagram = diagram;
        this.session = SessionManager.INSTANCE.getSession(diagram.getTarget());
        this.sync = new DDiagramElementSynchronizer(this.diagram, this.interpreter, this.accessor);
        this.initDiagramRelatedFields();
    }

    public void initDiagram(String name, EObject target, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Init diagram", 4);
            this.session = SessionManager.INSTANCE.getSession(target);
            this.diagram = this.createEmptyDiagram(name, target);
            monitor.worked(1);
            this.applyInitializationOperation(target);
            monitor.worked(1);
            this.sync = new DDiagramElementSynchronizer(this.diagram, this.interpreter, this.accessor);
            ConcernService.setCurrentConcern(this.diagram, this.description.getDefaultConcern());
            this.activateInitialLayers();
            monitor.worked(1);
            if (this.diagram.getFilterVariableHistory() == null) {
                this.diagram.setFilterVariableHistory(DiagramFactory.eINSTANCE.createFilterVariableHistory());
            }
            this.initDiagramRelatedFields();
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    private DSemanticDiagram createEmptyDiagram(String name, EObject target) {
        DSemanticDiagram result = this.description.createDiagram();
        result.setName(name);
        result.setDescription(this.description);
        result.setTarget(target);
        return result;
    }

    private void applyInitializationOperation(EObject target) {
        if (this.description.getDiagramInitialisation() != null && this.description.getDiagramInitialisation().getFirstModelOperations() != null) {
            try {
                new TaskHelper(this.accessor, this.createUICallBack()).buildTaskFromModelOperation((DRepresentation)this.diagram, target, this.description.getDiagramInitialisation().getFirstModelOperations()).execute();
            }
            catch (MetaClassNotFoundException metaClassNotFoundException) {
            }
            catch (FeatureNotFoundException featureNotFoundException) {}
        }
    }

    private UICallBack createUICallBack() {
        return new NoUICallback();
    }

    private void initDiagramRelatedFields() {
        this.edgeHelper = new DEdgeSynchronizerHelper(this, this.diagram, this.accessor);
        this.nodHelper = new DNodeSynchronizerHelper(this, this.diagram, this.accessor);
        this.diagramMappingsManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(this.session, this.diagram);
        this.mappingsUpdater = new MappingsUpdater(this.diagram, this.diagramMappingsManager, this);
    }

    private void activateInitialLayers() {
        Collection<Layer> layersToActivate = this.getAllInitialyActiveLayers();
        this.diagram.getActivatedLayers().addAll(layersToActivate);
    }

    private Collection<Layer> getAllInitialyActiveLayers() {
        Predicate<Layer> isActiveByDefault = new Predicate<Layer>(){

            public boolean apply(Layer layer) {
                return layer instanceof AdditionalLayer && (((AdditionalLayer)layer).isActiveByDefault() || !((AdditionalLayer)layer).isOptional());
            }
        };
        ArrayList<Layer> result = new ArrayList<Layer>();
        Layer mandatoryLayer = this.description.getDefaultLayer();
        if (mandatoryLayer != null) {
            result.add(mandatoryLayer);
        }
        result.addAll(Collections2.filter(this.description.getAdditionalLayers(), (Predicate)isActiveByDefault));
        result.addAll(Collections2.filter(DiagramComponentizationHelper.getContributedLayers(this.description, this.session.getSelectedViewpoints(false)), (Predicate)isActiveByDefault));
        return result;
    }

    private void activateNewMandatoryAdditionalLayers() {
        Collection<Layer> allMandatoryAdditionalLayers = this.getAllMandatoriesAdditionalLayers();
        ArrayList<Layer> allMandatoryAdditionalLayersToAdd = new ArrayList<Layer>();
        EList<Layer> activatedLayers = this.diagram.getActivatedLayers();
        for (Layer layer : allMandatoryAdditionalLayers) {
            if (activatedLayers.contains((Object)layer)) continue;
            allMandatoryAdditionalLayersToAdd.add(layer);
        }
        this.diagram.getActivatedLayers().addAll(allMandatoryAdditionalLayersToAdd);
    }

    private Collection<Layer> getAllMandatoriesAdditionalLayers() {
        Predicate<Layer> isMandatory = new Predicate<Layer>(){

            public boolean apply(Layer layer) {
                return layer instanceof AdditionalLayer && !((AdditionalLayer)layer).isOptional();
            }
        };
        ArrayList<Layer> result = new ArrayList<Layer>();
        Layer mandatoryLayer = this.description.getDefaultLayer();
        if (mandatoryLayer != null) {
            result.add(mandatoryLayer);
        }
        result.addAll(Collections2.filter(this.description.getAdditionalLayers(), (Predicate)isMandatory));
        result.addAll(Collections2.filter(DiagramComponentizationHelper.getContributedLayers(this.description, this.session.getSelectedViewpoints(false)), (Predicate)isMandatory));
        return result;
    }

    public void refresh(IProgressMonitor monitor) {
        DslCommonPlugin.PROFILER.startWork("Refresh a diagram");
        this.refreshOperation(monitor);
        DslCommonPlugin.PROFILER.stopWork("Refresh a diagram");
    }

    private void refreshOperation(IProgressMonitor monitor) {
        try {
            KeyCache.DEFAULT.clear();
            if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.diagram)) {
                RuntimeLoggerManager.INSTANCE.clear((EObject)this.description);
                this.activateNewMandatoryAdditionalLayers();
                HashMap<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets = new HashMap<DiagramElementMapping, Collection<EdgeTarget>>();
                HashMap<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration = new HashMap<EdgeMapping, Collection<MappingBasedDecoration>>();
                HashMap<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration = new HashMap<String, Collection<SemanticBasedDecoration>>();
                List<NodeMapping> nodeMappings = this.diagramMappingsManager.getNodeMappings();
                List<EdgeMapping> edgeMappings = this.diagramMappingsManager.getEdgeMappings();
                List<ContainerMapping> containerMappings = this.diagramMappingsManager.getContainerMappings();
                RefreshExtensionService.getInstance().beforeRefresh(this.diagram);
                int mappingNumbers = nodeMappings.size() + edgeMappings.size() + containerMappings.size();
                monitor.beginTask("Refreshing mappings", mappingNumbers);
                this.computePreviousCandidatesCache();
                this.mappingsUpdater.updateMappings();
                this.computePreviousCandidatesCache();
                this.fillIgnoredElements();
                HashSet<AbstractDNodeCandidate> elementsCreated = LayerService.withoutLayersMode(this.description) ? null : new HashSet<AbstractDNodeCandidate>();
                for (NodeMapping nodeMapping : nodeMappings) {
                    this.refreshNodeMapping(mappingsToEdgeTargets, this.diagram, nodeMapping, elementsCreated, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (elementsCreated != null) {
                    elementsCreated.clear();
                }
                for (ContainerMapping containerMapping : containerMappings) {
                    this.refreshContainerMapping(mappingsToEdgeTargets, this.diagram, containerMapping, elementsCreated, false, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                this.handleImportersIssues();
                this.computeDecorations(mappingsToEdgeTargets, edgeToSemanticBasedDecoration, edgeToMappingBasedDecoration);
                this.edgesDones = new HashSet();
                this.processEdgeMappingsRefresh(edgeMappings, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration, monitor);
                this.edgesDones.clear();
                this.deleteIgnoredElementsAndDuplicates();
                RefreshExtensionService.getInstance().postRefresh(this.diagram);
                this.clearCache();
            }
            KeyCache.DEFAULT.clear();
        }
        finally {
            monitor.done();
        }
    }

    private void processEdgeMappingsRefresh(List<EdgeMapping> edgeMappings, final Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration, IProgressMonitor monitor) {
        final IsMappingOfCurrentDiagramDescription isMappingOfCurrentDiagramDescription = new IsMappingOfCurrentDiagramDescription(this.description);
        Predicate<EdgeMapping> edgeMappingWithoutEdgeAsSourceOrTarget = new Predicate<EdgeMapping>(){

            public boolean apply(EdgeMapping input) {
                Iterable edgeSourceMappings = Iterables.filter((Iterable)Iterables.filter(input.getSourceMapping(), EdgeMapping.class), (Predicate)isMappingOfCurrentDiagramDescription);
                Iterable edgeTargetMappings = Iterables.filter((Iterable)Iterables.filter(input.getTargetMapping(), EdgeMapping.class), (Predicate)isMappingOfCurrentDiagramDescription);
                return Iterables.isEmpty((Iterable)edgeSourceMappings) && Iterables.isEmpty((Iterable)edgeTargetMappings);
            }
        };
        Predicate<EdgeMapping> refreshedEdgeMapping = new Predicate<EdgeMapping>(){

            public boolean apply(EdgeMapping input) {
                return mappingsToEdgeTargets.keySet().contains(input) || !DDiagramSynchronizer.this.getDiagram().getActivatedLayers().contains((Object)new EObjectQuery(input).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getLayer()));
            }
        };
        Predicate<EdgeMapping> unrefreshedEdgeMappingWithRefreshedEdgeAsSourceOrTarget = new Predicate<EdgeMapping>((Predicate)refreshedEdgeMapping){
            private final /* synthetic */ Predicate val$refreshedEdgeMapping;
            {
                this.val$refreshedEdgeMapping = predicate;
            }

            public boolean apply(EdgeMapping input) {
                boolean result = !mappingsToEdgeTargets.keySet().contains(input);
                Iterable edgeSourceMappings = Iterables.filter((Iterable)Iterables.filter(input.getSourceMapping(), EdgeMapping.class), (Predicate)isMappingOfCurrentDiagramDescription);
                Iterable edgeTargetMappings = Iterables.filter((Iterable)Iterables.filter(input.getTargetMapping(), EdgeMapping.class), (Predicate)isMappingOfCurrentDiagramDescription);
                return result && Iterables.all((Iterable)edgeSourceMappings, (Predicate)this.val$refreshedEdgeMapping) && Iterables.all((Iterable)edgeTargetMappings, (Predicate)this.val$refreshedEdgeMapping);
            }
        };
        for (EdgeMapping mapping : Iterables.filter(edgeMappings, (Predicate)edgeMappingWithoutEdgeAsSourceOrTarget)) {
            this.refreshEdgeMapping(this.diagramMappingsManager, mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            mappingsToEdgeTargets.put(mapping, (Collection<EdgeTarget>)this.diagram.getEdgesFromMapping(mapping));
        }
        ArrayList remaingEdgeMappingsToRefresh = Lists.newArrayList(edgeMappings);
        remaingEdgeMappingsToRefresh.removeAll(mappingsToEdgeTargets.keySet());
        boolean noRefreshImpliesCycleDetected = true;
        while (!mappingsToEdgeTargets.keySet().containsAll(edgeMappings)) {
            for (EdgeMapping mapping : Iterables.filter((Iterable)remaingEdgeMappingsToRefresh, (Predicate)unrefreshedEdgeMappingWithRefreshedEdgeAsSourceOrTarget)) {
                this.refreshEdgeMapping(this.diagramMappingsManager, mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                mappingsToEdgeTargets.put(mapping, (Collection<EdgeTarget>)this.diagram.getEdgesFromMapping(mapping));
                noRefreshImpliesCycleDetected = false;
            }
            remaingEdgeMappingsToRefresh = Lists.newArrayList(edgeMappings);
            remaingEdgeMappingsToRefresh.removeAll(mappingsToEdgeTargets.keySet());
            if (noRefreshImpliesCycleDetected) {
                return;
            }
            noRefreshImpliesCycleDetected = true;
        }
    }

    private void computePreviousCandidatesCache() {
        this.previousCandidatesCache = LinkedHashMultimap.create();
        this.retrievePreviousCandidates(this.diagram, (Multimap<EObjectCouple, DDiagramElement>)this.previousCandidatesCache);
    }

    private void clearCache() {
        this.previousCandidatesCache = null;
    }

    private void handleImportersIssues() {
        for (DiagramElementMapping mapping : this.diagramMappingsManager.getOtherImportersMappings()) {
            EObjectCouple key = new EObjectCouple((EObject)this.diagram, (EObject)mapping);
            this.ignoredDuringRefreshProcess.remove(key);
            Set elements = this.previousCandidatesCache.get((Object)key);
            if (elements == null) {
                return;
            }
            for (DiagramElementMapping subMapping : mapping.getAllMappings()) {
                for (DDiagramElement element : elements) {
                    key = new EObjectCouple((EObject)element, (EObject)subMapping);
                    this.ignoredDuringRefreshProcess.remove(key);
                }
            }
        }
    }

    private void fillIgnoredElements() {
        this.ignoredDuringRefreshProcess.addAll(this.previousCandidatesCache.keySet());
    }

    private void deleteIgnoredElementsAndDuplicates() {
        DisplayServiceManager.INSTANCE.getDisplayService().activateCache();
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(this.session, this.diagram);
        NotificationUtil.sendNotification((EObject)this.diagram, (int)0, (int)2);
        for (EObjectCouple ignoredElement : this.ignoredDuringRefreshProcess) {
            Set elements = this.previousCandidatesCache.get((Object)ignoredElement);
            for (DDiagramElement element : elements) {
                EObject semanticElement = element.getTarget();
                if (semanticElement == null) {
                    this.accessor.eDelete((EObject)element, this.session != null ? this.session.getSemanticCrossReferencer() : null);
                }
                if (!this.shouldKeepElement(mappingManager, element)) {
                    this.accessor.eDelete((EObject)element, this.session != null ? this.session.getSemanticCrossReferencer() : null);
                    continue;
                }
                this.hideElementToUser(element);
            }
        }
        NotificationUtil.sendNotification((EObject)this.diagram, (int)1, (int)2);
        DisplayServiceManager.INSTANCE.getDisplayService().deactivateCache();
    }

    private void hideElementToUser(DDiagramElement element) {
        if (element.isVisible()) {
            element.setVisible(false);
        }
    }

    private boolean shouldKeepElement(DiagramMappingsManager mappingManager, DDiagramElement element) {
        return element.getParentDiagram() != null && !DisplayServiceManager.INSTANCE.getDisplayService().computeVisibility(mappingManager, this.diagram, element);
    }

    public void computeDecorations(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration) {
        EList<Layer> activatedLayers = this.diagram.getActivatedLayers();
        for (Layer layer : activatedLayers) {
            if (layer.getDecorationDescriptionsSet() == null || layer.getDecorationDescriptionsSet().getDecorationDescriptions().size() <= 0) continue;
            for (DecorationDescription decorationDescription : layer.getDecorationDescriptionsSet().getDecorationDescriptions()) {
                if (decorationDescription instanceof MappingBasedDecoration) {
                    this.computeDecoration((MappingBasedDecoration)decorationDescription, mappingsToEdgeTargets, edgeToMappingBasedDecoration);
                    continue;
                }
                if (!(decorationDescription instanceof SemanticBasedDecoration)) continue;
                this.computeDecoration((SemanticBasedDecoration)decorationDescription, mappingsToEdgeTargets, edgeToSemanticBasedDecoration);
            }
        }
    }

    private void computeDecoration(SemanticBasedDecoration decorationDescription, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration) {
        String domainClass = decorationDescription.getDomainClass();
        for (Collection<EdgeTarget> collection : mappingsToEdgeTargets.values()) {
            for (DDiagramElement element : Iterables.filter(collection, DDiagramElement.class)) {
                if (!this.accessor.eInstanceOf(element.getTarget(), decorationDescription.getDomainClass())) continue;
                this.sync.addDecoration(element, (DecorationDescription)decorationDescription);
            }
        }
        if (!edgeToSemanticBasedDecoration.containsKey(domainClass)) {
            edgeToSemanticBasedDecoration.put(domainClass, new HashSet());
        }
        edgeToSemanticBasedDecoration.get(domainClass).add(decorationDescription);
    }

    private void computeDecoration(MappingBasedDecoration decorationDescription, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration) {
        for (DiagramElementMapping mapping : decorationDescription.getMappings()) {
            if (mapping instanceof AbstractNodeMapping) {
                Collection<EdgeTarget> targets = mappingsToEdgeTargets.get(mapping);
                if (targets == null) continue;
                for (DDiagramElement element : Iterables.filter(targets, DDiagramElement.class)) {
                    this.sync.addDecoration(element, decorationDescription);
                }
                continue;
            }
            if (!(mapping instanceof EdgeMapping)) continue;
            if (!edgeToMappingBasedDecoration.containsKey(mapping)) {
                edgeToMappingBasedDecoration.put((EdgeMapping)mapping, new HashSet());
            }
            edgeToMappingBasedDecoration.get(mapping).add(decorationDescription);
        }
    }

    private void convertType(EObject eObject) {
        EStructuralFeature typeEFeature = eObject.eClass().getEStructuralFeature("type");
        if (typeEFeature != null && visualIDMap.containsKey(eObject.eGet(typeEFeature))) {
            eObject.eSet(typeEFeature, (Object)visualIDMap.get(eObject.eGet(typeEFeature)));
        }
    }

    private AbstractDNode handleListAttributeChangeOnMapping(AbstractDNode node, ContainerMapping containerMapping, DragAndDropTarget viewContainer, IProgressMonitor monitor) {
        boolean isListContainer = new ContainerMappingQuery(containerMapping).isListContainer();
        if (node instanceof DNodeContainer && isListContainer || node instanceof DNodeList && !isListContainer) {
            AbstractDNodeCandidate newCandidate = new AbstractDNodeCandidate(containerMapping, node.getTarget(), viewContainer);
            HashSet<AbstractDNodeCandidate> newCandidates = new HashSet<AbstractDNodeCandidate>(1);
            newCandidates.add(newCandidate);
            AbstractDNode newNode = this.createNewContent(newCandidates, viewContainer, containerMapping, false, monitor).get(0);
            SiriusDiagramHelper.removeNodeFromContainer(viewContainer, false, node);
            Collection settings = this.session.getSemanticCrossReferencer().getInverseReferences((EObject)node);
            for (EStructuralFeature.Setting setting : settings) {
                EObject referencer = setting.getEObject();
                referencer.eSet(setting.getEStructuralFeature(), (Object)newNode);
                this.convertType(referencer);
                List<?> children = this.getChildren(referencer);
                for (Object eChild : children) {
                    if (!(eChild instanceof EObject)) continue;
                    this.convertType((EObject)eChild);
                    ArrayList<EObject> toRemove = new ArrayList<EObject>();
                    for (Object childOfChild : this.getChildren((EObject)eChild)) {
                        if (!(childOfChild instanceof EObject)) continue;
                        toRemove.add((EObject)childOfChild);
                    }
                    for (EObject eObject : toRemove) {
                        EcoreUtil.remove((EObject)eObject);
                    }
                }
            }
            return newNode;
        }
        return node;
    }

    private List<?> getChildren(EObject eObject) {
        EStructuralFeature childrenEFeature = eObject.eClass().getEStructuralFeature("children");
        if (childrenEFeature != null) {
            EList children = (EList)eObject.eGet(childrenEFeature);
            return children;
        }
        return Collections.emptyList();
    }

    private AbstractDNode handleListAttributeChangeOnContainerMapping(AbstractDNode node, AbstractNodeMapping nodeMapping, DDiagramElementContainer diagramElementContainer, IProgressMonitor monitor) {
        ContainerMapping containerMapping = diagramElementContainer.getActualMapping();
        boolean isListContainer = new ContainerMappingQuery(containerMapping).isListContainer();
        if (node instanceof DNode && isListContainer || node instanceof DNodeListElement && !isListContainer) {
            AbstractDNodeCandidate newCandidate = new AbstractDNodeCandidate(nodeMapping, node.getTarget(), diagramElementContainer);
            HashSet<AbstractDNodeCandidate> newCandidates = new HashSet<AbstractDNodeCandidate>(1);
            newCandidates.add(newCandidate);
            AbstractDNode newNode = this.createNewContent(newCandidates, diagramElementContainer, nodeMapping, false, monitor).get(0);
            SiriusDiagramHelper.removeNodeFromContainer(diagramElementContainer, false, node);
            return newNode;
        }
        return node;
    }

    private void refreshContainerMapping(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, DragAndDropTarget viewContainer, ContainerMapping mapping, Set<AbstractDNodeCandidate> semanticFilter, boolean border, boolean orderBySemantic, IProgressMonitor monitor) {
        SetIntersection<AbstractDNodeCandidate> status = this.computeCurrentStatus(viewContainer, mapping, semanticFilter);
        Collection newElements = status.getNewElements();
        try {
            monitor.beginTask("Refresh containers", 3);
            this.deleteCandidatesToRemove(status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList keptNodes = Lists.newArrayList();
            ArrayList createdNodes = Lists.newArrayList();
            if (orderBySemantic) {
                this.handleKeptAndNewNodesWithOrder(viewContainer, mapping, status, keptNodes, createdNodes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                this.handleKeptNodes(viewContainer, status, keptNodes, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                createdNodes.addAll(this.createNewContent(newElements, viewContainer, mapping, border, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            MultipleCollection addedNodes = new MultipleCollection();
            addedNodes.addAll(createdNodes);
            addedNodes.addAll(keptNodes);
            this.putOrAdd(mappingsToEdgeTargets, mapping, (Collection<DDiagramElement>)addedNodes);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            try {
                subMonitor.beginTask("", addedNodes.size());
                for (DDiagramElement newElem : addedNodes) {
                    if (!(newElem instanceof DDiagramElementContainer)) continue;
                    DDiagramElementContainer newNode = (DDiagramElementContainer)newElem;
                    this.refreshMappingsInContainerMapping(mappingsToEdgeTargets, newNode, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void refreshMappingsInContainerMapping(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, DDiagramElementContainer newNode, IProgressMonitor monitor) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)newNode)) {
            try {
                monitor.beginTask("Refresh container childs", 1);
                this.refreshBorderNodeMapping(mappingsToEdgeTargets, newNode, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (newNode instanceof DNodeContainer) {
                    DNodeContainer newContainer = (DNodeContainer)newNode;
                    List<ContainerMapping> childMappings = this.diagramMappingsManager.getContainerMappings(newContainer);
                    List<NodeMapping> childNodeMappings = this.diagramMappingsManager.getNodeMappings(newContainer);
                    HashSet<AbstractDNodeCandidate> elementsCreated = LayerService.withoutLayersMode(this.description) ? null : new HashSet<AbstractDNodeCandidate>();
                    boolean stackContainer = new DNodeContainerExperimentalQuery(newContainer).isRegionContainer();
                    for (ContainerMapping containerMapping : childMappings) {
                        this.refreshContainerMapping(mappingsToEdgeTargets, newNode, containerMapping, elementsCreated, false, stackContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (elementsCreated != null) {
                        elementsCreated.clear();
                    }
                    for (NodeMapping nodeMapping : childNodeMappings) {
                        this.refreshNodeMapping(mappingsToEdgeTargets, newNode, nodeMapping, elementsCreated, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                } else if (newNode instanceof DNodeList) {
                    List<NodeMapping> childNodeMappings = this.diagramMappingsManager.getNodeMappings((DNodeList)newNode);
                    HashSet<AbstractDNodeCandidate> elementsCreated = LayerService.withoutLayersMode(this.description) ? null : new HashSet<AbstractDNodeCandidate>();
                    for (NodeMapping child : childNodeMappings) {
                        this.refreshNodeMapping(mappingsToEdgeTargets, newNode, child, elementsCreated, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void refreshNodeMapping(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToAbstractNodes, DragAndDropTarget viewContainer, NodeMapping mapping, Set<AbstractDNodeCandidate> semanticFilter, IProgressMonitor monitor) {
        SetIntersection<AbstractDNodeCandidate> status = this.computeCurrentStatus(viewContainer, mapping, semanticFilter);
        try {
            monitor.beginTask("Nodes refresh", 3);
            this.deleteCandidatesToRemove(status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList keptNodes = Lists.newArrayList();
            ArrayList createdNodes = Lists.newArrayList();
            this.handleKeptAndNewNodesWithOrder(viewContainer, mapping, status, keptNodes, createdNodes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            MultipleCollection addedNodes = new MultipleCollection();
            addedNodes.addAll(createdNodes);
            addedNodes.addAll(keptNodes);
            this.putOrAdd(mappingsToAbstractNodes, mapping, (Collection<DDiagramElement>)addedNodes);
            for (AbstractDNode newNode : Iterables.filter((Iterable)addedNodes, AbstractDNode.class)) {
                this.refreshBorderNodeMapping(mappingsToAbstractNodes, newNode, semanticFilter, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void refreshBorderNodeMapping(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToAbstractNodes, AbstractDNode newNode, Set<AbstractDNodeCandidate> semanticFilter, IProgressMonitor monitor) {
        if (newNode instanceof DragAndDropTarget && this.accessor.getPermissionAuthority().canEditInstance((EObject)newNode)) {
            DragAndDropTarget newNodeDDT = (DragAndDropTarget)((Object)newNode);
            List<NodeMapping> borderedNodeMappings = this.diagramMappingsManager.getBorderedNodeMappings(newNode);
            try {
                monitor.beginTask("BorderedNodes refresh", 4 * borderedNodeMappings.size());
                for (NodeMapping bordermapping : borderedNodeMappings) {
                    SetIntersection<AbstractDNodeCandidate> borderStatus = this.computeCurrentStatus(newNodeDDT, bordermapping, semanticFilter);
                    this.deleteCandidatesToRemove(borderStatus, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ArrayList keptNodes = Lists.newArrayList();
                    ArrayList createdNodes = Lists.newArrayList();
                    createdNodes.addAll(this.createNewContent(borderStatus.getNewElements(), newNodeDDT, bordermapping, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                    this.handleKeptNodes(newNodeDDT, borderStatus, keptNodes, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    MultipleCollection addedBorderNodes = new MultipleCollection();
                    addedBorderNodes.addAll(createdNodes);
                    addedBorderNodes.addAll(keptNodes);
                    this.putOrAdd(mappingsToAbstractNodes, bordermapping, (Collection<DDiagramElement>)addedBorderNodes);
                    for (AbstractDNode bNewNode : Iterables.filter((Iterable)addedBorderNodes, AbstractDNode.class)) {
                        this.refreshBorderNodeMapping(mappingsToAbstractNodes, bNewNode, semanticFilter, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private SetIntersection<AbstractDNodeCandidate> computeCurrentStatus(DragAndDropTarget viewcontainer, AbstractNodeMapping mapping, Set<AbstractDNodeCandidate> semanticFilter) {
        GSetIntersection biSet = new GSetIntersection();
        this.addPreviousCandidates((SetIntersection<AbstractDNodeCandidate>)biSet, viewcontainer, mapping);
        this.addNowNodeCandidates((SetIntersection<AbstractDNodeCandidate>)biSet, viewcontainer, mapping, semanticFilter);
        return biSet;
    }

    private void deleteCandidatesToRemove(SetIntersection<AbstractDNodeCandidate> status, IProgressMonitor monitor) {
        try {
            Iterable candidatesToRemove = status.getRemovedElements();
            monitor.beginTask("Nodes deletion", Iterables.size((Iterable)candidatesToRemove));
            for (AbstractDNodeCandidate nodeToDelete : candidatesToRemove) {
                if (!nodeToDelete.comesFromDiagramElement()) continue;
                this.accessor.eDelete((EObject)nodeToDelete.getOriginalElement(), this.session != null ? this.session.getSemanticCrossReferencer() : null);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void handleKeptAndNewNodesWithOrder(DragAndDropTarget viewContainer, DiagramElementMapping mapping, SetIntersection<AbstractDNodeCandidate> status, Collection<AbstractDNode> keptNodes, Collection<AbstractDNode> createdNodes, IProgressMonitor monitor) {
        try {
            Iterable allElements = status.getAllElements();
            monitor.beginTask("", Iterables.size((Iterable)allElements));
            boolean createContents = this.accessor.getPermissionAuthority().canCreateIn((EObject)viewContainer) && new DiagramElementMappingQuery(mapping).isSynchronizedAndCreateElement(this.diagram);
            RefreshOrderHelper refreshOrderHelper = new RefreshOrderHelper(viewContainer, mapping);
            int mappingBeginIndex = refreshOrderHelper.getMappingBeginIndex();
            int currentGlobalPosition = 0;
            for (AbstractDNodeCandidate candidate : allElements) {
                int positionToAppend = mappingBeginIndex + currentGlobalPosition;
                if (candidate.getOriginalElement() != null) {
                    AbstractDNode node = this.handleKeptNode(viewContainer, candidate, keptNodes, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!refreshOrderHelper.getOldGlobalPosition(node).equals(positionToAppend)) {
                        refreshOrderHelper.getOwnedDDiagramElements().move(positionToAppend, (Object)node);
                    }
                } else if (createContents) {
                    AbstractDNode createdNode = this.sync.createNewNode(this.diagramMappingsManager, candidate, false, positionToAppend);
                    createdNodes.add(createdNode);
                }
                ++currentGlobalPosition;
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void handleKeptNodes(DragAndDropTarget viewContainer, SetIntersection<AbstractDNodeCandidate> status, Collection<AbstractDNode> keptNodes, boolean border, IProgressMonitor monitor) {
        Iterable keptNodeCandidates = status.getKeptElements();
        try {
            monitor.beginTask("Refresh Nodes", Iterables.size((Iterable)keptNodeCandidates));
            for (AbstractDNodeCandidate keptCandidate : keptNodeCandidates) {
                this.handleKeptNode(viewContainer, keptCandidate, keptNodes, border, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private AbstractDNode handleKeptNode(DragAndDropTarget viewContainer, AbstractDNodeCandidate keptCandidate, Collection<AbstractDNode> keptNodes, boolean border, IProgressMonitor monitor) {
        AbstractDNode keptNode = keptCandidate.getOriginalElement();
        try {
            monitor.beginTask("Node refresh", 3);
            AbstractNodeMapping nodeMapping = (AbstractNodeMapping)keptNode.getDiagramElementMapping();
            if (keptNode instanceof DDiagramElementContainer) {
                ContainerMapping keptNodeMapping = ((DDiagramElementContainer)keptNode).getActualMapping();
                if ((keptNode = this.handleListAttributeChangeOnMapping(keptNode, keptNodeMapping, viewContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) instanceof DNodeContainer) {
                    DNodeContainer dnc = (DNodeContainer)keptNode;
                    dnc.setChildrenPresentation(dnc.getActualMapping().getChildrenPresentation());
                }
            } else if (!border && viewContainer instanceof DDiagramElementContainer && nodeMapping instanceof NodeMapping) {
                keptNode = this.handleListAttributeChangeOnContainerMapping(keptNode, nodeMapping, (DDiagramElementContainer)viewContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.sync.refresh(keptNode);
            monitor.worked(1);
            this.sync.refreshStyle(keptNode, nodeMapping);
            monitor.worked(1);
            keptNodes.add(keptNode);
        }
        finally {
            monitor.done();
        }
        return keptNode;
    }

    public Collection<DEdgeCandidate> computeEdgeCandidates(EdgeMapping mapping, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        return this.edgeHelper.computeNowEdgeCandidates(mapping, mappingsToEdgeTargets);
    }

    protected Set<DDiagramElement> getPreviousDiagramElements(DragAndDropTarget container, DiagramElementMapping mapping) {
        if (this.forceRetrieve) {
            LinkedHashSet previousDiagramElements = Sets.newLinkedHashSet();
            for (DDiagramElement dDiagramElement : DiagramElementsHierarchyVisitor.INSTANCE.getChildren(container)) {
                DiagramElementMapping elementMapping = dDiagramElement.getDiagramElementMapping();
                if (elementMapping instanceof AbstractNodeMapping && new DiagramElementMappingQuery(elementMapping).areInSameHiearchy(mapping)) {
                    previousDiagramElements.add(dDiagramElement);
                    continue;
                }
                if (!(elementMapping instanceof IEdgeMapping) || !new DiagramElementMappingQuery(elementMapping).areInSameHiearchy(mapping)) continue;
                previousDiagramElements.add(dDiagramElement);
            }
            return previousDiagramElements;
        }
        EObjectCouple key = new EObjectCouple((EObject)container, (EObject)mapping);
        if (this.previousCandidatesCache == null) {
            this.computePreviousCandidatesCache();
        }
        return this.previousCandidatesCache.get((Object)key);
    }

    private void addNowNodeCandidates(SetIntersection<AbstractDNodeCandidate> biSet, DragAndDropTarget container, AbstractNodeMapping mapping, Set<AbstractDNodeCandidate> semanticFilter) {
        Collection<AbstractDNodeCandidate> nowCandidates = this.computeNodeCandidates(container, mapping, semanticFilter);
        for (AbstractDNodeCandidate candidate : nowCandidates) {
            biSet.addInNew((Object)candidate);
        }
    }

    protected void forceRetrieve() {
        this.forceRetrieve = true;
    }

    protected void resetforceRetrieve() {
        this.forceRetrieve = false;
    }

    public Collection<AbstractDNodeCandidate> computeNodeCandidates(DragAndDropTarget container, AbstractNodeMapping mapping, Set<AbstractDNodeCandidate> semanticFilter) {
        return this.nodHelper.computeNodeCandidates(container, mapping, semanticFilter);
    }

    private void retrievePreviousCandidates(DragAndDropTarget container, Multimap<EObjectCouple, DDiagramElement> candidates) {
        for (DDiagramElement dDiagramElement : DiagramElementsHierarchyVisitor.INSTANCE.getChildren(container)) {
            EObjectCouple key = dDiagramElement.getMapping() == null ? new EObjectCouple((EObject)container, FAKE_MAPPING) : new EObjectCouple((EObject)container, (EObject)dDiagramElement.getMapping());
            candidates.put((Object)key, (Object)dDiagramElement);
            if (!(dDiagramElement instanceof DragAndDropTarget)) continue;
            this.retrievePreviousCandidates((DragAndDropTarget)((Object)dDiagramElement), candidates);
        }
    }

    private void addPreviousCandidates(SetIntersection<AbstractDNodeCandidate> biSet, DragAndDropTarget container, AbstractNodeMapping mapping) {
        EObjectCouple key = new EObjectCouple((EObject)container, (EObject)mapping);
        this.ignoredDuringRefreshProcess.remove(key);
        Set candidates = this.previousCandidatesCache.get((Object)key);
        if (candidates == null) {
            candidates = Collections.emptySet();
        }
        this.addCandidates(biSet, candidates.iterator(), mapping);
    }

    private <T extends DDiagramElement> void addCandidates(SetIntersection<AbstractDNodeCandidate> biSet, Iterator<T> it, AbstractNodeMapping mapping) {
        while (it.hasNext()) {
            DDiagramElement element = (DDiagramElement)it.next();
            DiagramElementMapping elementMapping = element.getDiagramElementMapping();
            if (!EqualityHelper.areEquals((EObject)elementMapping, (EObject)mapping) && mapping.eResource() != null) continue;
            AbstractDNodeCandidate abstractDNodeCandidate = new AbstractDNodeCandidate((AbstractDNode)element);
            biSet.addInOld((Object)abstractDNodeCandidate);
        }
    }

    private List<AbstractDNode> createNewContent(Collection<AbstractDNodeCandidate> candidatesToCreate, DragAndDropTarget container, AbstractNodeMapping mapping, boolean border, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Nodes creation", candidatesToCreate.size());
            if (!candidatesToCreate.isEmpty() && this.accessor.getPermissionAuthority().canCreateIn((EObject)container) && new DiagramElementMappingQuery(mapping).isSynchronizedAndCreateElement(this.diagram)) {
                ArrayList<AbstractDNode> createdNodes = new ArrayList<AbstractDNode>(candidatesToCreate.size());
                for (AbstractDNodeCandidate candidate : candidatesToCreate) {
                    AbstractDNode createdNode = this.sync.createNewNode(this.diagramMappingsManager, candidate, border);
                    createdNodes.add(createdNode);
                    monitor.worked(1);
                }
                ArrayList<AbstractDNode> arrayList = createdNodes;
                return arrayList;
            }
        }
        finally {
            monitor.done();
        }
        return new ArrayList<AbstractDNode>();
    }

    public Option<DEdge> createEdgeMapping(DiagramMappingsManager mappingManager, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, EdgeMapping mapping, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration) {
        this.edgesDones = new HashSet();
        Collection<DEdge> newEdges = this.createDEdgeOnMapping(mappingManager, mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
        this.edgesDones.clear();
        if (!newEdges.isEmpty()) {
            return Options.newSome((Object)newEdges.iterator().next());
        }
        return Options.newNone();
    }

    private Collection<DEdge> createDEdgeOnMapping(DiagramMappingsManager mappingManager, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, EdgeMapping mapping, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration) {
        HashSet<DEdge> newEdges = new HashSet<DEdge>();
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.diagram)) {
            SetIntersection<DEdgeCandidate> status = this.createEdgeCandidates(mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
            for (DEdgeCandidate candidate : status.getNewElements()) {
                newEdges.add(this.sync.createNewEdge(mappingManager, candidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration));
            }
        }
        return newEdges;
    }

    private void refreshEdgeMapping(DiagramMappingsManager mappingManager, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, EdgeMapping mapping, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration, IProgressMonitor monitor) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)this.diagram)) {
            SetIntersection<DEdgeCandidate> status = this.createEdgeCandidates(mappingsToEdgeTargets, mapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
            if (new DiagramElementMappingQuery(mapping).isSynchronizedAndCreateElement(this.diagram)) {
                try {
                    Collection newElements = status.getNewElements();
                    monitor.beginTask("Refresh edges", newElements.size());
                    for (DEdgeCandidate candidate : newElements) {
                        this.edgesDones.add(this.sync.createNewEdge(mappingManager, candidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration));
                        monitor.worked(1);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
    }

    private SetIntersection<DEdgeCandidate> createEdgeCandidates(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, EdgeMapping mapping, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration) {
        GSetIntersection status = new GSetIntersection();
        EObjectCouple key = new EObjectCouple((EObject)this.diagram, (EObject)mapping);
        this.ignoredDuringRefreshProcess.remove(key);
        this.handleSubMappings(mapping);
        this.handleSuperMappings(mapping);
        ArrayList invalidCandidates = Lists.newArrayList();
        for (DEdge edge : this.diagram.getEdgesFromMapping(mapping)) {
            DEdgeCandidate edgeCandidate = new DEdgeCandidate(edge);
            if (edgeCandidate.isInvalid()) {
                invalidCandidates.add(edgeCandidate);
                continue;
            }
            status.addInOld((Object)edgeCandidate);
        }
        Collection<DEdgeCandidate> edgesCandidates = this.computeEdgeCandidates(mapping, mappingsToEdgeTargets);
        for (DEdgeCandidate edgeCandidate : edgesCandidates) {
            status.addInNew((Object)edgeCandidate);
        }
        for (DEdgeCandidate edgeCandidate : Iterables.concat((Iterable)status.getRemovedElements(), (Iterable)invalidCandidates)) {
            if (this.isDefinedInAnotherLayer(edgeCandidate, mappingsToEdgeTargets)) continue;
            DslCommonPlugin.PROFILER.startWork("Cleaning all edges");
            this.accessor.eDelete((EObject)edgeCandidate.getEdge(), this.session != null ? this.session.getSemanticCrossReferencer() : null);
            DslCommonPlugin.PROFILER.stopWork("Cleaning all edges");
        }
        for (DEdgeCandidate edgeCandidate : status.getKeptElements()) {
            DslCommonPlugin.PROFILER.startWork("Updating all edges");
            if (!this.edgesDones.contains(edgeCandidate.getEdge())) {
                if (edgeCandidate.getEdge().getActualMapping() != mapping) {
                    edgeCandidate.getEdge().setActualMapping(mapping);
                }
                this.sync.computeEdgeDecorations(edgeCandidate.getEdge(), edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
                Option<EdgeMapping> edgeMapping = new IEdgeMappingQuery(edgeCandidate.getEdge().getActualMapping()).getEdgeMapping();
                if (edgeMapping.some()) {
                    this.sync.createStyle(edgeCandidate.getEdge(), (EdgeMapping)edgeMapping.get(), this.diagram);
                    this.sync.refresh(edgeCandidate.getEdge());
                    this.sync.refreshStyle(edgeCandidate.getEdge(), (EdgeMapping)edgeMapping.get(), this.diagram);
                    this.sync.updatePath(edgeCandidate.getEdge(), (EdgeMapping)edgeMapping.get(), mappingsToEdgeTargets);
                }
                this.edgesDones.add(edgeCandidate.getEdge());
            }
            DslCommonPlugin.PROFILER.stopWork("Updating all edges");
        }
        return status;
    }

    private void handleSubMappings(IEdgeMapping mapping) {
        if (mapping instanceof EdgeMappingImport) {
            IEdgeMapping importedEdgeMaping = ((EdgeMappingImport)mapping).getImportedMapping();
            EObjectCouple key = new EObjectCouple((EObject)this.diagram, (EObject)importedEdgeMaping);
            this.ignoredDuringRefreshProcess.remove(key);
            this.handleSubMappings(importedEdgeMaping);
        }
    }

    private void handleSuperMappings(IEdgeMapping mapping) {
        Iterator<EObjectCouple> iterator = this.ignoredDuringRefreshProcess.iterator();
        while (iterator.hasNext()) {
            EObjectCouple couple = iterator.next();
            EdgeMappingImport edgeMappingImport = null;
            if (couple.getObj2() instanceof EdgeMappingImportWrapper) {
                edgeMappingImport = ((EdgeMappingImportWrapper)couple.getObj2()).getWrappedEdgeMappingImport();
            } else if (couple.getObj2() instanceof EdgeMappingImport) {
                edgeMappingImport = (EdgeMappingImport)couple.getObj2();
            }
            if (edgeMappingImport == null || !couple.getObj1().equals(this.diagram) || !EdgeMappingHelper.isImported(mapping, edgeMappingImport)) continue;
            iterator.remove();
        }
    }

    private boolean isDefinedInAnotherLayer(DEdgeCandidate edgeCandidate, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        Object targetMappings;
        Object sourceMappings;
        if (edgeCandidate.getEdge() == null) {
            return false;
        }
        DEdge edge = edgeCandidate.getEdge();
        EdgeTarget source = edge.getSourceNode();
        EdgeTarget target = edge.getTargetNode();
        boolean sourceIsValid = source != null && (!(source instanceof DDiagramElement) || ((DDiagramElement)((Object)source)).getParentDiagram() == this.diagram);
        boolean targetIsValid = target != null && (!(target instanceof DDiagramElement) || ((DDiagramElement)((Object)target)).getParentDiagram() == this.diagram);
        Option<EdgeMapping> actualMapping = new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping();
        if (actualMapping.some()) {
            sourceMappings = ((EdgeMapping)actualMapping.get()).getSourceMapping().iterator();
            targetMappings = ((EdgeMapping)actualMapping.get()).getTargetMapping().iterator();
        } else {
            sourceMappings = Iterators.emptyIterator();
            targetMappings = Iterators.emptyIterator();
        }
        boolean sourceIsNotDisplayed = this.nodeIsNotDisplayed((Iterator<DiagramElementMapping>)sourceMappings, source, mappingsToEdgeTargets);
        boolean targetIsNotDisplayed = this.nodeIsNotDisplayed((Iterator<DiagramElementMapping>)targetMappings, target, mappingsToEdgeTargets);
        return sourceIsValid && targetIsValid && (sourceIsNotDisplayed || targetIsNotDisplayed);
    }

    private boolean nodeIsNotDisplayed(Iterator<DiagramElementMapping> mappingsToConsider, EdgeTarget node, Map<DiagramElementMapping, Collection<EdgeTarget>> elementsInDiagram) {
        boolean sourceIsNotDisplayed = true;
        while (mappingsToConsider.hasNext() && sourceIsNotDisplayed) {
            DiagramElementMapping sourceMapping = mappingsToConsider.next();
            Collection<EdgeTarget> elementsFromMapping = this.getDiagramElementFromMapping(sourceMapping, elementsInDiagram);
            if (elementsFromMapping == null || !elementsFromMapping.contains(node)) continue;
            sourceIsNotDisplayed = false;
        }
        return sourceIsNotDisplayed;
    }

    private Collection<EdgeTarget> getDiagramElementFromMapping(DiagramElementMapping sourceMapping, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        return mappingsToEdgeTargets.get(sourceMapping);
    }

    private void putOrAdd(Map map, DiagramElementMapping mapping, Collection<DDiagramElement> addedNodes) {
        Collection existing = (Collection)map.get(mapping);
        if (existing == null) {
            existing = new MultipleCollection();
            existing.addAll(addedNodes);
            map.put(mapping, existing);
        } else {
            existing.addAll(addedNodes);
        }
        DragAndDropTargetDescription mappingToAdd = null;
        if (mapping instanceof ContainerMappingImport) {
            mappingToAdd = ((ContainerMappingImport)mapping).getImportedMapping();
        } else if (mapping instanceof NodeMappingImport) {
            mappingToAdd = ((NodeMappingImport)mapping).getImportedMapping();
        }
        if (mappingToAdd != null) {
            this.putOrAdd(map, (DiagramElementMapping)((Object)mappingToAdd), addedNodes);
        }
    }

    public void setTool(boolean b) {
        this.edgeHelper.setTool(b);
    }

    private static final class RefreshOrderHelper {
        final DragAndDropTarget viewContainer;
        final Map<EObject, Integer> oldChildPositionInGlobalList = Maps.newHashMap();
        private RepresentationElementMapping mapping;
        private int mappingBeginIndex;

        public RefreshOrderHelper(DragAndDropTarget viewContainer, RepresentationElementMapping mapping) {
            this.viewContainer = viewContainer;
            this.mapping = mapping;
            this.init();
        }

        public void init() {
            EList<EObject> ownedDDiagramElements = this.getOwnedDDiagramElements();
            this.mappingBeginIndex = ownedDDiagramElements.size();
            int position = 0;
            for (DDiagramElement diagElement : Iterables.filter(ownedDDiagramElements, DDiagramElement.class)) {
                if (this.mapping.equals(diagElement.getMapping())) {
                    if (position < this.mappingBeginIndex) {
                        this.mappingBeginIndex = position;
                    }
                    this.oldChildPositionInGlobalList.put((EObject)diagElement, position);
                }
                ++position;
            }
            if (this.mappingBeginIndex < 0) {
                this.mappingBeginIndex = ownedDDiagramElements.size() - 1;
            }
        }

        protected Object getOldGlobalPosition(DDiagramElement element) {
            if (this.oldChildPositionInGlobalList.containsKey(element)) {
                return this.oldChildPositionInGlobalList.get(element);
            }
            return -1;
        }

        protected int getMappingBeginIndex() {
            return this.mappingBeginIndex;
        }

        protected EReference getOwnedDiagramElementsToUpdate() {
            EReference ref = null;
            if (this.viewContainer instanceof DDiagram) {
                ref = DiagramPackage.eINSTANCE.getDDiagram_OwnedDiagramElements();
            } else if (this.viewContainer instanceof DNodeList) {
                ref = DiagramPackage.eINSTANCE.getDNodeList_OwnedElements();
            } else if (this.viewContainer instanceof DNodeContainer) {
                ref = DiagramPackage.eINSTANCE.getDNodeContainer_OwnedDiagramElements();
            }
            if (ref == null) {
                throw new IllegalArgumentException();
            }
            return ref;
        }

        protected EList<EObject> getOwnedDDiagramElements() {
            EList eGetResult = (EList)this.viewContainer.eGet((EStructuralFeature)this.getOwnedDiagramElementsToUpdate());
            return eGetResult;
        }
    }
}

