/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.helper.task.DropinForNodeTaskCommand;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.DMappingBasedQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.IContainerMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramElementContainerSpecOperations;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.SemanticBasedDecoration;
import org.eclipse.sirius.viewpoint.description.tool.DragSource;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public final class DnDTasksOperations {
    private DnDTasksOperations() {
    }

    private static DDiagram getParentDiagram(DragAndDropTarget target) {
        DDiagram parentDiagram = null;
        if (target instanceof DDiagram) {
            parentDiagram = (DDiagram)target;
        } else if (target instanceof DNodeContainer) {
            parentDiagram = ((DNodeContainer)target).getParentDiagram();
        } else if (target instanceof DNodeList) {
            parentDiagram = ((DNodeList)target).getParentDiagram();
        } else if (target instanceof DNode) {
            parentDiagram = ((DNode)target).getParentDiagram();
        }
        return parentDiagram;
    }

    public static AbstractCommandTask createDropinForNodeTask(final DragAndDropTarget target, final NodeMapping mapping, final DDiagramElement droppedDiagramElement, final EObject droppedElement, final EObject semanticContainer, final boolean moveEdges) {
        DropinForNodeTaskCommand result = new DropinForNodeTaskCommand();
        final DDiagram parentDiagram = DnDTasksOperations.getParentDiagram(target);
        if (target instanceof DNodeList) {
            result = new DropinForNodeTaskCommand(){

                public void execute() {
                    DNodeListElement viewNodeListElement;
                    if (droppedDiagramElement != null && mapping.equals(droppedDiagramElement.getMapping())) {
                        viewNodeListElement = (DNodeListElement)droppedDiagramElement;
                    } else {
                        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(droppedElement);
                        viewNodeListElement = new NodeMappingHelper(interpreter).createListElement(mapping, droppedElement, parentDiagram);
                    }
                    ((DNodeList)target).getOwnedElements().add((Object)viewNodeListElement);
                    if (!viewNodeListElement.equals(droppedDiagramElement)) {
                        if (moveEdges) {
                            DnDTasksOperations.moveEdges(target, semanticContainer, droppedDiagramElement, viewNodeListElement);
                        }
                        DnDTasksOperations.deletePreviousEdges(target, droppedDiagramElement);
                    }
                }
            };
        } else if (target instanceof DNodeContainer) {
            result = new DropinForNodeTaskCommand(){

                public void execute() {
                    DNode dNode = droppedDiagramElement != null && mapping.equals(droppedDiagramElement.getMapping()) ? (DNode)droppedDiagramElement : mapping.createNode(droppedElement, semanticContainer, parentDiagram);
                    DNodeContainer dNodeContainer = (DNodeContainer)target;
                    if (dNodeContainer.getActualMapping().getAllBorderedNodeMappings().contains((Object)mapping)) {
                        dNodeContainer.getOwnedBorderedNodes().add((Object)dNode);
                    } else {
                        dNodeContainer.getOwnedDiagramElements().add((Object)dNode);
                    }
                    if (!dNode.equals(droppedDiagramElement)) {
                        if (moveEdges) {
                            DnDTasksOperations.moveEdges(target, semanticContainer, droppedDiagramElement, dNode);
                        }
                        DnDTasksOperations.deletePreviousEdges(target, droppedDiagramElement);
                    }
                }
            };
        } else if (target instanceof DNode) {
            result = new DropinForNodeTaskCommand(){

                public void execute() {
                    DNode dNode = droppedDiagramElement != null && mapping.equals(droppedDiagramElement.getMapping()) ? (DNode)droppedDiagramElement : mapping.createNode(droppedElement, semanticContainer, parentDiagram);
                    ((DNode)target).getOwnedBorderedNodes().add((Object)dNode);
                    if (!dNode.equals(droppedDiagramElement)) {
                        if (moveEdges) {
                            DnDTasksOperations.moveEdges(target, semanticContainer, droppedDiagramElement, dNode);
                        }
                        DnDTasksOperations.deletePreviousEdges(target, droppedDiagramElement);
                    }
                }
            };
        } else if (target instanceof DDiagram) {
            result = new DropinForNodeTaskCommand(){

                public void execute() {
                    DNode dNode = droppedDiagramElement != null && mapping.equals(droppedDiagramElement.getMapping()) ? (DNode)droppedDiagramElement : mapping.createNode(droppedElement, semanticContainer, parentDiagram);
                    parentDiagram.getOwnedDiagramElements().add((Object)dNode);
                    if (!dNode.equals(droppedDiagramElement)) {
                        if (moveEdges) {
                            DnDTasksOperations.moveEdges(target, semanticContainer, droppedDiagramElement, dNode);
                        }
                        DnDTasksOperations.deletePreviousEdges(target, droppedDiagramElement);
                    }
                }
            };
        }
        return result;
    }

    public static AbstractCommandTask createDropinForContainerTask(final DragAndDropTarget target, final ContainerMapping mapping, final DDiagramElement droppedDiagramElement, final EObject droppedElement, final EObject semanticContainer, final ContainerDropDescription tool) {
        return new AbstractCommandTask(){

            public void execute() {
                DDiagram parentDiagram = DnDTasksOperations.getParentDiagram(target);
                DDiagramElementContainer newDiagramElementContainer = null;
                if (droppedDiagramElement != null && mapping.equals(droppedDiagramElement.getMapping())) {
                    newDiagramElementContainer = (DDiagramElementContainer)droppedDiagramElement;
                } else if (mapping instanceof IContainerMappingExt) {
                    IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticContainer);
                    newDiagramElementContainer = new ContainerMappingHelper(interpreter).createContainer((IContainerMappingExt)mapping, droppedElement, semanticContainer, parentDiagram);
                }
                if (newDiagramElementContainer != null) {
                    if (target instanceof DDiagram) {
                        ((DDiagram)target).getOwnedDiagramElements().add((Object)newDiagramElementContainer);
                    } else if (target instanceof DNodeContainer) {
                        ((DNodeContainer)target).getOwnedDiagramElements().add((Object)newDiagramElementContainer);
                    }
                    if (droppedDiagramElement instanceof DNodeContainer && newDiagramElementContainer instanceof DNodeContainer) {
                        DnDTasksOperations.moveSubNodes((DNodeContainer)droppedDiagramElement, droppedElement, tool, (DNodeContainer)newDiagramElementContainer);
                    }
                    if (!newDiagramElementContainer.equals(droppedDiagramElement)) {
                        if (tool.isMoveEdges()) {
                            DnDTasksOperations.moveEdges(target, semanticContainer, droppedDiagramElement, newDiagramElementContainer);
                        }
                        DnDTasksOperations.deletePreviousEdges(target, droppedDiagramElement);
                    }
                }
            }

            public String getLabel() {
                return "DropIn task for container";
            }
        };
    }

    private static void deletePreviousEdges(DragAndDropTarget target, DDiagramElement droppedDiagramElement) {
        DDiagram parentDiagram = DnDTasksOperations.getParentDiagram(target);
        ArrayList<DEdge> edgesOnPreviousNode = new ArrayList<DEdge>();
        if (droppedDiagramElement != null && parentDiagram != null) {
            EList<DEdge> edges = parentDiagram.getEdges();
            for (DEdge edge : edges) {
                if (!edge.getSourceNode().equals(droppedDiagramElement) && !edge.getTargetNode().equals(droppedDiagramElement)) continue;
                edgesOnPreviousNode.add(edge);
            }
        }
        for (DEdge edge : edgesOnPreviousNode) {
            SiriusUtil.delete((EObject)edge);
        }
    }

    private static void moveEdges(DragAndDropTarget target, EObject semanticTarget, DDiagramElement droppedDiagramElement, DDiagramElement createdDiagramElement) {
        DDiagram parentDiagram = DnDTasksOperations.getParentDiagram(target);
        Session session = SessionManager.INSTANCE.getSession(semanticTarget);
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, parentDiagram);
        ModelAccessor accessor = session.getModelAccessor();
        IInterpreter interpreter = session.getInterpreter();
        DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(interpreter, parentDiagram.getDescription(), accessor);
        diagramSync.setDiagram((DSemanticDiagram)parentDiagram);
        DDiagramElementSynchronizer sync = diagramSync.getElementSynchronizer();
        HashMap<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration = new HashMap<EdgeMapping, Collection<MappingBasedDecoration>>();
        HashMap<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration = new HashMap<String, Collection<SemanticBasedDecoration>>();
        ArrayList<DEdge> edgesOnPreviousNode = new ArrayList<DEdge>();
        if (droppedDiagramElement != null) {
            EList<DEdge> edges = parentDiagram.getEdges();
            for (DEdge edge : edges) {
                if (!edge.getSourceNode().equals(droppedDiagramElement) && !edge.getTargetNode().equals(droppedDiagramElement)) continue;
                edgesOnPreviousNode.add(edge);
            }
        }
        Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets = sync.computeMappingsToEdgeTargets(session.getSelectedViewpoints(false));
        List<EdgeMapping> candidateMappings = DnDTasksOperations.getCandidatesMappingsForCreatedDiagramElement(parentDiagram, createdDiagramElement);
        DMappingBasedQuery cdeQuery = new DMappingBasedQuery((DMappingBased)createdDiagramElement);
        for (EdgeMapping candidateEdgeMapping : candidateMappings) {
            ArrayList<DEdgeCandidate> selectedCandidates = new ArrayList<DEdgeCandidate>();
            block2: for (DEdge edge : edgesOnPreviousNode) {
                Collection<DEdgeCandidate> candidates;
                EList<DiagramElementMapping> sourceMappings = candidateEdgeMapping.getSourceMapping();
                EList<DiagramElementMapping> targetMappings = candidateEdgeMapping.getTargetMapping();
                if (cdeQuery.isFromAnyMapping((Collection<? extends DiagramElementMapping>)sourceMappings)) {
                    EdgeTarget edgeTarget = edge.getTargetNode();
                    DMappingBasedQuery edgeTargetQuery = new DMappingBasedQuery((DMappingBased)edgeTarget);
                    if (edgeTarget instanceof DMappingBased && edgeTargetQuery.isFromAnyMapping((Collection<? extends DiagramElementMapping>)targetMappings)) {
                        candidates = diagramSync.computeEdgeCandidates(candidateEdgeMapping, mappingsToEdgeTargets);
                        for (DEdgeCandidate candidate : candidates) {
                            if (candidate.getSourceView().equals(edge.getSourceNode()) && candidate.getTargetView().equals(createdDiagramElement) && DnDTasksOperations.addCandidate(edge, selectedCandidates, candidate)) break;
                        }
                    }
                }
                if (!cdeQuery.isFromAnyMapping((Collection<? extends DiagramElementMapping>)targetMappings)) continue;
                EdgeTarget edgeSource = edge.getSourceNode();
                DMappingBasedQuery edgeSourceQuery = new DMappingBasedQuery((DMappingBased)edgeSource);
                if (!(edgeSource instanceof DMappingBased) || !edgeSourceQuery.isFromAnyMapping((Collection<? extends DiagramElementMapping>)sourceMappings)) continue;
                candidates = diagramSync.computeEdgeCandidates(candidateEdgeMapping, mappingsToEdgeTargets);
                for (DEdgeCandidate candidate : candidates) {
                    if (candidate.getSourceView().equals(createdDiagramElement) && candidate.getTargetView().equals(edge.getTargetNode()) && DnDTasksOperations.addCandidate(edge, selectedCandidates, candidate)) continue block2;
                }
            }
            if (!selectedCandidates.isEmpty()) {
                diagramSync.computeDecorations(mappingsToEdgeTargets, edgeToSemanticBasedDecoration, edgeToMappingBasedDecoration);
            }
            for (DEdgeCandidate candidate : selectedCandidates) {
                sync.createNewEdge(mappingManager, candidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
            }
        }
    }

    private static void moveSubNodes(DNodeContainer oldDiagramElementContainer, EObject containerDroppedElement, ContainerDropDescription tool, DNodeContainer newDiagramElementContainer) {
        EList<DDiagramElement> ownedDiagramElementsToDrop = oldDiagramElementContainer.getOwnedDiagramElements();
        for (DDiagramElement diagramElementToDrop : ownedDiagramElementsToDrop) {
            DragAndDropTargetDescription dragDragAndDropDescription = newDiagramElementContainer.getDragAndDropDescription();
            ContainerDropDescription dropTool = DDiagramElementContainerSpecOperations.getBestDropDescription(dragDragAndDropDescription, diagramElementToDrop.getTarget(), containerDroppedElement, containerDroppedElement, newDiagramElementContainer, DragSource.DIAGRAM_LITERAL, (EObject)diagramElementToDrop);
            if (dropTool == null || !DnDTasksOperations.checkDragAndDropPrecondition(tool, diagramElementToDrop.getTarget(), containerDroppedElement, containerDroppedElement, newDiagramElementContainer)) continue;
            DiagramElementMapping mapping = dropTool.getBestMapping(newDiagramElementContainer, diagramElementToDrop.getTarget());
            try {
                if (mapping instanceof NodeMapping) {
                    DnDTasksOperations.createDropinForNodeTask(newDiagramElementContainer, (NodeMapping)mapping, diagramElementToDrop, diagramElementToDrop.getTarget(), diagramElementToDrop.getTarget().eContainer(), tool.isMoveEdges()).execute();
                    continue;
                }
                if (mapping instanceof EdgeMapping || !(mapping instanceof ContainerMapping)) continue;
                DnDTasksOperations.createDropinForContainerTask(newDiagramElementContainer, (ContainerMapping)mapping, diagramElementToDrop, diagramElementToDrop.getTarget(), diagramElementToDrop.getTarget().eContainer(), tool).execute();
            }
            catch (MetaClassNotFoundException e) {
                SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
            }
            catch (FeatureNotFoundException e) {
                SiriusPlugin.getDefault().error("Error while modifying model", (Throwable)e);
            }
        }
    }

    private static boolean addCandidate(DEdge edge, Collection<DEdgeCandidate> candidates, DEdgeCandidate candidate) {
        boolean added = false;
        Option<EdgeMapping> edgeMapping = new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping();
        if (edgeMapping.some()) {
            if (((EdgeMapping)edgeMapping.get()).isUseDomainElement()) {
                if (edge.getTarget() == candidate.getSemantic()) {
                    added = candidates.add(candidate);
                }
            } else {
                added = candidates.add(candidate);
            }
        }
        return added;
    }

    private static List<EdgeMapping> getCandidatesMappingsForCreatedDiagramElement(DDiagram diagram, DDiagramElement createdDiagramElement) {
        ArrayList<EdgeMapping> candidatesMapping = new ArrayList<EdgeMapping>();
        DiagramDescription diagramDescription = diagram.getDescription();
        Session session = SessionManager.INSTANCE.getSession(createdDiagramElement.getTarget());
        EList<EdgeMapping> allEdgesMapping = new DiagramComponentizationManager().getAllEdgeMappings(session.getSelectedViewpoints(false), diagramDescription);
        Iterator iterator = allEdgesMapping.iterator();
        while (iterator.hasNext()) {
            DMappingBasedQuery dMappingBasedQuery = new DMappingBasedQuery((DMappingBased)createdDiagramElement);
            EdgeMapping mapping = (EdgeMapping)iterator.next();
            if (!dMappingBasedQuery.isFromAnyMapping((Collection<? extends DiagramElementMapping>)mapping.getSourceMapping()) && !dMappingBasedQuery.isFromAnyMapping((Collection<? extends DiagramElementMapping>)mapping.getTargetMapping())) continue;
            candidatesMapping.add(mapping);
        }
        return candidatesMapping;
    }

    public static AbstractCommandTask createRemoveAfterDropInTask(final EObject viewContainer, final EObject element) {
        return new AbstractCommandTask(){

            public void execute() {
                if (viewContainer instanceof DDiagram) {
                    ((DDiagram)viewContainer).getOwnedDiagramElements().remove((Object)element);
                } else if (viewContainer instanceof DNodeList) {
                    ((DNodeList)viewContainer).getOwnedElements().remove((Object)element);
                } else if (viewContainer instanceof DNodeContainer) {
                    DNodeContainer viewNodeContainer = (DNodeContainer)viewContainer;
                    if (viewNodeContainer.getOwnedBorderedNodes().contains((Object)element)) {
                        viewNodeContainer.getOwnedBorderedNodes().remove((Object)element);
                    }
                    if (viewNodeContainer.getOwnedDiagramElements().contains((Object)element)) {
                        viewNodeContainer.getOwnedDiagramElements().remove((Object)element);
                    }
                } else if (viewContainer instanceof DNode) {
                    ((DNode)viewContainer).getOwnedBorderedNodes().remove((Object)element);
                }
            }

            public String getLabel() {
                return null;
            }
        };
    }

    public static boolean checkDragAndDropPrecondition(ContainerDropDescription description, EObject droppedElement, EObject oldContainer, EObject newContainer, EObject newViewContainer) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(droppedElement);
        if (oldContainer != null) {
            interpreter.setVariable("oldContainer", (Object)oldContainer);
        }
        interpreter.setVariable("newContainer", (Object)newContainer);
        interpreter.setVariable("newViewContainer", (Object)newViewContainer);
        interpreter.setVariable("element", (Object)droppedElement);
        String precondition = description.getPrecondition();
        boolean check = false;
        check = precondition != null && !StringUtil.isEmpty((String)precondition) ? RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(droppedElement, (EObject)description, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition()) : true;
        interpreter.unSetVariable("newContainer");
        interpreter.unSetVariable("newViewContainer");
        interpreter.unSetVariable("element");
        if (oldContainer != null) {
            interpreter.unSetVariable("oldContainer");
        }
        return check;
    }
}

