/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.description;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CenteringStyle implements Enumerator
{
    NONE(0, "None", "None"),
    BOTH(1, "Both", "Both"),
    SOURCE(2, "Source", "Source"),
    TARGET(3, "Target", "Target");

    public static final int NONE_VALUE = 0;
    public static final int BOTH_VALUE = 1;
    public static final int SOURCE_VALUE = 2;
    public static final int TARGET_VALUE = 3;
    private static final CenteringStyle[] VALUES_ARRAY;
    public static final List<CenteringStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CenteringStyle[]{NONE, BOTH, SOURCE, TARGET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CenteringStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CenteringStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CenteringStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CenteringStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CenteringStyle get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return BOTH;
            }
            case 2: {
                return SOURCE;
            }
            case 3: {
                return TARGET;
            }
        }
        return null;
    }

    private CenteringStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

