/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.util.Set;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;

public class RevealDDiagramElements
extends RecordingCommand {
    public static final String REVEAL_ELEMENTS_LABEL = "Reveal elements";
    public static final String REVEAL_ELEMENT_LABEL = "Reveal element";
    private final Set<DDiagramElement> diagramElements;

    public RevealDDiagramElements(TransactionalEditingDomain domain, Set<DDiagramElement> diagramElements) {
        super(domain, RevealDDiagramElements.getLabel(diagramElements));
        this.diagramElements = diagramElements;
    }

    protected void doExecute() {
        for (DDiagramElement diagramElement : this.diagramElements) {
            HideFilterHelper.INSTANCE.reveal(diagramElement);
        }
    }

    public static String getLabel(Set<DDiagramElement> diagramElements) {
        String result = diagramElements != null && diagramElements.size() > 1 ? REVEAL_ELEMENTS_LABEL : REVEAL_ELEMENT_LABEL;
        return result;
    }
}

