/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import java.util.HashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.PasteDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class PasteCommandBuilder
extends AbstractDiagramCommandBuilder {
    private PasteDescription tool;
    private DSemanticDecorator pasteTarget;
    private DSemanticDecorator droppedDiagramElement;
    private EObject droppedElement;

    public PasteCommandBuilder(PasteDescription tool, DSemanticDecorator container, DSemanticDecorator diagramElement) {
        this.tool = tool;
        this.pasteTarget = container;
        this.droppedDiagramElement = diagramElement;
        this.droppedElement = diagramElement.getTarget();
    }

    public PasteCommandBuilder(PasteDescription tool, DSemanticDecorator container, EObject droppedElement) {
        this.tool = tool;
        this.pasteTarget = container;
        this.droppedElement = droppedElement;
    }

    public Command buildCommand() {
        if (this.permissionAuthority.canEditInstance((EObject)this.pasteTarget) && this.permissionAuthority.canEditInstance(this.droppedElement) && this.checkPastePrecondition()) {
            DCommand cmd = this.buildPasteCommandFromTool();
            DDiagram diagram = (DDiagram)this.getDDiagram().get();
            this.addRefreshTask(diagram, cmd, (AbstractToolDescription)this.tool);
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private boolean checkPastePrecondition() {
        return PasteCommandBuilder.checkPastePrecondition(this.tool, this.droppedElement, this.pasteTarget.getTarget(), (EObject)this.droppedDiagramElement, (EObject)this.pasteTarget);
    }

    public static boolean checkPastePrecondition(PasteDescription description, EObject semanticDroppedElement, EObject semanticPasteTarget, EObject pasteTargetView, EObject viewDroppedElement) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticPasteTarget);
        interpreter.setVariable("container", (Object)semanticPasteTarget);
        interpreter.setVariable("containerView", (Object)pasteTargetView);
        interpreter.setVariable("copiedElement", (Object)semanticDroppedElement);
        interpreter.setVariable("copiedView", (Object)viewDroppedElement);
        boolean check = true;
        String precondition = description.getPrecondition();
        if (precondition != null && !StringUtil.isEmpty((String)precondition)) {
            check = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(semanticPasteTarget, (EObject)description, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
        }
        interpreter.unSetVariable("container");
        interpreter.unSetVariable("containerView");
        interpreter.unSetVariable("copiedElement");
        interpreter.unSetVariable("copiedView");
        return check;
    }

    private DCommand buildPasteCommandFromTool() {
        DCommand result = this.createEnclosingCommand();
        EObject semanticPasteTarget = this.pasteTarget.getTarget();
        if (this.permissionAuthority.canEditInstance(semanticPasteTarget) && this.permissionAuthority.canEditInstance(this.droppedElement)) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)semanticPasteTarget);
            HashMap<Object, Object> variables = new HashMap<Object, Object>();
            variables.put(this.tool.getContainer(), semanticPasteTarget);
            variables.put(this.tool.getContainerView(), this.pasteTarget);
            variables.put(this.tool.getCopiedElement(), this.droppedElement);
            variables.put(this.tool.getCopiedView(), this.droppedDiagramElement);
            result.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback));
            Option representation = new EObjectQuery((EObject)this.pasteTarget).getRepresentation();
            if (this.tool.getInitialOperation() != null && this.tool.getInitialOperation().getFirstModelOperations() != null) {
                result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)representation.get(), semanticPasteTarget, this.tool.getInitialOperation().getFirstModelOperations()));
            }
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    protected String getEnclosingCommandLabel() {
        return this.tool != null ? new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel() : "Paste";
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        DDiagram diagram = null;
        diagram = this.pasteTarget instanceof DDiagram ? (DDiagram)this.pasteTarget : ((DDiagramElement)this.pasteTarget).getParentDiagram();
        return Options.newSome((Object)diagram);
    }
}

