/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.parser;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.mofscript.parser.MofScriptParseError;

public class MofScriptErrorManager {
    private Vector errors = new Vector();
    private String targetResource = null;

    public void setTargetResource(String tResource) {
        this.targetResource = tResource;
    }

    public void add(MofScriptParseError error) {
        if (this.targetResource != null) {
            error.targetResource = this.targetResource;
        }
        this.addUnique(error);
    }

    private void addUnique(MofScriptParseError error) {
        for (MofScriptParseError perr : this.errors) {
            if (perr.line != error.line || perr.column != error.column) continue;
            return;
        }
        this.errors.add(error);
    }

    public int errorCount() {
        int errorCount = 0;
        MofScriptParseError err2 = null;
        for (MofScriptParseError err2 : this.errors) {
            if (err2.severity != MofScriptParseError.MOFSCRIPT_ERROR) continue;
            ++errorCount;
        }
        return errorCount;
    }

    public Iterator getErrors() {
        return this.errors.iterator();
    }

    public void clear() {
        this.errors.clear();
    }
}

