/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.parser;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mofscript.MOFScriptModel.Advice;
import org.eclipse.mofscript.MOFScriptModel.ArithmeticExpression;
import org.eclipse.mofscript.MOFScriptModel.ComparisonExpression;
import org.eclipse.mofscript.MOFScriptModel.CreateExpression;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.FileStatement;
import org.eclipse.mofscript.MOFScriptModel.FunctionCall;
import org.eclipse.mofscript.MOFScriptModel.FunctionCallStatement;
import org.eclipse.mofscript.MOFScriptModel.GeneralAssignment;
import org.eclipse.mofscript.MOFScriptModel.IfStatement;
import org.eclipse.mofscript.MOFScriptModel.IteratorStatement;
import org.eclipse.mofscript.MOFScriptModel.Literal;
import org.eclipse.mofscript.MOFScriptModel.LogicalExpression;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptAspect;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptObject;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptParameter;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptSpecification;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatementOwner;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;
import org.eclipse.mofscript.MOFScriptModel.PointCut;
import org.eclipse.mofscript.MOFScriptModel.PrintStatement;
import org.eclipse.mofscript.MOFScriptModel.Reference;
import org.eclipse.mofscript.MOFScriptModel.ResultAssignment;
import org.eclipse.mofscript.MOFScriptModel.SelectExpression;
import org.eclipse.mofscript.MOFScriptModel.SimpleExpression;
import org.eclipse.mofscript.MOFScriptModel.StatementBlock;
import org.eclipse.mofscript.MOFScriptModel.TransformationRule;
import org.eclipse.mofscript.MOFScriptModel.ValueExpression;
import org.eclipse.mofscript.MOFScriptModel.VariableDeclaration;
import org.eclipse.mofscript.MOFScriptModel.WhileStatement;
import org.eclipse.mofscript.parser.MofScriptErrorManager;
import org.eclipse.mofscript.parser.MofScriptModelException;
import org.eclipse.mofscript.parser.MofScriptParseError;
import org.eclipse.mofscript.parser.ParserUtil;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.TransformationProxy;

public class MofScriptModelChecker {
    public static int SOURCE_METAMODEL = 1;
    public static int TARGET_METAMODEL = 2;
    protected TransformationProxy _transformationProxy = null;
    protected MOFScriptSpecification _transformationSpec = null;
    protected MOFScriptTransformation _transformation = null;
    protected ExecutionManager _execMgr = null;
    protected MofScriptErrorManager _errorMgr = null;
    protected Stack<Object> _variableStack = new Stack<Object>(){

        @Override
        public Object push(Object o) {
            return super.push(o);
        }
    };
    protected Hashtable<String, MOFScriptParameter> _inputParameters = new Hashtable();
    protected Hashtable<String, Expression> _fileDeclarations = null;
    protected Hashtable<String, MOFScriptTransformation> _importedTransformations = null;
    protected String _currentRuleType = null;
    protected TransformationRule _currentRule = null;
    protected boolean _metamodelsOk = true;
    protected Hashtable<String, MOFScriptObject> _postCheckReferences = null;
    protected static boolean NON_EXISTING_FUNCTION = false;

    public MofScriptModelChecker() {
        this._errorMgr = new MofScriptErrorManager();
        this._fileDeclarations = new Hashtable();
        this._importedTransformations = new Hashtable();
        this._postCheckReferences = new Hashtable();
        this._execMgr = ExecutionManager.getExecutionManager();
    }

    public TransformationProxy getTransformationProxy() {
        return this._transformationProxy;
    }

    public void setTransformationSpecification(MOFScriptSpecification trModel) {
        this._transformationSpec = trModel;
        if (trModel != null && this._transformationSpec.getTransformation().size() > 0) {
            this._transformation = (MOFScriptTransformation)this._transformationSpec.getTransformation().get(0);
        }
    }

    public MOFScriptSpecification getTransformationSpecification() {
        return this._transformationSpec;
    }

    public void setTransformationModel(MOFScriptTransformation transformation) {
        this._transformation = transformation;
    }

    public MOFScriptTransformation getTransformationModel() {
        if (this._transformationProxy != null) {
            return this._transformationProxy.getTransformation();
        }
        return this._transformation;
    }

    public void clear() {
        this._errorMgr.clear();
        this._fileDeclarations.clear();
        this._postCheckReferences.clear();
        this._importedTransformations.clear();
        this._inputParameters.clear();
        this._transformationProxy = null;
        this._transformation = null;
        this._transformationSpec = null;
    }

    public boolean getMetaModelsOK() {
        return this._metamodelsOk;
    }

    public void checkMetaModels() {
        boolean sourceMM = true;
        boolean targetMM = true;
        EList parameters = this._transformation.getParameters();
        for (MOFScriptParameter param : parameters) {
            this._inputParameters.put(param.getName(), param);
        }
        this._metamodelsOk = sourceMM && targetMM;
    }

    public boolean addSourceMetaModel(MOFScriptParameter param) {
        String name = param.getName();
        String type = param.getType();
        EPackage mmpackage = null;
        mmpackage = this._execMgr.lookupAndAddSourceMetaModel(name, type);
        if (mmpackage == null) {
            this._execMgr.messageEvent("Could not load metamodel: " + name + "\n");
            return false;
        }
        return true;
    }

    public boolean addTargetMetaModel(MOFScriptParameter param) {
        String name = param.getName();
        String type = param.getType();
        EPackage mmpackage = null;
        mmpackage = this._execMgr.lookupAndAddTargetMetaModel(name, type, param.getTypePrefix());
        if (mmpackage == null) {
            this._execMgr.messageEvent("Could not load metamodel: " + name + "\n");
            return false;
        }
        return true;
    }

    public void checkVariableDeclaration(VariableDeclaration varDecl) {
        this.checkType(varDecl.getType(), (MOFScriptObject)varDecl);
    }

    public void checkTransformationRule(TransformationRule rule, boolean postCheck) {
        MofScriptParseError error = null;
        this._currentRule = rule;
        this._variableStack.clear();
        Hashtable<String, String> currentScopeVariables = new Hashtable<String, String>();
        MOFScriptParameter ruleContext = rule.getContext();
        if (ruleContext != null && ruleContext.getName() != null && ruleContext.getType() != null) {
            currentScopeVariables.put(ruleContext.getName(), ruleContext.getType());
            if (!postCheck && (error = this.checkRuleContext(ruleContext)) != null) {
                this._errorMgr.add(error);
            }
        }
        EList ruleVars = rule.getVariables();
        for (VariableDeclaration var : ruleVars) {
            currentScopeVariables.put(var.getName(), (String)var);
        }
        this._variableStack.push(currentScopeVariables);
        if (!postCheck) {
            String return_type = rule.getReturn();
            if (return_type != null) {
                String[] split_type = return_type.split("\\.");
                if (split_type.length > 0) {
                    error = this.validateTypePrefix(split_type[0], SOURCE_METAMODEL, (MOFScriptObject)rule);
                    this._currentRuleType = split_type[0];
                }
                if (split_type.length > 1) {
                    error = this.validateType(split_type[0], split_type[1], SOURCE_METAMODEL, (MOFScriptObject)rule);
                    this._currentRuleType = split_type[1];
                    rule.setReturn(split_type[1]);
                }
            }
            EList parameters = rule.getParameters();
            for (MOFScriptParameter p : parameters) {
                this.checkParameter(p);
            }
            EList statements = rule.getStatements();
            for (MOFScriptStatement statement : statements) {
                this.checkStatement(statement, postCheck);
            }
        } else {
            EList statements = rule.getStatements();
            for (MOFScriptStatement statement : statements) {
                this.checkStatement(statement, postCheck);
            }
            EList variables = rule.getVariables();
            for (VariableDeclaration varDecl : variables) {
                Expression statement = varDecl.getValue();
            }
            EList blocks = rule.getBlocks();
            for (StatementBlock block : blocks) {
                String reference = null;
                if (block.isProtected() || (reference = block.getReference()) == null) continue;
                this.checkReferenceName(reference, (MOFScriptObject)rule);
            }
        }
        this._variableStack.pop();
        currentScopeVariables.clear();
        currentScopeVariables = null;
    }

    protected ENamedElement getMetaModelReference(String refName) {
        String mmtype;
        String[] typeSplit = refName.split("\\.");
        String mmref = typeSplit[0];
        EPackage mmodel = null;
        mmodel = mmref.equalsIgnoreCase("ecore") ? this._execMgr.getEcoreMetaModel() : this._execMgr.getMetaModel(mmref);
        if (mmodel == null) {
            mmodel = this._execMgr.getTargetMetaModel(mmref);
        }
        EClassifier namedElement = null;
        if (mmodel != null && (namedElement = mmodel.getEClassifier(mmtype = typeSplit[typeSplit.length - 1])) == null) {
            namedElement = mmodel.eClass().getEStructuralFeature(mmtype);
        }
        return namedElement;
    }

    protected MofScriptParseError checkRuleContext(MOFScriptParameter parameter) {
        MofScriptParseError error = null;
        parameter.getName();
        String type = parameter.getType();
        String[] typeSplit = type.split("\\.");
        String mmref = typeSplit[0];
        this._currentRule.getOwner().getParameters();
        EPackage mmodel = null;
        EClassifier clazzifier = null;
        String mmtype = null;
        mmtype = typeSplit[typeSplit.length - 1];
        if (mmref.equalsIgnoreCase("ecore")) {
            mmodel = this._execMgr.getEcoreMetaModel();
            clazzifier = mmodel.getEClassifier(mmtype);
            if (clazzifier != null) {
                return null;
            }
            error = new MofScriptParseError("Undefined type for ecore metamodel: " + mmtype, parameter.getLine(), parameter.getColumn());
            return error;
        }
        if (type.equalsIgnoreCase("module")) {
            return null;
        }
        mmodel = this._execMgr.getMetaModel(mmref);
        if (mmodel != null) {
            clazzifier = ExecutionManager.getExecutionManager().getClassifierForPackage(mmodel, mmtype);
            if (clazzifier != null) {
                return null;
            }
            error = new MofScriptParseError("Undefined type for metamodel ( " + mmref + " ): " + mmtype);
            return error;
        }
        error = new MofScriptParseError("Illegal/unknown context: " + mmref, parameter.getLine(), parameter.getColumn());
        return error;
    }

    public void checkParameter(MOFScriptParameter parameter) {
        String dname = parameter.getName();
        String dtype = parameter.getType();
        dtype = this.checkType(dtype, (MOFScriptObject)parameter);
        ((Hashtable)this._variableStack.peek()).put(dname, dtype);
    }

    protected String checkType(String dtype, MOFScriptObject checkObject) {
        String[] split_type = dtype.split("\\.");
        String checkType = dtype;
        if (split_type.length > 1) {
            checkType = split_type.length == 1 ? split_type[0] : split_type[1];
        }
        if (split_type.length > 1) {
            this.validateType(split_type[0], checkType, SOURCE_METAMODEL, checkObject);
        }
        return dtype;
    }

    public void checkStatement(MOFScriptStatement statement, boolean postCheck) {
        block29: {
            block27: {
                block35: {
                    block34: {
                        block33: {
                            boolean found;
                            block32: {
                                boolean foundContext;
                                block31: {
                                    block30: {
                                        block28: {
                                            if (postCheck) break block27;
                                            if (!(statement instanceof ResultAssignment)) break block28;
                                            ResultAssignment ra = (ResultAssignment)statement;
                                            ra.getResultPart();
                                            Expression exp = ra.getExpression();
                                            if (!(this._currentRuleType.equalsIgnoreCase("String") || this._currentRuleType.equalsIgnoreCase("Boolean") || this._currentRuleType.equalsIgnoreCase("Integer") || this._currentRuleType.equalsIgnoreCase("Real") || this._currentRuleType.equalsIgnoreCase("List") || this._currentRuleType.equalsIgnoreCase("Hashtable"))) {
                                                this._currentRuleType.equalsIgnoreCase("Object");
                                            }
                                            this.checkExpression(exp);
                                            break block29;
                                        }
                                        if (!(statement instanceof GeneralAssignment)) break block30;
                                        GeneralAssignment ga = (GeneralAssignment)statement;
                                        String name = ga.getName();
                                        Expression expression = ga.getExpression();
                                        this.checkReferenceName(name, (MOFScriptObject)ga);
                                        this.checkExpression(expression);
                                        break block29;
                                    }
                                    if (!(statement instanceof IteratorStatement)) break block31;
                                    IteratorStatement is = (IteratorStatement)statement;
                                    String type = is.getType();
                                    String varName = is.getVariable();
                                    SimpleExpression source = is.getSource();
                                    String[] typepair = null;
                                    MofScriptParseError error = null;
                                    if (type != null && (typepair = type.split("\\.")).length > 1) {
                                        error = this.validateType(typepair[0], typepair[1], SOURCE_METAMODEL, (MOFScriptObject)is);
                                    }
                                    Hashtable<String, String> currentScopeVariables = new Hashtable<String, String>();
                                    if (varName == null) {
                                        error = new MofScriptParseError("Missing parameter variable in forEach (collection->forEach (c)): ", statement.getLine(), statement.getColumn());
                                        this._errorMgr.add(error);
                                    } else if (type != null) {
                                        currentScopeVariables.put(varName, type);
                                    } else {
                                        currentScopeVariables.put(varName, "Any");
                                    }
                                    EList variables = is.getVariables();
                                    for (VariableDeclaration varDecl : variables) {
                                        currentScopeVariables.put(varDecl.getName(), (String)varDecl);
                                    }
                                    this._variableStack.push(currentScopeVariables);
                                    if (is.getFilterExpression() != null) {
                                        this.checkExpression(is.getFilterExpression());
                                    }
                                    if (is.getBetween() != null) {
                                        this.checkExpression((Expression)is.getBetween());
                                    }
                                    this.checkExpression((Expression)source);
                                    EList itstatements = is.getStatements();
                                    for (MOFScriptStatement itStat : itstatements) {
                                        this.checkStatement(itStat, postCheck);
                                    }
                                    this._variableStack.pop();
                                    currentScopeVariables.clear();
                                    currentScopeVariables = null;
                                    break block29;
                                }
                                if (!(statement instanceof PrintStatement)) break block32;
                                PrintStatement printSt = (PrintStatement)statement;
                                String context = printSt.getContext();
                                if (context != null && !context.equals("") && !(foundContext = this.checkFileContext(context, (MOFScriptObject)statement, statement.getOwner()))) {
                                    MofScriptParseError error = new MofScriptParseError("FileContext not declared: " + context, statement.getLine(), statement.getColumn());
                                    this._errorMgr.add(error);
                                }
                                ValueExpression body = printSt.getPrintBody();
                                this.checkExpression((Expression)body);
                                break block29;
                            }
                            if (!(statement instanceof FileStatement)) break block33;
                            FileStatement fSt = (FileStatement)statement;
                            String fRef = fSt.getFileReference();
                            ValueExpression fUri = fSt.getFileURI();
                            if (fRef != null && fUri != null) {
                                this._fileDeclarations.put(fRef, (Expression)fUri);
                            } else if (fRef != null && !(found = this.checkFileContext(fRef, (MOFScriptObject)statement, statement.getOwner()))) {
                                MofScriptParseError error = new MofScriptParseError("FileContext not declared for 'Use' " + fRef, fSt.getLine(), fSt.getColumn());
                                this._errorMgr.add(error);
                            }
                            this.checkExpression((Expression)fUri);
                            break block29;
                        }
                        if (!(statement instanceof FunctionCallStatement)) break block34;
                        FunctionCallStatement fSt = (FunctionCallStatement)statement;
                        FunctionCall fc = fSt.getFunction();
                        this.checkExpression((Expression)fc);
                        break block29;
                    }
                    if (!(statement instanceof IfStatement)) break block35;
                    IfStatement ifSt = (IfStatement)statement;
                    this.checkIfStatement(ifSt, postCheck);
                    EList elses = ifSt.getElseBranch();
                    for (IfStatement elsesIf : elses) {
                        this.checkIfStatement(elsesIf, postCheck);
                    }
                    break block29;
                }
                if (!(statement instanceof WhileStatement)) break block29;
                WhileStatement whileSt = (WhileStatement)statement;
                this.checkWhileStatement(whileSt, postCheck);
                break block29;
            }
            if (statement instanceof FunctionCallStatement) {
                FunctionCall fc = ((FunctionCallStatement)statement).getFunction();
                this.postCheckExpression((Expression)fc);
            } else if (statement instanceof IteratorStatement) {
                IteratorStatement itSt = (IteratorStatement)statement;
                if (itSt.getFilterExpression() != null) {
                    this.postCheckExpression(itSt.getFilterExpression());
                }
                Iterator it = itSt.getStatements().iterator();
                while (it.hasNext()) {
                    this.checkStatement((MOFScriptStatement)it.next(), postCheck);
                }
            } else if (statement instanceof PrintStatement) {
                PrintStatement pSt = (PrintStatement)statement;
                this.postCheckExpression((Expression)pSt.getPrintBody());
            } else if (statement instanceof IfStatement) {
                IfStatement ifSt = (IfStatement)statement;
                this.postCheckExpression(ifSt.getIfExpression());
                EList statements = ifSt.getStatements();
                for (MOFScriptStatement st : statements) {
                    this.checkStatement(st, postCheck);
                }
                EList elses = ifSt.getElseBranch();
                for (IfStatement elsesIf : elses) {
                    EList elsesIfSt = elsesIf.getStatements();
                    for (MOFScriptStatement st : elsesIfSt) {
                        this.checkStatement(st, postCheck);
                    }
                }
            }
        }
    }

    private void checkIfStatement(IfStatement ifSt, boolean postCheck) {
        Expression lExpr = ifSt.getIfExpression();
        if (lExpr != null) {
            this.checkExpression(lExpr);
        }
        Hashtable<String, String> currentScopeVars = new Hashtable<String, String>();
        EList variables = ifSt.getVariables();
        for (VariableDeclaration varDecl : variables) {
            currentScopeVars.put(varDecl.getName(), varDecl.getType());
        }
        this._variableStack.push(currentScopeVars);
        EList statements = ifSt.getStatements();
        for (MOFScriptStatement st : statements) {
            this.checkStatement(st, postCheck);
        }
        this._variableStack.pop();
        currentScopeVars.clear();
        currentScopeVars = null;
    }

    private void checkWhileStatement(WhileStatement whileSt, boolean postCheck) {
        Expression lExpr = whileSt.getCondition();
        if (lExpr != null) {
            this.checkExpression(lExpr);
        }
        Hashtable<String, String> currentScopeVars = new Hashtable<String, String>();
        EList variables = whileSt.getVariables();
        for (VariableDeclaration varDecl : variables) {
            currentScopeVars.put(varDecl.getName(), varDecl.getType());
        }
        this._variableStack.push(currentScopeVars);
        EList statements = whileSt.getStatements();
        for (MOFScriptStatement st : statements) {
            this.checkStatement(st, postCheck);
        }
        this._variableStack.pop();
        currentScopeVars.clear();
        currentScopeVars = null;
    }

    private boolean checkFileContext(String fileContext, MOFScriptObject checkObj, MOFScriptStatementOwner owner) {
        boolean found = false;
        EList statements = owner.getStatements();
        MOFScriptStatement statement2 = null;
        if (fileContext.equalsIgnoreCase("stdout")) {
            return true;
        }
        for (MOFScriptStatement statement2 : statements) {
            String fileRef;
            if (!(statement2 instanceof FileStatement) || (fileRef = ((FileStatement)statement2).getFileReference()) == null || !fileRef.equalsIgnoreCase(fileContext)) continue;
            found = true;
        }
        if (!found && owner instanceof MOFScriptStatement) {
            found = this.checkFileContext(fileContext, checkObj, ((MOFScriptStatement)owner).getOwner());
        }
        return found;
    }

    public String findGlobalParameter(String name) {
        EList params = this._transformation.getParameters();
        for (MOFScriptParameter p : params) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p.getType();
        }
        return null;
    }

    public VariableDeclaration findGlobalVariables(MOFScriptTransformation transformation, String name) {
        EList variables = transformation.getVariables();
        for (VariableDeclaration v : variables) {
            if (!v.getName().equalsIgnoreCase(name)) continue;
            return v;
        }
        if (transformation.getExtends() != null) {
            return this.findGlobalVariables(transformation.getExtends(), name);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object findVariable(String name) {
        void var3_10;
        void var3_8;
        void var3_4;
        Hashtable vars = null;
        Object var3_3 = null;
        for (Object e : this._variableStack) {
            vars = (Hashtable)e;
            Object v = vars.get(name);
            if (v != null) break;
        }
        if (var3_4 == null) {
            VariableDeclaration variableDeclaration = this.findGlobalVariables(this._transformation, name);
        }
        if (var3_8 == null) {
            MOFScriptParameter mOFScriptParameter = this._inputParameters.get(name);
        }
        return var3_10;
    }

    public void checkExpression(Expression exp) {
        if (exp instanceof Literal) {
            Literal cfr_ignored_0 = (Literal)exp;
        } else if (exp instanceof Reference) {
            this.checkReference((Reference)exp);
        } else if (exp instanceof FunctionCall) {
            FunctionCall f = (FunctionCall)exp;
            String fName = f.getName();
            EList parameters = f.getParameters();
            String[] splitName = fName.split("\\.");
            if (splitName.length > 1) {
                this.checkReferenceName(splitName[0], (MOFScriptObject)exp);
            }
            for (Expression param : parameters) {
                this.checkExpression(param);
            }
        } else if (exp instanceof ArithmeticExpression) {
            ArithmeticExpression e = (ArithmeticExpression)exp;
            this.checkExpression((Expression)e.getPart1());
            this.checkExpression((Expression)e.getPart2());
        } else if (exp instanceof ComparisonExpression) {
            ComparisonExpression cexp = (ComparisonExpression)exp;
            this.checkExpression((Expression)cexp.getPart1());
            this.checkExpression((Expression)cexp.getPart2());
        } else if (exp instanceof LogicalExpression) {
            LogicalExpression lexp = (LogicalExpression)exp;
            this.checkExpression(lexp.getPart1());
            this.checkExpression(lexp.getPart2());
        } else if (exp instanceof SelectExpression) {
            String[] typepair;
            SelectExpression sexp = (SelectExpression)exp;
            String type = sexp.getType();
            MofScriptParseError error = null;
            if (type != null && (typepair = type.split("\\.")).length > 1) {
                error = this.validateType(typepair[0], typepair[1], SOURCE_METAMODEL, (MOFScriptObject)exp);
            }
            Hashtable<String, String> currentScopeVariables = new Hashtable<String, String>();
            String varName = sexp.getVariable();
            if (varName == null) {
                error = new MofScriptParseError("Missing parameter variable in forEach (collection->forEach (c)): ", sexp.getLine(), sexp.getColumn());
                this._errorMgr.add(error);
            } else if (type != null) {
                currentScopeVariables.put(varName, type);
            } else {
                currentScopeVariables.put(varName, "Any");
            }
            this._variableStack.push(currentScopeVariables);
            if (sexp.getFilterExpression() != null) {
                this.checkExpression(sexp.getFilterExpression());
            }
            this._variableStack.pop();
        } else if (exp instanceof CreateExpression) {
            CreateExpression ce = (CreateExpression)exp;
            String type = ce.getType();
            this.checkType(type, (MOFScriptObject)ce);
        }
    }

    public void checkReference(Reference ref) {
        ref.getAdditionalExpressionPart();
        String refName = ref.getName();
        this.checkReferenceName(refName, (MOFScriptObject)ref);
    }

    public void checkReferenceName(String refName, MOFScriptObject checkObj) {
        ENamedElement namedElement;
        String[] split = refName.split("\\.");
        MofScriptParseError error = null;
        VariableDeclaration tmpVar = null;
        Object tmpObj = null;
        String refVar = null;
        tmpObj = this.findVariable(split[0]);
        if (tmpObj instanceof String) {
            refVar = (String)tmpObj;
        } else if (tmpObj instanceof VariableDeclaration) {
            tmpVar = (VariableDeclaration)tmpObj;
            refVar = tmpVar.getName();
        }
        if (refVar == null && (refVar = this.findGlobalParameter(refName)) != null) {
            refVar = refName;
        }
        if (refVar == null && (namedElement = this.getMetaModelReference(refName)) != null) {
            return;
        }
        if (refVar == null) {
            this._postCheckReferences.put(refName, checkObj);
        } else if (refVar != null && split.length > 1) {
            String varType = refVar;
            if (tmpVar != null && tmpVar instanceof VariableDeclaration) {
                varType = tmpVar.getType();
            }
            String[] typesplit = varType.split("\\.");
            EStructuralFeature feature = null;
            String type = null;
            String metaModelRef = "";
            String string = type = typesplit.length >= 2 ? typesplit[1] : typesplit[0];
            if (typesplit.length > 1) {
                metaModelRef = typesplit[0];
            }
            feature = typesplit[0].equalsIgnoreCase("ecore") ? this._execMgr.findFeatureForEcoreConcept(type, split[1]) : this._execMgr.findFeatureForSourceConcept(metaModelRef, type, split[1]);
            if (type.equalsIgnoreCase("Any") || type.equalsIgnoreCase("Object")) {
                return;
            }
            if (feature == null) {
                error = new MofScriptParseError("Can't find feature '" + split[1] + "' for type '" + type + "'.", checkObj.getLine(), checkObj.getColumn());
                this._errorMgr.add(error);
            }
        }
    }

    MofScriptParseError validateTypePrefix(String prefix, int metamodel, MOFScriptObject checkObj) {
        boolean validated = true;
        if (prefix.equalsIgnoreCase("void") || prefix.equalsIgnoreCase("string") || prefix.equalsIgnoreCase("integer") || prefix.equalsIgnoreCase("real") || prefix.equalsIgnoreCase("boolean") || prefix.equalsIgnoreCase("hashtable") || prefix.equalsIgnoreCase("list") || prefix.equalsIgnoreCase("object")) {
            validated = true;
        } else if (prefix.equalsIgnoreCase("ecore")) {
            validated = true;
        } else if (metamodel == SOURCE_METAMODEL) {
            validated = this.validatePrefix(prefix, this._execMgr.getMetaModel(prefix));
        }
        MofScriptParseError error = null;
        if (!validated) {
            error = new MofScriptParseError("Error in type prefix (metamodel prefix): " + prefix, checkObj.getLine(), checkObj.getColumn());
            this._errorMgr.add(error);
        }
        return error;
    }

    private boolean validatePrefix(String prefix, EPackage metamodel) {
        return metamodel != null;
    }

    MofScriptParseError validateType(String mm, String type, int metamodel, MOFScriptObject checkObj) {
        MofScriptParseError error = null;
        try {
            EPackage metamodelPackage;
            EClassifier element = null;
            String model = null;
            if (mm.equalsIgnoreCase("ecore")) {
                element = this._execMgr.getEcoreMetaModel().getEClassifier(type);
                model = mm;
            }
            if (element == null) {
                element = this._execMgr.findSourceMetaModelConcept(mm, type);
            }
            if (element == null) {
                element = this._execMgr.findTargetMetaModelConcept(mm, type);
            }
            if ((metamodelPackage = this._execMgr.getMetaModel(mm)) != null) {
                model = metamodelPackage.getName();
            }
            if (element == null) {
                error = new MofScriptParseError("Type not found: '" + type + "' in metamodel '" + model + "'", checkObj.getLine(), checkObj.getColumn());
                this._errorMgr.add(error);
            }
        }
        catch (Exception ex) {
            System.out.println("MTTModelChecker::validateType:" + ex);
        }
        return error;
    }

    public void postCheck() throws MofScriptModelException {
        MofScriptParseError error = null;
        if (this._transformation == null) {
            throw new MofScriptModelException("No transformation defined in ModelChecker.");
        }
        int entry_count = 0;
        this.setExtendsRelation(this._transformation, new Hashtable());
        for (MOFScriptTransformation importedTr : this._importedTransformations.values()) {
            this.setExtendsRelation(importedTr, new Hashtable());
        }
        this._transformationProxy = new TransformationProxy(this._transformation);
        this._execMgr.setTransformationProxy(this._transformationProxy);
        Enumeration<String> _enum = this._importedTransformations.keys();
        while (_enum.hasMoreElements()) {
            String key = _enum.nextElement();
            this._transformationProxy.addImportedTransformation("", key, this._importedTransformations.get(key));
        }
        this.postCheckUnresolvedReferences();
        EList rules = this._transformation.getTransformationrules();
        TransformationRule r2 = null;
        for (TransformationRule r2 : rules) {
            if (this._transformationProxy.hasOtherRuleWithName(r2)) {
                String context = "";
                if (r2.getContext() != null) {
                    context = String.valueOf(r2.getContext().getType()) + "::";
                }
                error = new MofScriptParseError("Rule Override: '" + context + r2.getName() + "'", r2.getLine(), r2.getColumn(), MofScriptParseError.MOFSCRIPT_INFO);
                this._errorMgr.add(error);
                continue;
            }
            Object[] trNameAndRule = this._transformationProxy.checkImportedRules(r2.getName());
            if (trNameAndRule == null || r2.getName().equalsIgnoreCase("main")) continue;
            if (this._transformationProxy.isSuperTransformation(((TransformationRule)trNameAndRule[1]).getOwner())) {
                MOFScriptTransformation closestSuperWithRule = this._transformationProxy.getClosestSuperWithRule((TransformationRule)trNameAndRule[1]);
                String closestSuperName = (String)trNameAndRule[0];
                if (closestSuperWithRule != null) {
                    closestSuperName = closestSuperWithRule.getName();
                }
                error = new MofScriptParseError(" Overrides rule from super transformation: " + ((TransformationRule)trNameAndRule[1]).getName() + " in '" + closestSuperName + "'", r2.getLine(), r2.getColumn(), MofScriptParseError.MOFSCRIPT_INFO);
                this._errorMgr.add(error);
                continue;
            }
            if (this._transformation.getName().equalsIgnoreCase((String)trNameAndRule[0])) continue;
            error = new MofScriptParseError(" Duplicate rule defined: " + ((TransformationRule)trNameAndRule[1]).getName() + " in imported transformation '" + trNameAndRule[0] + "'", r2.getLine(), r2.getColumn(), MofScriptParseError.MOFSCRIPT_WARNING);
            this._errorMgr.add(error);
        }
        for (TransformationRule r2 : rules) {
            this.checkTransformationRule(r2, true);
            if (!r2.isIsEntryPoint()) continue;
            ++entry_count;
        }
        if (entry_count == 0) {
            error = new MofScriptParseError("Warning: No Entry Point defined");
        } else if (entry_count > 1) {
            error = new MofScriptParseError("Warning: Multiple Entry Points", 0, 0, MofScriptParseError.MOFSCRIPT_WARNING);
        }
        if (this._transformation instanceof MOFScriptAspect) {
            MOFScriptAspectChecker aspectChecker = new MOFScriptAspectChecker((MOFScriptAspect)this._transformation);
            aspectChecker.check();
        }
    }

    protected void postCheckUnresolvedReferences() {
        Enumeration<String> _leEnum = this._postCheckReferences.keys();
        while (_leEnum.hasMoreElements()) {
            String ref = _leEnum.nextElement();
            MOFScriptObject checkObj = this._postCheckReferences.get(ref);
            VariableDeclaration varDecl = this.findGlobalVariables(this._transformation, ref);
            if (varDecl == null) {
                Collection<MOFScriptTransformation> importedTrs = this._importedTransformations.values();
                MOFScriptTransformation importedTr2 = null;
                for (MOFScriptTransformation importedTr2 : importedTrs) {
                    varDecl = this.findGlobalVariables(importedTr2, ref);
                    if (varDecl != null) break;
                }
            }
            if (varDecl != null) continue;
            MofScriptParseError error = new MofScriptParseError("Cannot find reference: " + ref, checkObj.getLine(), checkObj.getColumn());
            this._errorMgr.add(error);
        }
    }

    protected void postCheckExpression(Expression exp) {
        if (exp instanceof FunctionCall) {
            this.postCheckFunctionCall((FunctionCall)exp);
        } else if (exp instanceof ArithmeticExpression) {
            ArithmeticExpression aexp = (ArithmeticExpression)exp;
            this.postCheckExpression((Expression)aexp.getPart1());
            this.postCheckExpression((Expression)aexp.getPart2());
        } else if (exp instanceof LogicalExpression) {
            LogicalExpression lexp = (LogicalExpression)exp;
            this.postCheckExpression(lexp.getPart1());
            this.postCheckExpression(lexp.getPart2());
        }
        if (exp instanceof SimpleExpression) {
            SimpleExpression sexp = (SimpleExpression)exp;
            EList additionalExpressionParts = sexp.getAdditionalExpressionPart();
            VariableDeclaration tmpVar = this.getTempVar();
            SimpleExpression extraExp2 = null;
            for (SimpleExpression extraExp2 : additionalExpressionParts) {
                if (extraExp2 instanceof FunctionCall) {
                    FunctionCall functionCall = (FunctionCall)extraExp2;
                    String orgName = functionCall.getName();
                    functionCall.setName(String.valueOf(tmpVar.getName()) + "." + functionCall.getName());
                    this.postCheckExpression((Expression)functionCall);
                    functionCall.setName(orgName);
                    continue;
                }
                boolean cfr_ignored_0 = extraExp2 instanceof Reference;
            }
        }
    }

    protected void postCheckFunctionCall(FunctionCall fc) {
        Object varObj;
        String fName = fc.getName();
        EList parameters = fc.getParameters();
        String[] splitName = fName.split("\\.");
        String ruleCalled = "";
        ruleCalled = splitName[splitName.length - 1];
        MofScriptParseError error = null;
        Collection allRules = this._transformationProxy.getAllTransformationRules(ruleCalled);
        if (fc.isIsSuperCall()) {
            if (this._transformation.getExtends() == null) {
                error = new MofScriptParseError("Transformation cannot have calls to a super transformation. It does not have any.", fc.getLine(), fc.getColumn(), MofScriptParseError.MOFSCRIPT_ERROR);
                this._errorMgr.add(error);
            } else if (!this._transformationProxy.superHasRule(ruleCalled)) {
                error = new MofScriptParseError("Super transformation does not own an operation/rule named: " + ruleCalled, fc.getLine(), fc.getColumn(), MofScriptParseError.MOFSCRIPT_ERROR);
                this._errorMgr.add(error);
            }
        }
        if ((varObj = this.findVariable(splitName[0])) != null && varObj instanceof VariableDeclaration) {
            VariableDeclaration varDecl = (VariableDeclaration)varObj;
            error = this.checkVariableUsage(varDecl, ruleCalled, fc);
            if ((varDecl.getType().equalsIgnoreCase("Object") || NON_EXISTING_FUNCTION) && allRules.size() > 0) {
                return;
            }
            if (error != null) {
                this._errorMgr.add(error);
            }
            return;
        }
        if (allRules.size() == 0) {
            VariableDeclaration tmpVar = this.getTempVar();
            error = this.checkVariableUsage(tmpVar, ruleCalled, fc);
            if (error == null) {
                return;
            }
            this._errorMgr.add(error);
            return;
        }
        if (allRules.size() > 0) {
            boolean paramOk = false;
            for (TransformationRule rule : allRules) {
                if (rule.getParameters().size() != parameters.size()) continue;
                paramOk = true;
                break;
            }
            if (!paramOk) {
                error = new MofScriptParseError("Wrong number of parameters for rule '" + fc.getName() + "'" + ruleCalled, fc.getLine(), fc.getColumn(), MofScriptParseError.MOFSCRIPT_ERROR);
                this._errorMgr.add(error);
            }
            if (allRules.size() == 1) {
                fc.setTransformationRule((TransformationRule)allRules.iterator().next());
            }
        }
    }

    public boolean isSuperTransformation(MOFScriptTransformation transformation, MOFScriptTransformation possibleSuper) {
        MOFScriptTransformation theExtends = transformation.getExtends();
        if (theExtends == null) {
            return false;
        }
        if (possibleSuper == theExtends) {
            return true;
        }
        return this.isSuperTransformation(theExtends, possibleSuper);
    }

    protected void setExtendsRelation(MOFScriptTransformation transformation, Hashtable trHierarchy) {
        MofScriptParseError error = null;
        if (transformation == null || transformation.getName() == null) {
            return;
        }
        trHierarchy.put(transformation.getName(), transformation);
        String trExtension = transformation.getExtendsName();
        if (trExtension != null && !trExtension.equals("")) {
            MOFScriptTransformation extendedTr2 = null;
            if (trExtension.equalsIgnoreCase(transformation.getName())) {
                extendedTr2 = transformation;
            } else {
                for (MOFScriptTransformation extendedTr2 : this._importedTransformations.values()) {
                    if (extendedTr2.getName().equalsIgnoreCase(trExtension)) break;
                    extendedTr2 = null;
                }
            }
            if (extendedTr2 != null && extendedTr2 == transformation) {
                error = new MofScriptParseError("Cannot extend itself. " + trExtension, this._transformation.getLine(), this._transformation.getColumn(), MofScriptParseError.MOFSCRIPT_ERROR);
                this._errorMgr.add(error);
            } else if (extendedTr2 != null) {
                if (trHierarchy.get(extendedTr2.getName()) != null) {
                    error = new MofScriptParseError("Circular inheritance hierarchy. " + extendedTr2.getName() + " is already in the inheritance path.", this._transformation.getLine(), this._transformation.getColumn(), MofScriptParseError.MOFSCRIPT_ERROR);
                    this._errorMgr.add(error);
                } else {
                    transformation.setExtends(extendedTr2);
                    this.setExtendsRelation(extendedTr2, trHierarchy);
                }
            } else {
                error = new MofScriptParseError("Extends non-existing transformation: " + trExtension, this._transformation.getLine(), this._transformation.getColumn(), MofScriptParseError.MOFSCRIPT_ERROR);
                this._errorMgr.add(error);
            }
        }
    }

    public void addImportedTransformation(String importName, String importUri, MOFScriptTransformation importedTr) {
        this._importedTransformations.put(importUri, importedTr);
    }

    protected VariableDeclaration getTempVar() {
        String mofscript_tmpvar_Object = "mofscript_internal_tmp_Object";
        VariableDeclaration tmpVar = (VariableDeclaration)((Hashtable)this._variableStack.firstElement()).get(mofscript_tmpvar_Object);
        if (tmpVar == null) {
            tmpVar = ParserUtil.getMofScriptModelFactory().createVariableDeclaration();
            tmpVar.setName(mofscript_tmpvar_Object);
            tmpVar.setType("Object");
            ((Hashtable)this._variableStack.firstElement()).put(mofscript_tmpvar_Object, tmpVar);
        }
        return tmpVar;
    }

    protected MofScriptParseError checkVariableUsage(VariableDeclaration var, String functionCalled, FunctionCall fc) {
        NON_EXISTING_FUNCTION = false;
        MofScriptParseError error = null;
        String varType = var.getType();
        if (varType == null) {
            return new MofScriptParseError("Undefined rule/function : " + functionCalled);
        }
        String[] varTypeSplit = varType.split("\\.");
        EClass eclassType = null;
        if (varTypeSplit.length == 2) {
            eclassType = this._execMgr.findMetaModelConcept(varTypeSplit[0], varTypeSplit[1]);
        }
        if (eclassType != null) {
            varType = "Object";
        }
        if (varType.equalsIgnoreCase("Object") || varType.equalsIgnoreCase("List") || varType.equalsIgnoreCase("Hashtable") || varType.equalsIgnoreCase("Integer") || varType.equalsIgnoreCase("Real") || varType.equalsIgnoreCase("Boolean") || varType.equalsIgnoreCase("String")) {
            if (functionCalled.equalsIgnoreCase("oclIsTypeOf")) {
                return this.checkParameterUsage(functionCalled, fc, 1);
            }
            if (functionCalled.equalsIgnoreCase("oclIsKindOf")) {
                return this.checkParameterUsage(functionCalled, fc, 1);
            }
            if (functionCalled.equalsIgnoreCase("oclGetType")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_delete")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getFeature")) {
                return this.checkParameterUsage(functionCalled, fc, 1);
            }
            if (functionCalled.equalsIgnoreCase("_setFeature")) {
                return this.checkParameterUsage(functionCalled, fc, 2);
            }
            if (functionCalled.equalsIgnoreCase("_getContainer")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getClass")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getOperations")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getAttributes")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getReferences")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getTypeParameters")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getPackage")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getSuperTypes")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getFeatures")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getCrossReferences")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getUsages")) {
                return this.checkParameterUsage(functionCalled, fc, 0, 1);
            }
            if (functionCalled.equalsIgnoreCase("_getUsageFeatures")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_getContainingFeature")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("_isInstance")) {
                return this.checkParameterUsage(functionCalled, fc, 1);
            }
            if (functionCalled.equalsIgnoreCase("objectsOfType")) {
                return this.checkParameterUsage(functionCalled, fc, 1);
            }
            if (functionCalled.equalsIgnoreCase("store")) {
                return this.checkParameterUsage(functionCalled, fc, 1);
            }
            if (functionCalled.equalsIgnoreCase("clone")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
            if (functionCalled.equalsIgnoreCase("shallowCopy")) {
                return this.checkParameterUsage(functionCalled, fc, 0);
            }
        }
        if (varType.equalsIgnoreCase("Object")) {
            error = this.stringFunctionOk(functionCalled, fc);
            if (NON_EXISTING_FUNCTION) {
                NON_EXISTING_FUNCTION = false;
                error = this.listFunctionOk(functionCalled, fc);
            }
            if (NON_EXISTING_FUNCTION) {
                NON_EXISTING_FUNCTION = false;
                error = this.hashtableFunctionOk(functionCalled, fc);
            }
            if (NON_EXISTING_FUNCTION) {
                NON_EXISTING_FUNCTION = false;
                error = this.systemFunctionOk(functionCalled, fc);
            }
            return error;
        }
        if (varType.equalsIgnoreCase("String")) {
            error = this.stringFunctionOk(functionCalled, fc);
        } else if (varType.equalsIgnoreCase("Integer")) {
            error = this.integerFunctionOk(functionCalled, fc);
        } else if (varType.equalsIgnoreCase("Real")) {
            error = this.realFunctionOk(functionCalled, fc);
        } else if (varType.equalsIgnoreCase("Boolean")) {
            error = this.booleanFunctionOk(functionCalled, fc);
        } else if (varType.equalsIgnoreCase("Hashtable")) {
            error = this.hashtableFunctionOk(functionCalled, fc);
        } else if (varType.equalsIgnoreCase("List") || varType.equalsIgnoreCase("Object")) {
            error = this.listFunctionOk(functionCalled, fc);
        } else {
            error = new MofScriptParseError("Undefined rule/function: " + functionCalled);
            NON_EXISTING_FUNCTION = true;
        }
        return error;
    }

    protected MofScriptParseError systemFunctionOk(String functionCalled, FunctionCall fc) {
        MofScriptParseError error = null;
        if (functionCalled.equalsIgnoreCase("date")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("time")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("exec")) {
            error = this.checkParameterUsage(functionCalled, fc, 1, 3);
            return error;
        }
        if (functionCalled.equalsIgnoreCase("getenv")) {
            error = this.checkParameterUsage(functionCalled, fc, 1);
        } else if (functionCalled.equalsIgnoreCase("setenv")) {
            error = this.checkParameterUsage(functionCalled, fc, 2);
        } else if (!(functionCalled.equalsIgnoreCase("count") || functionCalled.equalsIgnoreCase("position") || functionCalled.equalsIgnoreCase("fileExists"))) {
            if (functionCalled.equalsIgnoreCase("java")) {
                error = this.checkParameterUsage(functionCalled, fc, 4, 4);
            } else {
                NON_EXISTING_FUNCTION = true;
                error = new MofScriptParseError("Undefined function call: " + functionCalled, fc.getLine(), fc.getColumn());
            }
        }
        return error;
    }

    protected MofScriptParseError stringFunctionOk(String functionCalled, FunctionCall fc) {
        MofScriptParseError error = null;
        if (functionCalled.equalsIgnoreCase("substring")) {
            return this.checkParameterUsage(functionCalled, fc, 2);
        }
        if (functionCalled.equalsIgnoreCase("subStringBefore")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("subStringAfter")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("toLower")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("toUpper")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("firstToLower")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("firstToUpper")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("size")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("indexOf")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("endsWith")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("startsWith")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("trim")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("normalizeSpace")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("replace")) {
            return this.checkParameterUsage(functionCalled, fc, 2);
        }
        if (functionCalled.equalsIgnoreCase("equals")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("equalsIgnoreCase")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("charAt")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("isUpperCase")) {
            return this.checkParameterUsage(functionCalled, fc, 0, 1);
        }
        if (functionCalled.equalsIgnoreCase("isLowerCase")) {
            return this.checkParameterUsage(functionCalled, fc, 0, 1);
        }
        if (functionCalled.equalsIgnoreCase("matches")) {
            return this.checkParameterUsage(functionCalled, fc, 0, 1);
        }
        if (functionCalled.equalsIgnoreCase("strcmp")) {
            return this.checkParameterUsage(functionCalled, fc, 0, 1);
        }
        if (functionCalled.equalsIgnoreCase("strtok")) {
            return this.checkParameterUsage(functionCalled, fc, 0, 1);
        }
        NON_EXISTING_FUNCTION = true;
        error = new MofScriptParseError("Calling undefined rule/function : " + functionCalled, fc.getLine(), fc.getColumn());
        return error;
    }

    protected MofScriptParseError listFunctionOk(String functionCalled, FunctionCall fc) {
        MofScriptParseError error = null;
        if (functionCalled.equalsIgnoreCase("add") || functionCalled.equalsIgnoreCase("addOrg")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("remove")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("size")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("forEach")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("first")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("last")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("clear")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("isEmpty")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("addAll")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("addAllFirst")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("addBefore")) {
            return this.checkParameterUsage(functionCalled, fc, 2);
        }
        if (functionCalled.equalsIgnoreCase("addAfter")) {
            return this.checkParameterUsage(functionCalled, fc, 2);
        }
        if (functionCalled.equalsIgnoreCase("contains")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("get")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        NON_EXISTING_FUNCTION = true;
        error = new MofScriptParseError("Calling undefined function for type 'List': " + functionCalled, fc.getLine(), fc.getColumn());
        return error;
    }

    protected MofScriptParseError hashtableFunctionOk(String functionCalled, FunctionCall fc) {
        MofScriptParseError error = null;
        if (functionCalled.equalsIgnoreCase("put")) {
            return this.checkParameterUsage(functionCalled, fc, 2);
        }
        if (functionCalled.equalsIgnoreCase("get")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("remove")) {
            return this.checkParameterUsage(functionCalled, fc, 1);
        }
        if (functionCalled.equalsIgnoreCase("keys")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("values")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("size")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("forEach")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("first")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("clear")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        if (functionCalled.equalsIgnoreCase("isEmpty")) {
            return this.checkParameterUsage(functionCalled, fc, 0);
        }
        NON_EXISTING_FUNCTION = true;
        error = new MofScriptParseError("Calling undefined function for type 'Hashtable': " + functionCalled, fc.getLine(), fc.getColumn());
        return error;
    }

    protected MofScriptParseError booleanFunctionOk(String functionCalled, FunctionCall fc) {
        MofScriptParseError error = null;
        return error;
    }

    protected MofScriptParseError realFunctionOk(String functionCalled, FunctionCall fc) {
        MofScriptParseError error = null;
        return error;
    }

    protected MofScriptParseError integerFunctionOk(String functionCalled, FunctionCall fc) {
        MofScriptParseError error = null;
        return error;
    }

    protected MofScriptParseError checkParameterUsage(String fName, FunctionCall fc, int requiredParamCount) {
        return this.checkParameterUsage(fName, fc, requiredParamCount, requiredParamCount);
    }

    protected MofScriptParseError checkParameterUsage(String fName, FunctionCall fc, int lowerCount, int upperCount) {
        EList params = fc.getParameters();
        MofScriptParseError error = null;
        if (params.size() < lowerCount || params.size() > upperCount) {
            error = new MofScriptParseError("Wrong number of arguments for function: " + fName + ". Expected " + lowerCount + " to " + upperCount + " params.");
        }
        return error;
    }

    public void printErrors() {
        ExecutionManager.getExecutionManager().getExecutionStack().notifyOutputMessage(String.valueOf(this._errorMgr.errorCount()) + " semantic errors detected.");
        Iterator it = this._errorMgr.getErrors();
        while (it.hasNext()) {
            MofScriptParseError error = (MofScriptParseError)it.next();
            ExecutionManager.getExecutionManager().getExecutionStack().notifyOutputMessage("   - Error: " + error.error);
        }
    }

    public MofScriptErrorManager getErrorManager() {
        return this._errorMgr;
    }

    public int getErrorCount() {
        return this._errorMgr.errorCount();
    }

    public Iterator getErrors() {
        return this._errorMgr.getErrors();
    }

    private class MOFScriptAspectChecker {
        MOFScriptAspect _aspect = null;

        public MOFScriptAspectChecker(MOFScriptAspect aspect) {
            this._aspect = aspect;
        }

        public void check() {
            this.checkPointCuts();
            this.checkAdvices();
        }

        protected void checkPointCuts() {
            EList pointcuts = this._aspect.getPointcut();
            PointCut pointcut2 = null;
            for (PointCut pointcut2 : pointcuts) {
                this.checkPointCut(pointcut2);
            }
        }

        protected void checkAdvices() {
            EList advices = this._aspect.getAdvice();
            Advice advice2 = null;
            for (Advice advice2 : advices) {
                this.checkAdvice(advice2);
            }
        }

        protected void checkAdvice(Advice advice) {
            PointCut advicePointCut = this.getNamedPointCut(advice.getPointCutRef());
            if (advicePointCut == null) {
                MofScriptParseError error = new MofScriptParseError("Advice '" + advice.getName() + "' references undefined pointcut '" + advice.getPointCutRef() + "'");
                MofScriptModelChecker.this._errorMgr.add(error);
            }
        }

        protected void checkPointCut(PointCut pointcut) {
        }

        protected PointCut getNamedPointCut(String pcName) {
            Iterator pcit = this._aspect.getPointcut().iterator();
            PointCut pc = null;
            while (pcit.hasNext()) {
                pc = (PointCut)pcit.next();
                if (!pc.getName().equals(pcName)) continue;
                return pc;
            }
            return null;
        }
    }
}

