/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.parser;

import java.util.List;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedRangeException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MismatchedTreeNodeException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.eclipse.mofscript.parser.MofScript2Lexer;
import org.eclipse.mofscript.parser.MofScript2Parser;

public class MofScriptParseError {
    public static int MOFSCRIPT_WARNING = 1;
    public static int MOFSCRIPT_ERROR = 2;
    public static int MOFSCRIPT_INFO = 3;
    public String error;
    public int line;
    public int column;
    public String targetResource;
    public int severity;
    public static MofScriptParseError DEFAULT_ERROR = new MofScriptParseError();

    public MofScriptParseError(String err, int lin, int col) {
        this.error = err;
        this.line = lin;
        this.column = col;
        this.severity = MOFSCRIPT_ERROR;
    }

    public MofScriptParseError(RecognitionException e, MofScript2Parser baserec) {
        List invList = BaseRecognizer.getRuleInvocationStack((Throwable)e, (String)((Object)((Object)baserec)).getClass().getName());
        this.error = "Error in " + (String)invList.get(invList.size() - 1) + " - Token: " + e.token;
        this.line = e.line;
        this.column = e.charPositionInLine;
        this.severity = MOFSCRIPT_ERROR;
        String[] tokenNames = baserec.getTokenNames();
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e;
            String tokenName = "<unknown>";
            tokenName = mte.expecting == -1 ? "EOF" : tokenNames[mte.expecting];
            this.error = "mismatched token: " + e.token.getText() + "; expecting type " + tokenName;
        } else if (e instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mtne = (MismatchedTreeNodeException)e;
            String tokenName = "<unknown>";
            tokenName = mtne.expecting == -1 ? "EOF" : tokenNames[mtne.expecting];
            this.error = "Mismatched tree node: " + mtne.node + "; expecting type " + tokenName;
        } else if (e instanceof NoViableAltException) {
            NoViableAltException cfr_ignored_0 = (NoViableAltException)e;
            this.error = "No viable alternative: input: " + e.token.getText();
        } else if (e instanceof EarlyExitException) {
            EarlyExitException eee = (EarlyExitException)e;
            this.error = "Required (...)+ loop (decision=" + eee.decisionNumber + ") did not match anything; token=" + e.token.getText();
        } else if (e instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            this.error = "Mismatched token: " + e.token.getText() + "; expecting set " + mse.expecting;
        } else if (e instanceof MismatchedNotSetException) {
            MismatchedNotSetException mse = (MismatchedNotSetException)e;
            this.error = "mismatched token: " + e.token.getText() + "; expecting set " + mse.expecting;
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            this.error = "Rule " + fpe.ruleName + " failed predicate: {" + fpe.predicateText + "}?";
        }
    }

    public MofScriptParseError(RecognitionException e, MofScript2Lexer baserec) {
        List invStack = MofScript2Lexer.getRuleInvocationStack((Throwable)e, (String)((Object)((Object)baserec)).getClass().getName());
        this.error = String.valueOf(invStack.toString()) + ": line " + e.line + ":" + e.charPositionInLine;
        this.line = e.line;
        this.column = e.charPositionInLine;
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e;
            this.error = "mismatched char: '" + (char)e.c + "; expecting char '" + (char)mte.expecting + "'";
        } else if (e instanceof NoViableAltException) {
            NoViableAltException cfr_ignored_0 = (NoViableAltException)e;
            this.error = "No viable alternative: '" + (char)e.c + "'";
        } else if (e instanceof EarlyExitException) {
            EarlyExitException eee = (EarlyExitException)e;
            this.error = "required (...)+ loop (decision=" + eee.decisionNumber + ") did not match anything;  char=" + (char)e.c + "'";
        } else if (e instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            this.error = "mismatched char: '" + (char)e.c + "; expecting set " + mse.expecting;
        } else if (e instanceof MismatchedNotSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            this.error = "mismatched char: '" + (char)e.c + "; expecting set " + mse.expecting;
        } else if (e instanceof MismatchedRangeException) {
            MismatchedRangeException mre = (MismatchedRangeException)e;
            this.error = "mismatched char: '" + (char)e.c + "; expecting set '" + (char)mre.a + "'..'" + (char)mre.b + "'";
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            this.error = "rule " + fpe.ruleName + " failed predicate: {" + fpe.predicateText + "}?";
        }
    }

    public MofScriptParseError(String err, int lin, int col, int theSeverity) {
        this.error = err;
        this.line = lin;
        this.column = col;
        this.severity = theSeverity;
    }

    public MofScriptParseError(String err) {
        this.error = err;
    }

    public MofScriptParseError() {
        this.error = "MTTParseError";
    }

    public String toString() {
        return "MTTParseError: " + this.error + ", line: " + this.line + ", column: " + this.column;
    }
}

