/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptComment;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptImport;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptModelFactory;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptObject;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptSpecification;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;
import org.eclipse.mofscript.parser.MofScript2Lexer;
import org.eclipse.mofscript.parser.MofScript2Parser;
import org.eclipse.mofscript.parser.MofScriptModelChecker;
import org.eclipse.mofscript.parser.MofScriptParseError;
import org.eclipse.mofscript.parser.MofScriptParserFactory;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.TransformationProxy;

public class ParserUtil {
    private static MOFScriptModelFactory _mttModelFactory = null;
    private static MofScriptModelChecker _modelChecker = null;
    private static ExecutionManager _executionManager = null;
    private static String _metamodelRep = null;
    private static String _modelExtension = ".ecore";
    private static MofScript2Lexer _lexer = null;
    private static String _inputFileLocation = null;
    private static Hashtable _parsedTransformations = null;
    private static int _parserLineTracker = 0;
    private static String _compilePath = null;
    private static Vector _commentHolder = null;
    private boolean _parseSilent = false;

    public ParserUtil() {
        if (_executionManager == null) {
            _executionManager = ExecutionManager.getExecutionManager();
        }
        if (_commentHolder == null) {
            _commentHolder = new Vector();
        }
        _mttModelFactory = _executionManager.getModelFactory();
        if (_modelChecker == null) {
            _modelChecker = MofScriptParserFactory.createModelChecker(_executionManager);
        }
        if (_parsedTransformations == null) {
            _parsedTransformations = new Hashtable();
        }
    }

    public void setMetaModelRepositoryURI(String uri) {
        _metamodelRep = uri;
        _executionManager.setFileMetaModelRepository(uri);
    }

    public void setInputFileLocation(String location) {
        _inputFileLocation = location;
    }

    public String getInputFileLocation() {
        return _inputFileLocation;
    }

    public static MOFScriptModelFactory getMofScriptModelFactory() {
        return _mttModelFactory;
    }

    public void setCompilePath(String path) {
        _compilePath = path;
    }

    protected MOFScriptSpecification doParse(Reader in, boolean primary, boolean doPostCheck, String uri) {
        EList transformations;
        MOFScriptSpecification specification;
        block18: {
            ExecutionManager.getExecutionManager().getExecutionStack().notifyOutputMessage("    ## Parsing '" + uri + "'\n");
            specification = null;
            transformations = null;
            ParserUtil.resetParserLineTracker();
            if (primary) {
                _modelChecker.clear();
                _executionManager.clearSourceMetaModels();
                _executionManager.clearModelTypeMap();
                _parsedTransformations.clear();
            }
            ANTLRReaderStream cstream = null;
            try {
                cstream = new ANTLRReaderStream(in);
            }
            catch (IOException ioex) {
                _modelChecker.getErrorManager().add(new MofScriptParseError("IOException in parse operation: " + ioex.getMessage()));
                return null;
            }
            _lexer = new MofScript2Lexer((CharStream)cstream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)_lexer);
            MofScript2Parser parser = new MofScript2Parser((TokenStream)tokens);
            specification = parser.mofscriptSpecification();
            if (specification != null) break block18;
            return null;
        }
        try {
            transformations = specification.getTransformation();
            if (transformations.size() > 0) {
                MOFScriptTransformation cfr_ignored_0 = (MOFScriptTransformation)transformations.get(0);
            }
            _parsedTransformations.put(uri.toLowerCase(), specification);
            EList imports = specification.getImports();
            FileReader fReader = null;
            MOFScriptSpecification importTransformation = null;
            String currentImportFileLoc = _inputFileLocation;
            for (MOFScriptImport theImport : imports) {
                String importUri;
                String importName;
                block20: {
                    importName = theImport.getName();
                    importUri = theImport.getUri();
                    theImport.getImportSemantics();
                    theImport.getType();
                    try {
                        try {
                            importTransformation = (MOFScriptSpecification)_parsedTransformations.get(importUri.toLowerCase());
                            if (importTransformation == null) {
                                File f = this.lookForFile(importUri);
                                fReader = new FileReader(f);
                                _modelChecker.getErrorManager().setTargetResource(importUri);
                                _inputFileLocation = f.getParent();
                                importTransformation = this.doParse(fReader, false, doPostCheck, importUri);
                            }
                        }
                        catch (Exception exception) {
                            _modelChecker.getErrorManager().add(new MofScriptParseError("Cannot find import: " + importUri, theImport.getLine(), theImport.getColumn()));
                            _inputFileLocation = currentImportFileLoc;
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        _inputFileLocation = currentImportFileLoc;
                        throw throwable;
                    }
                    _inputFileLocation = currentImportFileLoc;
                }
                if (importTransformation != null && importTransformation == specification) {
                    MofScriptParseError error = new MofScriptParseError("Transformation imports itself. ", theImport.getLine(), theImport.getColumn());
                    error.severity = MofScriptParseError.MOFSCRIPT_WARNING;
                    _modelChecker.getErrorManager().add(error);
                    continue;
                }
                if (importTransformation == null) continue;
                EList importedTransformations = importTransformation.getTransformation();
                for (MOFScriptTransformation importedTr : importedTransformations) {
                    _modelChecker.addImportedTransformation(importName, importUri, importedTr);
                }
            }
            _modelChecker.getErrorManager().setTargetResource(null);
            if (_modelChecker.getMetaModelsOK() && primary) {
                _modelChecker.setTransformationSpecification(specification);
                if (doPostCheck) {
                    _modelChecker.postCheck();
                }
            }
        }
        catch (RecognitionException rex) {
            System.out.println((Object)rex);
            _modelChecker.getErrorManager().add(new MofScriptParseError(rex.getLocalizedMessage(), rex.line, rex.charPositionInLine));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return specification;
    }

    public TransformationProxy getParsedTransformation() {
        return _modelChecker.getTransformationProxy();
    }

    private File lookForFile(String importUri) {
        File f = new File(String.valueOf(_inputFileLocation) + importUri);
        if (!f.exists()) {
            String[] pathElements = null;
            if (_compilePath != null) {
                pathElements = _compilePath.split(";");
                int i = 0;
                while (i < pathElements.length) {
                    f = new File(String.valueOf(_inputFileLocation) + "/" + pathElements[i] + "/" + importUri);
                    if (f.exists()) {
                        return f;
                    }
                    ++i;
                }
                i = 0;
                while (i < pathElements.length) {
                    f = new File(String.valueOf(pathElements[i]) + "/" + importUri);
                    if (f.exists()) {
                        return f;
                    }
                    ++i;
                }
            }
        } else {
            return f;
        }
        return new File(String.valueOf(_inputFileLocation) + importUri);
    }

    public MOFScriptSpecification parse(String str, String uri) {
        new StringReader(str);
        MOFScriptSpecification transformation = this.parse(str, true, uri);
        return transformation;
    }

    protected MOFScriptSpecification parse(File f) {
        try {
            new FileReader(f);
            return this.parse(f, true);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return null;
        }
    }

    public MOFScriptSpecification parse(String str, boolean doPostCheck, String uri) {
        StringReader in = new StringReader(str);
        MOFScriptSpecification transformation = this.doParse(in, true, doPostCheck, uri);
        return transformation;
    }

    public MOFScriptSpecification parse(String str, boolean doPostCheck, String uri, boolean silent) {
        this._parseSilent = silent;
        StringReader in = new StringReader(str);
        MOFScriptSpecification transformation = this.doParse(in, true, doPostCheck, uri);
        this._parseSilent = false;
        return transformation;
    }

    public MOFScriptSpecification parse(File f, boolean doPostCheck) {
        try {
            FileReader reader = new FileReader(f);
            return this.doParse(reader, true, doPostCheck, f.getName());
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return null;
        }
    }

    public List readModelDecls(String str) {
        MofScript2Parser parser = this.initStringParser(str);
        try {
            MOFScriptTransformation tranformation = parser.mofscriptDeclarationExtra();
            if (tranformation != null) {
                return tranformation.getParameters();
            }
        }
        catch (Exception exception) {}
        return new ArrayList();
    }

    private MofScript2Parser initStringParser(String str) {
        _modelChecker.clear();
        StringReader in = new StringReader(str);
        try {
            ANTLRReaderStream cStream = new ANTLRReaderStream((Reader)in);
            MofScript2Lexer lexer = new MofScript2Lexer((CharStream)cStream);
            CommonTokenStream cts = new CommonTokenStream((TokenSource)lexer);
            return new MofScript2Parser((TokenStream)cts);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            return null;
        }
    }

    public static MofScriptModelChecker getModelChecker() {
        return _modelChecker;
    }

    public static ExecutionManager getExecutionManager() {
        return _executionManager;
    }

    public static File lookupFileMetaModel2(String model) {
        File lookup = null;
        lookup = new File(String.valueOf(_metamodelRep) + File.separator + model + _modelExtension);
        return lookup;
    }

    public static void setParseInfo(MOFScriptObject parseobj) {
        if (parseobj != null) {
            parseobj.setLine(ParserUtil.getLine());
            parseobj.setColumn(ParserUtil.getColumn());
            if (_commentHolder != null && _commentHolder.size() > 0) {
                parseobj.getComment().addAll((Collection)_commentHolder);
                _commentHolder.clear();
            }
        }
    }

    public static void setParseInfo(MOFScriptObject parseobj, ParserRuleReturnScope rrscope) {
        if (parseobj != null && rrscope != null) {
            Token start = rrscope.start;
            ParserUtil.setParseInfoFromToken(parseobj, start);
            if (_commentHolder != null && _commentHolder.size() > 0) {
                parseobj.getComment().addAll((Collection)_commentHolder);
                _commentHolder.clear();
            }
        }
    }

    public static void setParseInfo(MOFScriptObject parseobj, Token token) {
        if (parseobj != null && token != null) {
            ParserUtil.setParseInfoFromToken(parseobj, token);
        }
    }

    public static void setParseInfo(MOFScriptObject toSet, MOFScriptObject setFrom) {
        if (toSet != null && setFrom != null) {
            toSet.setLine(setFrom.getLine());
            toSet.setColumn(setFrom.getColumn());
        }
    }

    protected static void setParseInfoFromToken(MOFScriptObject parseobj, Object startToken) {
        if (startToken != null && startToken instanceof CommonToken) {
            parseobj.setLine(((CommonToken)startToken).getLine());
            parseobj.setColumn(((CommonToken)startToken).getCharPositionInLine());
        }
    }

    public static void addMOFScriptComment(MOFScriptComment comment) {
        if (_commentHolder != null && comment != null) {
            _commentHolder.add(comment);
        }
    }

    public static MofScript2Lexer getLexer() {
        return _lexer;
    }

    public static int getLine() {
        return _lexer.getLine();
    }

    public static int getColumn() {
        return _lexer.getCharPositionInLine();
    }

    public static void resetParserLineTracker() {
        _parserLineTracker = 1;
    }

    public static void incrementParserLineTracker() {
        ++_parserLineTracker;
    }

    public static void setParserLine(int line) {
    }

    public static int getParserLineTracker() {
        return _parserLineTracker;
    }

    public static String replaceEscapes(String input) {
        input = input.replace("\\n", "\n");
        input = input.replace("\\t", "\t");
        input = input.replace("\\f", "\f");
        input = input.replace("\\\"", "\"");
        input = input.replace("\\'", "'");
        input = input.replace("\\\\", "\\");
        return input;
    }
}

