/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.Arrays;
import java.util.List;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.search.IReferenceCollection;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.ReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.UseScanVisitor;

public class UseScanReferenceVisitor
extends UseScanVisitor {
    private IApiComponent fLookupAPIComponent;
    private List fLookupMemberTypes;
    private String fCurrentReferencedMemberRootType;
    private IComponentDescriptor fCurrentComponent;
    private IComponentDescriptor fReferencingComponent;
    private IReferenceCollection fReferences;
    private IMemberDescriptor fCurrentReferencedMember;

    public UseScanReferenceVisitor(IApiComponent component, String[] lookupTypes, IReferenceCollection references) {
        this.fLookupAPIComponent = component;
        this.fLookupMemberTypes = lookupTypes == null || lookupTypes.length == 0 ? null : Arrays.asList(lookupTypes);
        this.fReferences = references;
    }

    public boolean visitComponent(IComponentDescriptor target) {
        if (this.fLookupAPIComponent == null || this.fLookupAPIComponent.getSymbolicName().equals(target.getId())) {
            this.fCurrentComponent = target;
            return true;
        }
        return false;
    }

    public boolean visitMember(IMemberDescriptor referencedMember) {
        boolean found = false;
        String referencedMemberRootType = referencedMember instanceof IReferenceTypeDescriptor ? ((IReferenceTypeDescriptor)referencedMember).getQualifiedName() : referencedMember.getEnclosingType().getQualifiedName();
        if (referencedMemberRootType.indexOf(36) > -1) {
            referencedMemberRootType = referencedMemberRootType.substring(0, referencedMemberRootType.indexOf(36));
        }
        found = this.fLookupMemberTypes == null || this.fLookupMemberTypes.contains(referencedMemberRootType);
        this.fCurrentReferencedMemberRootType = referencedMemberRootType;
        this.fCurrentReferencedMember = referencedMember;
        return found;
    }

    public void visitReference(IReferenceDescriptor reference) {
        ReferenceDescriptor refDesc = new ReferenceDescriptor(this.fReferencingComponent, reference.getMember(), reference.getLineNumber(), this.fCurrentComponent, this.fCurrentReferencedMember, reference.getReferenceKind(), reference.getReferenceFlags(), reference.getVisibility(), null);
        this.fReferences.add(this.fCurrentReferencedMemberRootType, refDesc);
    }

    public boolean visitReferencingComponent(IComponentDescriptor component) {
        this.fReferencingComponent = component;
        return true;
    }
}

