/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.identifiedelement;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractTextPropertySection;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class IdentifiedElementLabelPropertySection
extends AbstractTextPropertySection {
    protected CLabel help;

    @Override
    public void refresh() {
        super.refresh();
        String tooltip = this.getToolTipText();
        if (tooltip != null && this.help != null) {
            this.help.setToolTipText(this.getToolTipText());
        }
    }

    @Override
    protected String getDefaultLabelText() {
        return "Label";
    }

    @Override
    protected String getLabelText() {
        String labelText = String.valueOf(super.getLabelText()) + ":";
        return labelText;
    }

    @Override
    public EAttribute getFeature() {
        return DescriptionPackage.eINSTANCE.getIdentifiedElement_Label();
    }

    @Override
    protected Object getFeatureValue(String newText) {
        return newText;
    }

    @Override
    protected boolean isEqual(String newText) {
        return this.getFeatureAsText().equals(newText);
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.text.setToolTipText(this.getToolTipText());
        this.help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.text, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        this.help.setLayoutData((Object)data);
        this.help.setFont(SiriusEditor.getFontRegistry().get("description"));
        this.help.setImage(this.getHelpIcon());
        this.help.setToolTipText(this.getToolTipText());
    }

    @Override
    protected String getPropertyDescription() {
        return "The label used to display this to the end-user.";
    }

    protected Composite getComposite() {
        return this.composite;
    }

    protected void setText(String newText) {
        this.text.setText(newText);
    }

    protected Text getText() {
        return this.text;
    }

    protected CLabel getLabel() {
        return this.nameLabel;
    }
}

