/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.MOFScriptModel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AssignmentOperator implements Enumerator
{
    EQ_LITERAL(0, "EQ", "EQ"),
    PLUS_EQ_LITERAL(1, "PLUS_EQ", "PLUS_EQ");

    public static final String copyright = "\r\n  Copyright (c) 2005, 2006, 2007, 2008 SINTEF\r\n  All rights reserved. This program and the accompanying materials\r\n  are made available under the terms of the Eclipse Public License v1.0\r\n  which accompanies this distribution, and is available at\r\n  http://www.eclipse.org/legal/epl-v10.html\r\n\r\n  Contributors:\r\n     Jon Oldevik, Tor Neple, G?ran Olsen, SINTEF (Norway)\r\n  \r\n     Developed as part of the MODELWARE (http://www.modelware-ist.org/) and \r\n    MODELPLEX (http://www.modelplex-ist.org/) IP projects \r\n\r\n";
    public static final int EQ = 0;
    public static final int PLUS_EQ = 1;
    private static final AssignmentOperator[] VALUES_ARRAY;
    public static final List<AssignmentOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AssignmentOperator[]{EQ_LITERAL, PLUS_EQ_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AssignmentOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssignmentOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssignmentOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssignmentOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssignmentOperator get(int value) {
        switch (value) {
            case 0: {
                return EQ_LITERAL;
            }
            case 1: {
                return PLUS_EQ_LITERAL;
            }
        }
        return null;
    }

    private AssignmentOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

