/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.MOFScriptModel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ComparisonOperator implements Enumerator
{
    EQ_LITERAL(0, "EQ", "EQ"),
    LT_LITERAL(1, "LT", "LT"),
    GT_LITERAL(2, "GT", "GT"),
    LE_LITERAL(3, "LE", "LE"),
    GE_LITERAL(4, "GE", "GE"),
    AND_LITERAL(5, "AND", "AND"),
    OR_LITERAL(6, "OR", "OR"),
    NE_LITERAL(7, "NE", "NE");

    public static final String copyright = "\r\n  Copyright (c) 2005, 2006, 2007, 2008 SINTEF\r\n  All rights reserved. This program and the accompanying materials\r\n  are made available under the terms of the Eclipse Public License v1.0\r\n  which accompanies this distribution, and is available at\r\n  http://www.eclipse.org/legal/epl-v10.html\r\n\r\n  Contributors:\r\n     Jon Oldevik, Tor Neple, G?ran Olsen, SINTEF (Norway)\r\n  \r\n     Developed as part of the MODELWARE (http://www.modelware-ist.org/) and \r\n    MODELPLEX (http://www.modelplex-ist.org/) IP projects \r\n\r\n";
    public static final int EQ = 0;
    public static final int LT = 1;
    public static final int GT = 2;
    public static final int LE = 3;
    public static final int GE = 4;
    public static final int AND = 5;
    public static final int OR = 6;
    public static final int NE = 7;
    private static final ComparisonOperator[] VALUES_ARRAY;
    public static final List<ComparisonOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComparisonOperator[]{EQ_LITERAL, LT_LITERAL, GT_LITERAL, LE_LITERAL, GE_LITERAL, AND_LITERAL, OR_LITERAL, NE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComparisonOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComparisonOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComparisonOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComparisonOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComparisonOperator get(int value) {
        switch (value) {
            case 0: {
                return EQ_LITERAL;
            }
            case 1: {
                return LT_LITERAL;
            }
            case 2: {
                return GT_LITERAL;
            }
            case 3: {
                return LE_LITERAL;
            }
            case 4: {
                return GE_LITERAL;
            }
            case 5: {
                return AND_LITERAL;
            }
            case 6: {
                return OR_LITERAL;
            }
            case 7: {
                return NE_LITERAL;
            }
        }
        return null;
    }

    private ComparisonOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

