/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.MOFScriptModel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ImportType implements Enumerator
{
    LIBRARY_LITERAL(0, "LIBRARY", "LIBRARY"),
    TRANSFORMATION_LITERAL(1, "TRANSFORMATION", "TRANSFORMATION");

    public static final String copyright = "\r\n  Copyright (c) 2005, 2006, 2007, 2008 SINTEF\r\n  All rights reserved. This program and the accompanying materials\r\n  are made available under the terms of the Eclipse Public License v1.0\r\n  which accompanies this distribution, and is available at\r\n  http://www.eclipse.org/legal/epl-v10.html\r\n\r\n  Contributors:\r\n     Jon Oldevik, Tor Neple, G?ran Olsen, SINTEF (Norway)\r\n  \r\n     Developed as part of the MODELWARE (http://www.modelware-ist.org/) and \r\n    MODELPLEX (http://www.modelplex-ist.org/) IP projects \r\n\r\n";
    public static final int LIBRARY = 0;
    public static final int TRANSFORMATION = 1;
    private static final ImportType[] VALUES_ARRAY;
    public static final List<ImportType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ImportType[]{LIBRARY_LITERAL, TRANSFORMATION_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ImportType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImportType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImportType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImportType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImportType get(int value) {
        switch (value) {
            case 0: {
                return LIBRARY_LITERAL;
            }
            case 1: {
                return TRANSFORMATION_LITERAL;
            }
        }
        return null;
    }

    private ImportType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

