/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.core.extension.factory.ThreadNameModifierFactory;
import org.eclipse.team.svn.core.extension.options.IIgnoreRecommendations;
import org.eclipse.team.svn.core.extension.options.IOptionProvider;
import org.eclipse.team.svn.core.operation.LoggedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreExtensionsManager {
    public static final String EXTENSION_NAMESPACE = "org.eclipse.team.svn.core";
    public static final String SVN_CONNECTOR = "svnconnector";
    public static final String CORE_OPTIONS = "coreoptions";
    public static final String CRASH_RECOVERY = "crashrecovery";
    public static final String IGNORE_RECOMMENDATIONS = "resourceIgnoreRules";
    private HashMap<String, ISVNConnectorFactory> connectors;
    private HashSet<String> validConnectors;
    private HashMap<String, IOptionProvider> optionProviders = new HashMap();
    private String selectedOptionProviderId;
    private IResolutionHelper[] helpers;
    private IIgnoreRecommendations[] ignoreRecommendations;
    private static CoreExtensionsManager instance = new CoreExtensionsManager();
    private boolean disableHelpers;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CoreExtensionsManager instance() {
        if (instance == null || CoreExtensionsManager.instance.initialized) return instance;
        Class<CoreExtensionsManager> clazz = CoreExtensionsManager.class;
        synchronized (CoreExtensionsManager.class) {
            String id;
            IOptionProvider optProvider;
            if (CoreExtensionsManager.instance.initialized) return instance;
            Object[] extensions = CoreExtensionsManager.loadCoreExtensions(CORE_OPTIONS);
            HashSet<String> inferiors = new HashSet<String>();
            int i = 0;
            while (i < extensions.length) {
                String[] inferiorOnes;
                optProvider = (IOptionProvider)extensions[i];
                id = instance.registerOptionProvider(optProvider);
                if (i == extensions.length - 1) {
                    instance.selectOptionProvider(id);
                }
                if ((inferiorOnes = optProvider.getCoveredProviders()) != null) {
                    int k = 0;
                    while (k < inferiorOnes.length) {
                        inferiors.add(inferiorOnes[k]);
                        ++k;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < extensions.length) {
                optProvider = (IOptionProvider)extensions[i];
                id = optProvider.getId();
                if (!inferiors.contains(id)) {
                    instance.selectOptionProvider(id);
                    break;
                }
                ++i;
            }
            extensions = CoreExtensionsManager.loadCoreExtensions(CRASH_RECOVERY);
            CoreExtensionsManager.instance.helpers = Arrays.asList(extensions).toArray(new IResolutionHelper[extensions.length]);
            extensions = CoreExtensionsManager.loadCoreExtensions(IGNORE_RECOMMENDATIONS);
            CoreExtensionsManager.instance.ignoreRecommendations = Arrays.asList(extensions).toArray(new IIgnoreRecommendations[extensions.length]);
            CoreExtensionsManager.instance.initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public IIgnoreRecommendations[] getIgnoreRecommendations() {
        return this.ignoreRecommendations;
    }

    public IResolutionHelper[] getResolutionHelpers() {
        return this.disableHelpers ? new IResolutionHelper[]{} : this.helpers;
    }

    public void setResolutionHelpersDisabled(boolean disable) {
        this.disableHelpers = disable;
    }

    public boolean isResoultionHelpersDisabled() {
        return this.disableHelpers;
    }

    public IOptionProvider getOptionProvider(String id) {
        return this.optionProviders.containsKey(id) ? this.optionProviders.get(id) : IOptionProvider.DEFAULT;
    }

    public IOptionProvider getOptionProvider() {
        return this.getOptionProvider(this.selectedOptionProviderId);
    }

    public void setOptionProvider(IOptionProvider optionProvider) {
        this.selectOptionProvider(this.registerOptionProvider(optionProvider));
    }

    public void selectOptionProvider(String id) {
        this.selectedOptionProviderId = id;
    }

    public String getSelectedOptionProviderId() {
        return this.selectedOptionProviderId;
    }

    public String registerOptionProvider(IOptionProvider optionProvider) {
        this.optionProviders.put(optionProvider.getId(), optionProvider);
        return optionProvider.getId();
    }

    public Collection<String> getAccessibleClientIds() {
        this.initializeConnectors();
        return this.connectors.keySet();
    }

    public Collection<ISVNConnectorFactory> getAccessibleClients() {
        this.initializeConnectors();
        return this.connectors.values();
    }

    public ISVNConnectorFactory getSVNConnectorFactory() {
        String id = this.getOptionProvider().getSVNConnectorId();
        return this.getSVNConnectorFactory(id);
    }

    public ISVNConnectorFactory getSVNConnectorFactory(String id) {
        ISVNConnectorFactory retVal = this.getFirstValidConnector(id);
        if (retVal == null) {
            retVal = ISVNConnectorFactory.EMPTY;
        }
        return retVal;
    }

    private ISVNConnectorFactory getFirstValidConnector(String id) {
        this.initializeConnectors();
        if (this.validConnectors.contains(id)) {
            return this.connectors.get(id);
        }
        if (this.validConnectors.contains("org.eclipse.team.svn.connector.svnkit16")) {
            return this.connectors.get("org.eclipse.team.svn.connector.svnkit16");
        }
        for (ISVNConnectorFactory connector : this.connectors.values()) {
            if (!this.validConnectors.contains(connector.getId())) continue;
            return connector;
        }
        return null;
    }

    private CoreExtensionsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeConnectors() {
        block7: {
            if (this.connectors != null) break block7;
            CoreExtensionsManager coreExtensionsManager = this;
            synchronized (coreExtensionsManager) {
                if (this.connectors != null) break block7;
                this.connectors = new HashMap();
                this.validConnectors = new HashSet();
                Object[] extensions = CoreExtensionsManager.loadCoreExtensions(SVN_CONNECTOR);
                int i = 0;
                while (i < extensions.length) {
                    block8: {
                        ThreadNameModifierFactory factory = new ThreadNameModifierFactory((ISVNConnectorFactory)extensions[i]);
                        try {
                            if (factory.getCompatibilityVersion().compareTo("0.8.0.I20120413-1700") != 0) {
                            }
                        }
                        catch (Throwable throwable) {}
                        break block8;
                        this.connectors.put(factory.getId(), factory);
                        this.validateClient(factory);
                    }
                    ++i;
                }
            }
        }
    }

    private void validateClient(ISVNConnectorFactory connector) {
        try {
            connector.newInstance().dispose();
            this.validConnectors.add(connector.getId());
        }
        catch (Throwable throwable) {}
    }

    private static Object[] loadCoreExtensions(String extensionPoint) {
        return CoreExtensionsManager.loadExtensions(EXTENSION_NAMESPACE, extensionPoint);
    }

    private static Object[] loadExtensions(String namespace, String extensionPoint) {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(namespace, extensionPoint);
        if (extension == null) {
            String errMessage = SVNMessages.formatErrorString("Error_InvalidExtensionPoint", new String[]{namespace, extensionPoint});
            throw new RuntimeException(errMessage);
        }
        IExtension[] extensions = extension.getExtensions();
        ArrayList<Object> retVal = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    retVal.add(configElements[j].createExecutableExtension("class"));
                }
                catch (CoreException ex) {
                    LoggedOperation.reportError(SVNMessages.getErrorString("Error_LoadExtensions"), ex);
                }
                ++j;
            }
            ++i;
        }
        return retVal.toArray();
    }
}

