/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.utility.FileUtility;

public class MarkResolvedOperation
extends AbstractFileOperation {
    protected boolean recursive;

    public MarkResolvedOperation(File[] files, boolean recursive) {
        super("Operation_MarkResolvedFile", SVNMessages.class, files);
        this.recursive = recursive;
    }

    public MarkResolvedOperation(IFileProvider provider, boolean recursive) {
        super("Operation_MarkResolvedFile", SVNMessages.class, provider);
        this.recursive = recursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        if (this.recursive) {
            files = FileUtility.shrinkChildNodes(files, false);
        } else {
            FileUtility.reorder(files, true);
        }
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            IRepositoryLocation location = SVNFileStorage.instance().asRepositoryResource(current, false).getRepositoryLocation();
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.resolve(current.getAbsolutePath(), 6, ISVNConnector.Depth.infinityOrEmpty(MarkResolvedOperation.this.recursive), new SVNProgressMonitor(MarkResolvedOperation.this, monitor, null));
                }
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

