/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;

public class BlockOutputStream
extends OutputStream {
    private Hashtable<String, Integer> _idCounters = new Hashtable();
    FileBlock _fileBlock = new ProtectedFileBlock("root");
    FileBlock _existingFile = null;
    String _fileUri = null;
    int _unprotectedIdCounter = 0;
    int _startLine = 1;
    int _endLine = 1;

    public BlockOutputStream(String fileUri) {
        this._fileUri = fileUri;
        this.preReadFile();
    }

    public int getIdBlockCounter(String objectId) {
        int counter = 0;
        if (this._idCounters.containsKey(objectId)) {
            counter = this._idCounters.get(objectId);
        } else {
            this._idCounters.put(objectId, counter);
        }
        return counter;
    }

    public void increaseIdCounter(String objectId) {
        Integer i = this._idCounters.get(objectId);
        i = i + 1;
        this._idCounters.remove(objectId);
        this._idCounters.put(objectId, i);
    }

    public FileBlock getBlockWithId(String id) {
        return this._fileBlock.getBlockWithId(id);
    }

    @Override
    public void write(int b) throws IOException {
        this._fileBlock.write(b);
    }

    public void newBlock(boolean isProtected, String id) {
        this._fileBlock.newBlock(isProtected, id);
    }

    public int getLineDifference(String blockId) {
        int diff = 0;
        if (blockId != null && blockId.length() > 0 && this._existingFile != null) {
            FileBlock newBlock = this._fileBlock.getBlockWithId(blockId);
            FileBlock oldBlock = this._existingFile.getBlockWithId(blockId);
            if (newBlock != null && oldBlock != null) {
                diff = oldBlock.getLineCount() - newBlock.getLineCount() - 2;
            }
        }
        return diff;
    }

    public void writeToFile() {
        if (this._existingFile != null) {
            this.merge();
        }
        File outputFile = new File(this._fileUri);
        try {
            FileOutputStream fs = new FileOutputStream(outputFile);
            this._fileBlock.writeToFileStream(fs);
            try {
                fs.flush();
                fs.close();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
        catch (FileNotFoundException fex) {
            fex.printStackTrace();
        }
    }

    protected void merge() {
        this._fileBlock.merge(this._existingFile);
    }

    public int position() {
        return this._fileBlock.position();
    }

    protected void preReadFile() {
        File f = new File(this._fileUri);
        if (f.exists()) {
            this._existingFile = new ProtectedFileBlock("root");
            try {
                FileInputStream fs = new FileInputStream(f);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fs));
                String line = null;
                try {
                    line = reader.readLine();
                    int bindex = -1;
                    boolean isBlockEnd = false;
                    while (line != null) {
                        isBlockEnd = false;
                        bindex = line.indexOf("#BlockStart");
                        if (bindex > -1) {
                            bindex = line.indexOf("id=");
                            String id = "";
                            if (bindex > -1) {
                                id = line.substring(bindex + 3, line.length());
                            }
                            this._existingFile.newBlock(false, id);
                            line = line.trim();
                        } else {
                            bindex = line.indexOf("#BlockEnd");
                            if (bindex > -1) {
                                isBlockEnd = true;
                                line = line.trim();
                            }
                        }
                        this._existingFile.write(line.getBytes());
                        line = reader.readLine();
                        if (!isBlockEnd) continue;
                        this._existingFile.newBlock(true, "");
                    }
                    fs.close();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
            catch (FileNotFoundException fex) {
                fex.printStackTrace();
            }
        }
    }

    public String get_fileUri() {
        return this._fileUri;
    }

    public FileBlock get_fileBlock() {
        return this._fileBlock;
    }

    public class FileBlock {
        protected FileBlock _nextBlock = null;
        protected String _id = null;
        protected ByteArrayOutputStream _byteStream = null;
        protected int _blockStart = 0;
        protected int _blockEnd = 0;
        protected int _mergeDiff = 0;
        protected int _startLine = 0;
        protected int _endLine = 0;
        protected int _lineCount = 0;
        protected int _idBlockCount = 0;

        public FileBlock(String id) {
            this._id = id;
            this._byteStream = new ByteArrayOutputStream();
        }

        public int position() {
            return this._nextBlock != null ? this._nextBlock.position() + this._byteStream.size() : this._byteStream.size();
        }

        public int getMergeDiff() {
            return this._mergeDiff;
        }

        public int getLineCount() {
            return this._lineCount;
        }

        public void setLineCount(int count) {
            this._lineCount = count;
        }

        protected void putData(byte[] data) {
            try {
                this._byteStream = new ByteArrayOutputStream();
                this._byteStream.write(10);
                this._byteStream.write(data);
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }

        protected byte[] getData() {
            return this._byteStream.toByteArray();
        }

        protected void setBlockStart(int position) {
            this._blockStart = position;
        }

        public int getBlockStart() {
            return this._blockStart;
        }

        public void write(int b) {
            if (this._nextBlock == null) {
                this._byteStream.write(b);
            } else {
                this._nextBlock.write(b);
            }
        }

        public void write(byte[] data) {
            if (this._nextBlock == null) {
                try {
                    this._byteStream.write(data);
                    this._byteStream.write(10);
                    ++this._lineCount;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this._nextBlock.write(data);
            }
        }

        protected void writeToFileStream(FileOutputStream fs) {
            try {
                fs.write(this._byteStream.toByteArray());
                if (this._nextBlock != null) {
                    this._nextBlock.writeToFileStream(fs);
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }

        public void newBlock(boolean isProtected, String id) {
            if (this._nextBlock == null) {
                this._nextBlock = isProtected ? new ProtectedFileBlock(id) : new UnprotectedFileBlock(id);
                this._nextBlock.setBlockStart(this._byteStream.size());
            } else {
                this._nextBlock.newBlock(isProtected, id);
            }
        }

        protected FileBlock getBlockWithId(String id) {
            if (this._id.equals(id)) {
                return this;
            }
            if (this._nextBlock != null) {
                return this._nextBlock.getBlockWithId(id);
            }
            return null;
        }

        public void merge(FileBlock otherBlock) {
            if (this._nextBlock != null) {
                this._nextBlock.merge(otherBlock);
            }
        }

        public int get_endLine() {
            return this._endLine;
        }

        public void set_endLine(int line) {
            this._endLine = line;
            this._lineCount = this._endLine - this._startLine;
        }

        public int get_startLine() {
            return this._startLine;
        }

        public void set_startLine(int line) {
            this._startLine = line;
        }
    }

    public class ProtectedFileBlock
    extends FileBlock {
        public ProtectedFileBlock(String id) {
            super(id);
        }
    }

    public class UnprotectedFileBlock
    extends FileBlock {
        public UnprotectedFileBlock(String id) {
            super(id);
        }

        @Override
        public void merge(FileBlock otherBlock) {
            FileBlock replacingBlock = otherBlock.getBlockWithId(this._id);
            if (replacingBlock != null) {
                int orgSize = this.getData().length;
                this.putData(replacingBlock.getData());
                this.setLineCount(replacingBlock.getLineCount());
                int newSize = this.getData().length;
                this._mergeDiff = newSize - orgSize;
            }
            if (this._nextBlock != null) {
                this._nextBlock.merge(otherBlock);
            }
        }
    }
}

