/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mofscript.MOFScriptModel.AssignmentOperator;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.TransformationRule;
import org.eclipse.mofscript.MOFScriptModel.ValueExpression;
import org.eclipse.mofscript.MOFScriptModel.VariableDeclaration;
import org.eclipse.mofscript.fileresourcemodel.frm.FileResource;
import org.eclipse.mofscript.fileresourcemodel.frm.FileResourcesType;
import org.eclipse.mofscript.fileresourcemodel.frm.impl.FrmFactoryImpl;
import org.eclipse.mofscript.runtime.BlockOutputStream;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutionStack;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.traceability.TraceabilityEnvironment;

public class ExecutionEnvironment {
    protected Hashtable<String, Object> _inputobjects = new Hashtable();
    private Hashtable<String, Variable> _variables = new Hashtable();
    protected static Hashtable<String, OutputStream> _streams = null;
    protected static Hashtable<OutputStream, PrintStream> _printStreams = null;
    protected static Hashtable<String, String> _streamContexts = null;
    private Hashtable<String, Object> _referenceCache = new Hashtable();
    private static Vector<String> _resources = null;
    protected ExecutionEnvironment _parentEnv = null;
    private boolean _useParentCache = true;
    protected OutputStream _currentStream = null;
    private int iteratorCount = -1;
    private int iteratorPosition = -1;
    private static RuleExecutionStack _ownerStack = null;
    private static int _indentCount = -1;
    private static final int _indentSize = 4;
    private static String _indent = null;
    private static boolean _useIndent = true;
    private static String _printContext = null;
    private static String _rootDirectory = null;
    private static boolean _useFileModel = false;
    private static boolean _useLog = false;
    protected static int _lineNumber = 1;
    protected static Hashtable<OutputStream, TraceabilityEnvironment.OffsetCounter> _offsets = new Hashtable();
    protected static boolean _traceValue = false;
    protected boolean _inPrintAction = false;
    protected static String _openFileUri = null;
    protected static long _blockCounter = 1L;
    private boolean _unprotectedBlock = false;
    protected String _objectId = "";
    private static String _blockCommentTag = null;
    private static volatile boolean debug = false;
    private static volatile boolean stopDebug = false;
    private static volatile boolean contDebug = false;

    public ExecutionEnvironment() {
        if (_streams == null) {
            _streams = new Hashtable();
        }
        if (_printStreams == null) {
            _printStreams = new Hashtable();
        }
        if (_streamContexts == null) {
            _streamContexts = new Hashtable();
        }
        if (_indentCount == -1) {
            _indentCount = 0;
        }
        if (_indent == null) {
            _indent = "";
            int i = 0;
            while (i < 4) {
                _indent = String.valueOf(_indent) + " ";
                ++i;
            }
        }
        if (_resources == null) {
            _resources = new Vector();
        }
        if (_blockCommentTag == null || _blockCommentTag != ExecutionManager.getExecutionManager().getBlockCommentTag()) {
            _blockCommentTag = ExecutionManager.getExecutionManager().getBlockCommentTag();
        }
    }

    public void setUseFileModel(boolean useModel) {
        _useFileModel = useModel;
    }

    public boolean getUseFileModel() {
        return _useFileModel;
    }

    public static void setDebug(boolean tf) {
        debug = tf;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static boolean getStopDebug() {
        return stopDebug;
    }

    public static boolean getContDebug() {
        return contDebug;
    }

    public static void stopDebug() {
        stopDebug = true;
        debug = false;
    }

    public static void contDebug() {
        contDebug = true;
    }

    public static void resetDebug() {
        contDebug = false;
        stopDebug = false;
    }

    public void setUseLog(boolean useLog) {
        _useLog = useLog;
    }

    public boolean getUseLog() {
        return _useLog;
    }

    public FileResourcesType getFileModel() {
        FileResourcesType fileModel = null;
        FileResource fProxy = null;
        if (_useFileModel) {
            FrmFactoryImpl factory = new FrmFactoryImpl();
            fileModel = factory.createFileResourcesType();
            Enumeration<String> _enum = _streams.keys();
            while (_enum.hasMoreElements()) {
                String uri = _enum.nextElement();
                ByteArrayOutputStream bstream = (ByteArrayOutputStream)_streams.get(uri);
                File tmpFile = null;
                if (bstream == null) continue;
                byte[] theBytes = bstream.toByteArray();
                fProxy = factory.createFileResource();
                int extindex = uri.lastIndexOf(".");
                String ext = "";
                if (extindex > -1) {
                    ext = uri.substring(extindex + 1, uri.length());
                }
                fProxy.setMimeType("text/plain");
                String relativeUri = uri.replaceAll("\\\\", "/");
                int fileStartIndex = relativeUri.lastIndexOf("/");
                if (fileStartIndex > -1) {
                    relativeUri = relativeUri.substring(0, fileStartIndex);
                }
                tmpFile = new File(uri);
                fProxy.setName(tmpFile.getName());
                fProxy.setExtension(ext);
                fProxy.setRelativePath(relativeUri);
                fProxy.setContent(theBytes);
                fileModel.getFileResource().add((Object)fProxy);
            }
        }
        return fileModel;
    }

    public void setRootDirectory(String rootDir) {
        _rootDirectory = rootDir;
    }

    public static void indent() {
        ++_indentCount;
    }

    public static void undent() {
        if (_indentCount > 0) {
            --_indentCount;
        }
    }

    public static String getIndent() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < _indentCount) {
            sb.append(_indent);
            ++i;
        }
        return sb.toString();
    }

    public static boolean useIndent() {
        return _useIndent;
    }

    public Variable getVariable(String varName) {
        return this.findVariable(varName);
    }

    public Collection<Variable> getVariables() {
        return this._variables.values();
    }

    public void notifyMessage(String msg) {
        if (_ownerStack != null) {
            _ownerStack.notifyOutputMessage(msg);
        }
    }

    public void notifyError(String error, ExpressionEvaluator expEval) {
        String additionalInfo = "";
        if (expEval != null) {
            TransformationRule inRule = expEval.getOwnerRule();
            Expression contextExpression = expEval.getExpression();
            additionalInfo = String.valueOf(additionalInfo) + "\n( - Context: " + inRule.getOwner().getName() + "::" + inRule.getName() + "::" + contextExpression.toString() + "\n";
        }
        if (_ownerStack != null) {
            _ownerStack.notifyOutputMessage(String.valueOf(error) + additionalInfo);
        }
    }

    public int getIteratorCount() {
        if (this.iteratorCount > -1) {
            return this.iteratorCount;
        }
        if (this._parentEnv != null) {
            return this._parentEnv.getIteratorCount();
        }
        return -1;
    }

    public int getIteratorPosition() {
        if (this.iteratorPosition > -1) {
            return this.iteratorPosition;
        }
        if (this._parentEnv != null) {
            return this._parentEnv.getIteratorPosition();
        }
        return -1;
    }

    public void initIteratorCounters() {
        this.iteratorCount = 0;
        this.iteratorPosition = 0;
    }

    public void increaseIteratorCount() {
        ++this.iteratorCount;
    }

    public void increaseIteratorPosition() {
        ++this.iteratorPosition;
    }

    public Object getVariableImplementation(String varName) {
        Object varImpl = null;
        Variable var = this._variables.get(varName);
        if (var != null) {
            varImpl = this.getVariableImplementation(var);
        } else if (this._parentEnv != null) {
            varImpl = this._parentEnv.getVariableImplementation(varName);
        }
        return varImpl;
    }

    public Object getVariableValue(String varName) {
        Object val;
        Variable var = this._variables.get(varName);
        Object object = val = var != null ? var.value : null;
        if (val == null && this._parentEnv != null && this._useParentCache) {
            val = this._parentEnv.getVariableValue(varName);
        }
        return val;
    }

    public Object getVariableImplementation(Variable var) {
        Hashtable varValue = null;
        String varType = var.getType();
        varValue = var.getValue();
        if (varValue == null) {
            if (varType.equalsIgnoreCase("Hashtable") || varType.equalsIgnoreCase("Dictionary")) {
                varValue = new Hashtable();
                var.value = varValue;
            } else if (varType.equalsIgnoreCase("List")) {
                varValue = new ArrayList();
                var.value = varValue;
            } else if (varType.equalsIgnoreCase("String")) {
                varValue = new StringBuffer();
                var.value = varValue;
            } else if (varType.equalsIgnoreCase("Integer")) {
                varValue = new Integer(0);
                var.value = varValue;
            } else if (varType.equalsIgnoreCase("Real")) {
                varValue = new Double(0.0);
                var.value = varValue;
            } else if (varType.equalsIgnoreCase("Boolean")) {
                varValue = new Boolean(true);
                var.value = varValue;
            } else if (varType.equalsIgnoreCase("Object")) {
                varValue = new Object();
            }
        }
        return varValue;
    }

    public void setTypeForVariable(Variable varDecl, Object varValue) {
        if (varValue == null) {
            varDecl.setType("Object");
        } else if (varValue instanceof String || varValue instanceof StringBuffer) {
            varDecl.setType("String");
        } else if (varValue instanceof List) {
            varDecl.setType("List");
        } else if (varValue instanceof Hashtable) {
            varDecl.setType("Hashtable");
        } else if (varValue instanceof Integer) {
            varDecl.setType("Integer");
        } else if (varValue instanceof Double) {
            varDecl.setType("Real");
        } else if (varValue instanceof Boolean) {
            varDecl.setType("Boolean");
        } else {
            varDecl.setType("Object");
        }
    }

    public Object assignVariableValue(String varName, Object value, AssignmentOperator operator, Expression assignedExpression) {
        Variable var = this._variables.get(varName);
        Object assignValue = value;
        if (var != null) {
            Object varImpl = this.getVariableImplementation(varName);
            assignValue = ExecutionEnvironment.getAssignValue(var.type, varImpl, assignValue, operator);
            var.value = assignValue != null ? assignValue : value;
            if (assignedExpression != null && assignedExpression instanceof ValueExpression) {
                var.assignedExpression = (ValueExpression)EcoreUtil.copy((EObject)assignedExpression);
            }
        } else if (this._parentEnv != null) {
            assignValue = this._parentEnv.assignVariableValue(varName, value, operator, assignedExpression);
        }
        return assignValue;
    }

    public static Object getAssignValue(String type, Object input, Object assignValue, AssignmentOperator operator) {
        if (assignValue == null) {
            input = null;
        } else if (type.equals("Object") || type.equals("")) {
            input = assignValue;
        } else if (input instanceof StringBuffer) {
            if (assignValue instanceof String) {
                if (operator == AssignmentOperator.EQ_LITERAL) {
                    ((StringBuffer)input).delete(0, ((StringBuffer)input).length());
                    ((StringBuffer)input).append((String)assignValue);
                } else if (operator == AssignmentOperator.PLUS_EQ_LITERAL) {
                    ((StringBuffer)input).append((String)assignValue);
                }
            } else if (operator == AssignmentOperator.EQ_LITERAL) {
                ((StringBuffer)input).delete(0, ((StringBuffer)input).length());
                ((StringBuffer)input).append(assignValue.toString());
            } else if (operator == AssignmentOperator.PLUS_EQ_LITERAL) {
                ((StringBuffer)input).append(assignValue.toString());
            }
        } else if (input instanceof String) {
            if (assignValue instanceof String) {
                if (operator == AssignmentOperator.EQ_LITERAL) {
                    input = assignValue;
                } else if (operator == AssignmentOperator.PLUS_EQ_LITERAL) {
                    input = String.valueOf(input) + assignValue.toString();
                }
            }
        } else if (input instanceof Integer) {
            if (assignValue instanceof Integer) {
                input = operator == AssignmentOperator.PLUS_EQ_LITERAL ? new Integer((Integer)input + (Integer)assignValue) : new Integer((Integer)assignValue);
            } else if (assignValue instanceof Double) {
                input = operator == AssignmentOperator.PLUS_EQ_LITERAL ? new Integer((Integer)input + ((Double)assignValue).intValue()) : new Integer(((Double)assignValue).intValue());
            } else if (assignValue instanceof BigInteger) {
                input = operator == AssignmentOperator.PLUS_EQ_LITERAL ? new Integer((Integer)input + ((BigInteger)assignValue).intValue()) : new Integer(((BigInteger)assignValue).intValue());
            } else if (assignValue instanceof String || assignValue instanceof StringBuffer) {
                try {
                    String val = assignValue.toString();
                    input = Integer.valueOf(val);
                }
                catch (Exception exception) {
                    input = new Integer(0);
                }
            } else {
                input = new Integer(-1);
            }
        } else if (input instanceof Boolean) {
            input = assignValue instanceof Boolean ? assignValue : new Boolean(false);
        } else if (input instanceof Double) {
            if (assignValue instanceof Double) {
                input = operator == AssignmentOperator.PLUS_EQ_LITERAL ? new Double((Double)input + (Double)assignValue) : assignValue;
            } else if (assignValue instanceof Integer) {
                input = operator == AssignmentOperator.PLUS_EQ_LITERAL ? new Double((Double)input + (double)((Integer)assignValue).intValue()) : new Double(((Integer)assignValue).intValue());
            } else if (assignValue instanceof String) {
                try {
                    input = new Double(Double.parseDouble((String)assignValue));
                }
                catch (NumberFormatException numberFormatException) {
                    input = new Double(-1.0);
                }
            } else {
                input = new Double(-1.0);
            }
        } else if (input instanceof List) {
            input = assignValue instanceof List ? assignValue : new ArrayList();
        } else if (input instanceof Hashtable) {
            input = assignValue instanceof Hashtable ? assignValue : new Hashtable();
        } else if (input instanceof Object || type.equals("Object")) {
            input = assignValue;
        } else if (input == null && assignValue instanceof EObject) {
            input = assignValue;
        }
        return input;
    }

    public void setVariable(String varName, Variable val) {
        this._variables.put(varName, val);
    }

    public Variable findVariable(String varName) {
        Variable var = this._variables.get(varName);
        if (var == null && this._parentEnv != null) {
            var = this._parentEnv.findVariable(varName);
        }
        return var;
    }

    public ExecutionEnvironment getParentEnvironment() {
        return this._parentEnv;
    }

    public void setParentEnvironment(ExecutionEnvironment parent) {
        this._parentEnv = parent;
    }

    public void setOwnerStack(RuleExecutionStack stack) {
        _ownerStack = stack;
    }

    public void addVariables(List<Variable> variables) {
        for (Variable vardecl : variables) {
            if (this._variables.get(vardecl.getName()) != null) continue;
            this._variables.put(vardecl.getName(), vardecl);
        }
    }

    public void addModelVariables(List<VariableDeclaration> variables) {
        Variable var = null;
        VariableDeclaration decl2 = null;
        for (VariableDeclaration decl2 : variables) {
            var = new Variable(decl2);
            if (this._variables.get(var.name) != null) continue;
            this._variables.put(var.name, var);
        }
    }

    void evaluateVariables(RuleExecutor rExec) {
        Object value = null;
        Variable var2 = null;
        for (Variable var2 : this._variables.values()) {
            try {
                if (var2.assignedExpression == null || (value = MofScriptExecuterFactory.createExpressionExecutor(var2.assignedExpression, this, rExec).evaluateExpression(null)) == null) continue;
                this.assignVariableValue(var2.getName(), value, AssignmentOperator.EQ_LITERAL, var2.assignedExpression);
            }
            catch (MofScriptExecutionException mofScriptExecutionException) {}
        }
    }

    public void addVariable(Variable var) {
        if (var != null) {
            this._variables.put(var.getName(), var);
        }
    }

    public void removeVariable(Variable var) {
        if (var != null && this._variables.containsKey(var.getName())) {
            this._variables.remove(var.getName());
        }
    }

    public void addLocalVariablesZZZ(List<VariableDeclaration> variables, RuleExecutor currentRuleExecutor) {
        VariableDeclaration modelvar2 = null;
        Object value = null;
        for (VariableDeclaration modelvar2 : variables) {
            Variable var = new Variable();
            var.name = modelvar2.getName();
            var.type = modelvar2.getType();
            var.isConstant = modelvar2.isConstant();
            var.assignedExpression = modelvar2.getValue();
            this.addVariable(var);
            try {
                if (var.assignedExpression == null || (value = MofScriptExecuterFactory.createExpressionExecutor(var.assignedExpression, this, currentRuleExecutor).evaluateExpression(null)) == null) continue;
                this.assignVariableValue(var.getName(), value, AssignmentOperator.EQ_LITERAL, var.assignedExpression);
            }
            catch (MofScriptExecutionException mofScriptExecutionException) {}
        }
    }

    public Object getInputObject(String name) {
        Object ret = this._inputobjects.get(name);
        if ((ret == null || ret.equals("")) && this._parentEnv != null && this._useParentCache) {
            ret = this._parentEnv.getInputObject(name);
        }
        if (ExecutionManager.getExecutionManager().getUseTraceability()) {
            this.storeInputObject(ret);
        }
        return ret;
    }

    public void storeInputObject(Object ret) {
    }

    public void addInputObject(String name, Object obj) {
        if (obj != null) {
            this._inputobjects.put(name, obj);
        }
    }

    public void clearInputObject(String name) {
        this._inputobjects.remove(name);
    }

    public void setUseParentCache(boolean useParentCache) {
        this._useParentCache = useParentCache;
    }

    public Object getCachedReference(String refName) {
        Object cached = this._referenceCache.get(refName);
        if (cached == null && this._parentEnv != null && this._useParentCache) {
            cached = this._parentEnv.getCachedReference(refName);
        }
        return cached;
    }

    public void setCachedReference(String refname, Object value) {
        if (value != null) {
            this._referenceCache.put(refname, value);
        }
    }

    public void clearReferenceCache() {
        this._referenceCache.clear();
    }

    protected OutputStream addOutputStream(String uri, OutputStream stream, String context) {
        OutputStream str = this.getOutputStream(uri);
        if (str == null) {
            str = stream;
            _streams.put(uri, stream);
            _printStreams.put(stream, new PrintStream(stream));
        }
        if (context != null && !context.equals("")) {
            _streamContexts.put(context, uri);
        }
        return str;
    }

    protected OutputStream getOutputStreamForContext(String context) {
        if (context != null) {
            return this.getOutputStream(_streamContexts.get(context));
        }
        return null;
    }

    protected PrintStream getPrintStreamForContext(String context) {
        OutputStream str = this.getOutputStreamForContext(context);
        return str != null ? _printStreams.get(str) : null;
    }

    public OutputStream getOutputStream(String uri) {
        OutputStream str = _streams.get(uri);
        return str;
    }

    public void setCurrentStream(String uri, String context) {
        File openfile = new File(uri);
        String absPath = openfile.getAbsolutePath();
        String path = openfile.getPath();
        String absUri = uri;
        if (!path.equalsIgnoreCase(absPath) && _rootDirectory != null && !_rootDirectory.equals("")) {
            absUri = _rootDirectory.concat(System.getProperty("file.separator")).concat(uri);
            openfile = new File(absUri);
            _openFileUri = absUri;
        }
        if (!openfile.exists()) {
            try {
                File parentfile = openfile.getParentFile();
                if (parentfile != null) {
                    parentfile.mkdirs();
                }
                openfile.createNewFile();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
        try {
            OutputStream existing_stream = this.getOutputStream(openfile.getAbsolutePath());
            if (existing_stream != null) {
                this._currentStream = existing_stream;
            } else if (!_useFileModel) {
                if (_ownerStack != null) {
                    _ownerStack.notifyOutputMessage("   New file: " + openfile.getAbsolutePath() + "\n");
                }
                BlockOutputStream bos = new BlockOutputStream(openfile.getAbsolutePath());
                this.addOutputStream(openfile.getAbsolutePath(), bos, context);
                this._currentStream = bos;
                _openFileUri = openfile.getAbsolutePath();
            } else {
                if (_ownerStack != null) {
                    _ownerStack.notifyOutputMessage("   New file object:" + openfile.getAbsolutePath() + "\n");
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.addOutputStream(uri, os, context);
                this._currentStream = os;
            }
        }
        catch (Exception exception) {}
    }

    public void setCurrentStream(String contextReference) {
        String streamUri;
        if (contextReference != null && (streamUri = _streamContexts.get(contextReference)) != null) {
            this._currentStream = _streams.get(streamUri);
        }
    }

    public OutputStream getCurrentStream() {
        if (this._currentStream != null) {
            return this._currentStream;
        }
        return this._parentEnv != null ? this._parentEnv.getCurrentStream() : null;
    }

    public PrintStream getCurrentPrintStream() {
        if (this._currentStream != null) {
            return _printStreams.get(this._currentStream);
        }
        return this._parentEnv != null ? this._parentEnv.getCurrentPrintStream() : null;
    }

    protected String getCurrentStreamUri() {
        if (this._currentStream == null) {
            return null;
        }
        String uri = null;
        Enumeration<String> _enum = _streams.keys();
        while (_enum.hasMoreElements()) {
            uri = _enum.nextElement();
            if (this._currentStream != _streams.get(uri)) continue;
            return uri;
        }
        return null;
    }

    public void storeFiles() {
        this._currentStream = null;
        Enumeration<String> _enum = _streams.keys();
        while (_enum.hasMoreElements()) {
            String key = _enum.nextElement();
            OutputStream ps = _streams.get(key);
            _resources.add(key);
            if (ps instanceof BlockOutputStream) {
                ((BlockOutputStream)ps).writeToFile();
            } else {
                try {
                    ps.flush();
                    ps.close();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
            Object var3_3 = null;
        }
    }

    public void clean() {
        _streams.clear();
        _printStreams.clear();
        this.cleanLocal();
    }

    protected void cleanLocal() {
        if (this._variables != null) {
            this._variables.clear();
        }
        if (this._inputobjects != null) {
            this._inputobjects.clear();
        }
        if (this._referenceCache != null) {
            this._referenceCache.clear();
        }
        this._variables = null;
        this._inputobjects = null;
        this._referenceCache = null;
        _indentCount = -1;
    }

    public static void setPrintContext(String context) {
        _printContext = context;
    }

    public void print(String s, boolean println) {
        PrintStream contextStream;
        boolean isStdOut = false;
        PrintStream pstream = this.getCurrentPrintStream();
        if (pstream == null || _printContext != null && _printContext.equalsIgnoreCase("stdout")) {
            pstream = System.out;
            isStdOut = true;
        } else if (_printContext != null && !_printContext.equals("") && (contextStream = this.getPrintStreamForContext(_printContext)) != null) {
            pstream = contextStream;
        }
        if (println) {
            if (isStdOut) {
                this.notifyMessage(String.valueOf(s) + "\n");
            } else {
                ExecutionEnvironment.increaseLineNumber(s);
            }
            pstream.println(s);
        } else {
            if (isStdOut) {
                this.notifyMessage(s);
            } else {
                ExecutionEnvironment.increaseLineNumber(s);
            }
            pstream.print(s);
        }
    }

    public void log(String s) {
        if (_useLog) {
            Date d = new Date();
            ExecutionManager.getExecutionManager().getExecutionStack().notifyOutputMessage("$log: " + s + " [" + d.toString() + "]");
        }
    }

    public void println(String s) {
        this.print(s, true);
    }

    public static Vector<String> getResources() {
        return _resources;
    }

    public static void cleanResources() {
        _resources.clear();
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanLocal();
        }
        finally {
            super.finalize();
        }
    }

    public void setInPrintAction(boolean inPrintAction) {
        this._inPrintAction = inPrintAction;
    }

    public boolean isInPrintAction() {
        return this._inPrintAction;
    }

    public void setTrace(boolean tV) {
        _traceValue = tV;
    }

    public boolean getTrace() {
        return _traceValue;
    }

    public static void increaseLineNumber(String s) {
        String[] a = s.split("\\n");
        int i = a.length;
        if (i > 1) {
            if (s.endsWith("\\n") || s.equalsIgnoreCase("\\n")) {
                ++_lineNumber;
            }
            _lineNumber += i - 1;
        }
    }

    public int getLineNumber() {
        return _lineNumber;
    }

    public static void resetBlockCounter() {
        _blockCounter = 0L;
    }

    public void startUnprotectedBlock(String objectUri) {
        String blockStart;
        int counter = 0;
        ++_blockCounter;
        OutputStream os = this.getCurrentStream();
        this.setUnprotectedBlock(true);
        this._objectId = objectUri;
        if (os != null && os instanceof BlockOutputStream) {
            String[] objIds = this._objectId.split("_#_");
            String objId = objIds[0];
            counter = ((BlockOutputStream)os).getIdBlockCounter(objId);
            if (objIds.length < 2) {
                this._objectId = String.valueOf(objectUri) + "_#_" + counter;
            }
            blockStart = "#BlockStart number=" + _blockCounter + " id=" + this._objectId;
            ((BlockOutputStream)os).newBlock(false, this._objectId);
            if (ExecutionManager.getExecutionManager().getUseTraceability()) {
                TraceabilityEnvironment.OffsetCounter c = _offsets.get(os);
                int line = c.get_lineNumber() + 1;
                ((BlockOutputStream)os).getBlockWithId(this._objectId).set_startLine(line);
            }
        } else {
            blockStart = "#BlockStart number=" + _blockCounter + " id=" + this._objectId;
        }
        this.println("");
        this.println(String.valueOf(_blockCommentTag) + blockStart);
    }

    public void endUnprotectedBlock() {
        this.setUnprotectedBlock(false);
        String blockEnd = "#BlockEnd number=" + _blockCounter;
        this.println("");
        this.println(String.valueOf(_blockCommentTag) + blockEnd);
        OutputStream os = this.getCurrentStream();
        if (os != null && os instanceof BlockOutputStream) {
            String[] objIds = this._objectId.split("_#_");
            String objId = objIds[0];
            ((BlockOutputStream)os).increaseIdCounter(objId);
            ((BlockOutputStream)os).newBlock(true, "");
            if (ExecutionManager.getExecutionManager().getUseTraceability()) {
                TraceabilityEnvironment.OffsetCounter c = _offsets.get(os);
                int line = c.get_lineNumber() - 2;
                ((BlockOutputStream)os).getBlockWithId(this._objectId).set_endLine(line);
                int lineDiff = ((BlockOutputStream)os).getLineDifference(this._objectId);
                c.increaseLineNumber(lineDiff);
            }
        }
        this._objectId = "";
    }

    public boolean isUnprotectedBlock() {
        return this._unprotectedBlock;
    }

    public void setUnprotectedBlock(boolean unprotected) {
        this._unprotectedBlock = unprotected;
    }

    public void saveTargetModel(String fileLoc, EObject model, Resource originalResource, EObject originalModel) {
        File openfile = new File(fileLoc);
        String absPath = openfile.getAbsolutePath();
        String path = openfile.getPath();
        String absUri = fileLoc;
        if (!path.equalsIgnoreCase(absPath) && _rootDirectory != null && !_rootDirectory.equals("")) {
            absUri = _rootDirectory.concat(System.getProperty("file.separator")).concat(fileLoc);
            openfile = new File(absUri);
        }
        URI fileUri = URI.createFileURI((String)absUri);
        Resource res = null;
        if (originalResource != null) {
            res = originalResource;
            res.setURI(fileUri);
        } else {
            res = ExecutionManager.getExecutionManager().getResourceSet().createResource(fileUri);
            res.getContents().add((Object)model);
        }
        try {
            res.save(Collections.EMPTY_MAP);
            this.notifyMessage("Model stored to: " + absUri);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

