/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptModelFactory;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptParameter;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptSpecification;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;
import org.eclipse.mofscript.MOFScriptModel.ParameterDirection;
import org.eclipse.mofscript.MOFScriptModel.TransformationRule;
import org.eclipse.mofscript.MOFScriptModel.VariableDeclaration;
import org.eclipse.mofscript.MOFScriptModel.impl.MOFScriptModelFactoryImpl;
import org.eclipse.mofscript.fileresourcemodel.frm.FileResourcesType;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.OurSwitch;
import org.eclipse.mofscript.runtime.RuleExecutionStack;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.TransformationProxy;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.statement.DebugListener;
import org.eclipse.mofscript.runtime.traceability.TraceabilityEnvironment;
import org.eclipse.mofscript.runtime.traceability.TraceabilityRuleExecutor;

public class ExecutionManager {
    protected EcorePackage _ecorePackage = EcorePackage.eINSTANCE;
    protected EcoreFactory _ecoreFactory = this._ecorePackage.getEcoreFactory();
    private ResourceSet _fileResources;
    protected Hashtable<String, EPackage> _sourceMetaModels;
    protected Hashtable<String, String> _sourceMetaModelNames;
    protected Hashtable<String, EPackage> _targetMetaModels;
    protected Hashtable<String, String> _targetMetaModelNames;
    protected Hashtable<String, EObject> _sourceModels;
    protected EObject _targetModel;
    protected boolean _useTraceability;
    protected boolean _useTramde;
    protected boolean _coarseTramde;
    protected ExecutionEnvironment _rootEnv = null;
    protected RuleExecutionStack _executionStack = null;
    protected MOFScriptModelFactory _mttModelFactory = null;
    protected TransformationProxy _transformationProxy = null;
    private String _fileMetaModelRepository = null;
    protected boolean _useFileModel = false;
    protected FileResourcesType _filUML2eModel = null;
    private String _rootDir = null;
    private String _traceDir = null;
    private String _blockCommentTag = null;
    private Hashtable _fileResourceCache = new Hashtable();
    private FileResourcesType _fileModel = null;
    private boolean _UML2IsAvailable = false;
    private boolean _rsaIsAvailable = false;
    private boolean _useLog = false;
    private boolean _executionOccured = false;
    private static ExecutionManager _singleton = null;
    private List<EObject> _outputModels = null;
    private Hashtable<String, String> _outputModelParamTypes = null;
    private static List<DebugListener> _debugListeners = null;
    private static boolean _tramdeActive = true;
    private static boolean _tramdeIsAvailable = false;

    protected ExecutionManager() {
        this._fileResources = new ResourceSetImpl();
        XMIResourceFactoryImpl _xmiFac = new XMIResourceFactoryImpl();
        EcoreResourceFactoryImpl _ecoreFac = new EcoreResourceFactoryImpl();
        this._fileResources.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", _ecoreFac);
        this._fileResources.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", _xmiFac);
        this.registerExternalResources();
        this._executionStack = new RuleExecutionStack();
        this._sourceMetaModels = new Hashtable();
        this._sourceMetaModelNames = new Hashtable();
        this._sourceModels = new Hashtable();
        this._outputModels = new ArrayList<EObject>();
        this._targetMetaModels = new Hashtable();
        this._targetMetaModelNames = new Hashtable();
        this._mttModelFactory = new MOFScriptModelFactoryImpl();
        this._outputModelParamTypes = new Hashtable();
        if (_debugListeners == null) {
            _debugListeners = new ArrayList<DebugListener>();
        }
        this.initUMLSupport();
        this.checkRSAAvailability();
        this.checkTramdeAvailability();
    }

    public boolean isTramdeActive() {
        return _tramdeActive;
    }

    public void checkTramdeAvailability() {
        String tramdeClassName = "org.sintef.tramde.tramdeModel.TraceModel";
        _tramdeIsAvailable = false;
        try {
            Class.forName(tramdeClassName);
            _tramdeIsAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public static boolean getTramdeAvailable() {
        return _tramdeIsAvailable;
    }

    public static ExecutionManager getExecutionManager() {
        if (_singleton == null) {
            _singleton = new ExecutionManager();
        }
        return _singleton;
    }

    protected void updatePackageRegistry() {
        this._fileResources.getPackageRegistry().clear();
        new Vector();
        this._fileResources.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)this._ecorePackage);
        File metamodeldir = new File(this._fileMetaModelRepository);
        if (metamodeldir.isDirectory()) {
            FilenameFilter ff = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".ecore");
                }
            };
            File[] files = metamodeldir.listFiles(ff);
            ResourceSetImpl rSet = new ResourceSetImpl();
            URI fileUri = null;
            Resource res = null;
            EPackage emfModel = null;
            int i = 0;
            while (i < files.length) {
                res = null;
                try {
                    fileUri = URI.createFileURI((String)files[i].getAbsolutePath());
                    res = rSet.getResource(fileUri, true);
                    if (res != null) {
                        emfModel = (EPackage)res.getContents().get(0);
                        if (emfModel.getNsURI().equals("")) {
                            EPackage cfr_ignored_0 = (EPackage)emfModel.getESubpackages().get(0);
                        }
                        this._fileResources.getPackageRegistry().put((Object)emfModel.getNsURI(), (Object)emfModel);
                    }
                }
                catch (Exception ex) {
                    this._executionStack.notifyOutputMessage("ExecutionManager::updatePackageRegistry - " + ex);
                }
                ++i;
            }
        }
    }

    public Hashtable lookupMetaModels() {
        Hashtable<String, String> mmCollection = new Hashtable<String, String>();
        String uriKey2 = null;
        EPackage epack = null;
        try {
            for (String uriKey2 : this._fileResources.getPackageRegistry().keySet()) {
                epack = this._fileResources.getPackageRegistry().getEPackage(uriKey2);
                if (epack != null) {
                    mmCollection.put(uriKey2, epack.getName());
                    continue;
                }
                mmCollection.put(uriKey2, uriKey2);
            }
        }
        catch (Exception exception) {}
        try {
            EPackage.Registry reg = EPackage.Registry.INSTANCE;
            Set keys = reg.keySet();
            for (String uriKey2 : keys) {
                try {
                    epack = reg.getEPackage(uriKey2);
                    if (epack != null) {
                        mmCollection.put(uriKey2, epack.getName());
                        continue;
                    }
                    mmCollection.put(uriKey2, uriKey2);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return mmCollection;
    }

    public void setFileMetaModelRepository(String directory) {
        this._fileMetaModelRepository = directory;
        this.updatePackageRegistry();
    }

    public void setUseTraceability(boolean useIt) {
        this._useTraceability = useIt;
    }

    public void setTraceabilityGenDir(String traceGenDir) {
        this._traceDir = traceGenDir;
    }

    public boolean getUseTraceability() {
        return this._useTraceability;
    }

    public boolean getUseTramde() {
        return this._useTramde;
    }

    public void setUseTramde(boolean useIt) {
        this._useTramde = useIt;
    }

    public boolean getUseCoarseTramde() {
        return this._coarseTramde;
    }

    public void setUseCoarseTramde(boolean useIt) {
        this._coarseTramde = useIt;
    }

    public static void addDebugListener(DebugListener dl) {
        _debugListeners.add(dl);
    }

    public static void removeDebugListener(DebugListener dl) {
        _debugListeners.remove(dl);
    }

    public static List<DebugListener> getDebugListeners() {
        return _debugListeners;
    }

    public void setBlockCommentTag(String blockCommentTag) {
        this._blockCommentTag = blockCommentTag;
    }

    public String getBlockCommentTag() {
        return this._blockCommentTag;
    }

    public void setUMLIsAvailable(boolean umlIsAvailable) {
        this._UML2IsAvailable = umlIsAvailable;
    }

    protected void initUMLSupport() {
        String uml2ClassName = "org.eclipse.uml2.uml.Element";
        this._UML2IsAvailable = false;
        try {
            Class.forName(uml2ClassName);
            this._UML2IsAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public boolean getUMLIsAvailable() {
        return this._UML2IsAvailable;
    }

    public void setUseLog(boolean useLog) {
        this._useLog = useLog;
    }

    public Resource getResource(URI uri) {
        try {
            return this._fileResources.getResource(uri, true);
        }
        catch (Exception ex) {
            this._executionStack.notifyOutputMessage(ex.getMessage());
            return null;
        }
    }

    public TransformationRule getTransformationRule2(String name, String possibleScope, String ownerTransformation) {
        if (ownerTransformation.equals(this._transformationProxy.getName())) {
            return this._transformationProxy.getTransformationRule(name);
        }
        return null;
    }

    public Collection getTransformationRules(String name, String possibleScope, String ownerTransformation) {
        if (ownerTransformation.equals(this._transformationProxy.getName())) {
            return this._transformationProxy.getAllTransformationRules(name);
        }
        return new ArrayList();
    }

    public EPackage getEcoreMetaModel() {
        return this._ecorePackage;
    }

    public void clearTransformationModel() {
        this._transformationProxy = null;
    }

    public void setTransformationProxy(TransformationProxy trProxy) {
        this._transformationProxy = trProxy;
    }

    public TransformationProxy getTransformationProxy() {
        return this._transformationProxy;
    }

    public void setTransformationModel(MOFScriptTransformation transformation) {
        this.lookupAndAddSourceMetaModelsFromParameterList((List)transformation.getParameters());
        this._transformationProxy = new TransformationProxy(transformation);
    }

    public void setTransformationSpecification(MOFScriptSpecification transformationSpec) {
        this._transformationProxy = new TransformationProxy(transformationSpec);
    }

    public MOFScriptSpecification getTransformationSpecification() {
        if (this._transformationProxy != null) {
            return this._transformationProxy.getTransformationSpecification();
        }
        return null;
    }

    public void setUseFileModel(boolean useFileModel) {
        this._useFileModel = useFileModel;
    }

    public void setRootDirectory(String rootDir) {
        this._rootDir = rootDir;
    }

    public String getRootDirectory() {
        return this._rootDir;
    }

    public MOFScriptModelFactory getModelFactory() {
        return this._mttModelFactory;
    }

    public ResourceSet getResourceSet() {
        return this._fileResources;
    }

    public RuleExecutionStack getExecutionStack() {
        return this._executionStack;
    }

    public void loadTransformationModel(File sourcefile) {
        URI fileUri = URI.createFileURI((String)sourcefile.getAbsolutePath());
        Resource res = this._fileResources.getResource(fileUri, true);
        MOFScriptSpecification spec = (MOFScriptSpecification)res.getContents().get(0);
        this._transformationProxy = new TransformationProxy(spec);
    }

    public EPackage lookupPackageRegistry_111(String name) {
        EPackage lookup = null;
        lookup = this._fileResources.getPackageRegistry().getEPackage(name);
        return lookup;
    }

    public void clearSourceMetaModels() {
        this._sourceMetaModels.clear();
        this._sourceMetaModelNames.clear();
        this._targetMetaModelNames.clear();
        this._targetMetaModels.clear();
        this._outputModelParamTypes.clear();
        this._outputModels.clear();
    }

    private void clearSourceModels() {
        this._sourceModels.clear();
    }

    /*
     * Exception decompiling
     */
    public void loadSourceModel(File sourceFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public EPackage lookupResourceMetaModel(String mmUri) {
        EPackage lookupPackage = null;
        lookupPackage = EPackage.Registry.INSTANCE.containsKey((Object)mmUri) ? EPackage.Registry.INSTANCE.getEPackage(mmUri) : (this._fileResources.getPackageRegistry().containsKey((Object)mmUri) ? this._fileResources.getPackageRegistry().getEPackage(mmUri) : this.lookupResourceMetaModelByName(mmUri));
        return lookupPackage;
    }

    public synchronized EPackage lookupResourceMetaModelByName(String name) {
        EPackage lookupPackage = null;
        String uriKey2 = null;
        HashSet keys = new HashSet();
        EPackage.Registry preg = EPackage.Registry.INSTANCE;
        keys.addAll(preg.keySet());
        try {
            for (String uriKey2 : keys) {
                lookupPackage = preg.getEPackage(uriKey2);
                if (!lookupPackage.getName().equalsIgnoreCase(name)) continue;
                return lookupPackage;
            }
        }
        catch (Exception exception) {}
        try {
            for (String uriKey2 : this._fileResources.getPackageRegistry().keySet()) {
                lookupPackage = this._fileResources.getPackageRegistry().getEPackage(uriKey2);
                if (!lookupPackage.getName().equalsIgnoreCase(name)) continue;
                return lookupPackage;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public EPackage lookupAndAddSourceMetaModel(String mmName, String mmUri) {
        EPackage lookupPackage = this.lookupResourceMetaModel(mmUri);
        if (lookupPackage != null) {
            this._sourceMetaModels.put(mmUri, lookupPackage);
            this._sourceMetaModelNames.put(mmName, mmUri);
        }
        return lookupPackage;
    }

    public EPackage lookupAndAddTargetMetaModel(String mmName, String mmUri, String typePrefix) {
        EPackage lookupPackage = this.lookupResourceMetaModel(mmUri);
        if (lookupPackage != null) {
            this._targetMetaModels.put(mmUri, lookupPackage);
            this._targetMetaModelNames.put(mmName, mmUri);
            this._outputModelParamTypes.put(mmName, typePrefix);
        }
        return lookupPackage;
    }

    protected void lookupAndAddMetaModel(MOFScriptParameter p) {
        if (p.getDirection() == ParameterDirection.IN_LITERAL) {
            this.lookupAndAddSourceMetaModel(p.getName(), p.getType());
        } else if (p.getDirection() == ParameterDirection.OUT_LITERAL) {
            this.lookupAndAddTargetMetaModel(p.getName(), p.getType(), p.getTypePrefix());
        }
    }

    public void lookupAndAddSourceMetaModelsFromParameterList(List paramList) {
        this.clearSourceMetaModels();
        for (MOFScriptParameter param : paramList) {
            this.lookupAndAddMetaModel(param);
        }
    }

    protected void addSourceModelResource(String metamodelRef, Resource res) {
        if (res != null) {
            EList contents = res.getContents();
            if (contents != null && contents.size() > 0) {
                EObject e = (EObject)contents.get(0);
                e.eAllContents();
                e.eContents();
                this._sourceModels.put(metamodelRef, e);
            }
        } else {
            this._executionStack.notifyOutputMessage("#Error in source model loading: Resource is null.");
        }
    }

    public void addSourceModel(EObject model) {
        if (this._executionOccured) {
            this.clearSourceModels();
            this._executionOccured = false;
        }
        String metaModelRef = this.getSourceMetaModelName(this._sourceModels.size());
        this._sourceModels.put(metaModelRef, model);
    }

    public EPackage getDefaultMetaModel() {
        if (this._sourceMetaModels.elements().hasMoreElements()) {
            return this._sourceMetaModels.elements().nextElement();
        }
        return null;
    }

    public EPackage getMetaModel(String name) {
        EPackage mm = this.getSourceMetaModel(name);
        if (mm == null) {
            mm = this.getTargetMetaModel(name);
        }
        return mm;
    }

    public EPackage getSourceMetaModel(String name) {
        String mmName = this._sourceMetaModelNames.get(name);
        if (mmName != null) {
            return this._sourceMetaModels.get(mmName);
        }
        return null;
    }

    public EPackage getTargetMetaModel(String name) {
        String mmName = this._targetMetaModelNames.get(name);
        if (mmName != null) {
            return this._targetMetaModels.get(mmName);
        }
        return null;
    }

    public String getSourceMetaModelName(int index) {
        MOFScriptParameter param;
        EList paramList = this._transformationProxy.getTransformation().getParameters();
        if (paramList.size() > index && (param = (MOFScriptParameter)paramList.get(index)) != null) {
            return param.getName();
        }
        return "";
    }

    public EObject getSourceModel(String metaModelRef) {
        return this._sourceModels.get(metaModelRef);
    }

    public void executeTransformation() throws MofScriptExecutionException {
        block22: {
            this._executionOccured = true;
            if (this._transformationProxy == null) {
                throw new MofScriptExecutionException("No Transformation Model defined.", "", 0);
            }
            if (this._sourceMetaModels.size() == 0 && this._targetMetaModels.size() == 0) {
                throw new MofScriptExecutionException("No Source or Target Meta Models defined", "", 0);
            }
            if (this._sourceMetaModels.size() > 0 && this._sourceModels.size() < this._sourceMetaModels.size()) {
                throw new MofScriptExecutionException("Missing Source Models.", "", 0);
            }
            this._executionStack.clearAll();
            this._outputModels.clear();
            this._rootEnv = MofScriptExecuterFactory.createExecutionEnvironment();
            this._rootEnv.setRootDirectory(this._rootDir);
            this._rootEnv.setUseLog(this._useLog);
            this._rootEnv.setOwnerStack(this._executionStack);
            ExecutionEnvironment.resetBlockCounter();
            this._executionStack.pushEnvironment(this._rootEnv);
            this._rootEnv.notifyMessage("## Starting transformation: \"" + this._transformationProxy.getName() + "\"\n");
            EList globalVariables = this._transformationProxy.getTransformation().getVariables();
            this._rootEnv.addModelVariables((List<VariableDeclaration>)globalVariables);
            List importedVars = this._transformationProxy.getAllImportedVariables();
            this._rootEnv.addModelVariables(importedVars);
            EList transformationParameters = this._transformationProxy.getTransformation().getParameters();
            Iterator it = transformationParameters.iterator();
            while (it.hasNext()) {
                EPackage metaModel = null;
                EObject inputModel = null;
                try {
                    MOFScriptParameter param = (MOFScriptParameter)it.next();
                    metaModel = this.getMetaModel(param.getName());
                    if (param.getDirection() == ParameterDirection.IN_LITERAL) {
                        inputModel = this.getSourceModel(param.getName());
                    } else if (param.getDirection() == ParameterDirection.OUT_LITERAL) {
                        String metaModelElement = this.getMetamodelForParam(param.getName());
                        if (metaModelElement != null) {
                            String[] split = metaModelElement.split("\\.");
                            String mmType = split[split.length - 1];
                            EClass cl = (EClass)this.getClassifierForPackage(metaModel, mmType);
                            inputModel = metaModel.getEFactoryInstance().create(cl);
                            Resource tmpResource = MofScriptExecuterFactory.createResource(URI.createFileURI((String)""), inputModel);
                            tmpResource.getContents().add((Object)inputModel);
                        } else {
                            inputModel = EcoreUtil.create((EClass)metaModel.eClass());
                        }
                        if (inputModel != null) {
                            this._sourceModels.put(param.getName(), inputModel);
                        }
                    }
                    Variable var = new Variable();
                    var.name = param.getName();
                    var.type = String.valueOf(param.getName()) + "." + inputModel.eClass().getName();
                    var.value = inputModel;
                    this._rootEnv.addVariable(var);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this._rootEnv.setUseFileModel(this._useFileModel);
            try {
                try {
                    TransformationRule entryPoint = this._transformationProxy.getEntryPoint();
                    if (entryPoint != null) {
                        this.startTransformation(entryPoint);
                        break block22;
                    }
                    this._rootEnv.notifyMessage("#Runtime info# No entry point defined. No execution.\n");
                }
                catch (MofScriptExecutionException mttex) {
                    this._rootEnv.notifyError("#Runtime Error# " + mttex.getMessage(), mttex.getExpression());
                    if (this._useFileModel) {
                        this._fileModel = this._rootEnv.getFileModel();
                    }
                    this._rootEnv.storeFiles();
                    if (this._useTraceability) {
                        ((TraceabilityEnvironment)this._rootEnv).storeTraceablityModel(this._traceDir);
                        TraceabilityEnvironment.resetTraceCounter();
                        TraceabilityEnvironment.cleanTraceEnv();
                        this._rootEnv.notifyMessage("\n## Trace model stored: " + this._traceDir);
                    }
                    this._rootEnv.notifyMessage("\n## Finished transformation: \"" + this._transformationProxy.getName() + "\"\n");
                    this.addOutputModels();
                    this._executionStack.popEnvironment();
                    this._rootEnv.clean();
                    this._executionStack.safeClear();
                    this._rootEnv = null;
                }
            }
            finally {
                if (this._useFileModel) {
                    this._fileModel = this._rootEnv.getFileModel();
                }
                this._rootEnv.storeFiles();
                if (this._useTraceability) {
                    ((TraceabilityEnvironment)this._rootEnv).storeTraceablityModel(this._traceDir);
                    TraceabilityEnvironment.resetTraceCounter();
                    TraceabilityEnvironment.cleanTraceEnv();
                    this._rootEnv.notifyMessage("\n## Trace model stored: " + this._traceDir);
                }
                this._rootEnv.notifyMessage("\n## Finished transformation: \"" + this._transformationProxy.getName() + "\"\n");
                this.addOutputModels();
                this._executionStack.popEnvironment();
                this._rootEnv.clean();
                this._executionStack.safeClear();
                this._rootEnv = null;
            }
        }
    }

    private void addOutputModels() {
        EList transformationParameters = this._transformationProxy.getTransformation().getParameters();
        Iterator it = transformationParameters.iterator();
        while (it.hasNext()) {
            try {
                Object value;
                Variable var;
                MOFScriptParameter param = (MOFScriptParameter)it.next();
                if (param.getDirection() != ParameterDirection.OUT_LITERAL || (var = this._rootEnv.getVariable(param.getName())) == null || !((value = var.getValue()) instanceof EObject)) continue;
                this._outputModels.add((EObject)value);
            }
            catch (Exception exception) {}
        }
    }

    public FileResourcesType getFileModel() {
        return this._fileModel;
    }

    public Vector getProducedResources() {
        return this._executionStack.getProducedResources();
    }

    private Object startTransformation(TransformationRule rule) throws MofScriptExecutionException {
        MOFScriptParameter ruleContext = rule.getContext();
        RuleExecutor rExec = null;
        rExec = this.getUseTraceability() ? new TraceabilityRuleExecutor(rule, this) : new RuleExecutor(rule, this);
        this._rootEnv.evaluateVariables(rExec);
        ExecutionEnvironment env = null;
        String[] typeSplit = ruleContext.getType().split("\\.");
        String metaModelRef = "";
        if (typeSplit.length > 1) {
            metaModelRef = typeSplit[0];
        }
        EClass contextType = this.findSourceMetaModelConcept(metaModelRef, typeSplit[typeSplit.length - 1]);
        Collection<Object> inputObjects = new ArrayList<EObject>();
        EObject sourceModel = this._sourceModels.get(metaModelRef);
        EClass sourceModelEClass = null;
        if (sourceModel != null) {
            sourceModelEClass = sourceModel.eClass();
        }
        if (contextType == null || sourceModelEClass == null) {
            inputObjects.add(sourceModel);
        } else if (contextType.equals(sourceModelEClass) || contextType.getName().equalsIgnoreCase(sourceModelEClass.getName())) {
            inputObjects.add(sourceModel);
        } else if (sourceModel != null) {
            inputObjects = this.getObjectsByType(sourceModel.eAllContents(), contextType);
        }
        Object result = null;
        Iterator it = inputObjects.iterator();
        while (it.hasNext()) {
            env = MofScriptExecuterFactory.createExecutionEnvironment();
            this._executionStack.pushEnvironment(env);
            env.addInputObject(ruleContext.getName(), it.next());
            rExec.setExecutionEnvironment(env);
            result = rExec.executeRule();
            this._executionStack.popEnvironment();
        }
        return result;
    }

    protected Collection getObjectsByType(TreeIterator treeIt, EClass type) {
        ArrayList<Object> theObjects = new ArrayList<Object>();
        while (treeIt.hasNext()) {
            Object o = treeIt.next();
            if (!(o instanceof EObject) || !type.isInstance(o)) continue;
            theObjects.add(o);
        }
        return theObjects;
    }

    public static String getObjectAttributeValue(EObject object, String featureName) {
        EClass eclazz = object.eClass();
        EList elizt = eclazz.getEAllAttributes();
        for (EAttribute eattr : elizt) {
            if (!eattr.getName().equalsIgnoreCase(featureName)) continue;
            Object value = object.eGet((EStructuralFeature)eattr);
            return value.toString();
        }
        return "";
    }

    public static String getObjectNameValue(EObject object) {
        return ExecutionManager.getObjectAttributeValue(object, "name");
    }

    public Class<?> getFeatureForName(String featureName) {
        EPackage sourceMetaModel = this._sourceMetaModels.elements().nextElement();
        return this.createFeatureFromName(featureName, sourceMetaModel);
    }

    public Class<?> createFeatureFromName(String featureName, EPackage metamodel) {
        Class<?> retval = null;
        EClassifier classifier = this.getClassifierForPackage(metamodel, featureName);
        if (classifier != null && (retval = classifier.getInstanceClass()) == null) {
            retval = classifier.getClass();
        }
        return retval;
    }

    public static List getMMTokens(EPackage metaModel) {
        ArrayList<Object> retval = new ArrayList<Object>();
        OurSwitch sw = new OurSwitch();
        TreeIterator iter = EcoreUtil.getAllContents(Collections.singleton(metaModel));
        while (iter.hasNext()) {
            EObject iterobj = (EObject)iter.next();
            Object o = sw.doSwitch(iterobj);
            if (o == null) continue;
            retval.add(o);
        }
        return retval;
    }

    public List getSourceMMTokens() {
        EPackage sourceMM = this._sourceMetaModels.elements().nextElement();
        return ExecutionManager.getMMTokens(sourceMM);
    }

    public EClass findMetaModelConcept(String metaModelName, String concept) {
        EClass cl = this.findSourceMetaModelConcept(metaModelName, concept);
        if (cl == null) {
            cl = this.findTargetMetaModelConcept(metaModelName, concept);
        }
        return cl;
    }

    public EClass findSourceMetaModelConcept(String metaModelName, String concept) {
        EPackage metaModel = null;
        if (metaModelName == null || metaModelName.equals("")) {
            metaModel = this.getDefaultMetaModel();
        }
        if ((metaModel = metaModelName.equalsIgnoreCase("ecore") ? this.getEcoreMetaModel() : this.getSourceMetaModel(metaModelName)) != null) {
            return this.findMetaModelConcept(metaModel, concept);
        }
        return null;
    }

    public EClass findTargetMetaModelConcept(String metaModelName, String concept) {
        EPackage metaModel = null;
        if (metaModelName == null || metaModelName.equals("")) {
            metaModel = this.getDefaultMetaModel();
        }
        if ((metaModel = this.getTargetMetaModel(metaModelName)) != null) {
            return this.findMetaModelConcept(metaModel, concept);
        }
        return null;
    }

    private EClass findMetaModelConcept(EPackage model, String concept) {
        EClass clazzifier = (EClass)this.getClassifierForPackage(model, concept);
        return clazzifier;
    }

    public Vector<EObject> getMetaModelConcept(String concept) {
        Vector<EObject> typeAndPackage = new Vector<EObject>();
        EClassifier classifier = null;
        for (EPackage ep : this._sourceMetaModels.values()) {
            classifier = ep.getEClassifier(concept);
            if (classifier == null || !(classifier instanceof EClass)) continue;
            typeAndPackage.add((EObject)classifier);
            typeAndPackage.add((EObject)ep);
        }
        for (EPackage ep : this._targetMetaModels.values()) {
            classifier = ep.getEClassifier(concept);
            if (classifier == null || !(classifier instanceof EClass)) continue;
            typeAndPackage.add((EObject)classifier);
            typeAndPackage.add((EObject)ep);
        }
        return typeAndPackage;
    }

    public EStructuralFeature findFeatureForSourceConcept(String metaModel, String metamodelconcept, String feature) {
        EStructuralFeature feature_lookup = null;
        EClass clazz = this.findSourceMetaModelConcept(metaModel, metamodelconcept);
        if (clazz == null) {
            clazz = this.findTargetMetaModelConcept(metaModel, metamodelconcept);
        }
        if (clazz != null) {
            feature_lookup = ExecutionManager.getFeatureForClass(clazz, feature);
        }
        return feature_lookup;
    }

    public EStructuralFeature findFeatureForEcoreConcept(String ecoreConcept, String feature) {
        EStructuralFeature feature_lookup = null;
        EClass clazz = (EClass)this._ecorePackage.getEClassifier(ecoreConcept);
        if (clazz != null) {
            feature_lookup = clazz.getEStructuralFeature(feature);
        }
        return feature_lookup;
    }

    public EStructuralFeature findFeatureForSourceRootConcept_1002(String metamodelName, String feature) {
        EPackage sourceMM = this.getSourceMetaModel(metamodelName);
        if (sourceMM == null) {
            System.out.println("ExecutionManager::findFeatureForSourceRootConcept - Could not resolve metamodel: " + metamodelName);
        }
        return null;
    }

    public EStructuralFeature findFeatureForTargetConcept(String metaModel, String metamodelconcept, String feature) {
        EStructuralFeature feature_lookup = null;
        EClass clazz = this.findTargetMetaModelConcept(metaModel, metamodelconcept);
        if (clazz != null) {
            feature_lookup = clazz.getEStructuralFeature(feature);
            feature_lookup = ExecutionManager.getFeatureForClass(clazz, feature);
        }
        return feature_lookup;
    }

    protected Map getRulesForConcept(String concept) {
        Collection<TransformationRule> trRules;
        TreeMap<String, String> rules = new TreeMap<String, String>();
        if (this._transformationProxy != null && (trRules = this._transformationProxy.getTransformationRules()) != null) {
            for (TransformationRule rule : trRules) {
                if (!this.ruleIsForConcept(rule, concept)) continue;
                rules.put(rule.getName(), String.valueOf(rule.getName()) + "()");
            }
        }
        return rules;
    }

    public List getAllRulesForConcept(String concept) {
        Map conceptTransformations = null;
        conceptTransformations = this.getRulesForConcept(concept);
        TransformationRule rule2 = null;
        Collection<TransformationRule> importedRules = null;
        if (this._transformationProxy != null) {
            importedRules = this._transformationProxy.getAllImportedTransformationRules();
            for (TransformationRule rule2 : importedRules) {
                if (!this.ruleIsForConcept(rule2, concept)) continue;
                conceptTransformations.put(rule2.getName(), String.valueOf(rule2.getName()) + "()");
            }
        }
        return new ArrayList(conceptTransformations.values());
    }

    protected boolean ruleIsForConcept(TransformationRule r, String concept) {
        String[] conceptArray = null;
        String[] ruleArray = null;
        if (r.getContext() != null) {
            ruleArray = r.getContext().getType().split("\\.");
        }
        EClass ruleType = null;
        EClass conceptType = null;
        if (ruleArray.length > 0) {
            conceptArray = concept.split("\\.");
            concept = conceptArray[conceptArray.length - 1];
            String metaModel = "";
            if (conceptArray.length > 1) {
                metaModel = conceptArray[0];
            }
            conceptType = this.findSourceMetaModelConcept(metaModel, concept);
            String ruleMetaModel = "";
            if (ruleArray.length > 1) {
                ruleMetaModel = ruleArray[0];
            }
            ruleType = this.findSourceMetaModelConcept(ruleMetaModel, ruleArray[ruleArray.length - 1]);
            if (conceptType != null && ruleType != null) {
                return conceptType.isSuperTypeOf(ruleType);
            }
        }
        return false;
    }

    public EClassifier getMetaModelReference(String refName) {
        String[] typeSplit = refName.split("\\.");
        String mmref = typeSplit[0];
        if (typeSplit.length == 1) {
            mmref = "";
        }
        String mmtype = typeSplit[typeSplit.length - 1];
        EClassifier clazz = null;
        if (mmref.equalsIgnoreCase("ecore")) {
            clazz = this._ecorePackage.getEClassifier(mmtype);
        } else {
            clazz = this.findSourceMetaModelConcept(mmref, mmtype);
            if (clazz == null) {
                clazz = this.findTargetMetaModelConcept(mmref, mmtype);
            }
        }
        return clazz;
    }

    public static List getFeaturesForClass(EClass clazz) {
        Object featureList = null;
        EList l = clazz.getEAllStructuralFeatures();
        featureList = l;
        if (clazz.getEAllSuperTypes().iterator().hasNext()) {
            EClass topType = (EClass)clazz.getEAllSuperTypes().iterator().next();
            EList topFeatures = null;
            if (topType.eIsProxy()) {
                EClass proxy = (EClass)EcoreUtil.resolve((EObject)topType, (Resource)topType.eResource());
                topFeatures = proxy.getEAllStructuralFeatures();
                featureList = new ArrayList();
                featureList.addAll(topFeatures);
                featureList.addAll(l);
            } else {
                featureList = l;
            }
        }
        return featureList;
    }

    public static EStructuralFeature getFeatureForClass(EClass clazz, String feature) {
        EClass topType;
        EStructuralFeature theFeature = null;
        theFeature = clazz.getEStructuralFeature(feature);
        if (theFeature == null && clazz.getEAllSuperTypes().iterator().hasNext() && (topType = (EClass)clazz.getEAllSuperTypes().iterator().next()).eIsProxy()) {
            EClass proxy = (EClass)EcoreUtil.resolve((EObject)topType, (Resource)topType.eResource());
            theFeature = proxy.getEStructuralFeature(feature);
        }
        return theFeature;
    }

    public List getAllClassifiersForSourceMetaModel(String metaModel) {
        EPackage sourceMM = this.getSourceMetaModel(metaModel);
        if (sourceMM != null) {
            return this.getAllClassifiersForPackage(sourceMM);
        }
        return new ArrayList();
    }

    public List getAllClassifiersForMetaModel(String metaModel) {
        EPackage mm = this.getSourceMetaModel(metaModel);
        if (mm == null) {
            mm = this.getTargetMetaModel(metaModel);
        }
        if (mm != null) {
            return this.getAllClassifiersForPackage(mm);
        }
        return new ArrayList();
    }

    public List getAllClassifiersForPackage(EPackage pkg) {
        ArrayList allClassifiers = new ArrayList();
        allClassifiers.addAll(pkg.getEClassifiers());
        EList subs = pkg.getESubpackages();
        EPackage sub2 = null;
        for (EPackage sub2 : subs) {
            allClassifiers.addAll(this.getAllClassifiersForPackage(sub2));
        }
        return allClassifiers;
    }

    public EClassifier getClassifierForPackage(EPackage pkg, String clazzifierName) {
        if (clazzifierName == null || pkg == null) {
            return null;
        }
        EClassifier clazzifier = null;
        EClass clazz = null;
        clazzifier = pkg.getEClassifier(clazzifierName);
        if (clazzifier instanceof EClass) {
            clazz = (EClass)clazzifier;
        }
        if (clazz == null) {
            EList subs = pkg.getESubpackages();
            EPackage sub2 = null;
            for (EPackage sub2 : subs) {
                clazz = (EClass)this.getClassifierForPackage(sub2, clazzifierName);
                if (clazz != null) break;
            }
        }
        return clazz;
    }

    public Object getRealObject(Object mightBeProxy) {
        if (mightBeProxy instanceof EObject) {
            EObject var = (EObject)mightBeProxy;
            var.eClass();
            EObject proxy = null;
            if (var.eIsProxy()) {
                proxy = EcoreUtil.resolve((EObject)var, (Resource)var.eResource());
                proxy = EcoreUtil.resolve((EObject)var, (ResourceSet)this.getResourceSet());
                if (proxy != null && proxy != mightBeProxy) {
                    mightBeProxy = proxy;
                }
            }
        }
        return mightBeProxy;
    }

    public static Set getAllSuperRules(MOFScriptTransformation transformation) {
        if (transformation == null) {
            return new HashSet();
        }
        if (transformation.getExtends() == null) {
            return new HashSet();
        }
        MOFScriptTransformation theExtends = transformation.getExtends();
        HashSet toReturn = new HashSet();
        if (theExtends.getExtends() != null) {
            Set tmpSet = ExecutionManager.getAllSuperRules(theExtends);
            toReturn.addAll(tmpSet);
        }
        toReturn.addAll(theExtends.getTransformationrules());
        return toReturn;
    }

    public static Set getAllSuperRuleNames(MOFScriptTransformation transformation) {
        if (transformation == null) {
            return new HashSet();
        }
        if (transformation.getExtends() == null) {
            return new HashSet();
        }
        MOFScriptTransformation theExtends = transformation.getExtends();
        HashSet<String> toReturn = new HashSet<String>();
        if (theExtends.getExtends() != null) {
            Set tmpSet = ExecutionManager.getAllSuperRuleNames(theExtends);
            toReturn.addAll(tmpSet);
        }
        EList rules = theExtends.getTransformationrules();
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            toReturn.add(((TransformationRule)it.next()).getName());
        }
        return toReturn;
    }

    protected void registerExternalResources() {
        this.registerUML2Resources();
        this.registerNotationPackages();
    }

    protected void registerUML2Resources() {
        try {
            Class<?> uml2Class = Class.forName("org.eclipse.uml2.uml.UML2Package");
            this.registerAnonymousPackage(uml2Class);
            Class<?> uml2resourceClass = Class.forName("org.eclipse.uml2.uml.util.UML2Resource");
            Class<?> uml2ResourceFactory = null;
            try {
                Field fileExtensionField = uml2resourceClass.getField("FILE_EXTENSION");
                Class<?>[] clazzes = uml2resourceClass.getDeclaredClasses();
                int i = 0;
                while (i < clazzes.length) {
                    if (clazzes[i].getName().equals("org.eclipse.uml2.uml.util.UML2Resource$Factory")) {
                        uml2ResourceFactory = clazzes[i];
                    }
                    ++i;
                }
                Field factoryInstanceField = uml2ResourceFactory.getField("INSTANCE");
                Object fileExtesionVal = null;
                Object factoryVal = null;
                try {
                    fileExtesionVal = fileExtensionField.get(null);
                    factoryVal = factoryInstanceField.get(null);
                    this._fileResources.getResourceFactoryRegistry().getExtensionToFactoryMap().put((String)fileExtesionVal, factoryVal);
                    this._fileResources.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emx", factoryVal);
                    this._fileResources.getResourceFactoryRegistry().getExtensionToFactoryMap().put("epx", factoryVal);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    protected void registerNotationPackages() {
        try {
            Class<?> notationClass = Class.forName("com.ibm.xtools.notation.NotationPackage");
            Class<?> umlnotationClass = Class.forName("com.ibm.xtools.umlnotation.UmlnotationPackage");
            this.registerAnonymousPackage(notationClass);
            this.registerAnonymousPackage(umlnotationClass);
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    protected void registerAnonymousPackage(Class toRegister) {
        try {
            Field eInstanceField = toRegister.getField("eINSTANCE");
            Field eNS_URIFIeld = toRegister.getField("eNS_URI");
            Object instanceVal = null;
            Object eNS_URIVal = null;
            instanceVal = eInstanceField.get(null);
            eNS_URIVal = eNS_URIFIeld.get(null);
            this._fileResources.getPackageRegistry().put((Object)((String)eNS_URIVal), instanceVal);
        }
        catch (Exception exception) {}
    }

    protected boolean checkRSAAvailability() {
        this._rsaIsAvailable = false;
        String rsaModellerClass = "com.ibm.xtools.modeler.UMLModeler";
        try {
            this.messageEvent("\t Looking for RSA availability...");
            Class.forName(rsaModellerClass);
            this._rsaIsAvailable = true;
            this.messageEvent("\t RSA present.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.messageEvent("\t RSA not present");
        }
        return this._rsaIsAvailable;
    }

    protected EObject loadRSAModel(File srcFile) {
        EObject model;
        block9: {
            String rsaModellerClass = "com.ibm.xtools.modeler.UMLModeler";
            model = null;
            try {
                String path = srcFile.getAbsolutePath();
                URI fileUri = URI.createFileURI((String)path);
                Class<?> rsaModeller = Class.forName(rsaModellerClass);
                Class[] parameterTypes = new Class[]{URI.class};
                Object result = null;
                Object[] params = new Object[]{fileUri};
                try {
                    Method m = rsaModeller.getMethod("openModel", parameterTypes);
                    result = m.invoke(null, params);
                    if (result instanceof EObject) {
                        model = (EObject)result;
                        break block9;
                    }
                    if (result != null) {
                        this._executionStack.notifyOutputMessage("\t Invoked RSA loadModel - got result which is not EObject: " + result.getClass().getName());
                        break block9;
                    }
                    this._executionStack.notifyOutputMessage("\t Invoked RSA loadModel - got NULL.");
                }
                catch (NoSuchMethodException nsmex) {
                    this._executionStack.notifyOutputMessage("\t Could not find RSA method 'openModel' - " + nsmex);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._executionStack.notifyOutputMessage("\t Error loading RSA classes");
            }
            catch (Exception exception) {}
        }
        return model;
    }

    private void loadUML2Model(File sourceFile, String metamodel) {
        Resource res = null;
        String path = sourceFile.getAbsolutePath();
        URI fileUri = URI.createFileURI((String)path);
        ResourceSetImpl rSet = new ResourceSetImpl();
        res = rSet.getResource(fileUri, true);
        try {
            this.resolveAll(res);
        }
        catch (Exception exception) {}
        this.addSourceModelResource(metamodel, res);
    }

    private void resolveAll(Resource res) {
        Class[] methodArgTypes = new Class[]{Resource.class};
        Object[] methodArgs = new Object[]{res};
        Method m = null;
        try {
            m = EcoreUtil.class.getDeclaredMethod("resolveAll", methodArgTypes);
            m.invoke(null, methodArgs);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    protected MOFScriptTransformation getMofScriptTransformation(String fileUri) {
        String transformationResourceName = fileUri;
        Resource resource = null;
        MOFScriptTransformation transformation = null;
        URL trURL = this.getClass().getResource("transformations/" + transformationResourceName);
        URI uri2 = URI.createURI((String)trURL.toString());
        resource = this._fileResources.getResource(uri2, true);
        MOFScriptSpecification transformationSpec = null;
        EList contents = resource.getContents();
        if (contents != null && contents.size() > 0) {
            transformationSpec = (MOFScriptSpecification)contents.get(0);
        }
        if (transformationSpec != null) {
            transformation = (MOFScriptTransformation)transformationSpec.getTransformation().get(0);
        }
        return transformation;
    }

    public MOFScriptTransformation getMofScript2TextTransformation() {
        return this.getMofScriptTransformation("MofScript2Text.m2t.model.mofscript");
    }

    public MOFScriptTransformation getMofScriptAspectTransformation() {
        return this.getMofScriptTransformation("AspectTransformation.m2t.model.mofscript");
    }

    public void messageEvent(String message) {
        this._executionStack.notifyOutputMessage("##    " + message);
    }

    public void addOutModelTypeMap(String outParam, String metaModelType) {
        this._outputModelParamTypes.put(outParam, metaModelType);
    }

    public void clearModelTypeMap() {
        this._outputModelParamTypes.clear();
    }

    private String getMetamodelForParam(String paramName) {
        return this._outputModelParamTypes.get(paramName);
    }

    public Collection<EObject> getOutputModels() {
        return this._outputModels;
    }
}

