/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime;

import java.lang.reflect.Constructor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mofscript.MOFScriptModel.ArithmeticExpression;
import org.eclipse.mofscript.MOFScriptModel.BreakStatement;
import org.eclipse.mofscript.MOFScriptModel.ComparisonExpression;
import org.eclipse.mofscript.MOFScriptModel.CreateExpression;
import org.eclipse.mofscript.MOFScriptModel.DebugStatement;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.FileStatement;
import org.eclipse.mofscript.MOFScriptModel.FunctionCall;
import org.eclipse.mofscript.MOFScriptModel.FunctionCallStatement;
import org.eclipse.mofscript.MOFScriptModel.GeneralAssignment;
import org.eclipse.mofscript.MOFScriptModel.IfStatement;
import org.eclipse.mofscript.MOFScriptModel.IteratorStatement;
import org.eclipse.mofscript.MOFScriptModel.Literal;
import org.eclipse.mofscript.MOFScriptModel.LogicalExpression;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.MOFScriptModel.PrintStatement;
import org.eclipse.mofscript.MOFScriptModel.Reference;
import org.eclipse.mofscript.MOFScriptModel.ResultAssignment;
import org.eclipse.mofscript.MOFScriptModel.ReturnStatement;
import org.eclipse.mofscript.MOFScriptModel.SelectExpression;
import org.eclipse.mofscript.MOFScriptModel.VariableDeclarationStatement;
import org.eclipse.mofscript.MOFScriptModel.WhileStatement;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.expression.ArithmeticExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.ComparisonExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.CreateExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.FunctionCallEvaluator;
import org.eclipse.mofscript.runtime.expression.LiteralEvaluator;
import org.eclipse.mofscript.runtime.expression.LogicalExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.NullEvaluator;
import org.eclipse.mofscript.runtime.expression.ReferenceEvaluator;
import org.eclipse.mofscript.runtime.expression.SelectExpressionEvaluator;
import org.eclipse.mofscript.runtime.statement.BreakStatementExecutor;
import org.eclipse.mofscript.runtime.statement.DebugStatementExecutor;
import org.eclipse.mofscript.runtime.statement.FileStatementExecutor;
import org.eclipse.mofscript.runtime.statement.FunctionCallStatementExecutor;
import org.eclipse.mofscript.runtime.statement.GeneralAssignmentExecutor;
import org.eclipse.mofscript.runtime.statement.IfStatementExecutor;
import org.eclipse.mofscript.runtime.statement.IteratorStatementExecutor;
import org.eclipse.mofscript.runtime.statement.PrintStatementExecutor;
import org.eclipse.mofscript.runtime.statement.ResultAssignmentExecutor;
import org.eclipse.mofscript.runtime.statement.ReturnStatementExecutor;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;
import org.eclipse.mofscript.runtime.statement.VariableDeclarationStatementExecutor;
import org.eclipse.mofscript.runtime.statement.WhileStatementExecutor;
import org.eclipse.mofscript.runtime.traceability.TraceabilityEnvironment;
import org.eclipse.mofscript.runtime.traceability.TraceabilityGenAssignmentExec;
import org.eclipse.mofscript.runtime.traceability.TraceabilityReferenceEvaluator;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;

public class MofScriptExecuterFactory {
    protected static final String umlFunctionCallClassName = "org.eclipse.mofscript.runtime.uml2Extensions.UMLFunctionCallEvaluator";
    protected static final String umlTraceabilityFunctionCallClassName = "org.eclipse.mofscript.runtime.uml2Extensions.UMLTraceabilityFunctionCallEvaluator";
    static boolean traceOn = false;
    static boolean umlAvailable = ExecutionManager.getExecutionManager().getUMLIsAvailable();

    public static StatementExecutor createStatementExecutor(MOFScriptStatement statement, ExecutionEnvironment env, RuleExecutor ownerRuleExecutor) {
        if (statement instanceof ResultAssignment) {
            return new ResultAssignmentExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof GeneralAssignment) {
            if (ExecutionManager.getExecutionManager().getUseTraceability()) {
                return new TraceabilityGenAssignmentExec(statement, env, ownerRuleExecutor);
            }
            return new GeneralAssignmentExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof IteratorStatement) {
            return new IteratorStatementExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof FileStatement) {
            return new FileStatementExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof PrintStatement) {
            return new PrintStatementExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof FunctionCallStatement) {
            return new FunctionCallStatementExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof IfStatement) {
            return new IfStatementExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof BreakStatement) {
            return new BreakStatementExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof WhileStatement) {
            return new WhileStatementExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof ReturnStatement) {
            return new ReturnStatementExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof VariableDeclarationStatement) {
            return new VariableDeclarationStatementExecutor(statement, env, ownerRuleExecutor);
        }
        if (statement instanceof DebugStatement) {
            return new DebugStatementExecutor(statement, env, ownerRuleExecutor);
        }
        return new StatementExecutor(statement, env, ownerRuleExecutor);
    }

    public static ExpressionEvaluator createExpressionExecutor(Expression exp, ExecutionEnvironment env, RuleExecutor ownerRuleExecutor) {
        if (exp == null) {
            return new NullEvaluator(exp, env, ownerRuleExecutor);
        }
        if (exp instanceof CreateExpression) {
            return new CreateExpressionEvaluator(exp, env, ownerRuleExecutor);
        }
        if (exp instanceof LogicalExpression) {
            return new LogicalExpressionEvaluator(exp, env, ownerRuleExecutor);
        }
        if (exp instanceof ComparisonExpression) {
            return new ComparisonExpressionEvaluator(exp, env, ownerRuleExecutor);
        }
        if (exp instanceof ArithmeticExpression) {
            return new ArithmeticExpressionEvaluator(exp, env, ownerRuleExecutor);
        }
        if (exp instanceof Reference) {
            if (!ExecutionManager.getExecutionManager().getUseTraceability()) {
                return new ReferenceEvaluator(exp, env, ownerRuleExecutor);
            }
            return new TraceabilityReferenceEvaluator(exp, env, ownerRuleExecutor);
        }
        if (exp instanceof Literal) {
            return new LiteralEvaluator(exp, env, ownerRuleExecutor);
        }
        if (exp instanceof LogicalExpression) {
            return new LogicalExpressionEvaluator(exp, env, ownerRuleExecutor);
        }
        if (exp instanceof FunctionCall) {
            if (umlAvailable && !ExecutionManager.getExecutionManager().getUseTraceability()) {
                FunctionCallEvaluator evaluator = null;
                try {
                    Class<?> cl = Class.forName(umlFunctionCallClassName);
                    Constructor<?> constructor = cl.getConstructors()[0];
                    Object[] parameters = new Object[]{exp, env, ownerRuleExecutor};
                    evaluator = (FunctionCallEvaluator)constructor.newInstance(parameters);
                }
                catch (Exception exception) {}
                if (evaluator == null) {
                    evaluator = new FunctionCallEvaluator(exp, env, ownerRuleExecutor);
                }
                return evaluator;
            }
            if (umlAvailable && ExecutionManager.getExecutionManager().getUseTraceability()) {
                FunctionCallEvaluator evaluator = null;
                try {
                    Class<?> cl = Class.forName(umlTraceabilityFunctionCallClassName);
                    Constructor<?> constructor = cl.getConstructors()[0];
                    Object[] parameters = new Object[]{exp, env, ownerRuleExecutor};
                    evaluator = (FunctionCallEvaluator)constructor.newInstance(parameters);
                }
                catch (Exception exception) {}
                if (evaluator == null) {
                    evaluator = new FunctionCallEvaluator(exp, env, ownerRuleExecutor);
                }
                return evaluator;
            }
            return new FunctionCallEvaluator(exp, env, ownerRuleExecutor);
        }
        if (exp instanceof SelectExpression) {
            return new SelectExpressionEvaluator(exp, env, ownerRuleExecutor);
        }
        return null;
    }

    public static ExecutionEnvironment createExecutionEnvironment() {
        try {
            if (ExecutionManager.getExecutionManager().getUseTraceability()) {
                return new TraceabilityEnvironment();
            }
            return new ExecutionEnvironment();
        }
        catch (Exception exception) {
            return new ExecutionEnvironment();
        }
    }

    public static Resource createResource(URI uri, EObject baseModelObject) {
        Resource res = null;
        if (umlAvailable && baseModelObject != null && baseModelObject instanceof Model) {
            res = UMLResourceFactoryImpl.INSTANCE.createResource(uri);
        } else {
            XMIResourceFactoryImpl xmiFac = new XMIResourceFactoryImpl();
            res = xmiFac.createResource(uri);
        }
        return res;
    }
}

