/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime;

import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.ExecutionMessageListener;

public class RuleExecutionStack {
    private Stack<ExecutionEnvironment> _envStack = new Stack();
    private Vector _resources = new Vector();
    private static Vector<ExecutionMessageListener> _outputMessageListeners = null;

    public RuleExecutionStack() {
        if (_outputMessageListeners == null) {
            _outputMessageListeners = new Vector();
        }
    }

    public void pushEnvironment(ExecutionEnvironment env) {
        if (this._envStack.size() > 0) {
            ExecutionEnvironment parent = this._envStack.peek();
            env.setParentEnvironment(parent);
        }
        this._envStack.push(env);
    }

    public ExecutionEnvironment popEnvironment() {
        if (this._envStack.isEmpty()) {
            return null;
        }
        ExecutionEnvironment cur = this._envStack.pop();
        return cur;
    }

    public Vector getProducedResources() {
        return this._resources;
    }

    public ExecutionEnvironment getCurrentEnvironment() {
        return this._envStack.peek();
    }

    public ExecutionEnvironment peekParent() {
        ExecutionEnvironment env = this._envStack.peek();
        return env;
    }

    public boolean isRootEnvironment() {
        return this._envStack.size() == 0;
    }

    public void clearAll() {
        this._envStack.removeAllElements();
        this._resources.removeAllElements();
    }

    public void safeClear() {
        while (this._envStack.size() > 0) {
            ExecutionEnvironment env = this._envStack.pop();
            env.clean();
        }
        this._resources.addAll(ExecutionEnvironment.getResources());
        ExecutionEnvironment.cleanResources();
    }

    public void synchronize(ExecutionEnvironment env) {
        ExecutionEnvironment topEnv = null;
        if (!this._envStack.isEmpty()) {
            topEnv = this._envStack.peek();
        }
        while (topEnv != null && topEnv != env && !this._envStack.isEmpty()) {
            topEnv = this._envStack.pop();
        }
    }

    public void addOutputMessageListener(ExecutionMessageListener listener) {
        if (!_outputMessageListeners.contains(listener)) {
            _outputMessageListeners.add(listener);
        }
    }

    public void removeOutputMessageListener(ExecutionMessageListener listener) {
        _outputMessageListeners.remove(listener);
    }

    public void clearOutputMessageListeners() {
        _outputMessageListeners.clear();
    }

    public void notifyOutputMessage(String notification) {
        Iterator<ExecutionMessageListener> it = _outputMessageListeners.iterator();
        while (it.hasNext()) {
            it.next().executionMessage("print", notification);
        }
    }
}

