/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mofscript.MOFScriptModel.AssignmentOperator;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptParameter;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.MOFScriptModel.StatementBlock;
import org.eclipse.mofscript.MOFScriptModel.TransformationRule;
import org.eclipse.mofscript.MOFScriptModel.VariableDeclaration;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecuter;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;

public class RuleExecutor
implements MofScriptExecuter {
    protected TransformationRule _rule = null;
    protected ExecutionEnvironment _env = null;
    protected static ExecutionManager _execMgr = null;
    protected Object rule_return_value = null;
    protected Hashtable _referenceCache = null;
    protected StatementBlock _aBlock = null;
    private boolean _doReturn = false;

    public RuleExecutor(TransformationRule rule, ExecutionManager execMgr) {
        this._rule = rule;
        if (_execMgr == null) {
            _execMgr = execMgr;
        }
        this._referenceCache = new Hashtable();
    }

    public static ExecutionManager getExecutionManager() {
        return _execMgr;
    }

    public Hashtable getReferenceCache() {
        return this._referenceCache;
    }

    public void setExecutionEnvironment(ExecutionEnvironment env) {
        this._env = env;
        this._env.addModelVariables((List<VariableDeclaration>)this._rule.getVariables());
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this._env;
    }

    public void setRuleReturnValue(Object value) {
        this.rule_return_value = value;
    }

    public Object getRuleReturnValue() {
        return this.rule_return_value;
    }

    public TransformationRule getRule() {
        return this._rule;
    }

    public Object executeRule() throws MofScriptExecutionException {
        if (this._rule == null) {
            throw new MofScriptExecutionException("No rule to execute - rule == NULL.", "", 0);
        }
        if (this._env == null) {
            throw new MofScriptExecutionException("No environment specified for rule: " + this._rule.getName(), this._rule.getName(), this._rule.getLine());
        }
        this._env.setUseParentCache(false);
        String rule_return = this._rule.getReturn();
        Class<?> rule_return_type = null;
        if (rule_return != null) {
            rule_return_type = this.getReturnObject(rule_return);
        }
        EList parameters = this._rule.getParameters();
        MOFScriptParameter ruleContext = this._rule.getContext();
        String[] typeSplit = ruleContext.getType().split("\\.");
        if (typeSplit.length > 1) {
            String cfr_ignored_0 = typeSplit[0];
        }
        MOFScriptParameter param = null;
        String paramName = null;
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            Variable var = new Variable();
            param = (MOFScriptParameter)it.next();
            var.name = paramName = param.getName();
            var.type = param.getType();
            this._env.setVariable(paramName, var);
            this._env.assignVariableValue(paramName, this._env.getInputObject(paramName), AssignmentOperator.EQ_LITERAL, null);
            this._env.clearInputObject(paramName);
        }
        ruleContext.getType();
        ruleContext.getTypePrefix();
        Object selfContext = this._env.getInputObject("self");
        String objectUri = "";
        if (selfContext != null) {
            EObject inputContext = null;
            inputContext = (EObject)selfContext;
            objectUri = RuleExecutor.getObjectId(inputContext);
        }
        EList blocks = this._rule.getBlocks();
        this._aBlock = null;
        MOFScriptStatement statement2 = null;
        for (StatementBlock this._aBlock : blocks) {
            if (!this._aBlock.isProtected()) {
                this._env.startUnprotectedBlock(objectUri);
            }
            for (MOFScriptStatement statement2 : this._aBlock.getStatements()) {
                StatementExecutor stExec = MofScriptExecuterFactory.createStatementExecutor(statement2, this._env, this);
                stExec.executeStatement(rule_return_type);
                ExecutionManager.getExecutionManager().getExecutionStack().synchronize(this._env);
                if (!this._doReturn) continue;
                return this.rule_return_value;
            }
            if (this._aBlock.isProtected()) continue;
            this._env.endUnprotectedBlock();
        }
        return this.rule_return_value;
    }

    public static String getObjectId(EObject obj) {
        String id = EcoreUtil.getIdentification((EObject)obj);
        int index = id.indexOf(35);
        if (index > -1) {
            id = id.substring(index + 1, id.length() - 1);
        }
        return id;
    }

    protected Class<?> getReturnObject(String rule_return) {
        Class rule_return_object = null;
        rule_return_object = rule_return != null && rule_return.equalsIgnoreCase("String") ? String.class : (rule_return != null && rule_return.equalsIgnoreCase("Integer") ? Integer.class : (rule_return != null && rule_return.equalsIgnoreCase("Real") ? Double.class : (rule_return != null && rule_return.equalsIgnoreCase("Boolean") ? Boolean.class : (rule_return != null && rule_return.equalsIgnoreCase("List") ? ArrayList.class : (rule_return != null && (rule_return.equalsIgnoreCase("Hashtable") || rule_return.equalsIgnoreCase("Dictionary")) ? Hashtable.class : _execMgr.getFeatureForName(rule_return))))));
        return rule_return_object;
    }

    protected void finalize() throws Throwable {
        try {
            this._referenceCache.clear();
            this._referenceCache = null;
        }
        finally {
            super.finalize();
        }
    }

    public StatementBlock getStatementBlock() {
        return this._aBlock;
    }

    public void notifyReturn(Object returnValue) {
        this._doReturn = true;
        this.rule_return_value = returnValue;
    }

    public boolean isReturning() {
        return this._doReturn;
    }
}

