/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mofscript.MOFScriptModel.FunctionCall;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptAspect;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptModelFactory;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptParameter;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptSpecification;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;
import org.eclipse.mofscript.MOFScriptModel.ParameterDirection;
import org.eclipse.mofscript.MOFScriptModel.TransformationRule;
import org.eclipse.mofscript.MOFScriptModel.VariableDeclaration;
import org.eclipse.mofscript.runtime.ExecutionManager;

public class TransformationProxy {
    private MOFScriptTransformation _transformation = null;
    private MOFScriptSpecification _specification = null;
    private Hashtable<String, TransformationProxy> _importedTransformations = null;
    private Hashtable<TransformationProxy, String> _importedTransformationUris = null;
    private Hashtable<String, Hashtable<String, TransformationRule>> _ruleCache = null;
    private TransformationProxy _theSuper = null;

    public TransformationProxy(MOFScriptTransformation realTrans) {
        this._transformation = realTrans;
        this.init();
    }

    public TransformationProxy(MOFScriptSpecification trSpec) {
        this.setTransformationSpecification(trSpec);
        this.init();
    }

    private void init() {
        this._importedTransformations = new Hashtable();
        this._importedTransformationUris = new Hashtable();
        this._ruleCache = new Hashtable();
        if (this._transformation.getExtends() != null) {
            this._theSuper = new TransformationProxy(this._transformation.getExtends());
        }
        this.setRuleCache();
        if (this._transformation.eContainer() != null && this._transformation.eContainer() instanceof MOFScriptSpecification) {
            this._specification = (MOFScriptSpecification)this._transformation.eContainer();
        } else {
            this._specification = MOFScriptModelFactory.eINSTANCE.createMOFScriptSpecification();
            this._specification.getTransformation().add((Object)this._transformation);
        }
        if (this._transformation instanceof MOFScriptAspect) {
            MOFScriptParameter sourceMMParam = ExecutionManager.getExecutionManager().getModelFactory().createMOFScriptParameter();
            sourceMMParam.setDirection(ParameterDirection.IN_LITERAL);
            sourceMMParam.setName("MOFScriptModel");
            sourceMMParam.setType("http://org.eclipse.mofscript.model");
            this._transformation.getParameters().add((Object)sourceMMParam);
            ExecutionManager.getExecutionManager().lookupAndAddSourceMetaModel("MOFScriptModel", "http://org.eclipse.mofscript.model");
        }
    }

    public MOFScriptTransformation getTransformation() {
        return this._transformation;
    }

    public MOFScriptSpecification getTransformationSpecification() {
        return this._specification;
    }

    public String getName() {
        return this._transformation.getName();
    }

    public TransformationRule getEntryPoint() {
        EList rules = this._transformation.getTransformationrules();
        for (TransformationRule r : rules) {
            if (!r.isIsEntryPoint()) continue;
            return r;
        }
        if (this._theSuper != null) {
            return this._theSuper.getEntryPoint();
        }
        return null;
    }

    private void setRuleCache() {
        TransformationRule theRule2 = null;
        String ruleKey = null;
        Hashtable<String, TransformationRule> newHash = null;
        String ruleName = null;
        for (TransformationRule theRule2 : this._transformation.getTransformationrules()) {
            ruleName = theRule2.getName();
            ruleKey = String.valueOf(this._transformation.getName()) + "." + theRule2.getContext().getType();
            if (this.hasRuleWithName(ruleName)) {
                this._ruleCache.get(ruleName).put(ruleKey, theRule2);
                continue;
            }
            newHash = new Hashtable<String, TransformationRule>();
            newHash.put(ruleKey, theRule2);
            this._ruleCache.put(ruleName, newHash);
        }
    }

    protected Hashtable<String, TransformationRule> getCompleteRuleCache(String ruleName) {
        Hashtable<String, TransformationRule> theRuleCache = new Hashtable<String, TransformationRule>();
        if (this._theSuper != null) {
            theRuleCache.putAll(this._theSuper.getCompleteRuleCache(ruleName));
        }
        if (this.hasRuleWithName(ruleName)) {
            theRuleCache.putAll((Map<String, TransformationRule>)this._ruleCache.get(ruleName));
        }
        return theRuleCache;
    }

    public void setTransformationSpecification(MOFScriptSpecification trSpec) {
        if (trSpec != null) {
            this._specification = trSpec;
            if (this._specification.getTransformation().size() > 0) {
                this._transformation = (MOFScriptTransformation)this._specification.getTransformation().get(0);
            }
        }
    }

    public boolean hasRuleWithName(String ruleName) {
        return this._ruleCache.containsKey(ruleName);
    }

    public boolean hasOtherRuleWithName(TransformationRule rule) {
        Hashtable<String, TransformationRule> rules = this._ruleCache.get(rule.getName());
        Iterator<TransformationRule> it = rules.values().iterator();
        while (it.hasNext()) {
            if (it.next() == rule) continue;
            return true;
        }
        return false;
    }

    public MOFScriptTransformation getClosestSuperWithRule(TransformationRule rule) {
        rule.getName();
        if (this._theSuper == null) {
            return this._transformation;
        }
        if (this._theSuper.hasRuleWithName(rule.getName())) {
            return this._theSuper.getTransformation();
        }
        return this._theSuper.getClosestSuperWithRule(rule);
    }

    public Collection<TransformationRule> getTransformationRules() {
        ArrayList<TransformationRule> rules = new ArrayList<TransformationRule>();
        if (this._theSuper != null) {
            rules.addAll(this._theSuper.getTransformationRules());
        }
        rules.addAll((Collection<TransformationRule>)this._transformation.getTransformationrules());
        return rules;
    }

    public TransformationRule getTransformationRule(String name) {
        if (this.hasRuleWithName(name)) {
            Hashtable<String, TransformationRule> rules = this._ruleCache.get(name);
            if (rules.size() > 0) {
                return rules.values().iterator().next();
            }
        } else {
            if (this._theSuper != null) {
                return this._theSuper.getTransformationRule(name);
            }
            Hashtable<String, TransformationRule> imported = this.getImportedTransformationRule(name);
            if (imported.size() > 0) {
                return imported.values().iterator().next();
            }
        }
        return null;
    }

    public Collection<TransformationRule> getAllTransformationRules(String name) {
        Hashtable<String, TransformationRule> imported;
        ArrayList<TransformationRule> rules = new ArrayList<TransformationRule>();
        if (this.hasRuleWithName(name)) {
            rules.addAll(this._ruleCache.get(name).values());
        } else if (this._theSuper != null) {
            rules.addAll(this._theSuper.getAllTransformationRules(name));
        }
        if (rules.isEmpty() && (imported = this.getImportedTransformationRule(name)).size() > 0) {
            rules.addAll(imported.values());
        }
        return rules;
    }

    public Collection<TransformationRule> getAllImportedTransformationRules() {
        ArrayList<TransformationRule> rules = new ArrayList<TransformationRule>();
        for (TransformationProxy trP : this._importedTransformations.values()) {
            rules.addAll(trP.getTransformationRules());
        }
        return rules;
    }

    public Hashtable<String, TransformationRule> getImportedTransformationRule(String name) {
        Hashtable<String, TransformationRule> ruleHash = new Hashtable<String, TransformationRule>();
        for (TransformationProxy trP : this._importedTransformations.values()) {
            Hashtable<String, TransformationRule> rules = trP.getCompleteRuleCache(name);
            ruleHash.putAll(rules);
        }
        return ruleHash;
    }

    public TransformationRule getImportedTransformationRule(String name, String possibleScoping, String ownerTransformation) {
        TransformationRule ruleToReturn = null;
        TransformationProxy trP = this._importedTransformations.get(ownerTransformation);
        if (trP != null) {
            ruleToReturn = trP.getTransformationRule(name);
        }
        if (ruleToReturn != null) {
            return ruleToReturn;
        }
        Enumeration<String> keyIt = this._importedTransformations.keys();
        while (keyIt.hasMoreElements()) {
            String trName = keyIt.nextElement();
            if (trName.equalsIgnoreCase(ownerTransformation) || (ruleToReturn = (trP = this._importedTransformations.get(trName)).getTransformationRule(name)) == null) continue;
            return ruleToReturn;
        }
        return null;
    }

    public MOFScriptTransformation getImportedTransformation(String name) {
        if (this._importedTransformations.containsKey(name)) {
            return this._importedTransformations.get(name).getTransformation();
        }
        return null;
    }

    public List getAllImportedVariables() {
        ArrayList<VariableDeclaration> importedVars = new ArrayList<VariableDeclaration>();
        Hashtable<String, VariableDeclaration> varHash = new Hashtable<String, VariableDeclaration>();
        MOFScriptTransformation trans = null;
        EList variables = null;
        VariableDeclaration varDecl2 = null;
        importedVars.addAll(this.getSuperVariables());
        Iterator<TransformationProxy> leIt = this._importedTransformations.values().iterator();
        while (leIt.hasNext()) {
            trans = leIt.next().getTransformation();
            variables = trans.getVariables();
            for (VariableDeclaration varDecl2 : variables) {
                if (varHash.get(varDecl2.getName()) != null) continue;
                varHash.put(varDecl2.getName(), varDecl2);
                importedVars.add(varDecl2);
            }
        }
        varHash.clear();
        varHash = null;
        return importedVars;
    }

    private List getSuperVariables() {
        ArrayList superVars = new ArrayList();
        if (this._theSuper != null) {
            superVars.addAll(this._theSuper.getTransformation().getVariables());
            superVars.addAll(this._theSuper.getSuperVariables());
        }
        return superVars;
    }

    public Object[] checkImportedRules(String ruleName) {
        Hashtable<String, TransformationRule> imported;
        Object[] trNameAndRule = null;
        TransformationRule importedRule = null;
        if (this._theSuper != null) {
            Collection<TransformationRule> rules = this._theSuper.getAllTransformationRules(ruleName);
            if (rules.size() > 0) {
                importedRule = rules.iterator().next();
            }
        } else if (importedRule == null && (imported = this.getImportedTransformationRule(ruleName)).size() > 0) {
            importedRule = imported.values().iterator().next();
        }
        if (importedRule != null) {
            trNameAndRule = new Object[]{importedRule.getOwner().getName(), importedRule};
            return trNameAndRule;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public TransformationRule getTransformationRuleForType(FunctionCall f, String name, String ownerTransformation, Object contextObject) {
        tmpRule = null;
        contextClass = null;
        keysplit = null;
        key = null;
        ownerTransformationName = null;
        rCache = this.getCompleteRuleCache(name);
        if (rCache.size() <= 0 || !this.ownedByThisOrSuper(ownerTransformation)) ** GOTO lbl77
        if (rCache.size() == 1) {
            return (TransformationRule)rCache.values().toArray()[0];
        }
        if (contextObject != null && contextObject instanceof EObject) {
            contextClass = ((EObject)contextObject).eClass();
            contextClass.getESuperTypes();
            alternatives = new Hashtable<String, TransformationRule>();
            _enum = rCache.keys();
            while (_enum.hasMoreElements()) {
                key = _enum.nextElement();
                keysplit = key.split("\\.");
                ownerTransformationName = keysplit[0];
                if (!contextClass.getName().equalsIgnoreCase(keysplit[keysplit.length - 1])) continue;
                alternatives.put(ownerTransformationName, rCache.get(key));
            }
            if (alternatives.size() == 1) {
                return (TransformationRule)alternatives.values().iterator().next();
            }
            if (alternatives.size() > 1) {
                tmpModel = this._transformation;
                if (f.isIsSuperCall()) {
                    tmpModel = this._transformation.getExtends();
                }
                while (tmpModel != null) {
                    tmpRule = (TransformationRule)alternatives.get(tmpModel.getName());
                    if (tmpRule != null) {
                        return tmpRule;
                    }
                    tmpModel = tmpModel.getExtends();
                }
            }
            alternatives.clear();
            _enum = rCache.keys();
            while (_enum.hasMoreElements()) {
                key = _enum.nextElement();
                keysplit = key.split("\\.");
                ownerTransformationName = keysplit[0];
                ruleType = (EClass)ExecutionManager.getExecutionManager().getMetaModelReference(keysplit[keysplit.length - 1]);
                if (ruleType == null || !ruleType.isSuperTypeOf(contextClass)) continue;
                alternatives.put(ownerTransformationName, rCache.get(key));
            }
            if (alternatives.size() == 1) {
                return (TransformationRule)alternatives.values().iterator().next();
            }
            if (alternatives.size() > 1) {
                tmpModel = this._transformation;
                if (f.isIsSuperCall()) {
                    tmpModel = this._transformation.getExtends();
                }
                while (tmpModel != null) {
                    tmpRule = (TransformationRule)alternatives.get(tmpModel.getName());
                    if (tmpRule != null) {
                        return tmpRule;
                    }
                    tmpModel = tmpModel.getExtends();
                }
            }
        } else {
            toReturn = null;
            _enum = rCache.keys();
            while (_enum.hasMoreElements()) {
                key = _enum.nextElement();
                keysplit = key.split("\\.");
                ownerTransformationName = keysplit[0];
                ownedBySelf = false;
                if (ownerTransformationName.equalsIgnoreCase(this._transformation.getName()) && !f.isIsSuperCall()) {
                    ownedBySelf = true;
                    toReturn = rCache.get(key);
                    break;
                }
                if (ownedBySelf || !this.isSuperTransformation(ownerTransformationName)) continue;
                toReturn = rCache.get(key);
            }
            if (toReturn != null) {
                return toReturn;
            }
            return (TransformationRule)rCache.values().toArray()[0];
lbl77:
            // 1 sources

            alternatives = new ArrayList<TransformationRule>();
            for (TransformationProxy tPr : this._importedTransformations.values()) {
                alt = tPr.getTransformationRuleForType(f, name, tPr.getName(), contextObject);
                if (alt == null) continue;
                alternatives.add(alt);
            }
            if (alternatives.size() > 0) {
                return (TransformationRule)alternatives.get(0);
            }
        }
        return null;
    }

    protected boolean ownedByThisOrSuper(String ownerTransformation) {
        if (ownerTransformation.equals(this.getName())) {
            return true;
        }
        if (this._theSuper != null) {
            return this._theSuper.ownedByThisOrSuper(ownerTransformation);
        }
        return false;
    }

    protected TransformationRule getNearestTransformation(Collection<TransformationRule> importedRules) {
        TransformationRule importedRule2 = null;
        TransformationRule candidate = null;
        if (importedRules.size() == 0) {
            return null;
        }
        if (importedRules.size() == 1) {
            return importedRules.iterator().next();
        }
        for (TransformationRule importedRule2 : importedRules) {
            if (candidate == null) {
                candidate = importedRule2;
                continue;
            }
            if (!this.isSuperTypeOf(candidate.getOwner(), importedRule2.getOwner())) continue;
            candidate = importedRule2;
        }
        return candidate;
    }

    protected boolean isSuperTypeOf(MOFScriptTransformation potentialSuper, MOFScriptTransformation potentialSub) {
        if (potentialSub == potentialSuper) {
            return false;
        }
        if (potentialSub.getExtendsName() == null) {
            return false;
        }
        if (potentialSub.getExtendsName().equalsIgnoreCase(potentialSuper.getName())) {
            return true;
        }
        return this.isSuperTypeOf(potentialSuper, potentialSub.getExtends());
    }

    public boolean isSuperTransformation(MOFScriptTransformation transformation) {
        if (this._theSuper != null && this._theSuper.getTransformation() == transformation) {
            return true;
        }
        if (this._theSuper != null) {
            return this._theSuper.isSuperTransformation(transformation);
        }
        return false;
    }

    public boolean isSuperTransformation(String trName) {
        if (this._theSuper != null && this._theSuper.getName().equalsIgnoreCase(trName)) {
            return true;
        }
        if (this._theSuper != null) {
            return this._theSuper.isSuperTransformation(trName);
        }
        return false;
    }

    public boolean superHasRule(String ruleName) {
        if (this._theSuper == null) {
            return false;
        }
        return this._theSuper.getAllTransformationRules(ruleName).size() > 0;
    }

    public void addImportedTransformation(String importName, String importUri, MOFScriptTransformation importedTransformation) {
        if (!this.isSuperTransformation(importedTransformation) && !this._importedTransformations.containsKey(importedTransformation.getName()) && importedTransformation != this._transformation) {
            TransformationProxy importedProxy = new TransformationProxy(importedTransformation);
            this._importedTransformations.put(importedTransformation.getName(), importedProxy);
            this._importedTransformationUris.put(importedProxy, importUri);
        }
    }

    public String getTransformationUriForRule(String ruleName) {
        for (TransformationProxy imported : this._importedTransformations.values()) {
            TransformationRule r = imported.getTransformationRule(ruleName);
            if (r == null) continue;
            String uri = this._importedTransformationUris.get(imported);
            return uri;
        }
        return null;
    }
}

