/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.expression;

import org.eclipse.mofscript.MOFScriptModel.ArithmeticExpression;
import org.eclipse.mofscript.MOFScriptModel.ArithmeticOperator;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.ValueExpression;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;

public class ArithmeticExpressionEvaluator
extends ExpressionEvaluator {
    public ArithmeticExpressionEvaluator(Expression expression, ExecutionEnvironment env, RuleExecutor ownerRule) {
        super(expression, env, ownerRule);
    }

    @Override
    protected Object evaluate(Object inputObject) throws MofScriptExecutionException {
        Object ret = null;
        ArithmeticExpression cexp = (ArithmeticExpression)this._expression;
        ValueExpression part1 = cexp.getPart1();
        ValueExpression part2 = cexp.getPart2();
        ArithmeticOperator operator = cexp.getOperator();
        ExpressionEvaluator executer = MofScriptExecuterFactory.createExpressionExecutor((Expression)part1, this._env, this._ownerRuleExecutor);
        Object part1_result = executer.evaluateExpression(inputObject);
        executer = MofScriptExecuterFactory.createExpressionExecutor((Expression)part2, this._env, this._ownerRuleExecutor);
        Object part2_result = executer.evaluateExpression(inputObject);
        executer = null;
        if (part1_result == null) {
            ret = part1_result == null && part2_result != null ? part2_result : null;
        } else if (part2_result == null) {
            ret = part1_result;
        } else if (part1_result instanceof String) {
            if (operator == ArithmeticOperator.PLUS_LITERAL) {
                try {
                    ret = String.valueOf((String)part1_result) + part2_result;
                }
                catch (Exception ex) {
                    this._env.notifyError("#Runtime Error# In Arithmetic expression (Rule: " + this._ownerRuleExecutor.getRule().getName() + "): " + ex + " (line: " + cexp.getLine() + ")", this);
                }
            }
        } else if (part1_result instanceof StringBuffer) {
            if (operator == ArithmeticOperator.PLUS_LITERAL) {
                try {
                    ret = String.valueOf(part1_result.toString()) + part2_result.toString();
                }
                catch (Exception ex) {
                    this._env.notifyError("#Runtime Error# In Arithmetic expression (Rule: " + this._ownerRuleExecutor.getRule().getName() + "): " + ex + " (line: " + cexp.getLine() + ")", this);
                }
            }
        } else if (part1_result instanceof Integer) {
            if (operator == ArithmeticOperator.PLUS_LITERAL) {
                ret = part2_result instanceof Integer ? new Integer((Integer)part1_result + (Integer)part2_result) : (part2_result instanceof Double ? new Integer((Integer)part1_result + ((Double)part2_result).intValue()) : String.valueOf(part1_result.toString()) + part2_result.toString());
            } else if (operator == ArithmeticOperator.MINUS_LITERAL) {
                ret = part2_result instanceof Integer ? new Integer((Integer)part1_result - (Integer)part2_result) : (part2_result instanceof Double ? new Integer((Integer)part1_result - ((Double)part2_result).intValue()) : String.valueOf(part1_result.toString()) + part2_result.toString());
            } else if (operator == ArithmeticOperator.MULT_LITERAL) {
                ret = part2_result instanceof Integer ? new Integer((Integer)part1_result * (Integer)part2_result) : (part2_result instanceof Double ? new Integer((Integer)part1_result * ((Double)part2_result).intValue()) : String.valueOf(part1_result.toString()) + part2_result.toString());
            } else if (operator == ArithmeticOperator.DIV_LITERAL) {
                ret = part2_result instanceof Integer ? new Double(((Integer)part1_result).doubleValue() / ((Integer)part2_result).doubleValue()) : (part2_result instanceof Double ? new Double(((Integer)part1_result).doubleValue() / (Double)part2_result) : String.valueOf(part1_result.toString()) + part2_result.toString());
            }
        } else if (part1_result instanceof Double) {
            if (operator == ArithmeticOperator.PLUS_LITERAL) {
                ret = part2_result instanceof Integer ? new Double((Double)part1_result + ((Integer)part2_result).doubleValue()) : (part2_result instanceof Double ? new Double((Double)part1_result + (Double)part2_result) : String.valueOf(part1_result.toString()) + part2_result.toString());
            } else if (operator == ArithmeticOperator.MINUS_LITERAL) {
                ret = part2_result instanceof Integer ? new Double((Double)part1_result - (double)((Integer)part2_result).intValue()) : (part2_result instanceof Double ? new Double((Double)part1_result - (Double)part2_result) : String.valueOf(part1_result.toString()) + part2_result.toString());
            } else if (operator == ArithmeticOperator.MULT_LITERAL) {
                ret = part2_result instanceof Integer ? new Double((Double)part1_result * ((Integer)part2_result).doubleValue()) : (part2_result instanceof Double ? new Double((Double)part1_result * (Double)part2_result) : String.valueOf(part1_result.toString()) + part2_result.toString());
            } else if (operator == ArithmeticOperator.DIV_LITERAL) {
                ret = part2_result instanceof Integer ? new Double((Double)part1_result / ((Integer)part2_result).doubleValue()) : (part2_result instanceof Double ? new Double((Double)part1_result / (Double)part2_result) : String.valueOf(part1_result.toString()) + part2_result.toString());
            }
        } else {
            ret = part1_result instanceof Boolean ? String.valueOf(part1_result.toString()) + part2_result.toString() : String.valueOf(part1_result.toString()) + part2_result.toString();
        }
        return ret;
    }
}

