/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.expression;

import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.TransformationRule;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.traceability.TraceabilityReferenceEvaluator;

public abstract class ExpressionEvaluator {
    protected Expression _expression;
    protected ExecutionEnvironment _env;
    protected RuleExecutor _ownerRuleExecutor;
    protected static int _positionCounter;
    protected static int _stringPosCounter;
    protected static int _referenceStringLength;

    public ExpressionEvaluator(Expression expression, ExecutionEnvironment env, RuleExecutor ownerRuleExecutor) {
        this._expression = expression;
        this._env = env;
        this._ownerRuleExecutor = ownerRuleExecutor;
    }

    public TransformationRule getOwnerRule() {
        return this._ownerRuleExecutor.getRule();
    }

    public Expression getExpression() {
        return this._expression;
    }

    public final Object evaluateExpression(Object inputObject) throws MofScriptExecutionException {
        Object ret = null;
        ret = this.evaluate(inputObject);
        if (ret != null && ret instanceof String || ret instanceof StringBuffer) {
            _positionCounter += ret.toString().length();
            if (this instanceof TraceabilityReferenceEvaluator) {
                _referenceStringLength = ret.toString().length();
            }
        }
        return ret;
    }

    public static void resetPosisionCounter() {
        _positionCounter = 0;
    }

    protected abstract Object evaluate(Object var1) throws MofScriptExecutionException;
}

