/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.expression;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.FunctionCall;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptParameter;
import org.eclipse.mofscript.MOFScriptModel.Reference;
import org.eclipse.mofscript.MOFScriptModel.TransformationRule;
import org.eclipse.mofscript.MOFScriptModel.ValueExpression;
import org.eclipse.mofscript.MOFScriptModel.impl.MOFScriptModelFactoryImpl;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.ReferenceEvaluator;
import org.eclipse.mofscript.runtime.expression.SimpleExpressionEvaluator;
import org.eclipse.uml2.common.util.DerivedEObjectEList;

public class FunctionCallEvaluator
extends SimpleExpressionEvaluator {
    protected ValueExpression p1 = null;
    protected ValueExpression p2 = null;
    protected ValueExpression p3 = null;
    protected Object p1Result = null;
    protected Object p2Result = null;
    protected Object p3Result = null;
    protected ExpressionEvaluator evaluator = null;
    protected List<String> l = new ArrayList<String>();

    public FunctionCallEvaluator(Expression expression, ExecutionEnvironment env, RuleExecutor ownerRuleExecutor) {
        super(expression, env, ownerRuleExecutor);
    }

    @Override
    protected Object evaluateSimple(Object inputObject) throws MofScriptExecutionException {
        FunctionCall f = (FunctionCall)this._expression;
        Object ret = this.handleFunctionCall(f, inputObject);
        return ret;
    }

    protected void evaluateParameterValues(List parameters) throws MofScriptExecutionException {
        if (parameters.size() > 0) {
            this.p1 = (ValueExpression)parameters.get(0);
        }
        if (parameters.size() > 1) {
            this.p2 = (ValueExpression)parameters.get(1);
        }
        if (parameters.size() > 2) {
            this.p3 = (ValueExpression)parameters.get(2);
        }
        if (this.p1 != null) {
            this.evaluator = MofScriptExecuterFactory.createExpressionExecutor((Expression)this.p1, this._env, this._ownerRuleExecutor);
            this.p1Result = this.evaluator.evaluateExpression(null);
            if (this.p1Result instanceof StringBuffer) {
                this.p1Result = this.p1Result.toString();
            }
        }
        if (this.p2 != null) {
            this.evaluator = MofScriptExecuterFactory.createExpressionExecutor((Expression)this.p2, this._env, this._ownerRuleExecutor);
            this.p2Result = this.evaluator.evaluateExpression(null);
            if (this.p2Result instanceof StringBuffer) {
                this.p2Result = this.p2Result.toString();
            }
        }
        if (this.p3 != null) {
            this.evaluator = MofScriptExecuterFactory.createExpressionExecutor((Expression)this.p3, this._env, this._ownerRuleExecutor);
            this.p3Result = this.evaluator.evaluateExpression(null);
            if (this.p3Result instanceof StringBuffer) {
                this.p3Result = this.p3Result.toString();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object handleFunctionCall(FunctionCall f, Object inputContext) {
        Object result = null;
        ReferenceEvaluator refEval = null;
        try {
            Object variable;
            EList parameters = f.getParameters();
            this.evaluateParameterValues((List)parameters);
            String fullName = f.getName();
            String[] splitName = fullName.split("\\.");
            String fName = splitName[splitName.length - 1];
            String contextName = "";
            Object contextObject = "";
            if (splitName.length == 2) {
                if (splitName.length > 1) {
                    contextName = splitName[0];
                }
                if (contextName != null) {
                    contextObject = this._env.getInputObject(contextName);
                }
            } else if (splitName.length > 2) {
                int refIndex = fullName.lastIndexOf(".");
                String refName = fullName.substring(0, refIndex);
                MOFScriptModelFactoryImpl modelFac = new MOFScriptModelFactoryImpl();
                Reference ref = modelFac.createReference();
                ref.setName(refName);
                refEval = (ReferenceEvaluator)MofScriptExecuterFactory.createExpressionExecutor((Expression)ref, this._env, this._ownerRuleExecutor);
                Object refResult = refEval.evaluateExpression(ref);
                contextName = refName;
                contextObject = refResult;
            }
            if (f.isIsSuperCall() && contextObject.equals("")) {
                contextName = "self";
                contextObject = this._env.getInputObject(contextName);
            }
            if ((variable = this._env.getVariableImplementation(contextName)) != null && !(variable instanceof EObject)) {
                return this.variableFunctionCall(variable, fName, f);
            }
            if (variable != null) {
                contextObject = variable;
            }
            TransformationRule function = null;
            function = f.getTransformationRule() != null ? f.getTransformationRule() : RuleExecutor.getExecutionManager().getTransformationProxy().getTransformationRuleForType(f, fName, this._ownerRuleExecutor.getRule().getOwner().getName(), contextObject);
            if (function == null && contextObject != null && !contextObject.equals("")) {
                result = this.variableFunctionCall(contextObject, fName, f);
                if (refEval == null) return result;
                if (result == null) return result;
                refEval.finalizeReferenceProcessing(result.toString());
                return result;
            }
            if ((contextObject == null || contextObject.equals("") && !f.isIsSuperCall()) && !this.isSystemFunction(fName)) {
                if (function == null) return this.variableFunctionCall(contextObject, fName, f);
                String context = function.getContext().getType();
                if (!context.equals("module")) {
                    this._env.notifyError("#Runtime Error# Context name for function (" + fName + ") is NULL - context: " + contextName + " (line: " + f.getLine() + ")", this);
                    return null;
                }
            }
            if (this.isSystemFunction(fName)) {
                return this.systemFunction(fName, f);
            }
            if (function != null) {
                if (function.isIsAbstract()) {
                    throw new MofScriptExecutionException("#Runtime Error# Rule called from " + f.getLine() + " is abstract " + function.getName() + "\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                }
                EList function_parameters = function.getParameters();
                if (function_parameters.size() != parameters.size()) {
                    throw new MofScriptExecutionException("Wrong number of actual parameters to TransformationRule " + function.getName() + "\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                }
                new Hashtable();
                ExecutionEnvironment funcenv = MofScriptExecuterFactory.createExecutionEnvironment();
                if (contextObject != null && !contextObject.equals("")) {
                    funcenv.addInputObject("self", contextObject);
                }
                if (this._env.isInPrintAction()) {
                    funcenv.setInPrintAction(false);
                }
                MOFScriptParameter parame = null;
                if (this.p1Result != null) {
                    parame = (MOFScriptParameter)function_parameters.get(0);
                    funcenv.addInputObject(parame.getName(), this.p1Result);
                    if (this.p1 instanceof Reference) {
                        this.insertModelRefParameter(this.p1, parame);
                    }
                }
                if (this.p2Result != null) {
                    parame = (MOFScriptParameter)function_parameters.get(1);
                    funcenv.addInputObject(parame.getName(), this.p2Result);
                    if (this.p2 instanceof Reference) {
                        this.insertModelRefParameter(this.p2, parame);
                    }
                }
                if (this.p3Result != null) {
                    parame = (MOFScriptParameter)function_parameters.get(2);
                    funcenv.addInputObject(parame.getName(), this.p3Result);
                    if (this.p3 instanceof Reference) {
                        this.insertModelRefParameter(this.p3, parame);
                    }
                }
                int param_index = 3;
                if (function_parameters.size() > 3) {
                    while (param_index < function_parameters.size()) {
                        Expression param = (Expression)parameters.get(param_index);
                        ExpressionEvaluator executer = MofScriptExecuterFactory.createExpressionExecutor(param, this._env, this._ownerRuleExecutor);
                        Object expression_value = executer.evaluateExpression(null);
                        executer = null;
                        funcenv.addInputObject(((MOFScriptParameter)function_parameters.get(param_index++)).getName(), expression_value);
                    }
                }
                try {
                    RuleExecutor rExec = new RuleExecutor(function, null);
                    rExec.setExecutionEnvironment(funcenv);
                    RuleExecutor.getExecutionManager().getExecutionStack().pushEnvironment(funcenv);
                    Object res = rExec.executeRule();
                    RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
                    result = res instanceof StringBuffer ? res.toString() : res;
                }
                catch (MofScriptExecutionException qex) {
                    this._env.notifyError("#Runtime Error# Function call did not succeed:" + qex.getMessage(), this);
                    qex.printStackTrace();
                }
            }
            if (refEval == null) return result;
            if (result == null) return result;
            refEval.finalizeReferenceProcessing(result.toString());
            return result;
        }
        catch (MofScriptExecutionException mfex) {
            String lineMsg = "";
            if (mfex.getLine() > 0) {
                lineMsg = "(line: " + mfex.getLine() + ")";
            }
            this._env.notifyError("#Runtime Error in FunctionCallEvaluator:# " + mfex.getMessage() + lineMsg, this);
            return result;
        }
        catch (Exception ex) {
            Throwable t = ex.getCause();
            String reason = "";
            if (t.getMessage() != null) {
                reason = t.getMessage();
            }
            this._env.notifyError("#Runtime Error in FunctionCallEvaluator: " + t.getClass() + " " + reason, this);
        }
        return result;
    }

    protected void insertModelRefParameter(ValueExpression p, MOFScriptParameter param) {
    }

    protected Object variableFunctionCall(Object variable, String fName, FunctionCall f) throws MofScriptExecutionException {
        EList parameters = f.getParameters();
        if (variable == null) {
            variable = "";
        }
        if (fName.equalsIgnoreCase("store")) {
            return this.storeFunction(variable, fName, f);
        }
        if (fName.equalsIgnoreCase("clone")) {
            return this.cloneFunction(variable, fName, f);
        }
        if (fName.equalsIgnoreCase("shallowCopy")) {
            return this.shallowCopy(variable, fName, f);
        }
        if (fName.equalsIgnoreCase("oclIsTypeOf") || fName.equalsIgnoreCase("oclIsKindOf") || fName.equalsIgnoreCase("oclGetType") || fName.equalsIgnoreCase("objectsOfType")) {
            return this.oclGeneralFunction(variable, fName, f);
        }
        if (fName.startsWith("_get") || fName.equalsIgnoreCase("_isInstance") || fName.equalsIgnoreCase("_setFeature") || fName.equalsIgnoreCase("_delete")) {
            return this.metaOperation(variable, fName, f);
        }
        if (variable instanceof Hashtable) {
            Hashtable hashVar = (Hashtable)variable;
            if (fName.equalsIgnoreCase("put")) {
                if (parameters.size() == 2) {
                    return hashVar.put(this.p1Result, this.p2Result);
                }
                throw new MofScriptExecutionException("Wrong number of arguments to function 'put'\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            }
            if (fName.equalsIgnoreCase("get")) {
                if (parameters.size() == 1) {
                    return hashVar.get(this.p1Result);
                }
                throw new MofScriptExecutionException("Wrong number of arguments to function 'get'\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            }
            if (fName.equalsIgnoreCase("remove")) {
                if (parameters.size() == 1) {
                    return hashVar.remove(this.p1Result);
                }
                throw new MofScriptExecutionException("Wrong number of arguments to function 'remove'\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            }
            if (fName.equalsIgnoreCase("size")) {
                return new Integer(hashVar.size());
            }
            if (fName.equalsIgnoreCase("clear")) {
                hashVar.clear();
                return new Boolean(true);
            }
            if (fName.equalsIgnoreCase("keys")) {
                return new ArrayList(hashVar.keySet());
            }
            if (fName.equalsIgnoreCase("values")) {
                return new ArrayList(hashVar.values());
            }
            if (fName.equalsIgnoreCase("first")) {
                if (hashVar.values().size() > 0) {
                    return hashVar.values().iterator().next();
                }
                return null;
            }
            if (fName.equalsIgnoreCase("last")) {
                if (hashVar.values().size() > 0) {
                    return hashVar.values().iterator().next();
                }
                return null;
            }
            if (fName.equalsIgnoreCase("isEmpty")) {
                return new Boolean(hashVar.isEmpty());
            }
        } else if (variable instanceof List) {
            List listVar = (List)variable;
            if (fName.equalsIgnoreCase("add")) {
                if (parameters.size() == 1) {
                    if (listVar instanceof EObjectContainmentEList) {
                        EObjectContainmentEList cList = (EObjectContainmentEList)listVar;
                        if (this.p1Result instanceof Collection) {
                            cList.addUnique((Object)EcoreUtil.copy((EObject)((EObject)this.p1Result)));
                        } else if (this.p1Result instanceof EObject) {
                            cList.addUnique((Object)EcoreUtil.copy((EObject)((EObject)this.p1Result)));
                        } else {
                            cList.addUnique(this.p1Result);
                        }
                    } else if (listVar instanceof List) {
                        listVar.add(this.p1Result);
                    }
                    return "";
                }
            } else if (fName.equalsIgnoreCase("addOrg")) {
                if (listVar instanceof DerivedEObjectEList) {
                    throw new MofScriptExecutionException("The list is not modifiable.", "", this._expression.getLine());
                }
                if (parameters.size() == 1) {
                    if (listVar instanceof EObjectContainmentEList) {
                        EObjectContainmentEList cList = (EObjectContainmentEList)listVar;
                        if (this.p1Result instanceof Collection) {
                            cList.addUnique(this.p1Result);
                        } else {
                            cList.addUnique((Object)((EObject)this.p1Result));
                        }
                    } else if (listVar instanceof List) {
                        listVar.add(this.p1Result);
                    }
                    return "";
                }
            } else if (fName.equalsIgnoreCase("remove")) {
                if (parameters.size() == 1) {
                    listVar.remove(this.p1Result);
                    return "";
                }
            } else {
                if (fName.equalsIgnoreCase("size")) {
                    return new Integer(listVar.size());
                }
                if (fName.equalsIgnoreCase("clear")) {
                    listVar.clear();
                    return "";
                }
                if (fName.equalsIgnoreCase("first")) {
                    Iterator it = listVar.iterator();
                    if (it.hasNext()) {
                        return it.next();
                    }
                    return null;
                }
                if (fName.equalsIgnoreCase("last")) {
                    if (listVar.size() > 0) {
                        return listVar.get(listVar.size() - 1);
                    }
                    return null;
                }
                if (fName.equalsIgnoreCase("isEmpty")) {
                    return new Boolean(listVar.isEmpty());
                }
                if (fName.equalsIgnoreCase("select")) {
                    return this.selectFunction(variable, f);
                }
                if (fName.equalsIgnoreCase("contains")) {
                    if (parameters.size() == 1) {
                        return new Boolean(listVar.contains(this.p1Result));
                    }
                    return new Boolean(false);
                }
                if (fName.equalsIgnoreCase("get")) {
                    if (parameters.size() == 1) {
                        if (this.p1Result instanceof Integer) {
                            int index = (Integer)this.p1Result;
                            if (index > -1 && index < listVar.size()) {
                                return listVar.get(index);
                            }
                            throw new MofScriptExecutionException("Index " + index + " is out of range for list, size:" + listVar.size(), this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                        }
                        throw new MofScriptExecutionException("Wrong type of argument to function 'get'", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                    }
                } else if (fName.equalsIgnoreCase("addAll")) {
                    if (parameters.size() == 1) {
                        if (listVar instanceof EObjectContainmentEList) {
                            EObjectContainmentEList cList = (EObjectContainmentEList)listVar;
                            if (this.p1Result instanceof Collection) {
                                cList.addAllUnique(EcoreUtil.copyAll((Collection)((Collection)this.p1Result)));
                            } else if (this.p1Result instanceof EObject) {
                                cList.addUnique((Object)EcoreUtil.copy((EObject)((EObject)this.p1Result)));
                            } else {
                                cList.addUnique(this.p1Result);
                            }
                        } else if (listVar instanceof List) {
                            if (this.p1Result instanceof Collection) {
                                listVar.addAll((Collection)this.p1Result);
                            } else {
                                listVar.add(this.p1Result);
                            }
                        }
                        return "";
                    }
                } else if (fName.equalsIgnoreCase("addAllFirst")) {
                    if (parameters.size() == 1) {
                        if (listVar instanceof EObjectContainmentEList) {
                            EObjectContainmentEList cList = (EObjectContainmentEList)listVar;
                            ArrayList itemHolder = new ArrayList();
                            itemHolder.addAll(cList);
                            cList.clear();
                            if (this.p1Result instanceof Collection) {
                                cList.addAllUnique(EcoreUtil.copyAll((Collection)((Collection)this.p1Result)));
                                cList.addAll(itemHolder);
                            } else {
                                if (this.p1Result instanceof EObject) {
                                    cList.addUnique((Object)EcoreUtil.copy((EObject)((EObject)this.p1Result)));
                                } else {
                                    cList.addUnique(this.p1Result);
                                }
                                cList.addAll(itemHolder);
                            }
                        } else if (listVar instanceof List) {
                            ArrayList itemHolder = new ArrayList();
                            itemHolder.addAll(listVar);
                            listVar.clear();
                            if (this.p1Result instanceof Collection) {
                                listVar.addAll((Collection)this.p1Result);
                                listVar.addAll(itemHolder);
                            } else {
                                listVar.add(this.p1Result);
                                listVar.addAll(itemHolder);
                            }
                        }
                        return "";
                    }
                } else {
                    if (fName.equalsIgnoreCase("addAfter")) {
                        if (parameters.size() == 2 && listVar instanceof EObjectContainmentEList) {
                            EObjectContainmentEList cList = (EObjectContainmentEList)listVar;
                            int index = cList.indexOf(this.p1Result);
                            new ArrayList();
                            if (index > -1) {
                                if (this.p2Result instanceof Collection) {
                                    cList.addAllUnique(index + 1, EcoreUtil.copyAll((Collection)((Collection)this.p2Result)));
                                } else if (this.p2Result instanceof EObject) {
                                    cList.addUnique((Object)EcoreUtil.copy((EObject)((EObject)this.p2Result)));
                                } else {
                                    cList.addUnique(index + 1, this.p2Result);
                                }
                            }
                        }
                        return "";
                    }
                    if (fName.equalsIgnoreCase("addBefore")) {
                        EObjectContainmentEList cList;
                        int index;
                        if (parameters.size() == 2 && listVar instanceof EObjectContainmentEList && (index = (cList = (EObjectContainmentEList)listVar).indexOf(this.p1Result)) > -1) {
                            if (this.p2Result instanceof Collection) {
                                cList.addAllUnique(index, EcoreUtil.copyAll((Collection)((Collection)this.p2Result)));
                            } else if (this.p2Result instanceof EObject) {
                                cList.addUnique((Object)EcoreUtil.copy((EObject)((EObject)this.p2Result)));
                            } else {
                                cList.addUnique(index, this.p2Result);
                            }
                        }
                        return "";
                    }
                    if (fName.equalsIgnoreCase("indexOf")) {
                        if (parameters.size() == 1) {
                            int index = listVar.indexOf(this.p1Result);
                            return new Integer(index);
                        }
                        throw new MofScriptExecutionException("Missing parameter or too many params to function 'indexOf'", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                    }
                }
            }
        } else {
            if (variable instanceof String) {
                return this.handleStringFunction(variable, f);
            }
            if (variable instanceof EEnumLiteral) {
                return this.handleStringFunction(((EEnumLiteral)variable).getName(), f);
            }
            if (variable instanceof StringBuffer) {
                return this.handleStringFunction(variable, f);
            }
            if (variable instanceof Variable) {
                Variable varDecl = (Variable)variable;
                String varType = varDecl.getType();
                Object opValue = null;
                if (varType.equalsIgnoreCase("String")) {
                    Object calc = varDecl.getValue();
                    if (calc != null && !calc.equals("")) {
                        opValue = calc;
                    } else {
                        Expression varexp = varDecl.assignedExpression;
                        ExpressionEvaluator executer = MofScriptExecuterFactory.createExpressionExecutor(varexp, this._env, this._ownerRuleExecutor);
                        Object res = executer.evaluateExpression(null);
                        executer = null;
                        varDecl.value = res.toString();
                        opValue = res.toString();
                    }
                    Object result = super.handleStringFunction(opValue, f);
                    return result;
                }
                if (!varType.equalsIgnoreCase("Boolean") && !varType.equalsIgnoreCase("Integer")) {
                    varType.equalsIgnoreCase("Real");
                }
            }
        }
        throw new MofScriptExecutionException("Unknown function " + fName + " for type " + variable.getClass().getName(), this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
    }

    protected Object oclGeneralFunction(Object variable, String fName, FunctionCall f) throws MofScriptExecutionException {
        EList parameters = f.getParameters();
        ExpressionEvaluator evaluator = null;
        variable = ExecutionManager.getExecutionManager().getRealObject(variable);
        if (fName.equalsIgnoreCase("oclIsTypeOf")) {
            if (parameters.size() != 1) {
                throw new MofScriptExecutionException("Missing parameter for function '" + fName + "'\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            }
            this.p1 = (ValueExpression)parameters.get(0);
            evaluator = MofScriptExecuterFactory.createExpressionExecutor((Expression)this.p1, this._env, this._ownerRuleExecutor);
            Object evalResult = evaluator.evaluateExpression(null);
            if (variable instanceof EObject) {
                if (!(evalResult instanceof EClassifier)) {
                    return Boolean.FALSE;
                }
                EClassifier queryClass = (EClassifier)evalResult;
                String qclName = queryClass.getName();
                EClass eCl = ((EObject)variable).eClass();
                String eClName = eCl.getName();
                boolean isTypeOf = eClName.equalsIgnoreCase(qclName);
                if (isTypeOf) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (!(variable instanceof String || variable instanceof Boolean || variable instanceof Integer || variable instanceof Double || variable instanceof Float || variable instanceof List)) {
                boolean cfr_ignored_0 = variable instanceof Hashtable;
            }
            return Boolean.FALSE;
        }
        if (fName.equalsIgnoreCase("oclIsKindOf")) {
            if (parameters.size() != 1) {
                throw new MofScriptExecutionException("Missing parameter for function '" + fName + "'\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            }
            if (variable instanceof EObject) {
                if (!(this.p1Result instanceof EClassifier)) {
                    return Boolean.FALSE;
                }
                EClassifier queryClass = (EClassifier)this.p1Result;
                if (queryClass.isInstance(variable)) {
                    return Boolean.TRUE;
                }
                String qclName = queryClass.getName();
                EClass eCl = ((EObject)variable).eClass();
                String eClName = eCl.getName();
                EList superTypes = eCl.getEAllSuperTypes();
                boolean isKindOf = eClName.equalsIgnoreCase(qclName);
                if (!isKindOf) {
                    EClass superType = null;
                    int i = superTypes.size() - 1;
                    while (i >= 0) {
                        superType = (EClass)superTypes.get(i);
                        isKindOf = superType.getName().equalsIgnoreCase(qclName);
                        if (isKindOf) break;
                        --i;
                    }
                }
                if (isKindOf) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (!(variable instanceof String || variable instanceof Boolean || variable instanceof Integer || variable instanceof Double || variable instanceof Float || variable instanceof List)) {
                boolean cfr_ignored_1 = variable instanceof Hashtable;
            }
            return Boolean.FALSE;
        }
        if (fName.equalsIgnoreCase("oclGetType")) {
            if (parameters.size() > 0) {
                throw new MofScriptExecutionException("Illegal parameter for function '" + fName + "' (Should not have parameter.)\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            }
            if (variable instanceof EObject) {
                EClass eCl = ((EObject)variable).eClass();
                String eClName = eCl.getName();
                return eClName;
            }
            if (variable instanceof String || variable instanceof StringBuffer) {
                return "String";
            }
            if (variable instanceof Boolean) {
                return "Boolean";
            }
            if (variable instanceof Integer) {
                return "Integer";
            }
            if (variable instanceof Double || variable instanceof Float) {
                return "Real";
            }
            if (variable instanceof List) {
                return "List";
            }
            if (variable instanceof Hashtable) {
                return "Hashtable";
            }
            return variable.getClass().getName();
        }
        if (fName.equalsIgnoreCase("objectsOfType")) {
            if (parameters.size() == 0) {
                throw new MofScriptExecutionException("Missing parameter to function '" + fName + "'\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            }
            if (parameters.size() > 1) {
                throw new MofScriptExecutionException("To many parameters to function '" + fName + "' (Should have 1)\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            }
            ArrayList<EObject> returnedObjects = new ArrayList<EObject>();
            EClass typeToCheck = null;
            if (this.p1Result instanceof EClass) {
                typeToCheck = (EClass)this.p1Result;
            }
            if (variable instanceof EObject && typeToCheck != null) {
                EObject model = (EObject)variable;
                EObject contentObj = null;
                TreeIterator treeIt = model.eAllContents();
                while (treeIt.hasNext()) {
                    Object obj = treeIt.next();
                    if (!(obj instanceof EObject)) continue;
                    contentObj = (EObject)obj;
                    if (contentObj instanceof DynamicEObjectImpl) {
                        DynamicEObjectImpl deo = (DynamicEObjectImpl)contentObj;
                        EClass deoClass = deo.eClass();
                        if (!EcoreUtil.equals((EObject)typeToCheck, (EObject)deoClass) && !typeToCheck.isSuperTypeOf(deoClass)) continue;
                        returnedObjects.add(contentObj);
                        continue;
                    }
                    if (!typeToCheck.isInstance((Object)contentObj)) continue;
                    returnedObjects.add(contentObj);
                }
            }
            return returnedObjects;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object metaOperation(Object variable, String fName, FunctionCall f) throws MofScriptExecutionException {
        retVal = null;
        if (variable instanceof EObject) {
            eobj = (EObject)variable;
            if (fName.equalsIgnoreCase("_getContainer")) {
                retVal = eobj.eContainer();
            } else if (fName.equalsIgnoreCase("_getFeature")) {
                if (f.getParameters().size() != 1) {
                    throw new MofScriptExecutionException("Missing string parameter for function '" + fName, this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                }
                if (variable instanceof EClass) {
                    ecl = (EClass)variable;
                    return ecl.getEStructuralFeature(this.p1Result.toString());
                }
                if (variable instanceof EObject) {
                    if (!(this.p1Result instanceof String) && !(this.p1Result instanceof StringBuffer)) {
                        throw new MofScriptExecutionException("Wrong type for parameter to function " + fName + ": Should be string", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                    }
                    feature = ((EObject)variable).eClass().getEStructuralFeature(this.p1Result.toString());
                    if (feature == null) throw new MofScriptExecutionException("Feature not found in function: " + fName + " : " + this.p1Result.toString(), this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                    return ((EObject)variable).eGet(feature);
                }
            } else if (fName.equalsIgnoreCase("_setFeature")) {
                if (f.getParameters().size() != 2) {
                    throw new MofScriptExecutionException("Missing string parameter for function '" + fName, this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                }
                if (variable instanceof EObject) {
                    if (!(this.p1Result instanceof String) && !(this.p1Result instanceof StringBuffer)) {
                        throw new MofScriptExecutionException("Wrong type for 1st parameter to function " + fName + ": Should be string\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                    }
                    feature = ((EObject)variable).eClass().getEStructuralFeature(this.p1Result.toString());
                    if (feature == null) throw new MofScriptExecutionException("Feature not found in function: " + fName + " : " + this.p1Result.toString(), this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                    try {
                        etype = feature.getEType();
                        if (etype == null) ** GOTO lbl128
                        etn = etype.getName();
                        if (etn.equals("EFloat") || etn.equals("EDouble")) {
                            if (this.p2Result instanceof Double) {
                                if (etn.equals("EFloat")) {
                                    ((EObject)variable).eSet(feature, (Object)Float.valueOf(((Double)this.p2Result).floatValue()));
                                }
                                ((EObject)variable).eSet(feature, (Object)((double)((Double)this.p2Result)));
                            }
                            if (this.p2Result instanceof Integer) {
                                ((EObject)variable).eSet(feature, (Object)((int)((Integer)this.p2Result)));
                            }
                            if (this.p2Result instanceof String) {
                                if (etn.equals("EFloat")) {
                                    try {
                                        theFloat = Float.parseFloat((String)this.p2Result);
                                        ((EObject)variable).eSet(feature, (Object)Float.valueOf(theFloat));
                                    }
                                    catch (NumberFormatException v0) {}
                                }
                                try {
                                    theDoble = Double.parseDouble((String)this.p2Result);
                                    ((EObject)variable).eSet(feature, (Object)theDoble);
                                }
                                catch (NumberFormatException v1) {}
                            }
                            ((EObject)variable).eSet(feature, this.p2Result);
                        }
                        if (etn.equals("EInt") || etn.equals("ELong")) {
                            if (this.p2Result instanceof Integer) {
                                ((EObject)variable).eSet(feature, (Object)((int)((Integer)this.p2Result)));
                            }
                            if (this.p2Result instanceof Double) {
                                ((EObject)variable).eSet(feature, (Object)((Double)this.p2Result).intValue());
                            }
                            if (this.p2Result instanceof String) {
                                try {
                                    theInt = Integer.parseInt((String)this.p2Result);
                                    ((EObject)variable).eSet(feature, (Object)theInt);
                                }
                                catch (NumberFormatException v2) {}
                            }
                            ((EObject)variable).eSet(feature, this.p2Result);
                        }
                        ((EObject)variable).eSet(feature, this.p2Result);
                    }
                    catch (Exception v3) {
                        throw new MofScriptExecutionException("Could not assign value " + this.p2Result + " to feature " + feature.getName() + " in " + fName, this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                    }
                }
            } else {
                if (fName.equalsIgnoreCase("_getClass")) {
                    return eobj.eClass();
                }
                if (fName.equalsIgnoreCase("_getCrossReferences")) {
                    return eobj.eCrossReferences();
                }
                if (fName.equalsIgnoreCase("_getUsages")) {
                    toReturn = new ArrayList<EObject>();
                    if (this.p1Result != null && this.p1Result instanceof List) {
                        context = (List)this.p1Result;
                        lit = context.iterator();
                        while (lit.hasNext()) {
                            try {
                                o = (EObject)lit.next();
                                usages = EcoreUtil.UsageCrossReferencer.find((EObject)eobj, (EObject)o);
                                for (EStructuralFeature.Setting sett : usages) {
                                    toReturn.add(sett.getEObject());
                                }
                            }
                            catch (Exception ex) {
                                throw new MofScriptExecutionException("_getUsages: " + ex.getMessage(), this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                            }
                        }
                        return toReturn;
                    } else {
                        toplevel = eobj;
                        while (toplevel.eContainer() != null) {
                            if (toplevel.eContainer() == null) continue;
                            toplevel = toplevel.eContainer();
                        }
                        usages = EcoreUtil.UsageCrossReferencer.find((EObject)eobj, (EObject)toplevel);
                        for (EStructuralFeature.Setting sett : usages) {
                            toReturn.add(sett.getEObject());
                        }
                    }
                    return toReturn;
                }
                if (fName.equalsIgnoreCase("_getUsageFeatures")) {
                    toplevel = eobj;
                    while (toplevel.eContainer() != null) {
                        if (toplevel.eContainer() == null) continue;
                        toplevel = toplevel.eContainer();
                    }
                    usages = EcoreUtil.UsageCrossReferencer.find((EObject)eobj, (EObject)toplevel);
                    toReturn = new ArrayList<EStructuralFeature>();
                    for (EStructuralFeature.Setting sett : usages) {
                        toReturn.add(sett.getEStructuralFeature());
                    }
                    return toReturn;
                }
                if (fName.equalsIgnoreCase("_getContainingFeature")) {
                    return eobj.eContainingFeature();
                }
                if (fName.equalsIgnoreCase("_delete")) {
                    EcoreUtil.delete((EObject)eobj);
                }
            }
        }
lbl128:
        // 23 sources

        if (variable instanceof EClass) {
            ecl = (EClass)variable;
            if (fName.equalsIgnoreCase("_getOperations")) {
                return ecl.getEAllOperations();
            }
            if (fName.equalsIgnoreCase("_getAttributes")) {
                return ecl.getEAllAttributes();
            }
            if (fName.equalsIgnoreCase("_getReferences")) {
                return ecl.getEAllReferences();
            }
            if (fName.equalsIgnoreCase("_getTypeParameters")) {
                return ecl.getETypeParameters();
            }
            if (fName.equalsIgnoreCase("_getSuperTypes")) {
                return ecl.getESuperTypes();
            }
            if (fName.equalsIgnoreCase("_getFeatures")) {
                return ecl.getEAllStructuralFeatures();
            }
        }
        if (fName.equalsIgnoreCase("_getPackage") && variable instanceof EClassifier) {
            return ((EClassifier)variable).getEPackage();
        }
        if (!fName.equalsIgnoreCase("_isInstance") || !(variable instanceof EClassifier)) return retVal;
        if (f.getParameters().size() != 1) {
            throw new MofScriptExecutionException("Missing object parameter for function '" + fName, this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
        }
        if (!(this.p1Result instanceof EObject)) return new Boolean(false);
        return ((EClassifier)variable).isInstance(this.p1Result);
    }

    protected Object storeFunction(Object variable, String fName, FunctionCall f) throws MofScriptExecutionException {
        ValueExpression cfr_ignored_0 = (ValueExpression)f.getParameters().get(0);
        String paramValue = this.p1Result.toString();
        if (f.getParameters().size() != 1) {
            throw new MofScriptExecutionException("Missing parameter to function '" + fName + "'\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
        }
        if (variable instanceof EObject) {
            Resource er = ((EObject)variable).eResource();
            EObject toStore = EcoreUtil.copy((EObject)((EObject)variable));
            this._env.saveTargetModel(paramValue.toString(), toStore, er, (EObject)variable);
        }
        return null;
    }

    protected Object cloneFunction(Object variable, String fName, FunctionCall f) {
        if (variable instanceof EObject) {
            EObject toReturn = EcoreUtil.copy((EObject)((EObject)variable));
            return toReturn;
        }
        return null;
    }

    protected Object shallowCopy(Object variable, String fName, FunctionCall f) {
        EObject toReturn = null;
        if (variable instanceof EObject) {
            EObject eobj = (EObject)variable;
            EClass ecl = eobj.eClass();
            toReturn = EcoreUtil.create((EClass)ecl);
            EList attrs = ecl.getEAllAttributes();
            for (EAttribute attr : attrs) {
                if (!attr.isChangeable()) continue;
                Object attrVal = eobj.eGet((EStructuralFeature)attr);
                if (attrVal != null && attrVal instanceof EObject) {
                    attrVal = EcoreUtil.copy((EObject)((EObject)attrVal));
                }
                if (attrVal == null) continue;
                toReturn.eSet((EStructuralFeature)attr, attrVal);
            }
        }
        return toReturn;
    }

    protected boolean isSystemFunction(String functionName) {
        return functionName.equalsIgnoreCase("date") || functionName.equalsIgnoreCase("time") || functionName.equalsIgnoreCase("exec") || functionName.equalsIgnoreCase("getenv") || functionName.equalsIgnoreCase("setenv") || functionName.equalsIgnoreCase("count") || functionName.equalsIgnoreCase("position") || functionName.equalsIgnoreCase("fileExists") || functionName.equalsIgnoreCase("java");
    }

    protected Object systemFunction(String fName, FunctionCall f) throws MofScriptExecutionException {
        EList parameters = f.getParameters();
        if (fName.equalsIgnoreCase("date")) {
            Calendar cal = Calendar.getInstance();
            int month = cal.get(2);
            String s = String.valueOf(cal.get(5)) + "/" + ++month + "/" + cal.get(1);
            return s;
        }
        if (fName.equalsIgnoreCase("time")) {
            Calendar cal = Calendar.getInstance();
            String s = String.valueOf(cal.get(11)) + ":" + cal.get(12) + ":" + cal.get(13);
            return s;
        }
        if (fName.equalsIgnoreCase("exec")) {
            String[] cmdarray = null;
            String[] envp = null;
            File workingDirFile = null;
            if (parameters.size() == 0) {
                this._env.notifyError("#Runtime Error# Missing parameter to function 'exec'. Needs at least one parameter", this);
            } else {
                Iterator it;
                int index;
                if (this.p1Result instanceof String || this.p1Result instanceof StringBuffer) {
                    cmdarray = new String[]{this.p1Result.toString()};
                } else if (this.p1Result instanceof List) {
                    cmdarray = new String[((List)this.p1Result).size()];
                    index = 0;
                    it = ((List)this.p1Result).iterator();
                    while (it.hasNext()) {
                        cmdarray[index++] = it.next().toString();
                    }
                }
                if (this.p2Result != null) {
                    if (this.p2Result instanceof String || this.p2Result instanceof StringBuffer) {
                        envp = new String[]{this.p2Result.toString()};
                    } else if (this.p2Result instanceof List) {
                        envp = new String[((List)this.p2Result).size()];
                        index = 0;
                        it = ((List)this.p2Result).iterator();
                        while (it.hasNext()) {
                            envp[index++] = it.next().toString();
                        }
                    }
                }
                if (this.p3Result != null && (this.p3Result instanceof String || this.p3Result instanceof StringBuffer)) {
                    workingDirFile = new File(this.p3Result.toString());
                }
                try {
                    this._env.notifyMessage("## Executing process: " + this.p1Result);
                    Runtime.getRuntime().exec(cmdarray, envp, workingDirFile);
                }
                catch (IOException ioex) {
                    this._env.notifyMessage("## Execution process IOException: " + ioex.getMessage());
                }
                catch (NullPointerException nex) {
                    this._env.notifyMessage("## Execution process NullpointerException: " + nex.getMessage());
                }
                catch (Exception ex) {
                    this._env.notifyMessage("## Execution process Exception: " + ex.getMessage());
                }
            }
        } else {
            if (fName.equalsIgnoreCase("getenv")) {
                if (parameters.size() != 1) {
                    throw new MofScriptExecutionException("Missing parameter for function '" + fName + "'", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                }
                return System.getProperty(this.p1Result.toString());
            }
            if (fName.equalsIgnoreCase("setenv")) {
                if (parameters.size() != 2) {
                    throw new MofScriptExecutionException("Missing parameter for function '" + fName + "'\n", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                }
                System.setProperty(this.p1Result.toString(), this.p2Result.toString());
            } else {
                if (fName.equalsIgnoreCase("count")) {
                    return new Integer(this._env.getIteratorCount());
                }
                if (fName.equalsIgnoreCase("position")) {
                    return new Integer(this._env.getIteratorPosition());
                }
                if (fName.equalsIgnoreCase("fileExists")) {
                    if (parameters.size() == 0) {
                        this._env.notifyError("#Runtime Error# Missing parameter to function 'fileExists'. Needs at least one parameter", this);
                    }
                    String genPath = ExecutionManager.getExecutionManager().getRootDirectory();
                    String filePath = String.valueOf(genPath) + '\\' + this.p1Result;
                    System.out.println(filePath);
                    if (parameters.size() == 1) {
                        return new Boolean(new File(filePath).exists());
                    }
                    if (parameters.size() == 2) {
                        return new Boolean(new File(this.p1Result.toString(), this.p2Result.toString()).exists());
                    }
                } else if (fName.equalsIgnoreCase("java")) {
                    JavaFunctionHandler javaHandler = new JavaFunctionHandler();
                    return javaHandler.handleFunction(fName, (List)parameters);
                }
            }
        }
        return null;
    }

    protected Object selectFunction(Object variable, FunctionCall f) throws MofScriptExecutionException {
        ArrayList result = new ArrayList();
        Collection values = null;
        if (variable instanceof List) {
            values = (Collection)variable;
        } else if (variable instanceof Hashtable) {
            values = ((Hashtable)variable).values();
        } else {
            return result;
        }
        Expression selectExpression = (Expression)f.getParameters().get(0);
        Object expressionVal = null;
        boolean selected = false;
        for (Object val : values) {
            if (selectExpression != null) {
                ExpressionEvaluator expExec = MofScriptExecuterFactory.createExpressionExecutor(selectExpression, this._env, this._ownerRuleExecutor);
                expressionVal = expExec.evaluateExpression(null);
                if (expressionVal instanceof Boolean) {
                    selected = (Boolean)expressionVal;
                } else if (expressionVal instanceof String) {
                    selected = false;
                    this._env.notifyError("#Runtime Error#: Return value String from logical expression: " + expressionVal + " (line " + f.getLine() + ")", this);
                } else {
                    selected = false;
                    this._env.notifyError("#Runtime Error#: Return value Object from logical expression: " + expressionVal + " (line " + f.getLine() + ")", this);
                }
            }
            if (selected) {
                result.add(val);
            }
            selected = false;
        }
        return result;
    }

    public static Boolean isTypeOf(EObject toCheck, Object clazz) {
        if (!(clazz instanceof EClass)) {
            return Boolean.FALSE;
        }
        EClass queryClass = (EClass)clazz;
        String qclName = queryClass.getName();
        EClass eCl = toCheck.eClass();
        String eClName = eCl.getName();
        boolean isTypeOf = eClName.equalsIgnoreCase(qclName);
        if (isTypeOf) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isKindOf(EObject toCheck, Object clazz) {
        boolean isKindOf;
        block6: {
            isKindOf = false;
            if (!(clazz instanceof EClass)) {
                return Boolean.FALSE;
            }
            EClass queryClass = (EClass)clazz;
            String qclName = queryClass.getName();
            EClass eCl = toCheck.eClass();
            String eClName = eCl.getName();
            try {
                EList superTypes = eCl.getEAllSuperTypes();
                isKindOf = eClName.equalsIgnoreCase(qclName);
                if (isKindOf) break block6;
                EClass superType = null;
                int i = superTypes.size() - 1;
                while (i >= 0) {
                    superType = (EClass)superTypes.get(i);
                    isKindOf = superType.getName().equalsIgnoreCase(qclName);
                    if (!isKindOf) {
                        --i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                isKindOf = false;
            }
        }
        if (isKindOf) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private class FunctionHandler {
    }

    private class JavaFunctionHandler
    extends FunctionHandler {
        protected Object handleFunction(String fName, List parameters) {
            Object result = null;
            String className = null;
            String methodName = null;
            String classPath = null;
            if (parameters.size() < 2) {
                FunctionCallEvaluator.this._env.notifyError("#Runtime Error# Missing parameter to function '" + fName + "'. Signature: java (<classname>, <static methodname>, <classpath>?)", FunctionCallEvaluator.this);
            } else {
                if (FunctionCallEvaluator.this.p1Result instanceof String || FunctionCallEvaluator.this.p1Result instanceof StringBuffer) {
                    className = FunctionCallEvaluator.this.p1Result.toString();
                }
                if (FunctionCallEvaluator.this.p2Result instanceof String || FunctionCallEvaluator.this.p2Result instanceof StringBuffer) {
                    methodName = FunctionCallEvaluator.this.p2Result.toString();
                }
                ValueExpression p4 = null;
                Object p4Result = null;
                if (parameters.size() > 3) {
                    p4 = (ValueExpression)parameters.get(3);
                }
                if (p4 != null) {
                    FunctionCallEvaluator.this.evaluator = MofScriptExecuterFactory.createExpressionExecutor((Expression)p4, FunctionCallEvaluator.this._env, FunctionCallEvaluator.this._ownerRuleExecutor);
                    try {
                        p4Result = FunctionCallEvaluator.this.evaluator.evaluateExpression(null);
                    }
                    catch (MofScriptExecutionException mofScriptExecutionException) {
                        p4Result = ".";
                    }
                    if (p4Result instanceof String || p4Result instanceof StringBuffer) {
                        classPath = p4Result.toString();
                    }
                }
                ClassLoader loader = null;
                Class<?> clazz = null;
                try {
                    int i;
                    if (classPath != null) {
                        String[] paths = classPath.split(";");
                        URL[] urls = new URL[paths.length];
                        i = 0;
                        while (i < paths.length) {
                            File pfile = new File(paths[i]);
                            try {
                                URI uri = pfile.toURI();
                                urls[i] = uri.toURL();
                            }
                            catch (MalformedURLException urlEx) {
                                FunctionCallEvaluator.this._env.notifyMessage("Malformed URL: " + urlEx);
                            }
                            ++i;
                        }
                        loader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
                    } else {
                        loader = ClassLoader.getSystemClassLoader();
                    }
                    clazz = loader.loadClass(className);
                    Class[] parameterTypes = null;
                    Object[] args = null;
                    if (FunctionCallEvaluator.this.p3Result == null) {
                        parameterTypes = new Class[]{};
                        args = new Object[]{};
                    } else if (FunctionCallEvaluator.this.p3Result instanceof List) {
                        parameterTypes = new Class[((List)FunctionCallEvaluator.this.p3Result).size()];
                        i = 0;
                        while (i < parameterTypes.length) {
                            parameterTypes[i] = ((List)FunctionCallEvaluator.this.p3Result).get(i).getClass();
                            ++i;
                        }
                        args = new Object[parameterTypes.length];
                        List argList = (List)FunctionCallEvaluator.this.p3Result;
                        int argCount = 0;
                        Iterator it = argList.iterator();
                        while (it.hasNext()) {
                            args[argCount++] = it.next();
                        }
                    } else {
                        parameterTypes = new Class[]{FunctionCallEvaluator.this.p3Result.getClass()};
                        args = new Object[]{ExecutionManager.getExecutionManager().getRealObject(FunctionCallEvaluator.this.p3Result)};
                    }
                    Method m = null;
                    m = this.matchMethod(clazz, methodName, parameterTypes, args);
                    if (m == null) {
                        String paramTypesString = "";
                        int i2 = 0;
                        while (i2 < parameterTypes.length) {
                            paramTypesString = String.valueOf(paramTypesString) + parameterTypes[i2].getName() + ", ";
                            ++i2;
                        }
                        FunctionCallEvaluator.this._env.notifyMessage("## Java: No matching method found in class:" + clazz.getName() + ", method: " + methodName + ", parameter types: " + parameterTypes);
                        return null;
                    }
                    try {
                        if (Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers())) {
                            result = m.invoke(null, args);
                        } else if (Modifier.isPublic(m.getModifiers())) {
                            Object newInstance = clazz.newInstance();
                            result = m.invoke(newInstance, args);
                            newInstance = null;
                        }
                    }
                    catch (ClassNotFoundException clnfex) {
                        FunctionCallEvaluator.this._env.notifyMessage("## Java Class Not Found: " + clnfex.getMessage());
                    }
                    catch (InvocationTargetException invokex) {
                        FunctionCallEvaluator.this._env.notifyMessage("## Java Invocation error: " + invokex.getMessage());
                    }
                    catch (IllegalAccessException accex) {
                        FunctionCallEvaluator.this._env.notifyMessage("## Java Access exception: " + accex.getMessage());
                    }
                    catch (InstantiationException instex) {
                        FunctionCallEvaluator.this._env.notifyMessage("## Java Instantiation error: " + instex.getMessage());
                    }
                    catch (NoClassDefFoundError ncdef) {
                        FunctionCallEvaluator.this._env.notifyMessage("## Java Instantiation error: " + ncdef.getMessage());
                    }
                    catch (IllegalArgumentException ilarg) {
                        FunctionCallEvaluator.this._env.notifyMessage("## Java Illegal Argument error: " + ilarg.getMessage());
                    }
                }
                finally {
                    clazz = null;
                }
            }
            return result;
        }

        private Method matchMethod(Class clazz, String methodName, Class[] actualParamTypes, Object[] actualParams) {
            Method match = null;
            Method[] methods = clazz.getMethods();
            Class<?>[] paramTypes = null;
            boolean matchType = false;
            int i = 0;
            while (i < methods.length) {
                match = methods[i];
                if (match.getName().equals(methodName)) {
                    paramTypes = match.getParameterTypes();
                    int pcount = 0;
                    while (pcount < paramTypes.length) {
                        matchType = this.matchParamTypes(paramTypes[pcount], actualParamTypes[pcount], actualParams[pcount]);
                        if (!matchType) {
                            match = null;
                            break;
                        }
                        ++pcount;
                    }
                } else {
                    match = null;
                }
                if (match != null) break;
                ++i;
            }
            return match;
        }

        private boolean checkInterface(Class checkClass, String typeName) {
            Class<?>[] interfaces = checkClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (interfaces[i].getName().equals(typeName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean matchParamTypes(Class formalType, Class actualType, Object actualParam) {
            actualParam = ExecutionManager.getExecutionManager().getRealObject(actualParam);
            actualParam.getClass();
            if (actualType.getName().equals(formalType.getName())) {
                return true;
            }
            if (this.checkInterface(actualType, formalType.getName())) {
                return true;
            }
            Class superCl = null;
            superCl = actualType.getSuperclass();
            while (superCl != null) {
                if (superCl.getName().equals(formalType.getName())) {
                    return true;
                }
                if (this.checkInterface(superCl, formalType.getName())) {
                    return true;
                }
                superCl = superCl.getSuperclass();
            }
            if (formalType.isPrimitive()) {
                if (formalType.equals(Character.TYPE)) {
                    return actualType.equals(Character.class);
                }
                if (formalType.equals(Integer.TYPE)) {
                    return actualType.equals(Integer.class);
                }
                if (formalType.equals(Boolean.TYPE)) {
                    return actualType.equals(Boolean.class);
                }
            }
            return false;
        }
    }
}

