/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.expression;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.LogicalExpression;
import org.eclipse.mofscript.MOFScriptModel.LogicalOperator;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;

public class LogicalExpressionEvaluator
extends ExpressionEvaluator {
    public LogicalExpressionEvaluator(Expression expression, ExecutionEnvironment env, RuleExecutor ownerRuleExecutor) {
        super(expression, env, ownerRuleExecutor);
    }

    @Override
    protected Object evaluate(Object inputObject) throws MofScriptExecutionException {
        LogicalExpression logicalExp = (LogicalExpression)this._expression;
        boolean isPrinting = this._env.isInPrintAction();
        this._env.setInPrintAction(false);
        Expression part1 = logicalExp.getPart1();
        Expression part2 = logicalExp.getPart2();
        Object part1_result = null;
        Object part2_result = null;
        ExpressionEvaluator expEval = null;
        if (part1 != null) {
            expEval = MofScriptExecuterFactory.createExpressionExecutor(part1, this._env, this._ownerRuleExecutor);
            part1_result = expEval.evaluateExpression(inputObject);
        }
        this._env.setInPrintAction(isPrinting);
        LogicalOperator lOp = logicalExp.getOperator();
        boolean theBooleanValue_part1 = false;
        boolean theBooleanValue_part2 = false;
        if (part1_result instanceof String) {
            theBooleanValue_part1 = ((String)part1_result).equalsIgnoreCase("true");
        } else if (part1_result instanceof Boolean) {
            theBooleanValue_part1 = (Boolean)part1_result;
        }
        if (lOp == LogicalOperator.AND_LITERAL && !theBooleanValue_part1) {
            return Boolean.FALSE;
        }
        if (lOp == LogicalOperator.OR_LITERAL && theBooleanValue_part1) {
            return Boolean.TRUE;
        }
        this._env.setInPrintAction(false);
        if (part2 != null) {
            expEval = MofScriptExecuterFactory.createExpressionExecutor(part2, this._env, this._ownerRuleExecutor);
            part2_result = expEval.evaluate(inputObject);
        }
        this._env.setInPrintAction(isPrinting);
        if (part2_result != null && part2_result instanceof String) {
            theBooleanValue_part2 = ((String)part2_result).equalsIgnoreCase("true");
        } else if (part2_result != null && part2_result instanceof Boolean) {
            theBooleanValue_part2 = (Boolean)part2_result;
        }
        if (part1_result instanceof String || part1_result instanceof Boolean) {
            if (part2_result == null) {
                if (lOp == LogicalOperator.NONE_LITERAL) {
                    return new Boolean(theBooleanValue_part1);
                }
                if (lOp == LogicalOperator.NOT_LITERAL) {
                    return new Boolean(!theBooleanValue_part1);
                }
            } else if (part2_result instanceof String || part2_result instanceof Boolean) {
                if (lOp == LogicalOperator.AND_LITERAL) {
                    return new Boolean(theBooleanValue_part1 && theBooleanValue_part2);
                }
                if (lOp == LogicalOperator.OR_LITERAL) {
                    return new Boolean(theBooleanValue_part1 || theBooleanValue_part2);
                }
            }
        } else {
            if (part1_result instanceof EObject) {
                return Boolean.FALSE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

