/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.expression;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.Reference;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.SimpleExpressionEvaluator;
import org.eclipse.mofscript.runtime.traceability.TraceabilityReferenceEvaluator;

public class ReferenceEvaluator
extends SimpleExpressionEvaluator {
    private static boolean _isCachableReference;

    public ReferenceEvaluator(Expression expression, ExecutionEnvironment env, RuleExecutor ownerRuleExecutor) {
        super(expression, env, ownerRuleExecutor);
        _isCachableReference = true;
    }

    public void setIsCachableReference(boolean isCachable) {
        _isCachableReference = isCachable;
    }

    @Override
    protected Object evaluateSimple(Object inputObject) throws MofScriptExecutionException {
        Object ret = null;
        Reference ref = (Reference)this._expression;
        String refname = ref.getName();
        String[] splitref = refname.split("\\.");
        Object input = this._env.getInputObject(splitref[0]);
        this.storeTempValues(input, refname);
        if (input == null) {
            Variable var = this._env.findVariable(splitref[0]);
            if (var != null) {
                Object calc = var.getValue();
                if (calc != null && !calc.equals("")) {
                    if (this instanceof TraceabilityReferenceEvaluator) {
                        TraceabilityReferenceEvaluator trev = (TraceabilityReferenceEvaluator)this;
                        trev.variableModelRef(var, refname);
                    }
                    ret = calc;
                } else {
                    Expression varexp = var.getAssignedExpression();
                    ExpressionEvaluator executer = MofScriptExecuterFactory.createExpressionExecutor(varexp, this._env, this._ownerRuleExecutor);
                    Object res = executer.evaluateExpression(null);
                    executer = null;
                    var.value = res instanceof StringBuffer ? res.toString() : res;
                    ret = res;
                }
                EObject possibleSourceModel = RuleExecutor.getExecutionManager().getSourceModel(splitref[0]);
                if (splitref.length > 1 && possibleSourceModel != null && possibleSourceModel == ret) {
                    EClassifier clazzifier = RuleExecutor.getExecutionManager().getMetaModelReference(refname);
                    ret = clazzifier != null ? clazzifier : this.getObjectFeature(ret, splitref, refname, ref.getLine());
                } else if (splitref.length > 1) {
                    ret = this.getObjectFeature(ret, splitref, refname, ref.getLine());
                }
            } else {
                ExecutionManager execMgr = RuleExecutor.getExecutionManager();
                EClassifier clazzifier = execMgr.getMetaModelReference(refname);
                ret = clazzifier;
            }
        } else {
            Object value = null;
            if (splitref.length == 1) {
                value = input;
                if (value instanceof EObject && this._env.isInPrintAction()) {
                    this.handleObjectReference((EObject)input, refname, value);
                }
            } else {
                value = this.getObjectFeature(input, splitref, refname, ref.getLine());
            }
            ret = value;
            if (_isCachableReference) {
                this._env.setCachedReference(refname, ret);
            }
        }
        if (ret != null && ret instanceof EEnumLiteral) {
            ret = ((EEnumLiteral)ret).getName();
        }
        if (ret != null) {
            boolean cfr_ignored_0 = ret instanceof EObject;
        }
        return ret;
    }

    public void storeTempValues(Object input, String refname) {
    }

    public void variableModelRef(Variable var, String refname) {
    }

    protected Object initializeVariable(String type) {
        if (type.equalsIgnoreCase("List")) {
            return new ArrayList();
        }
        if (type.equalsIgnoreCase("Hashtable") || type.equalsIgnoreCase("Dictionary")) {
            return new Hashtable();
        }
        return null;
    }

    protected Object getObjectFeature(Object input, String[] splitref, String refname, int refLine) {
        Object returnValue = null;
        EStructuralFeature feature = null;
        EStructuralFeature feature2 = null;
        EObject eobj = null;
        if (input instanceof EObject) {
            try {
                eobj = (EObject)input;
                feature = ExecutionManager.getFeatureForClass(eobj.eClass(), splitref[1]);
                if (feature != null) {
                    returnValue = eobj.eGet(feature, true);
                } else {
                    returnValue = null;
                    this._env.notifyError("#Runtime Error# Reference = NULL: Non existing feature: " + splitref[1] + " - (line: " + refLine + ")", this);
                }
                int splitindex = 2;
                while (splitindex < splitref.length) {
                    if (feature != null && feature instanceof EReference) {
                        EReference eref = (EReference)feature;
                        eref.getEType();
                        if (splitref.length > 2 && returnValue instanceof EObject) {
                            EObject erefobj = (EObject)returnValue;
                            EObject prox = null;
                            if (erefobj.eIsProxy()) {
                                prox = EcoreUtil.resolve((EObject)erefobj, (Resource)eobj.eResource());
                                if (prox != null) {
                                    prox = EcoreUtil.resolve((EObject)erefobj, (ResourceSet)ExecutionManager.getExecutionManager().getResourceSet());
                                    feature2 = ExecutionManager.getFeatureForClass(prox.eClass(), splitref[splitindex]);
                                    if (feature2 != null) {
                                        returnValue = prox.eGet(feature2);
                                    } else {
                                        this._env.notifyError("#Runtime Error# Reference = NULL: Non existing feature: " + splitref[splitindex] + " - (line: " + refLine + ")", this);
                                        returnValue = null;
                                    }
                                }
                            } else {
                                feature2 = ExecutionManager.getFeatureForClass(erefobj.eClass(), splitref[splitindex]);
                                if (feature2 != null) {
                                    returnValue = erefobj.eGet(feature2);
                                } else {
                                    this._env.notifyError("#Runtime Error# Reference = NULL: Non existing feature: " + splitref[splitindex] + " - (line: " + refLine + ")", this);
                                    returnValue = null;
                                }
                            }
                        }
                    } else {
                        this._env.notifyError("#Runtime Error# NULL pointer refererence: " + refname + " - (line: " + refLine + ")", this);
                    }
                    ++splitindex;
                }
                if (feature2 != null) {
                    feature = feature2;
                }
                if (feature != null && feature instanceof EReference) {
                    boolean cfr_ignored_0 = returnValue instanceof List;
                }
            }
            catch (Exception ex) {
                this._env.notifyError("#Runtime Error# In ReferenceEvaluator - " + ex.getMessage() + " (line: " + refLine + ")", this);
                ex.printStackTrace();
            }
            if (this._env.isInPrintAction() && returnValue != null) {
                this.handleObjectReference(eobj, refname, returnValue);
            }
        }
        return returnValue;
    }

    protected void handleObjectReference(EObject object, String refname, Object refValue) {
    }

    public void finalizeReferenceProcessing(String referenceValue) {
    }
}

