/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.FunctionCall;
import org.eclipse.mofscript.MOFScriptModel.Reference;
import org.eclipse.mofscript.MOFScriptModel.SelectExpression;
import org.eclipse.mofscript.MOFScriptModel.SimpleExpression;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.FunctionCallEvaluator;

public class SelectExpressionEvaluator
extends ExpressionEvaluator {
    public SelectExpressionEvaluator(Expression expression, ExecutionEnvironment env, RuleExecutor ownerRuleExecutor) {
        super(expression, env, ownerRuleExecutor);
    }

    @Override
    protected Object evaluate(Object inputObject) throws MofScriptExecutionException {
        SelectExpression select = (SelectExpression)this._expression;
        SimpleExpression sourceRef = select.getSourceReference();
        String variable = select.getVariable();
        String type = select.getType();
        Expression logExp = select.getFilterExpression();
        String[] fortypesplit = type.split("\\.");
        String fortype = fortypesplit[fortypesplit.length - 1];
        String metaModelRef = "";
        if (fortypesplit.length > 1) {
            metaModelRef = fortypesplit[0];
        }
        EClassifier forclazz = null;
        EClassifier ecoreClazz = null;
        Object result = null;
        EPackage mm = null;
        try {
            if (fortype.equalsIgnoreCase("Object") || fortype.equalsIgnoreCase("Any")) {
                forclazz = ExecutionManager.getExecutionManager().getEcoreMetaModel().getEClassifier("EObject");
            } else {
                ecoreClazz = ExecutionManager.getExecutionManager().getEcoreMetaModel().getEClassifier(fortype);
                mm = ExecutionManager.getExecutionManager().getMetaModel(metaModelRef);
                if (mm != null) {
                    forclazz = RuleExecutor.getExecutionManager().getClassifierForPackage(mm, fortype);
                }
                if (forclazz == null && ecoreClazz != null) {
                    forclazz = ecoreClazz;
                    mm = ExecutionManager.getExecutionManager().getEcoreMetaModel();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ExpressionEvaluator evaluator = MofScriptExecuterFactory.createExpressionExecutor((Expression)sourceRef, this._env, this._ownerRuleExecutor);
        Object objectToHandle = evaluator.evaluateExpression(null);
        Object variableImpl = null;
        if (sourceRef instanceof Reference && (variableImpl = this._env.getVariableImplementation(((Reference)sourceRef).getName())) != null) {
            objectToHandle = variableImpl;
        }
        ExecutionEnvironment selectEnv = MofScriptExecuterFactory.createExecutionEnvironment();
        RuleExecutor.getExecutionManager().getExecutionStack().pushEnvironment(selectEnv);
        Variable selectVariable = new Variable();
        selectVariable.type = fortype;
        selectVariable.name = variable;
        ArrayList<Object> resultCollection = new ArrayList<Object>();
        if (objectToHandle instanceof List || objectToHandle instanceof Hashtable) {
            Collection<Object> values = null;
            values = objectToHandle instanceof Hashtable ? ((Hashtable)objectToHandle).values() : (List)objectToHandle;
            Object val = null;
            Iterator<Object> it = values.iterator();
            while (it.hasNext()) {
                selectEnv.clearReferenceCache();
                val = it.next();
                selectEnv.addInputObject(variable, val);
                selectVariable.value = val;
                selectEnv.setVariable(variable, selectVariable);
                boolean matches_type = false;
                if (forclazz == null || !(forclazz instanceof EClass) || forclazz instanceof EDataType) {
                    matches_type = fortype.equalsIgnoreCase("Integer") ? val instanceof Integer : (fortype.equalsIgnoreCase("String") ? val instanceof String : (fortype.equalsIgnoreCase("Real") ? val instanceof Double || val instanceof Float : (fortype.equalsIgnoreCase("Boolean") ? val instanceof Boolean : fortype.equals("") || fortype.equalsIgnoreCase("OclAny") || fortype.equalsIgnoreCase("Any") || fortype.equalsIgnoreCase("Object"))));
                } else if (forclazz instanceof EClass && val instanceof EObject) {
                    Boolean isSuperClass = new Boolean(FunctionCallEvaluator.isKindOf((EObject)val, forclazz) != false || forclazz.getName().equals("EObject"));
                    matches_type = isSuperClass;
                } else if (fortype != null && fortype.equals("Object")) {
                    matches_type = true;
                }
                Object filterExpVal = null;
                boolean matches_filter = true;
                if (logExp != null && matches_type) {
                    ExpressionEvaluator expExec = MofScriptExecuterFactory.createExpressionExecutor(logExp, selectEnv, this._ownerRuleExecutor);
                    filterExpVal = expExec.evaluateExpression(null);
                    if (filterExpVal instanceof Boolean) {
                        matches_filter = (Boolean)filterExpVal;
                    } else {
                        matches_filter = false;
                        this._env.notifyError("#Runtime Error#: Return value Object from logical expression: " + filterExpVal + " (line " + select.getLine() + ")", this);
                    }
                }
                if (!matches_filter || !matches_type) continue;
                resultCollection.add(val);
            }
            if (select.getAppliedFunction() != null) {
                FunctionCall fc = select.getAppliedFunction();
                String fcName = fc.getName();
                selectVariable = new Variable();
                selectVariable.name = "__selectFunVar";
                selectVariable.type = "List";
                selectVariable.value = resultCollection;
                selectEnv.setVariable("__selectFunVar", selectVariable);
                fc.setName("__selectFunVar." + fc.getName());
                ExpressionEvaluator expExec = MofScriptExecuterFactory.createExpressionExecutor((Expression)fc, selectEnv, this._ownerRuleExecutor);
                result = expExec.evaluate(null);
                fc.setName(fcName);
            } else {
                result = resultCollection;
            }
        }
        RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
        return result;
    }

    protected EClassifier getEClassForEObject(EPackage mm, EObject eobj) {
        if (eobj != null) {
            EClassifier oclazz = mm.getEClassifier(eobj.eClass().getName());
            EClass oclazz2 = eobj.eClass();
            if (oclazz == null && oclazz2 != null) {
                oclazz = oclazz2;
            }
            return oclazz;
        }
        return null;
    }
}

