/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.expression;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.FunctionCall;
import org.eclipse.mofscript.MOFScriptModel.Reference;
import org.eclipse.mofscript.MOFScriptModel.SimpleExpression;
import org.eclipse.mofscript.MOFScriptModel.ValueExpression;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.ReferenceEvaluator;

public abstract class SimpleExpressionEvaluator
extends ExpressionEvaluator {
    public SimpleExpressionEvaluator(Expression expression, ExecutionEnvironment env, RuleExecutor ownerRuleExecutor) {
        super(expression, env, ownerRuleExecutor);
    }

    @Override
    protected final Object evaluate(Object inputObject) throws MofScriptExecutionException {
        Object ret = this.evaluateSimple(inputObject);
        Object libRet = this.checkAdditionalExpressionParts(ret);
        return libRet != null ? libRet : ret;
    }

    protected abstract Object evaluateSimple(Object var1) throws MofScriptExecutionException;

    protected Object checkAdditionalExpressionParts(Object currentValue) {
        SimpleExpression se = (SimpleExpression)this._expression;
        SimpleExpression extraExp2 = null;
        EList additionalExpressionParts = se.getAdditionalExpressionPart();
        Object lfvalue = currentValue;
        if (lfvalue == null) {
            return lfvalue;
        }
        Variable varDecl = null;
        if (additionalExpressionParts.size() > 0) {
            varDecl = new Variable();
            varDecl.name = "__internalTempVar__";
            this._env.addVariable(varDecl);
        }
        try {
            try {
                for (SimpleExpression extraExp2 : additionalExpressionParts) {
                    ExpressionEvaluator expEval;
                    this._env.setTypeForVariable(varDecl, lfvalue);
                    if (extraExp2 instanceof FunctionCall) {
                        FunctionCall lf = (FunctionCall)extraExp2;
                        FunctionCall copy = (FunctionCall)EcoreUtil.copy((EObject)lf);
                        copy.setName(String.valueOf(varDecl.getName()) + "." + lf.getName());
                        varDecl.value = lfvalue;
                        expEval = MofScriptExecuterFactory.createExpressionExecutor((Expression)copy, this._env, this._ownerRuleExecutor);
                        try {
                            try {
                                lfvalue = expEval.evaluate(lfvalue);
                            }
                            catch (MofScriptExecutionException mfex) {
                                this._env.notifyMessage("" + mfex);
                                copy = null;
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            copy = null;
                            throw throwable;
                        }
                        copy = null;
                        continue;
                    }
                    if (!(extraExp2 instanceof Reference)) continue;
                    Reference ref = (Reference)extraExp2;
                    String nameHolder = ref.getName();
                    ref.setName("_tmp_ref." + nameHolder);
                    this._env.addInputObject("_tmp_ref", lfvalue);
                    expEval = (ReferenceEvaluator)MofScriptExecuterFactory.createExpressionExecutor((Expression)ref, this._env, this._ownerRuleExecutor);
                    ((ReferenceEvaluator)expEval).setIsCachableReference(false);
                    try {
                        try {
                            lfvalue = ((SimpleExpressionEvaluator)expEval).evaluate(null);
                        }
                        catch (Exception exception) {
                            ref.setName(nameHolder);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        ref.setName(nameHolder);
                        throw throwable;
                    }
                    ref.setName(nameHolder);
                }
            }
            catch (Exception exception) {
                if (varDecl != null) {
                    this._env.removeVariable(varDecl);
                }
            }
        }
        finally {
            if (varDecl != null) {
                this._env.removeVariable(varDecl);
            }
        }
        return lfvalue;
    }

    protected Object handleAdditionalFunction(Object value, FunctionCall lf) throws MofScriptExecutionException {
        Object result = null;
        String function = lf.getName();
        lf.getParameters();
        if (value instanceof String) {
            result = this.handleStringFunction(value, lf);
        } else {
            this._env.notifyMessage("Function: " + function + "Type of value:" + value.getClass().getName());
            result = value;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handleStringFunction(Object value, FunctionCall lf) throws MofScriptExecutionException {
        void var4_30;
        if (value == null) {
            return null;
        }
        String input = value.toString();
        Object var4_4 = null;
        String[] fSplit = lf.getName().split("\\.");
        String function = fSplit[fSplit.length - 1];
        EList parameters = lf.getParameters();
        ValueExpression p1 = null;
        ValueExpression p2 = null;
        Object p1Val = null;
        Object p2Val = null;
        ExpressionEvaluator expEval = null;
        if (parameters.size() > 0) {
            p1 = (ValueExpression)parameters.get(0);
        }
        if (parameters.size() > 1) {
            p2 = (ValueExpression)parameters.get(1);
        }
        if (p1 != null && (p1Val = (expEval = MofScriptExecuterFactory.createExpressionExecutor((Expression)p1, this._env, this._ownerRuleExecutor)).evaluateExpression(null)) instanceof StringBuffer) {
            p1Val = p1Val.toString();
        }
        if (p2 != null && (p2Val = (expEval = MofScriptExecuterFactory.createExpressionExecutor((Expression)p2, this._env, this._ownerRuleExecutor)).evaluateExpression(null)) instanceof StringBuffer) {
            p2Val = p2Val.toString();
        }
        if (function.equalsIgnoreCase("substring")) {
            if (parameters.size() != 2) throw new MofScriptExecutionException("Missing parameter to operation subStringBefore", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof Integer) || !(p2Val instanceof Integer)) throw new MofScriptExecutionException("substring: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            int p1Int = (Integer)p1Val;
            int p2Int = (Integer)p2Val;
            if (p1Int <= -1 || p2Int < p1Int || p2Int > input.length()) throw new MofScriptExecutionException("substring: Index error: lower: " + p1Int + ", upper:" + p2Int, this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            String string = input.substring(p1Int, p2Int);
            return var4_30;
        } else if (function.equalsIgnoreCase("subStringBefore")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation subStringBefore", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("subStringBefore: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            int index = input.indexOf((String)p1Val);
            if (index <= -1) return var4_30;
            String string = input.substring(0, index);
            return var4_30;
        } else if (function.equalsIgnoreCase("subStringAfter")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation subStringAfter", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("subStringAfter: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            int index = input.indexOf((String)p1Val);
            if (index <= -1) return var4_30;
            String string = input.substring(index + ((String)p1Val).length(), input.length());
            return var4_30;
        } else if (function.equalsIgnoreCase("toLower")) {
            String string = input.toLowerCase();
            return var4_30;
        } else if (function.equalsIgnoreCase("toUpper")) {
            String string = input.toUpperCase();
            return var4_30;
        } else if (function.equalsIgnoreCase("firstToLower")) {
            if (input.length() == 0) {
                String string = input;
                return var4_30;
            } else {
                String string = String.valueOf(input.substring(0, 1).toLowerCase()) + input.substring(1, input.length());
            }
            return var4_30;
        } else if (function.equalsIgnoreCase("firstToUpper")) {
            if (input.length() == 0) {
                String string = input;
                return var4_30;
            } else {
                String string = String.valueOf(input.substring(0, 1).toUpperCase()) + input.substring(1, input.length());
            }
            return var4_30;
        } else if (function.equalsIgnoreCase("size")) {
            Integer n = new Integer(input.length());
            return var4_30;
        } else if (function.equalsIgnoreCase("indexOf")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation indexOf", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("indexOf: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            Integer n = new Integer(input.indexOf((String)p1Val));
            return var4_30;
        } else if (function.equalsIgnoreCase("lastIndexOf")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation lastIndexOf", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("lastIndexOf: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            Integer n = new Integer(input.lastIndexOf((String)p1Val));
            return var4_30;
        } else if (function.equalsIgnoreCase("endsWith")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation endsWith", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("endsWith: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            Boolean bl = new Boolean(input.endsWith((String)p1Val));
            return var4_30;
        } else if (function.equalsIgnoreCase("startsWith")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation endsWith", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("startsWith: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            Boolean bl = new Boolean(input.startsWith((String)p1Val));
            return var4_30;
        } else if (function.equalsIgnoreCase("trim")) {
            String string = input.trim();
            return var4_30;
        } else if (function.equalsIgnoreCase("normalizeSpace")) {
            String string = input.trim().replaceAll("([ \\t\\n\\r])+", " ");
            return var4_30;
        } else if (function.equalsIgnoreCase("replace")) {
            if (parameters.size() != 2) throw new MofScriptExecutionException("Missing parameter to operation replace", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String) || !(p2Val instanceof String)) throw new MofScriptExecutionException("replace: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            String string = input.replaceAll((String)p1Val, (String)p2Val);
            return var4_30;
        } else if (function.equalsIgnoreCase("equals")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation equals", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("equals: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            Boolean bl = new Boolean(input.equals((String)p1Val));
            return var4_30;
        } else if (function.equalsIgnoreCase("equalsIgnoreCase")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation equals", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("equalsIgnoreCase: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            Boolean bl = new Boolean(input.equalsIgnoreCase((String)p1Val));
            return var4_30;
        } else if (function.equalsIgnoreCase("isUpperCase")) {
            int intValue = 0;
            if (parameters.size() == 1) {
                if (!(p1Val instanceof Integer)) throw new MofScriptExecutionException("isUpperCase: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                intValue = (Integer)p1Val;
                if (intValue >= input.length() || intValue < 0) {
                    throw new MofScriptExecutionException("isUpperCase: Parameter index out of range: " + p1Val, this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                }
            }
            boolean isUpperCase = Character.isUpperCase(input.charAt(intValue));
            Boolean bl = new Boolean(isUpperCase);
            return var4_30;
        } else if (function.equalsIgnoreCase("isLowerCase")) {
            int intValue = 0;
            if (parameters.size() == 1) {
                if (!(p1Val instanceof Integer)) throw new MofScriptExecutionException("isLowerCase: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                intValue = (Integer)p1Val;
                if (intValue >= input.length() || intValue < 0) {
                    throw new MofScriptExecutionException("isLowerCase: Parameter index out of range: " + p1Val, this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
                }
            }
            boolean isUpperCase = Character.isLowerCase(input.charAt(intValue));
            Boolean bl = new Boolean(isUpperCase);
            return var4_30;
        } else if (function.equalsIgnoreCase("charAt")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation equals", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof Integer)) throw new MofScriptExecutionException("isUpperCase: Wrong type on parameters", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if ((Integer)p1Val >= input.length()) {
                throw new MofScriptExecutionException("charAt: Parameter index out of range: " + p1Val, this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            }
            String string = String.valueOf(input.charAt((Integer)p1Val));
            return var4_30;
        } else if (function.equalsIgnoreCase("matches")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation matches", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("isUpperCase: Wrong type on parameter", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            Boolean bl = new Boolean(input.matches((String)p1Val));
            return var4_30;
        } else if (function.equalsIgnoreCase("strcmp")) {
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation strcmp", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("strcmp: Wrong type on parameter", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            Integer n = new Integer(input.compareTo((String)p1Val));
            return var4_30;
        } else {
            if (!function.equalsIgnoreCase("strtok")) throw new MofScriptExecutionException("Unknown function for type String: " + function, this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (parameters.size() != 1) throw new MofScriptExecutionException("Missing parameter to operation strtok", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            if (!(p1Val instanceof String)) throw new MofScriptExecutionException("strtok: Wrong type on parameter", this._ownerRuleExecutor.getRule().getName(), this._expression.getLine(), this);
            String[] stringArray = input.split((String)p1Val);
        }
        return var4_30;
    }
}

